/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.Expr;
import com.wolfram.jlink.JLinkClassLoader;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.LoopbackLink;
import com.wolfram.jlink.MLFunction;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MsgHandlerRecord;
import com.wolfram.jlink.PacketArrivedEvent;
import com.wolfram.jlink.PacketListener;
import com.wolfram.jlink.Utils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public abstract class MathLinkImpl
implements MathLink {
    static final int DEBUGLEVEL = 0;
    protected Method userYielder;
    protected Object yielderObject;
    protected Vector userMsgHandlers = new Vector(2, 1);
    protected Vector packetListeners;
    private Object packetListenerLock = new Object();
    protected Class complexClass;
    protected Constructor complexCtor;
    protected Method complexReMethod;
    protected Method complexImMethod;

    public abstract void activate() throws MathLinkException;

    public synchronized boolean addMessageHandler(Class clazz, Object object, String string) {
        block5: {
            Method method = null;
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Class<?> clazz2 = clazz != null ? clazz : object.getClass();
            try {
                method = clazz2.getMethod(string, classArray);
            }
            catch (Exception exception) {
                return false;
            }
            Enumeration enumeration = this.userMsgHandlers.elements();
            while (enumeration.hasMoreElements()) {
                MsgHandlerRecord msgHandlerRecord = (MsgHandlerRecord)enumeration.nextElement();
                if (!msgHandlerRecord.meth.equals(method)) continue;
                return true;
            }
            this.userMsgHandlers.addElement(new MsgHandlerRecord(object, method, string));
            if (!Utils.isJava2OrLater() || method.isAccessible()) break block5;
            try {
                ((AccessibleObject)method).setAccessible(true);
            }
            catch (SecurityException securityException) {
                System.err.println("J/Link warning: The message handler " + string + " might not be called due to a security restriction. " + "See the documentation for the class java.lang.reflect.ReflectPermission. This problem might go away " + "if JLink.jar is loaded from the classpath instead of the jre/lib/ext directory.");
                securityException.printStackTrace();
            }
        }
        return true;
    }

    public void addPacketListener(PacketListener packetListener) {
        Object object = this.packetListenerLock;
        synchronized (object) {
            if (this.packetListeners == null) {
                this.packetListeners = new Vector(2, 2);
            }
            if (!this.packetListeners.contains(packetListener)) {
                this.packetListeners.addElement(packetListener);
            }
        }
    }

    public abstract int bytesToGet() throws MathLinkException;

    public abstract int bytesToPut() throws MathLinkException;

    public abstract int checkFunction(String var1) throws MathLinkException;

    public abstract void checkFunctionWithArgCount(String var1, int var2) throws MathLinkException;

    public abstract boolean clearError();

    public abstract void close();

    public abstract void connect() throws MathLinkException;

    protected synchronized Object constructComplex(double d, double d2) {
        Object[] objectArray = new Object[]{new Double(d), new Double(d2)};
        try {
            return this.complexCtor.newInstance(objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public abstract long createMark() throws MathLinkException;

    public abstract void destroyMark(long var1);

    public abstract void endPacket() throws MathLinkException;

    public abstract int error();

    public abstract String errorMessage();

    public abstract void flush() throws MathLinkException;

    public abstract int getArgCount() throws MathLinkException;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Object getArray(int n, int n2) throws MathLinkException {
        void var3_9;
        Object var3_3 = null;
        if (n2 == 1) {
            MLFunction mLFunction = this.getFunction();
            switch (n) {
                case -13: {
                    Object object = Array.newInstance(this.getComplexClass(), mLFunction.argCount);
                    int n3 = 0;
                    while (n3 < mLFunction.argCount) {
                        Array.set(object, n3, this.getComplex());
                        ++n3;
                    }
                    return var3_9;
                }
                case -12: {
                    Expr[] exprArray = new Expr[mLFunction.argCount];
                    int n4 = 0;
                    while (n4 < mLFunction.argCount) {
                        Array.set(exprArray, n4, this.getExpr());
                        ++n4;
                    }
                    return var3_9;
                }
                case -10: {
                    BigInteger[] bigIntegerArray = new BigInteger[mLFunction.argCount];
                    int n5 = 0;
                    while (n5 < mLFunction.argCount) {
                        Array.set(bigIntegerArray, n5, new BigInteger(this.getString()));
                        ++n5;
                    }
                    return var3_9;
                }
                case -11: {
                    BigDecimal[] bigDecimalArray = new BigDecimal[mLFunction.argCount];
                    int n6 = 0;
                    while (n6 < mLFunction.argCount) {
                        Array.set(bigDecimalArray, n6, Utils.bigDecimalFromString(this.getString()));
                        ++n6;
                    }
                    return var3_9;
                }
                default: {
                    return var3_9;
                }
            }
        }
        Object object = this.getArraySlices(n, n2, null);
        return var3_9;
    }

    protected Object getArraySlices(int n, int n2, Class clazz) throws MathLinkException {
        Object object = null;
        if (n2 > 1) {
            int n3;
            Object object2;
            if (clazz == null) {
                object2 = "";
                n3 = 1;
                while (n3 < n2) {
                    object2 = String.valueOf(object2) + "[";
                    ++n3;
                }
                switch (n) {
                    case -1: {
                        object2 = String.valueOf(object2) + "Z";
                        break;
                    }
                    case -2: {
                        object2 = String.valueOf(object2) + "B";
                        break;
                    }
                    case -3: {
                        object2 = String.valueOf(object2) + "C";
                        break;
                    }
                    case -4: {
                        object2 = String.valueOf(object2) + "S";
                        break;
                    }
                    case -5: {
                        object2 = String.valueOf(object2) + "I";
                        break;
                    }
                    case -6: {
                        object2 = String.valueOf(object2) + "J";
                        break;
                    }
                    case -7: {
                        object2 = String.valueOf(object2) + "F";
                        break;
                    }
                    case -8: {
                        object2 = String.valueOf(object2) + "D";
                        break;
                    }
                    case -9: {
                        object2 = String.valueOf(object2) + "Ljava.lang.String;";
                        break;
                    }
                    case -10: {
                        object2 = String.valueOf(object2) + "Ljava.math.BigInteger;";
                        break;
                    }
                    case -11: {
                        object2 = String.valueOf(object2) + "Ljava.math.BigDecimal;";
                        break;
                    }
                    case -12: {
                        object2 = String.valueOf(object2) + "Lcom.wolfram.jlink.Expr;";
                        break;
                    }
                    case -13: {
                        object2 = String.valueOf(object2) + "L" + this.getComplexClass().getName() + ";";
                        break;
                    }
                }
                try {
                    clazz = JLinkClassLoader.classFromName((String)object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            object2 = this.getFunction();
            n3 = ((MLFunction)object2).argCount;
            object = Array.newInstance(clazz, n3);
            object2 = null;
            Class clazz2 = null;
            if (n2 > 2) {
                String string = clazz.getName().substring(1);
                try {
                    clazz2 = JLinkClassLoader.classFromName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            int n4 = 0;
            while (n4 < n3) {
                Array.set(object, n4, this.getArraySlices(n, n2 - 1, clazz2));
                ++n4;
            }
        } else {
            object = this.getArray(n, 1);
        }
        return object;
    }

    public synchronized boolean getBoolean() throws MathLinkException {
        return this.getSymbol().equals("True");
    }

    public synchronized boolean[] getBooleanArray1() throws MathLinkException {
        return (boolean[])this.getArray(-1, 1);
    }

    public synchronized boolean[][] getBooleanArray2() throws MathLinkException {
        return (boolean[][])this.getArray(-1, 2);
    }

    public synchronized byte[] getByteArray1() throws MathLinkException {
        return (byte[])this.getArray(-2, 1);
    }

    public synchronized byte[][] getByteArray2() throws MathLinkException {
        return (byte[][])this.getArray(-2, 2);
    }

    public abstract byte[] getByteString(int var1) throws MathLinkException;

    public synchronized char[] getCharArray1() throws MathLinkException {
        return (char[])this.getArray(-3, 1);
    }

    public synchronized char[][] getCharArray2() throws MathLinkException {
        return (char[][])this.getArray(-3, 2);
    }

    public synchronized Object getComplex() throws MathLinkException {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.getNext();
        switch (n) {
            case 42: 
            case 43: {
                d = this.getDouble();
                break;
            }
            case 70: {
                this.checkFunctionWithArgCount("Complex", 2);
                d = this.getDouble();
                d2 = this.getDouble();
                break;
            }
            default: {
                throw new MathLinkException(1003);
            }
        }
        if (this.getComplexClass() == null) {
            return null;
        }
        return this.constructComplex(d, d2);
    }

    public synchronized Object[] getComplexArray1() throws MathLinkException {
        return (Object[])this.getArray(-13, 1);
    }

    public synchronized Object[][] getComplexArray2() throws MathLinkException {
        return (Object[][])this.getArray(-13, 2);
    }

    public synchronized Class getComplexClass() {
        return this.complexClass;
    }

    public abstract byte[] getData(int var1) throws MathLinkException;

    public abstract double getDouble() throws MathLinkException;

    public synchronized double[] getDoubleArray1() throws MathLinkException {
        return (double[])this.getArray(-8, 1);
    }

    public synchronized double[][] getDoubleArray2() throws MathLinkException {
        return (double[][])this.getArray(-8, 2);
    }

    public abstract Expr getExpr() throws MathLinkException;

    public synchronized float[] getFloatArray1() throws MathLinkException {
        return (float[])this.getArray(-7, 1);
    }

    public synchronized float[][] getFloatArray2() throws MathLinkException {
        return (float[][])this.getArray(-7, 2);
    }

    public abstract MLFunction getFunction() throws MathLinkException;

    public synchronized int[] getIntArray1() throws MathLinkException {
        return (int[])this.getArray(-5, 1);
    }

    public synchronized int[][] getIntArray2() throws MathLinkException {
        return (int[][])this.getArray(-5, 2);
    }

    public abstract int getInteger() throws MathLinkException;

    public synchronized long[] getLongArray1() throws MathLinkException {
        return (long[])this.getArray(-6, 1);
    }

    public synchronized long[][] getLongArray2() throws MathLinkException {
        return (long[][])this.getArray(-6, 2);
    }

    public abstract long getLongInteger() throws MathLinkException;

    public abstract int getMessage() throws MathLinkException;

    public abstract int getNext() throws MathLinkException;

    public synchronized short[] getShortArray1() throws MathLinkException {
        return (short[])this.getArray(-4, 1);
    }

    public synchronized short[][] getShortArray2() throws MathLinkException {
        return (short[][])this.getArray(-4, 2);
    }

    public abstract String getString() throws MathLinkException;

    public synchronized String[] getStringArray1() throws MathLinkException {
        return (String[])this.getArray(-9, 1);
    }

    public synchronized String[][] getStringArray2() throws MathLinkException {
        return (String[][])this.getArray(-9, 2);
    }

    public abstract String getSymbol() throws MathLinkException;

    public abstract int getType() throws MathLinkException;

    protected void messageCallback(int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        int n3 = 0;
        while (n3 < this.userMsgHandlers.size()) {
            try {
                MsgHandlerRecord msgHandlerRecord = (MsgHandlerRecord)this.userMsgHandlers.elementAt(n3);
                msgHandlerRecord.meth.invoke(msgHandlerRecord.target, objectArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n3;
        }
    }

    public abstract boolean messageReady() throws MathLinkException;

    public abstract void newPacket();

    public abstract int nextPacket() throws MathLinkException;

    public synchronized boolean notifyPacketListeners(int n) {
        Vector vector;
        if (this.packetListeners == null) {
            return true;
        }
        boolean bl = true;
        PacketArrivedEvent packetArrivedEvent = new PacketArrivedEvent((KernelLink)((Object)this), n);
        Object object = this.packetListenerLock;
        synchronized (object) {
            vector = (Vector)this.packetListeners.clone();
        }
        long l = 0L;
        try {
            try {
                boolean bl2 = true;
                l = this.createMark();
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    Object var13_10;
                    try {
                        try {
                            bl2 = ((PacketListener)vector.elementAt(n3)).packetArrived(packetArrivedEvent);
                            bl = bl && bl2;
                        }
                        catch (MathLinkException mathLinkException) {
                            this.clearError();
                        }
                        var13_10 = null;
                        this.seekMark(l);
                    }
                    catch (Throwable throwable) {
                        var13_10 = null;
                        this.seekMark(l);
                        throw throwable;
                    }
                    ++n3;
                }
            }
            catch (MathLinkException mathLinkException) {
                this.clearError();
            }
            Object var8_12 = null;
            if (l != 0L) {
                this.destroyMark(l);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (l != 0L) {
                this.destroyMark(l);
            }
            throw throwable;
        }
        return bl;
    }

    public abstract Expr peekExpr() throws MathLinkException;

    public abstract void put(double var1) throws MathLinkException;

    public abstract void put(int var1) throws MathLinkException;

    public abstract void put(long var1) throws MathLinkException;

    public synchronized void put(Object object) throws MathLinkException {
        if (object == null) {
            this.putSymbol("Null");
        } else if (object instanceof String) {
            this.putString((String)object);
        } else if (object.getClass().isArray()) {
            this.putArray(object, null);
        } else if (object instanceof Expr) {
            ((Expr)object).put(this);
        } else if (this.getComplexClass() != null && this.getComplexClass().isInstance(object)) {
            this.putComplex(object);
        } else if (object instanceof Number) {
            if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
                this.put(((Number)object).intValue());
            } else if (object instanceof Double || object instanceof Float) {
                this.put(((Number)object).doubleValue());
            } else if (object instanceof Long || object instanceof BigInteger) {
                byte[] byArray = object.toString().getBytes();
                this.putNext(43);
                this.putSize(byArray.length);
                this.putData(byArray, byArray.length);
            } else {
                String string = object.toString();
                byte[] byArray = string.getBytes();
                boolean bl = string.indexOf(46) != -1;
                this.putNext(42);
                this.putSize(byArray.length + (bl ? 0 : 1));
                this.putData(byArray, byArray.length);
                if (!bl) {
                    this.putData(new byte[]{46}, 1);
                }
            }
        } else if (object instanceof Boolean) {
            this.putSymbol((Boolean)object != false ? "True" : "False");
        } else if (object instanceof Character) {
            this.put(((Character)object).charValue());
        } else {
            this.putReference(object);
        }
    }

    public synchronized void put(Object object, String[] stringArray) throws MathLinkException {
        if (object == null) {
            this.putSymbol("Null");
        } else if (object.getClass().isArray()) {
            this.putArray(object, stringArray);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public abstract void put(boolean var1) throws MathLinkException;

    public abstract void putArgCount(int var1) throws MathLinkException;

    protected abstract void putArray(Object var1, String[] var2) throws MathLinkException;

    protected void putArrayPiecemeal(Object object, String[] stringArray, int n) throws MathLinkException {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            String string = stringArray != null && stringArray.length > n ? stringArray[n] : "List";
            int n2 = Array.getLength(object);
            this.putFunction(string, n2);
            ++n;
            int n3 = 0;
            while (n3 < n2) {
                this.putArrayPiecemeal(Array.get(object, n3), stringArray, n);
                ++n3;
            }
        } else {
            this.put(object);
        }
    }

    public abstract void putByteString(byte[] var1) throws MathLinkException;

    protected synchronized void putComplex(Object object) throws MathLinkException {
        double d = 0.0;
        double d2 = 0.0;
        try {
            d = (Double)this.complexReMethod.invoke(object, null);
            d2 = (Double)this.complexImMethod.invoke(object, null);
        }
        catch (Exception exception) {
            this.putSymbol("Null");
        }
        this.putFunction("Complex", 2);
        this.put(d);
        this.put(d2);
    }

    public synchronized void putData(byte[] byArray) throws MathLinkException {
        this.putData(byArray, byArray.length);
    }

    public abstract void putData(byte[] var1, int var2) throws MathLinkException;

    public abstract void putFunction(String var1, int var2) throws MathLinkException;

    public abstract void putMessage(int var1) throws MathLinkException;

    public abstract void putNext(int var1) throws MathLinkException;

    protected synchronized void putReference(Object object) throws MathLinkException {
        this.put(object.toString());
    }

    public abstract void putSize(int var1) throws MathLinkException;

    protected abstract void putString(String var1) throws MathLinkException;

    public abstract void putSymbol(String var1) throws MathLinkException;

    public abstract boolean ready() throws MathLinkException;

    public synchronized boolean removeMessageHandler(String string) {
        int n = 0;
        while (n < this.userMsgHandlers.size()) {
            if (((MsgHandlerRecord)this.userMsgHandlers.elementAt((int)n)).methName.equals(string)) {
                this.userMsgHandlers.removeElementAt(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public void removePacketListener(PacketListener packetListener) {
        Object object = this.packetListenerLock;
        synchronized (object) {
            if (this.packetListeners != null && this.packetListeners.contains(packetListener)) {
                this.packetListeners.removeElement(packetListener);
            }
        }
    }

    public abstract void seekMark(long var1);

    public synchronized boolean setComplexClass(Class clazz) {
        Constructor constructor = null;
        Method method = null;
        Method method2 = null;
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{Double.TYPE, Double.TYPE};
                constructor = clazz.getDeclaredConstructor(classArray);
                method = clazz.getDeclaredMethod("re", null);
                method2 = clazz.getDeclaredMethod("im", null);
            }
            catch (Exception exception) {
                return false;
            }
        }
        this.complexClass = clazz;
        this.complexCtor = constructor;
        this.complexReMethod = method;
        this.complexImMethod = method2;
        return true;
    }

    public abstract void setError(int var1);

    public synchronized boolean setYieldFunction(Class clazz, Object object, String string) {
        block5: {
            this.userYielder = null;
            this.yielderObject = null;
            if (string == null) break block5;
            Method method = null;
            Class[] classArray = new Class[]{};
            Class<?> clazz2 = clazz != null ? clazz : object.getClass();
            try {
                method = clazz2.getMethod(string, classArray);
            }
            catch (Exception exception) {
                return false;
            }
            this.userYielder = method;
            this.yielderObject = object;
            if (Utils.isJava2OrLater() && !this.userYielder.isAccessible()) {
                try {
                    ((AccessibleObject)this.userYielder).setAccessible(true);
                }
                catch (SecurityException securityException) {
                    System.err.println("J/Link warning: The yield function " + string + " might not be called due to a security restriction. " + "See the documentation for the class java.lang.reflect.ReflectPermission. This problem might go away " + "if JLink.jar is loaded from the classpath instead of the jre/lib/ext directory.");
                    securityException.printStackTrace();
                }
            }
        }
        return true;
    }

    public abstract void transferExpression(MathLink var1) throws MathLinkException;

    public abstract void transferToEndOfLoopbackLink(LoopbackLink var1) throws MathLinkException;

    protected boolean yielderCallback() {
        Object object = null;
        if (this.userYielder != null) {
            try {
                object = this.userYielder.invoke(this.yielderObject, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }
}

