/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.Metafile;

class MetafileRecord {
    private int recordType;
    private long length;
    private byte[] data;
    static final int META_SETBKCOLOR = 513;
    static final int META_SETBKMODE = 258;
    static final int META_SETTEXTCOLOR = 521;
    static final int META_SETWINDOWEXT = 524;
    static final int META_LINETO = 531;
    static final int META_MOVETO = 532;
    static final int META_TEXTOUT = 1313;
    static final int META_POLYGON = 804;
    static final int META_POLYLINE = 805;
    static final int META_SELECTOBJECT = 301;
    static final int META_DELETEOBJECT = 496;
    static final int META_CREATEPENINDIRECT = 762;
    static final int META_CREATEFONTINDIRECT = 763;
    static final int META_CREATEBRUSHINDIRECT = 764;
    static final int META_EOF = -1;
    static final int META_SETWINDOWORG = 523;
    static final int META_SETMAPMODE = 259;
    static final int META_SETPOLYFILLMODE = 262;
    static final int META_SETTEXTALIGN = 302;

    MetafileRecord(Metafile metafile) {
        try {
            this.length = metafile.readDWord() * 2L;
            this.recordType = metafile.readWord();
            if (this.length == -1L || this.recordType == -1) {
                this.recordType = -1;
            } else {
                this.data = new byte[(int)this.length - 6];
                if (metafile.readBytes(this.data) == -1) {
                    this.recordType = -1;
                }
            }
        }
        catch (Exception exception) {
            this.recordType = -1;
        }
    }

    byte[] getData() {
        return this.data;
    }

    int getType() {
        return this.recordType;
    }
}

