/*
 * Decompiled with CFR 0.152.
 */
package jdvi;

import java.io.EOFException;

public final class ArrayFile {
    public byte[] data;
    public int pos = 0;
    int length;
    int nybbleMask = 240;

    public ArrayFile(int n) {
        this.length = n;
        this.data = new byte[this.length];
    }

    public ArrayFile(ArrayFile arrayFile) {
        this.length = arrayFile.length;
        this.data = arrayFile.data;
    }

    public int read() throws EOFException {
        if (this.pos < this.length) {
            int n = (this.data[this.pos] & 0x80) + (this.data[this.pos] & 0x7F);
            ++this.pos;
            return n;
        }
        throw new EOFException();
    }

    public void read(byte[] byArray) throws EOFException {
        if (this.pos + byArray.length < this.length) {
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = this.data[this.pos];
                ++this.pos;
                ++n;
            }
        } else {
            throw new EOFException();
        }
    }

    public int read3() throws EOFException {
        int n = this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        return n;
    }

    public int readInt() throws EOFException {
        int n = this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        return n;
    }

    public int readNybble() throws EOFException {
        if (this.nybbleMask > 15) {
            int n = this.read();
            this.nybbleMask = n & 0xF;
            return (n & 0xF0) / 16;
        }
        int n = this.nybbleMask;
        this.nybbleMask = 16;
        return n;
    }

    public int readSigned() throws EOFException {
        if (this.pos < this.length) {
            byte by = this.data[this.pos];
            ++this.pos;
            return by;
        }
        throw new EOFException();
    }

    public int readSigned3() throws EOFException {
        int n = this.read();
        n = n << 8 | this.read();
        n = n << 8 | this.read();
        return n;
    }

    public short readSignedShort() throws EOFException {
        int n = this.read();
        n = n << 8 | this.read();
        return (short)n;
    }

    public long readUnsignedInt() throws EOFException {
        long l = this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        return l;
    }

    public int readUnsignedShort() throws EOFException {
        int n = this.read();
        n = n << 8 | this.read();
        return n;
    }

    public void skip(int n) {
        this.pos += n;
    }
}

