/*
 * Decompiled with CFR 0.152.
 */
package jdvi;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import jdvi.AppletWrapper;
import jdvi.HyperRef;
import jdvi.JDviColor;
import jdvi.JDviContext;
import jdvi.JDviDocument;
import jdvi.JDviRenderer;
import jdvi.JDviScribbable;
import jdvi.JDviScribble;
import jdvi.JDviStroke;
import jdvi.JDviText;
import jdvi.Magnifier;
import jdvi.Specialist;

public class JDviPanel
extends Panel
implements Specialist,
MouseMotionListener,
MouseListener,
KeyListener,
AppletContext {
    public JDviRenderer renderer;
    Magnifier magnifier;
    JDviContext context;
    public boolean useSystemProperties = false;
    transient Image offscreen;
    Cursor handCursor = new Cursor(12);
    Cursor moveCursor = new Cursor(13);
    HyperRef inHot = null;
    int praefixArg = 0;
    int praefixAnchor = -1;
    Color linkColor;
    Color targetColor;
    public Color tmpColor;
    public JDviDocument document;
    Stack history = new Stack();
    private String currentTarget;
    private boolean targetFound = false;
    int trueDviDpi = 300;
    int dviDpi = 120;
    public Image fullsize;
    protected int xoff = this.dviDpi / 2;
    protected int yoff = this.dviDpi / 2;
    int xsav;
    int ysav;
    protected int cpage = -1;
    Vector hyperRefs = new Vector();
    Vector appletsToShow = new Vector();
    AppletWrapper currentApplet;
    boolean appletFromHash = false;
    Hashtable appletHash = new Hashtable();
    Hashtable appletsByName = new Hashtable();
    public JDviScribble[] scribble;
    boolean scribbleMode = false;
    JDviStroke cStroke = null;
    Rectangle cRect = null;

    public JDviPanel(JDviContext jDviContext) {
        this.context = jDviContext;
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.trueDviDpi = this.getInteger("jdvi.resolution", 300);
        this.tmpColor = JDviColor.getColor(this.context, "textColor", Color.blue);
        this.linkColor = JDviColor.getColor(this.context, "linkColor", Color.blue);
        this.targetColor = JDviColor.getColor(this.context, "targetColor", Color.green);
        this.dviDpi = Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public JDviPanel(JDviContext jDviContext, int n) {
        this(jDviContext);
        this.trueDviDpi = n;
    }

    public JDviPanel(JDviContext jDviContext, URL uRL) throws FileNotFoundException, IOException {
        this(jDviContext, uRL, uRL.toString());
    }

    public JDviPanel(JDviContext jDviContext, URL uRL, String string) throws FileNotFoundException, IOException {
        this(jDviContext);
        this.loadDocument(uRL, string);
    }

    private void addStroke(JDviScribbable jDviScribbable) {
        if (this.scribble[this.cpage] == null) {
            this.scribble[this.cpage] = new JDviScribble();
        }
        this.scribble[this.cpage].addStroke(jDviScribbable);
    }

    public void back() {
        if (!this.history.empty()) {
            Position position = (Position)this.history.pop();
            int n = position.page;
            this.xoff = position.xoff;
            this.yoff = position.yoff;
            this.showPage(n);
        }
        if (this.history.empty()) {
            this.history.push(new Position(this.cpage, this.xoff, this.yoff));
        }
    }

    public void callSpecial(Graphics graphics, int n, int n2, String string, int n3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"=");
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.startsWith("PSfile")) {
            System.out.println("SPECIAL:\n" + string + " dpi=" + this.trueDviDpi);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            String string3 = stringTokenizer.nextToken();
            string3 = string3.substring(0, string3.lastIndexOf(".") + 1);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith("urx")) {
                    string2 = stringTokenizer.nextToken();
                    n5 = Integer.parseInt(string2);
                    continue;
                }
                if (string2.startsWith("ury")) {
                    string2 = stringTokenizer.nextToken();
                    n7 = Integer.parseInt(string2);
                    continue;
                }
                if (string2.startsWith("llx")) {
                    string2 = stringTokenizer.nextToken();
                    n8 = Integer.parseInt(string2);
                    continue;
                }
                if (string2.startsWith("lly")) {
                    string2 = stringTokenizer.nextToken();
                    n9 = Integer.parseInt(string2);
                    continue;
                }
                if (string2.startsWith("rwi")) {
                    string2 = stringTokenizer.nextToken();
                    n10 = Integer.parseInt(string2);
                    continue;
                }
                if (string2.startsWith("rhi")) {
                    string2 = stringTokenizer.nextToken();
                    n11 = Integer.parseInt(string2);
                    continue;
                }
                System.err.println("Unknown token: " + string2 + " in special.");
                return;
            }
            n6 = n11 != 0 ? n11 * this.dviDpi / 720 : (n7 - n9) * n10 * this.dviDpi / (720 * (n5 - n8));
            n4 = n10 != 0 ? n10 * this.dviDpi / 720 : (n5 - n8) * n11 * this.dviDpi / (720 * (n7 - n9));
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.context.getProperty("jdvi.image.formats", "gif;jpg"), ";");
            Image image = null;
            while (stringTokenizer2.hasMoreTokens() & image == null) {
                String string4 = String.valueOf(string3) + stringTokenizer2.nextToken();
                System.out.println("Try loading image " + string4 + " for special");
                try {
                    URL uRL = new URL(this.document.document, string4);
                    image = this.context.getImage(uRL);
                    if (image == null) continue;
                    MediaTracker mediaTracker = new MediaTracker(this);
                    mediaTracker.addImage(image, this.cpage);
                    mediaTracker.waitForID(this.cpage);
                    if ((mediaTracker.statusID(this.cpage, false) & 6) != 0) {
                        image = null;
                        continue;
                    }
                    graphics.drawImage(image, n, n2 - n6, n4, n6, null);
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Image " + string4 + " : " + malformedURLException);
                }
                catch (InterruptedException interruptedException) {
                    image = null;
                    System.err.println("Image loading: " + interruptedException);
                }
            }
            if (image == null) {
                graphics.drawRect(n, n2 - n6, n4, n6);
            }
            System.out.println("image done");
            return;
        }
        if (string2.startsWith("html")) {
            stringTokenizer = new StringTokenizer(string, " \"<>=");
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("A")) {
                string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("name")) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals(this.currentTarget)) {
                        this.targetFound = true;
                        this.tmpColor = this.renderer.getCurrentColor();
                        this.renderer.setCurrentColor(this.targetColor);
                        Dimension dimension = this.getSize();
                        this.yoff = n2 - dimension.height / 2;
                        Enumeration enumeration = this.appletsToShow.elements();
                        while (enumeration.hasMoreElements()) {
                            AppletWrapper appletWrapper = (AppletWrapper)enumeration.nextElement();
                            appletWrapper.setLocation(this.xoff, this.yoff, this.dviDpi);
                        }
                    }
                    return;
                }
                if (string2.equalsIgnoreCase("href")) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.startsWith("#")) {
                        string2 = string2.substring(1);
                    }
                    this.startNewLink(string2, n, n2);
                    return;
                }
            }
            if (string2.equalsIgnoreCase("applet")) {
                Integer n12 = new Integer(n3);
                if (this.appletHash.containsKey(n12)) {
                    this.currentApplet = (AppletWrapper)this.appletHash.get(n12);
                    this.appletFromHash = true;
                    System.out.println("applet from hash");
                } else {
                    string2 = stringTokenizer.nextToken();
                    if (!string2.equalsIgnoreCase("code")) {
                        System.err.println("No code tag in applet special at first position: " + string);
                        return;
                    }
                    string2 = stringTokenizer.nextToken();
                    if (string2.endsWith(".class")) {
                        string2 = string2.substring(0, string2.length() - 6);
                    }
                    System.out.println("looking for applet " + string2);
                    try {
                        Class<?> clazz = Class.forName(string2);
                        this.currentApplet = new AppletWrapper(this.context, this, (Applet)clazz.newInstance(), this.cpage, n3, n, n2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("could not load " + string2 + ":" + classNotFoundException);
                        this.currentApplet = null;
                        return;
                    }
                    catch (InstantiationException instantiationException) {
                        System.err.println("could not instanciate " + string2 + ":" + instantiationException);
                        this.currentApplet = null;
                        return;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.err.println("Illegal access " + string2 + ":" + illegalAccessException);
                        this.currentApplet = null;
                        return;
                    }
                    System.out.println("Applet out there ");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equalsIgnoreCase("WIDTH")) {
                            string2 = stringTokenizer.nextToken();
                            string2 = string2.substring(0, string2.length() - 2);
                            this.currentApplet.width = Double.valueOf(string2);
                            System.out.println("WIDTH=" + this.currentApplet.width);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("HEIGHT")) {
                            string2 = stringTokenizer.nextToken();
                            string2 = string2.substring(0, string2.length() - 2);
                            this.currentApplet.height = Double.valueOf(string2);
                            System.out.println("HEIGHT=" + this.currentApplet.height);
                            continue;
                        }
                        if (!string2.equalsIgnoreCase("NAME")) continue;
                        this.currentApplet.name = stringTokenizer.nextToken();
                    }
                    if (this.currentApplet != null) {
                        this.currentApplet.applet.setStub(this.currentApplet);
                        this.currentApplet.applet.setBackground(Color.white);
                        this.appletHash.put(new Integer(n3), this.currentApplet);
                        this.appletsByName.put(this.currentApplet.name, this.currentApplet.applet);
                    }
                }
                if (this.currentApplet != null) {
                    this.currentApplet.xp = n;
                    this.currentApplet.yp = n2;
                    this.currentApplet.applet.setLocation(n, n2);
                }
                return;
            }
            if (string2.equalsIgnoreCase("param")) {
                String string5 = "";
                String string6 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equalsIgnoreCase("name")) {
                        string5 = stringTokenizer.nextToken();
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("value")) continue;
                    string6 = stringTokenizer.nextToken();
                }
                if (this.currentApplet != null) {
                    this.currentApplet.setParameter(string5, string6);
                } else {
                    System.err.println("Parameter found but No current applet!");
                }
                return;
            }
            if (string2.equalsIgnoreCase("/applet")) {
                if (this.currentApplet != null) {
                    this.currentApplet.applet.setVisible(false);
                    this.add(this.currentApplet.applet);
                    this.appletsToShow.addElement(this.currentApplet);
                    if (!this.appletFromHash) {
                        this.currentApplet.applet.init();
                    }
                    this.currentApplet.applet.start();
                    this.currentApplet.setPosition(this.xoff, this.yoff, this.dviDpi);
                    this.currentApplet.applet.setVisible(true);
                    this.currentApplet = null;
                    this.appletFromHash = false;
                }
                return;
            }
            if (string2.equalsIgnoreCase("/a")) {
                this.closeNewLink(graphics);
                if (this.targetFound) {
                    this.targetFound = false;
                    this.currentTarget = "";
                    this.renderer.setCurrentColor(this.tmpColor);
                }
                return;
            }
        }
    }

    private void closeNewLink(Graphics graphics) {
        if (this.renderer.currentRef != null) {
            this.renderer.setCurrentColor(this.tmpColor);
            this.renderer.currentRef = null;
        }
    }

    public void flushFonts() {
        this.renderer.flushFonts();
    }

    public Applet getApplet(String string) {
        return (Applet)this.appletsByName.get(string);
    }

    public Enumeration getApplets() {
        return this.appletsByName.elements();
    }

    public AudioClip getAudioClip(URL uRL) {
        return null;
    }

    public Image getImage(URL uRL) {
        return this.context.getImage(uRL);
    }

    private int getInteger(String string, int n) {
        int n2 = n;
        try {
            try {
                n2 = Integer.parseInt(this.context.getProperty(string, "xxx"));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Formaterror while parsing " + string + "=" + this.context.getProperty(string) + " as an integer using default " + n + " insead");
                n2 = n;
            }
        }
        catch (Throwable throwable) {}
        return n2;
    }

    public int getNumberOfPages() {
        return this.document.page.length;
    }

    public void gotoPage(int n) {
        this.history.push(new Position(this.cpage, this.xoff, this.yoff));
        this.showPage(n);
    }

    public boolean gotoTarget(String string) {
        Integer n = (Integer)this.document.targetHash.get(string);
        if (n != null) {
            this.currentTarget = string;
            this.gotoPage(n);
            return true;
        }
        return false;
    }

    public void invalidate() {
        super.invalidate();
        this.offscreen = null;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 78 || n == 32 || n == 10) {
            this.nextPage();
            return;
        }
        if (n == 80 || n == 8) {
            this.previousPage();
            return;
        }
        if (n == 66) {
            this.back();
            return;
        }
        if (n > 47 && n <= 57) {
            this.praefixArg = 10 * this.praefixArg + n - 48;
            return;
        }
        if (n == 71) {
            this.gotoPage(this.praefixArg + this.praefixAnchor);
            this.praefixArg = 0;
            return;
        }
        if (n == 83) {
            this.scribbleMode ^= true;
            this.repaint();
            if (this.scribbleMode) {
                this.context.inform("scribble mode on");
            } else {
                this.context.inform("scribble mode off");
            }
            return;
        }
        if (n == 61 && this.dviDpi < this.trueDviDpi - 10) {
            this.setDviDpi(this.dviDpi + 10);
        }
        if (n == 45 | n == 0 && this.dviDpi > 50) {
            this.setDviDpi(this.dviDpi - 10);
        }
        if (n == 39) {
            this.xoff += 20;
        }
        if (n == 37) {
            this.xoff -= 20;
        }
        if (n == 40) {
            this.yoff += 20;
        }
        if (n == 38) {
            this.yoff -= 20;
        }
        this.showPage(this.cpage);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        System.out.println("KeyCode:" + keyEvent.getKeyCode() + ", KeyChar:" + keyEvent.getKeyChar());
    }

    public synchronized void loadDocument(URL uRL, String string) throws FileNotFoundException, IOException {
        System.out.println("Load " + uRL.toString());
        String string2 = this.context.getProperty("jdvi.font.path");
        if (string != null) {
            string2 = String.valueOf(string) + ";" + string2;
        }
        this.document = new JDviDocument(this.context, uRL, string2, this.trueDviDpi);
        this.renderer = new JDviRenderer(this, this.document, this.dviDpi);
        this.magnifier = new Magnifier(this.document);
        this.context.inform("loading done");
        this.scribble = new JDviScribble[this.document.page.length];
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Enumeration enumeration = this.hyperRefs.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            HyperRef hyperRef = (HyperRef)enumeration.nextElement();
            if (!hyperRef.hotArea.contains(mouseEvent.getX() + this.xoff, mouseEvent.getY() + this.yoff)) continue;
            Integer n = (Integer)this.document.targetHash.get(hyperRef.target);
            if (n != null) {
                this.currentTarget = hyperRef.target;
                this.gotoPage(n);
                continue;
            }
            if (hyperRef.target.startsWith("applet:")) {
                object = new StringTokenizer(hyperRef.target, ":.");
                String string = ((StringTokenizer)object).nextToken();
                string = ((StringTokenizer)object).nextToken();
                Applet applet = this.getApplet(string);
                if (applet != null) {
                    Class<?> clazz = applet.getClass();
                    string = ((StringTokenizer)object).nextToken();
                    try {
                        Method method = clazz.getMethod(string, new Class[0]);
                        method.invoke((Object)applet, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        this.context.inform("No such method.");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.context.inform("No accessto method.");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.context.inform(invocationTargetException.toString());
                    }
                } else {
                    this.context.inform("No such applet.");
                }
                return;
            }
            try {
                object = new URL(this.document.document, hyperRef.target);
                this.context.showDocument((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                this.context.inform("Malformed URL");
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.scribbleMode) {
            if (mouseEvent.isMetaDown()) {
                Graphics graphics = null;
                if (this.fullsize != null) {
                    graphics = this.fullsize.getGraphics();
                    graphics.setXORMode(JDviColor.getColor(this.context, "scribbleColor", Color.red));
                }
                if (graphics != null) {
                    graphics.drawRect(this.cRect.x, this.cRect.y, this.cRect.width, this.cRect.height);
                }
                this.cRect.width = -this.cRect.x + (mouseEvent.getX() + this.xoff);
                this.cRect.height = -this.cRect.y + (mouseEvent.getY() + this.yoff);
                if (graphics != null) {
                    graphics.drawRect(this.cRect.x, this.cRect.y, this.cRect.width, this.cRect.height);
                }
                graphics.dispose();
                this.repaint();
                return;
            }
            this.cStroke.addPoint(new Point(this.xsav + this.xoff, this.ysav + this.yoff));
            if (this.fullsize != null) {
                Graphics graphics = this.fullsize.getGraphics();
                graphics.setColor(this.cStroke.color);
                graphics.drawLine(this.xsav + this.xoff, this.ysav + this.yoff, mouseEvent.getX() + this.xoff, mouseEvent.getY() + this.yoff);
                graphics.dispose();
            }
            this.xsav = mouseEvent.getX();
            this.ysav = mouseEvent.getY();
            this.repaint();
        } else {
            if (mouseEvent.isMetaDown()) {
                int n = (mouseEvent.getX() + this.xoff - this.dviDpi) * this.trueDviDpi / this.dviDpi;
                int n2 = (mouseEvent.getY() + this.yoff - this.dviDpi) * this.trueDviDpi / this.dviDpi;
                this.magnifier.magnify(n, n2, this.cpage, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            this.xoff += -mouseEvent.getX() + this.xsav;
            this.yoff += -mouseEvent.getY() + this.ysav;
            this.xsav = mouseEvent.getX();
            this.ysav = mouseEvent.getY();
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        HyperRef hyperRef = null;
        Enumeration enumeration = this.hyperRefs.elements();
        while (enumeration.hasMoreElements()) {
            HyperRef hyperRef2 = (HyperRef)enumeration.nextElement();
            if (!hyperRef2.hotArea.contains(mouseEvent.getX() + this.xoff, mouseEvent.getY() + this.yoff)) continue;
            hyperRef = hyperRef2;
            break;
        }
        if (hyperRef != this.inHot) {
            if (hyperRef != null) {
                this.setCursor(this.handCursor);
                this.context.inform("goto: " + hyperRef.target);
            } else {
                this.setCursor(this.moveCursor);
                this.context.inform("");
            }
            this.inHot = hyperRef;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.scribbleMode && mouseEvent.isShiftDown()) {
            final int n = mouseEvent.getX();
            final int n2 = mouseEvent.getY();
            TextArea textArea = new TextArea("", 10, 3, 3);
            textArea.setLocation(mouseEvent.getX(), mouseEvent.getY());
            textArea.addTextListener(new TextListener(){

                public void textValueChanged(TextEvent textEvent) {
                    if (((TextArea)textEvent.getSource()).getText().endsWith("\n\n")) {
                        JDviPanel.this.remove((TextArea)textEvent.getSource());
                        String string = ((TextArea)textEvent.getSource()).getText();
                        JDviPanel.this.addStroke(new JDviText(JDviPanel.this.dviDpi, JDviColor.getColor(JDviPanel.this.context, "scribbleColor", Color.red), new Point(n + JDviPanel.this.xoff, n2 + JDviPanel.this.yoff), string.substring(0, string.length() - 2)));
                        System.out.println(((TextArea)textEvent.getSource()).getText());
                        JDviPanel.this.showPage(JDviPanel.this.cpage);
                    }
                }
            });
            this.add(textArea);
            textArea.setSize(200, 60);
            return;
        }
        if (this.scribbleMode) {
            if (mouseEvent.isMetaDown()) {
                this.cRect = new Rectangle(mouseEvent.getX() + this.xoff, mouseEvent.getY() + this.yoff, 0, 0);
                return;
            }
            this.cStroke = new JDviStroke(this.dviDpi, JDviColor.getColor(this.context, "scribbleColor", Color.red));
            this.addStroke(this.cStroke);
            this.xsav = mouseEvent.getX();
            this.ysav = mouseEvent.getY();
        } else {
            if (mouseEvent.isMetaDown()) {
                int n = (mouseEvent.getX() + this.xoff - this.dviDpi) * this.trueDviDpi / this.dviDpi;
                int n3 = (mouseEvent.getY() + this.yoff - this.dviDpi) * this.trueDviDpi / this.dviDpi;
                this.magnifier.magnify(n, n3, this.cpage, mouseEvent.getX(), mouseEvent.getY());
                this.add(this.magnifier);
                return;
            }
            this.xsav = mouseEvent.getX();
            this.ysav = mouseEvent.getY();
            Enumeration enumeration = this.appletsToShow.elements();
            while (enumeration.hasMoreElements()) {
                AppletWrapper appletWrapper = (AppletWrapper)enumeration.nextElement();
                Point point = appletWrapper.applet.getLocation();
                Dimension dimension = appletWrapper.applet.getSize();
                Graphics graphics = this.fullsize.getGraphics().create(appletWrapper.xp, appletWrapper.yp - (int)(appletWrapper.height * (double)this.dviDpi / 72.27), dimension.width, dimension.height);
                graphics.setColor(appletWrapper.applet.getForeground());
                appletWrapper.applet.printAll(graphics);
                graphics.dispose();
                this.repaint();
                appletWrapper.applet.setVisible(false);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.scribbleMode) {
            if (mouseEvent.isMetaDown()) {
                if (this.scribble[this.cpage] != null) {
                    this.scribble[this.cpage].removeStrokes(this.cRect, this.dviDpi);
                }
                this.showPage(this.cpage);
                return;
            }
            if (this.cStroke != null) {
                this.cStroke.addPoint(new Point(this.xsav + this.xoff, this.ysav + this.yoff));
            }
            this.cStroke = null;
        }
        this.remove(this.magnifier);
        Enumeration enumeration = this.appletsToShow.elements();
        while (enumeration.hasMoreElements()) {
            AppletWrapper appletWrapper = (AppletWrapper)enumeration.nextElement();
            appletWrapper.setPosition(this.xoff, this.yoff, this.dviDpi);
            appletWrapper.applet.setVisible(true);
        }
    }

    public void nextPage() {
        int n = this.cpage + 1;
        this.showPage(n);
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.setColor(Color.darkGray);
        int n = this.getSize().width - 1;
        int n2 = this.getSize().height - 1;
        graphics2.fillRect(0, 0, n, n2);
        super.paint(graphics2);
        if (this.fullsize == null) {
            this.showPage(this.cpage);
        }
        if (this.fullsize != null) {
            graphics2.drawImage(this.fullsize, -this.xoff, -this.yoff, null);
        }
        graphics2.drawRect(0, 0, n, n2);
        graphics.drawImage(this.offscreen, 0, 0, null);
        graphics2.dispose();
        this.requestFocus();
    }

    public void previousPage() {
        int n = this.cpage;
        if (this.cpage > 0) {
            --n;
        }
        this.showPage(n);
    }

    private void setDviDpi(int n) {
        this.dviDpi = n;
        System.out.println("Settign dviDpi to " + n);
        this.renderer.setDpi(n);
        this.fullsize.flush();
        this.fullsize = null;
    }

    public void setJDviContext(JDviContext jDviContext) {
        this.context = jDviContext;
    }

    public void setPaperSize(double d, double d2) {
        this.document.paperWidth = d;
        this.document.paperHeight = d2;
        if (this.fullsize != null) {
            this.fullsize.flush();
            this.fullsize = null;
        }
    }

    public void showDocument(URL uRL) {
        this.context.showDocument(uRL);
    }

    public void showDocument(URL uRL, String string) {
        this.context.showDocument(uRL, string);
    }

    public void showPage(int n) {
        Object object;
        int n2 = n;
        if (n2 < 0) {
            return;
        }
        if (this.document.page == null) {
            return;
        }
        if (n2 >= this.document.page.length) {
            n2 = this.document.page.length - 1;
        }
        this.cpage = n2;
        this.hyperRefs.removeAllElements();
        Enumeration enumeration = this.appletsToShow.elements();
        while (enumeration.hasMoreElements()) {
            object = (AppletWrapper)enumeration.nextElement();
            ((AppletWrapper)object).applet.stop();
            this.remove(((AppletWrapper)object).applet);
        }
        this.appletsToShow.removeAllElements();
        if (this.fullsize == null) {
            this.fullsize = this.createImage((int)(this.document.paperWidth * (double)this.dviDpi), (int)(this.document.paperHeight * (double)this.dviDpi));
        }
        System.out.println("Page " + n2 + " start parsing");
        object = this.fullsize.getGraphics();
        ((Graphics)object).setClip(0, 0, (int)(this.document.paperWidth * (double)this.dviDpi), (int)(this.document.paperHeight * (double)this.dviDpi));
        try {
            this.renderer.renderPage((Graphics)object, this.dviDpi, this.dviDpi, n2);
        }
        catch (EOFException eOFException) {
            System.err.println("unexpected end of file!");
        }
        this.renderer.flushFonts();
        if (this.scribble[this.cpage] != null) {
            this.scribble[this.cpage].draw((Graphics)object, this.dviDpi);
        }
        ((Graphics)object).dispose();
        this.repaint();
    }

    public void showStatus(String string) {
        this.context.inform(string);
    }

    private void startNewLink(String string, int n, int n2) {
        HyperRef hyperRef = new HyperRef(string, n, n2);
        this.hyperRefs.addElement(hyperRef);
        this.renderer.currentRef = hyperRef;
        this.tmpColor = this.renderer.getCurrentColor();
        this.renderer.setCurrentColor(this.linkColor);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void zoomIn() {
        if (this.dviDpi < this.trueDviDpi - 10) {
            this.setDviDpi(this.dviDpi + 10);
            this.showPage(this.cpage);
            System.out.println("Zoomed in " + this.dviDpi + "dpi");
        }
    }

    public void zoomOut() {
        if (this.dviDpi > 50) {
            this.setDviDpi(this.dviDpi - 10);
            this.showPage(this.cpage);
            System.out.println("Zoomed Out " + this.dviDpi + "dpi");
        }
    }

    class Position {
        public int page;
        public int xoff;
        public int yoff;

        public Position(int n, int n2, int n3) {
            this.page = n;
            this.xoff = n2;
            this.yoff = n3;
        }
    }
}

