/*
 * Decompiled with CFR 0.152.
 */
package jdvi.font;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;

public class Bitmap
implements Serializable {
    private int[] bits;
    public int width;
    public int height;

    public Bitmap(int n, int n2) {
        this.bits = new int[n * n2 / 32 + 1];
        this.width = n;
        this.height = n2;
    }

    public final void clear(int n) {
        int n2 = n / 32;
        this.bits[n2] = this.bits[n2] & ~(1 << n % 32);
    }

    public final void clear(int n, int n2) {
        int n3 = n + n2 * this.width;
        int n4 = n3 / 32;
        this.bits[n4] = this.bits[n4] & ~(1 << n3 % 32);
    }

    public final boolean get(int n) {
        return (this.bits[n / 32] & 1 << n % 32) != 0;
    }

    public final boolean get(int n, int n2) {
        int n3 = n + n2 * this.width;
        return (this.bits[n3 / 32] & 1 << n3 % 32) != 0;
    }

    public final Image getImage() {
        int[] nArray = new int[this.width * this.height];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -16777216 * this.getInt(n);
            ++n;
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, nArray, 0, this.width));
    }

    public final Image getImage(Color color) {
        int n = color.getRGB();
        int[] nArray = new int[this.width * this.height];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n * this.getInt(n2);
            ++n2;
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, nArray, 0, this.width));
    }

    public final int getInt(int n) {
        return this.get(n) ? 1 : 0;
    }

    public final int getInt(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = n + n2 * this.width;
            return this.bits[n3 / 32] >>> n3 % 32 & 1;
        }
        return 0;
    }

    public Image getScaledImage(int n, int n2, double d, Color color) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = color.getRed();
        int n8 = color.getGreen();
        int n9 = color.getBlue();
        int n10 = (int)(1.0 / (2.0 * d) + 1.0);
        int n11 = (int)((double)n * d + 1.0);
        int n12 = (int)((double)n2 * d + 1.0);
        int n13 = n11 + (int)((double)(this.width - n) * d + 1.0);
        if (n13 < 1) {
            n13 = 1;
        }
        if ((n3 = n12 + (int)((double)(this.height - n2) * d + 1.0)) < 1) {
            n3 = 1;
        }
        int[] nArray = new int[n13 * n3];
        int n14 = 0;
        while (n14 < n3) {
            int n15 = 0;
            while (n15 < n13) {
                n4 = (int)((double)(n15 - n11) / d + 0.5) + n;
                n5 = (int)((double)(n14 - n12) / d + 0.5) + n2;
                n6 = this.sampleRegion(n4 - n10, n5 - n10, n4 + n10, n5 + n10);
                n6 = 255 * n6 / (2 * n10 * (2 * n10));
                int n16 = 255 - n6;
                nArray[n15 + n14 * n13] = n6 = (n6 != 0 ? 255 : 0) << 24 | n16 + n7 * n6 / 255 << 16 | n16 + n8 * n6 / 255 << 8 | n16 + n9 * n6 / 255;
                ++n15;
            }
            ++n14;
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n13, n3, nArray, 0, n13));
    }

    public final int sampleRegion(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n2;
        while (n6 < n4) {
            int n7 = n;
            while (n7 < n3) {
                n5 += this.getInt(n7, n6);
                ++n7;
            }
            ++n6;
        }
        return n5;
    }

    public final void set(int n) {
        int n2 = n / 32;
        this.bits[n2] = this.bits[n2] | 1 << n % 32;
    }

    public final void set(int n, int n2) {
        int n3 = n + n2 * this.width;
        int n4 = n3 / 32;
        this.bits[n4] = this.bits[n4] | 1 << n3 % 32;
    }

    public final void set(int n, int n2, boolean bl) {
        int n3 = n + n2 * this.width;
        if (bl) {
            int n4 = n3 / 32;
            this.bits[n4] = this.bits[n4] | 1 << n3 % 32;
        } else {
            int n5 = n3 / 32;
            this.bits[n5] = this.bits[n5] & ~(1 << n3 % 32);
        }
    }

    public final void set(int n, boolean bl) {
        if (bl) {
            int n2 = n / 32;
            this.bits[n2] = this.bits[n2] | 1 << n % 32;
        } else {
            int n3 = n / 32;
            this.bits[n3] = this.bits[n3] & ~(1 << n % 32);
        }
    }
}

