/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgFrame;

public class PgTube
extends PgElementSet {
    protected PgElementSet m_elementSet;
    protected PgPolygon m_polygon;
    protected int m_numFrames;
    protected PgFrame[] m_frame;
    protected PuInteger m_discr;
    private int m_defDiscr = 5;
    protected PuDouble m_thickness;
    private double m_defThickness = 0.5;
    private static /* synthetic */ Class class$jvx$geom$PgTube;

    public PuDouble getThickness() {
        return this.m_thickness;
    }

    public void setThickness(double d) {
        this.m_thickness.setValue(d);
    }

    public PgTube(int n) {
        super(n);
        this.setTag(7);
        this.m_discr = new PuInteger(PsConfig.getMessage((String)"discr"), (PsUpdateIf)this);
        this.m_thickness = new PuDouble(PsConfig.getMessage((String)"thickness"), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgTube != null ? class$jvx$geom$PgTube : (class$jvx$geom$PgTube = PgTube.class$("jvx.geom.PgTube")))) {
            this.init();
        }
    }

    public void setElementSet(PgElementSet pgElementSet) {
        this.m_elementSet = pgElementSet;
        this.m_elementSet.addUpdateListener((PsUpdateIf)this);
    }

    public boolean update(Object object) {
        if (object != null && object == this.m_elementSet) {
            this.generateThickEdges();
            return super.update((Object)this);
        }
        if (object != null && object == this.m_polygon) {
            this.m_numFrames = this.m_polygon.getNumVertices();
            this.m_frame = PgFrame.realloc(this.m_frame, this.m_numFrames, ((PgGeometry)this).m_dim);
            this.generateFrames();
            this.generateTube();
            return super.update((Object)this);
        }
        if (object == this.m_discr) {
            if (this.m_polygon != null) {
                this.generateTube();
            } else if (this.m_elementSet != null) {
                this.generateThickEdges();
            }
            return super.update((Object)this);
        }
        if (object == this.m_thickness) {
            if (this.m_polygon != null) {
                this.generateTube();
            } else if (this.m_elementSet != null) {
                this.generateThickEdges();
            }
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public PuInteger getDiscr() {
        return this.m_discr;
    }

    public void setDiscr(int n) {
        this.m_discr.setValue(n);
    }

    public void setDefThickness(double d) {
        this.m_defThickness = d;
    }

    public void generateTube() {
        if (this.m_polygon == null || this.m_numFrames == 0) {
            return;
        }
        double d = this.m_thickness.getValue();
        int n = this.m_discr.getValue();
        this.setNumVertices(this.m_numFrames * n);
        this.assureVertexNormals();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double d2 = Math.PI * 2 / (double)n;
        int n2 = 0;
        while (n2 < n) {
            double d3 = d2 * (double)n2;
            dArray[n2] = Math.cos(d3);
            dArray2[n2] = Math.sin(d3);
            ++n2;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < this.m_numFrames) {
            int n4 = 0;
            while (n4 < n) {
                ((PgPointSet)this).m_vertexNormal[n2].blend(dArray[n4], this.m_frame[n3].e2, dArray2[n4], this.m_frame[n3].e3);
                ((PgPointSet)this).m_vertex[n2].blend(1.0, this.m_frame[n3].base, d, ((PgPointSet)this).m_vertexNormal[n2]);
                ++n2;
                ++n4;
            }
            ++n3;
        }
        this.makeCylinderConn(this.m_numFrames, n);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PgFrame[] generateFrames() {
        if (this.m_polygon == null || this.m_numFrames == 0) {
            return null;
        }
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        PgFrame pgFrame = new PgFrame(((PgGeometry)this).m_dim);
        PgFrame pgFrame2 = new PgFrame(((PgGeometry)this).m_dim);
        PdVector[] pdVectorArray = this.m_polygon.getVertices();
        if (this.m_numFrames != this.m_polygon.getNumVertices()) {
            PsDebug.warning((String)"incompatible numFrames != polygon.getNumVertices().");
            return null;
        }
        double d = 0.0;
        int n = 1;
        while (n < this.m_numFrames) {
            pdVector.sub(pdVectorArray[n], pdVectorArray[n - 1]);
            d = pdVector.length();
            if (d > 0.0) break;
            ++n;
        }
        if (d == 0.0) {
            return null;
        }
        pgFrame.e1.copy(pdVector);
        pgFrame.e1.normalize();
        pgFrame.e2.normalToVector(pgFrame.e1);
        pgFrame.e3.cross(pgFrame.e1, pgFrame.e2);
        pgFrame.base.copy(pdVectorArray[0]);
        this.m_frame[0].copy(pgFrame);
        n = 1;
        while (n < this.m_numFrames - 1) {
            pdVector.sub(pdVectorArray[n + 1], pdVectorArray[n]);
            pgFrame2.parallelTranslate(pgFrame, this.m_frame[n], pdVectorArray[n], pdVector);
            pgFrame.copy(pgFrame2);
            ++n;
        }
        pgFrame.base.copy(pdVectorArray[this.m_numFrames - 1]);
        this.m_frame[this.m_numFrames - 1].copy(pgFrame);
        return this.m_frame;
    }

    public void setPolygon(PgPolygon pgPolygon) {
        this.m_polygon = pgPolygon;
        this.m_polygon.addUpdateListener((PsUpdateIf)this);
    }

    public void generateThickEdges() {
        int n;
        if (this.m_elementSet == null) {
            return;
        }
        PgElementSet pgElementSet = this.m_elementSet;
        int n2 = pgElementSet.getNumVertices();
        int n3 = pgElementSet.getNumElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertexNormals();
        if (n2 < 1 || pdVectorArray2 == null || pdVectorArray2.length < n2) {
            PsDebug.warning((String)"original surface has missing normals, no tube computed");
            return;
        }
        double d = this.m_thickness.getValue();
        int n4 = this.m_discr.getValue();
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        int n5 = 2 * n2;
        int n6 = 0;
        while (n6 < n3) {
            n5 += n4 * piVectorArray[n6].getSize();
            ++n6;
        }
        this.setNumVertices(n5);
        ((PgPointSet)this).m_vertexNormal = PdVector.realloc((PdVector[])((PgPointSet)this).m_vertexNormal, (int)((PgPointSet)this).m_numVertices, (int)((PgGeometry)this).m_dim);
        n6 = 0;
        while (n6 < n2) {
            ((PgPointSet)this).m_vertexNormal[n6].copy(pdVectorArray2[n6]);
            ((PgPointSet)this).m_vertexNormal[n6 + n2].copy(pdVectorArray2[n6]);
            ((PgPointSet)this).m_vertexNormal[n6 + n2].multScalar(-1.0);
            ((PgPointSet)this).m_vertex[n6].blend(1.0, pdVectorArray[n6], d, pdVectorArray2[n6]);
            ((PgPointSet)this).m_vertex[n6 + n2].blend(1.0, pdVectorArray[n6], -d, pdVectorArray2[n6]);
            ++n6;
        }
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double d2 = Math.PI / (double)(n4 + 1);
        int n7 = 0;
        while (n7 < n4) {
            double d3 = d2 * (double)(n7 + 1);
            dArray[n7] = Math.cos(d3);
            dArray2[n7] = Math.sin(d3);
            ++n7;
        }
        n5 = 2 * n2;
        int n8 = 0;
        while (n8 < n3) {
            n = piVectorArray[n8].getSize();
            n6 = 0;
            while (n6 < n) {
                int n9 = piVectorArray[n8].m_data[n6];
                int n10 = piVectorArray[n8].m_data[(n6 + 1) % n];
                int n11 = piVectorArray[n8].m_data[(n6 + 2) % n];
                pdVector4.sub(pdVectorArray[n11], pdVectorArray[n10]);
                pdVector4.normalize();
                pdVector5.sub(pdVectorArray[n9], pdVectorArray[n10]);
                pdVector5.normalize();
                pdVector2.add(pdVector4, pdVector5);
                double d4 = PdVector.angle((PdVector)pdVector4, (PdVector)pdVector5);
                if (Math.abs(d4) > 179.999) break;
                pdVector2.setLength(d / Math.sin(d4 * Math.PI / 180.0 / 2.0));
                pdVector3.copy(pdVectorArray2[n10]);
                pdVector3.setLength(d);
                n7 = 0;
                while (n7 < n4) {
                    pdVector.blend(dArray[n7], pdVector3, dArray2[n7], pdVector2);
                    ((PgPointSet)this).m_vertex[n5].add(pdVectorArray[n10], pdVector);
                    ++n5;
                    ++n7;
                }
                ++n6;
            }
            ++n8;
        }
        n5 = 0;
        n6 = 0;
        while (n6 < n3) {
            n5 += (n4 + 1) * piVectorArray[n6].getSize();
            ++n6;
        }
        this.setNumElements(n5);
        this.setDimOfElements(4);
        n5 = 0;
        int n12 = 2 * n2;
        n8 = 0;
        while (n8 < n3) {
            int n13;
            int n14;
            n = piVectorArray[n8].getSize();
            int n15 = n12;
            n6 = 0;
            while (n6 < n - 1) {
                n14 = piVectorArray[n8].m_data[(n6 + 1) % n];
                n13 = piVectorArray[n8].m_data[(n6 + 2) % n];
                this.m_element[n5].m_data[0] = n14;
                this.m_element[n5].m_data[1] = n12;
                this.m_element[n5].m_data[2] = n12 + n4;
                this.m_element[n5].m_data[3] = n13;
                ++n5;
                ++n12;
                n7 = 0;
                while (n7 < n4 - 1) {
                    this.m_element[n5].m_data[0] = n12 - 1;
                    this.m_element[n5].m_data[1] = n12;
                    this.m_element[n5].m_data[2] = n12 + n4;
                    this.m_element[n5].m_data[3] = n12 + n4 - 1;
                    ++n5;
                    ++n12;
                    ++n7;
                }
                this.m_element[n5].m_data[0] = n12 - 1;
                this.m_element[n5].m_data[1] = n14 + n2;
                this.m_element[n5].m_data[2] = n13 + n2;
                this.m_element[n5].m_data[3] = n12 + n4 - 1;
                ++n5;
                ++n6;
            }
            n14 = piVectorArray[n8].m_data[(n6 + 1) % n];
            n13 = piVectorArray[n8].m_data[(n6 + 2) % n];
            this.m_element[n5].m_data[0] = n14;
            this.m_element[n5].m_data[1] = n12++;
            this.m_element[n5].m_data[2] = n15++;
            this.m_element[n5].m_data[3] = n13;
            ++n5;
            n7 = 0;
            while (n7 < n4 - 1) {
                this.m_element[n5].m_data[0] = n12 - 1;
                this.m_element[n5].m_data[1] = n12++;
                this.m_element[n5].m_data[2] = n15;
                this.m_element[n5].m_data[3] = n15 - 1;
                ++n5;
                ++n15;
                ++n7;
            }
            this.m_element[n5].m_data[0] = n12 - 1;
            this.m_element[n5].m_data[1] = n14 + n2;
            this.m_element[n5].m_data[2] = n13 + n2;
            this.m_element[n5].m_data[3] = n15 - 1;
            ++n5;
            ++n8;
        }
        this.makeNeighbour();
    }

    public void init() {
        super.init();
        this.m_discr.setDefBounds(2, 20, 1, 2);
        this.m_discr.setDefValue(this.m_defDiscr);
        this.m_discr.init();
        this.m_thickness.setDefBounds(0.01, 5.0, 0.1, 1.0);
        this.m_thickness.setDefValue(this.m_defThickness);
        this.m_thickness.init();
        if (this.m_polygon != null) {
            this.update(this.m_polygon);
            return;
        }
        if (this.m_elementSet != null) {
            this.update(this.m_elementSet);
            return;
        }
        this.m_frame = null;
        this.m_numFrames = 0;
    }

    public void setDefDiscr(int n) {
        this.m_defDiscr = n;
    }
}

