/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgUtil;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnJacobi;

public class PwCurvature
extends PsObject {
    public static PdVector[] getMeanCurvature(PgElementSet pgElementSet, PdVector[] pdVectorArray) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return pdVectorArray;
        }
        int n = pgElementSet.getDimOfVertices();
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        pdVectorArray = PdVector.realloc((PdVector[])pdVectorArray, (int)n3, (int)n);
        PdVector.setConstant((PdVector[])pdVectorArray, (double)0.0);
        double[] dArray = new double[3];
        PdVector[] pdVectorArray3 = new PdVector[3];
        PdVector[] pdVectorArray4 = new PdVector[3];
        PdVector pdVector = new PdVector(n);
        double[] dArray2 = new double[n3];
        int n4 = 0;
        do {
            pdVectorArray4[n4] = new PdVector(n);
        } while (++n4 < 3);
        int n5 = 0;
        while (n5 < n3) {
            pdVectorArray2[n5].clearTag(0);
            ++n5;
        }
        n5 = 0;
        while (n5 < n2) {
            pdVectorArray3 = pgElementSet.getElementVertices(n5);
            double d = PdVector.area((PdVector[])pdVectorArray3);
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray3[0], (PdVector)pdVectorArray3[1], (PdVector)pdVectorArray3[2]);
            n4 = 0;
            do {
                pdVectorArray4[n4].sub(pdVectorArray3[(n4 - 1 + 3) % 3], pdVectorArray3[(n4 + 1 + 3) % 3]);
            } while (++n4 < 3);
            n4 = 0;
            do {
                int n6 = (n4 - 1 + 3) % 3;
                int n7 = (n4 + 1 + 3) % 3;
                pdVector.blend(-dArray[n6], pdVectorArray4[n6], dArray[n7], pdVectorArray4[n7]);
                pdVectorArray[piVectorArray[n5].m_data[n4]].add(pdVector);
                pdVectorArray2[piVectorArray[n5].m_data[n4]].setTag(0);
                int n8 = piVectorArray[n5].m_data[n4];
                dArray2[n8] = dArray2[n8] + d;
            } while (++n4 < 3);
            ++n5;
        }
        return pdVectorArray;
    }

    public static boolean getMeanCurvature(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return false;
        }
        int n = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        pgElementSet.assureVertexNormals();
        PdVector[] pdVectorArray2 = null;
        pdVectorArray2 = PwCurvature.getMeanCurvature(pgElementSet, pdVectorArray2);
        PdVector[] pdVectorArray3 = pgElementSet.getVertexNormals();
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2].hasTag(0)) {
                pdVectorArray3[n2].copy(pdVectorArray2[n2]);
            } else {
                pdVectorArray3[n2].setConstant(0.0);
            }
            ++n2;
        }
        return true;
    }

    public static PdVector getMeanCurvature(PgElementSet pgElementSet, PdVector pdVector) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return pdVector;
        }
        int n = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (!pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        PdVector[] pdVectorArray2 = pgElementSet.getVertexNormals();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        } else if (pdVector.getSize() < n) {
            pdVector.setSize(n);
        }
        PdVector[] pdVectorArray3 = PwCurvature.getMeanCurvature(pgElementSet, null);
        int n2 = 0;
        while (n2 < n) {
            pdVector.m_data[n2] = 0.0;
            if (pdVectorArray[n2].hasTag(0)) {
                pdVector.m_data[n2] = PdVector.dot((PdVector)pdVectorArray3[n2], (PdVector)pdVectorArray2[n2]) > 0.0 ? pdVectorArray3[n2].length() : -pdVectorArray3[n2].length();
                double[] dArray = pdVectorArray3[n2].m_data;
            }
            ++n2;
        }
        return pdVector;
    }

    public static boolean getPrincipalCurvature(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"elements must be triangular, no action");
            return false;
        }
        PgVectorField[] pgVectorFieldArray = new PgVectorField[3];
        PdVector[][] pdVectorArrayArray = new PdVector[3][];
        int n = 0;
        do {
            pgVectorFieldArray[n] = new PgVectorField(3);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
            int n2 = pgElementSet.addVectorField(pgVectorFieldArray[n]);
            pdVectorArrayArray[n] = pgVectorFieldArray[n].getVectors();
        } while (++n < 3);
        pgVectorFieldArray[0].setGlobalVectorColor(Color.black);
        pgVectorFieldArray[1].setGlobalVectorColor(Color.red);
        pgVectorFieldArray[2].setGlobalVectorColor(Color.green);
        pdVectorArrayArray = PwCurvature.getPrincipalCurvature(pgElementSet, pdVectorArrayArray);
        PdVector pdVector = new PdVector();
        PwCurvature.getMeanCurvature(pgElementSet, pdVector);
        PdVector pdVector2 = new PdVector();
        PwCurvature.getGaussCurvature(pgElementSet, pdVector2);
        int n3 = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n4 = 0;
        while (n4 < n3) {
            if (pdVectorArray[n4].hasTag(0)) {
                double d;
                double d2;
                double d3 = pdVector.m_data[n4] * pdVector.m_data[n4] - pdVector2.m_data[n4];
                if (d3 <= 0.0) {
                    PsDebug.warning((String)("H^2-K = " + d3 + " < 0."));
                    d = d2 = Math.sqrt(pdVector2.m_data[n4]);
                } else {
                    d3 = Math.sqrt(d3);
                    d = pdVector.m_data[n4] + d3;
                    d2 = pdVector.m_data[n4] - d3;
                }
            }
            ++n4;
        }
        return true;
    }

    public static boolean getPrincipalCurvatureAngle(PgElementSet pgElementSet) {
        PgVectorField[] pgVectorFieldArray = new PgVectorField[3];
        PdVector[][] pdVectorArrayArray = new PdVector[3][];
        int n = 0;
        do {
            pgVectorFieldArray[n] = new PgVectorField(3);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
            int n2 = pgElementSet.addVectorField(pgVectorFieldArray[n]);
            pdVectorArrayArray[n] = pgVectorFieldArray[n].getVectors();
        } while (++n < 3);
        pdVectorArrayArray = PwCurvature.getPrincipalCurvatureAngle(pgElementSet, pdVectorArrayArray);
        return true;
    }

    public static PdVector[][] getPrincipalCurvature(PgElementSet pgElementSet, PdVector[][] pdVectorArray) {
        int n = pgElementSet.getDimOfVertices();
        if (n != 3) {
            PsDebug.warning((String)("invalid vertex dimension=" + n));
            return pdVectorArray;
        }
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        if (pdVectorArray == null || pdVectorArray.length != n) {
            pdVectorArray = new PdVector[n][];
        }
        int n4 = 0;
        while (n4 < n) {
            if (pdVectorArray[n4] == null || pdVectorArray[n4].length != n3) {
                pdVectorArray[n4] = new PdVector[n3];
            }
            ++n4;
        }
        pgElementSet.makeElementNormals();
        PdVector[] pdVectorArray2 = pgElementSet.getElementNormals();
        PdMatrix[] pdMatrixArray = null;
        pdMatrixArray = PdMatrix.realloc(null, (int)n3, (int)n, (int)n);
        PdMatrix pdMatrix = new PdMatrix(n, n);
        int n5 = 0;
        while (n5 < n2) {
            pdMatrix.adjoint(pdVectorArray2[n5]);
            n4 = 0;
            while (n4 < piVectorArray[n5].m_data.length) {
                pdMatrixArray[piVectorArray[n5].m_data[n4]].add(pdMatrix);
                ++n4;
            }
            ++n5;
        }
        PdVector pdVector = new PdVector(n);
        PdVector[] pdVectorArray3 = new PdVector[n];
        n5 = 0;
        while (n5 < n3) {
            n4 = 0;
            while (n4 < n) {
                pdVectorArray3[n4] = pdVectorArray[n4][n5];
                ++n4;
            }
            int n6 = PnJacobi.computeEigenvectors(pdMatrixArray[n5], n, pdVector, pdVectorArray3);
            n4 = 0;
            while (n4 < n) {
                pdVectorArray3[n4].setLength(pdVector.m_data[n4]);
                ++n4;
            }
            ++n5;
        }
        return pdVectorArray;
    }

    public static PdVector[][] getPrincipalCurvatureAngle(PgElementSet pgElementSet, PdVector[][] pdVectorArray) {
        int n = pgElementSet.getDimOfVertices();
        if (n != 3) {
            PsDebug.warning((String)("invalid vertex dimension=" + n));
            return pdVectorArray;
        }
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        if (pdVectorArray == null || pdVectorArray.length != n) {
            pdVectorArray = new PdVector[n][];
        }
        int n4 = 0;
        while (n4 < n) {
            if (pdVectorArray[n4] == null || pdVectorArray[n4].length != n3) {
                pdVectorArray[n4] = new PdVector[n3];
            }
            ++n4;
        }
        pgElementSet.makeElementNormals();
        PdVector[] pdVectorArray2 = pgElementSet.getElementNormals();
        PdMatrix[] pdMatrixArray = null;
        pdMatrixArray = PdMatrix.realloc(null, (int)n3, (int)n, (int)n);
        PdMatrix pdMatrix = new PdMatrix(n, n);
        PdVector pdVector = new PdVector(n);
        double[] dArray = new double[100];
        int n5 = 0;
        while (n5 < n2) {
            pdVector.copy(pdVectorArray2[n5]);
            if (piVectorArray[n5].m_data.length > 100) {
                PsDebug.error((String)"element with more than 100 vertices, skipped", (Object)pgElementSet);
            } else {
                PdVector[] pdVectorArray3 = pgElementSet.getElementVertices(n5);
                PdVector.angle((double[])dArray, (PdVector[])pdVectorArray3);
                n4 = 0;
                while (n4 < piVectorArray[n5].m_data.length) {
                    pdVector.setLength(dArray[n4]);
                    pdMatrix.adjoint(pdVector);
                    pdMatrixArray[piVectorArray[n5].m_data[n4]].add(pdMatrix);
                    ++n4;
                }
            }
            ++n5;
        }
        PdVector pdVector2 = new PdVector(n);
        PdVector[] pdVectorArray4 = new PdVector[n];
        n5 = 0;
        while (n5 < n3) {
            n4 = 0;
            while (n4 < n) {
                pdVectorArray4[n4] = pdVectorArray[n4][n5];
                ++n4;
            }
            int n6 = PnJacobi.computeEigenvectors(pdMatrixArray[n5], n, pdVector2, pdVectorArray4);
            n4 = 0;
            while (n4 < n) {
                pdVectorArray4[n4].setLength(pdVector2.m_data[n4]);
                ++n4;
            }
            ++n5;
        }
        return pdVectorArray;
    }

    public static boolean getPrincipalCurvatureArea(PgElementSet pgElementSet) {
        PgVectorField[] pgVectorFieldArray = new PgVectorField[3];
        PdVector[][] pdVectorArrayArray = new PdVector[3][];
        int n = 0;
        do {
            pgVectorFieldArray[n] = new PgVectorField(3);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
            int n2 = pgElementSet.addVectorField(pgVectorFieldArray[n]);
            pdVectorArrayArray[n] = pgVectorFieldArray[n].getVectors();
        } while (++n < 3);
        pdVectorArrayArray = PwCurvature.getPrincipalCurvatureArea(pgElementSet, pdVectorArrayArray);
        return true;
    }

    public static PdVector[][] getPrincipalCurvatureArea(PgElementSet pgElementSet, PdVector[][] pdVectorArray) {
        int n = pgElementSet.getDimOfVertices();
        if (n != 3) {
            PsDebug.warning((String)("invalid vertex dimension=" + n));
            return pdVectorArray;
        }
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        if (pdVectorArray == null || pdVectorArray.length != n) {
            pdVectorArray = new PdVector[n][];
        }
        int n4 = 0;
        while (n4 < n) {
            if (pdVectorArray[n4] == null || pdVectorArray[n4].length != n3) {
                pdVectorArray[n4] = new PdVector[n3];
            }
            ++n4;
        }
        pgElementSet.makeElementNormals();
        PdVector[] pdVectorArray2 = pgElementSet.getElementNormals();
        PdMatrix[] pdMatrixArray = null;
        pdMatrixArray = PdMatrix.realloc(null, (int)n3, (int)n, (int)n);
        PdMatrix pdMatrix = new PdMatrix(n, n);
        PdVector pdVector = new PdVector(n);
        int n5 = 0;
        while (n5 < n2) {
            pdVector.copy(pdVectorArray2[n5]);
            pdVector.setLength(pgElementSet.getAreaOfElement(n5));
            pdMatrix.adjoint(pdVector);
            n4 = 0;
            while (n4 < piVectorArray[n5].m_data.length) {
                pdMatrixArray[piVectorArray[n5].m_data[n4]].add(pdMatrix);
                ++n4;
            }
            ++n5;
        }
        PdVector pdVector2 = new PdVector(n);
        PdVector[] pdVectorArray3 = new PdVector[n];
        n5 = 0;
        while (n5 < n3) {
            n4 = 0;
            while (n4 < n) {
                pdVectorArray3[n4] = pdVectorArray[n4][n5];
                ++n4;
            }
            int n6 = PnJacobi.computeEigenvectors(pdMatrixArray[n5], n, pdVector2, pdVectorArray3);
            n4 = 0;
            while (n4 < n) {
                pdVectorArray3[n4].setLength(pdVector2.m_data[n4]);
                ++n4;
            }
            ++n5;
        }
        return pdVectorArray;
    }

    public static void makeColorFromGaussCurvature(PgElementSet pgElementSet) {
        pgElementSet.assureElementColors();
        pgElementSet.assureVertexColors();
        PdVector pdVector = new PdVector(pgElementSet.getNumVertices());
        PwCurvature.getGaussCurvature(pgElementSet, pdVector);
        double d = pdVector.min();
        double d2 = pdVector.max();
        int n = pgElementSet.getNumElements() - 1;
        while (n >= 0) {
            PiVector piVector = pgElementSet.getElement(n);
            double d3 = 0.0;
            int n2 = 0;
            while (n2 < piVector.getSize()) {
                d3 += pdVector.getEntry(piVector.m_data[n2]);
                ++n2;
            }
            pgElementSet.setElementColor(n, PdColor.hsv2rgb((Color)new Color((int)(((d3 /= (double)piVector.getSize()) - d) * 300.0 / (d2 - d)), 255, 255)));
            --n;
        }
        n = pgElementSet.getNumVertices() - 1;
        while (n >= 0) {
            pgElementSet.setVertexColor(n, PdColor.hsv2rgb((Color)new Color((int)((pdVector.getEntry(n) - d) * 300.0 / (d2 - d)), 255, 255)));
            --n;
        }
    }

    public static double getGaussCurvature(PgElementSet pgElementSet, int n) {
        return 0.0;
    }

    public static double getGaussCurvature(PgElementSet pgElementSet, PdVector pdVector) {
        int n;
        int n2;
        int n3 = pgElementSet.getNumElements();
        int n4 = pgElementSet.getNumVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        if (pdVector == null) {
            pdVector = new PdVector(n4);
        } else if (pdVector.getSize() != n4) {
            pdVector.setSize(n4);
        }
        double[] dArray = pdVector.m_data;
        int n5 = 0;
        while (n5 < n4) {
            pdVectorArray[n5].clearTag(0);
            ++n5;
        }
        double[] dArray2 = new double[3];
        n5 = 0;
        while (n5 < n3) {
            int n6;
            n2 = piVectorArray[n5].getSize();
            n = 0;
            while (n < n2) {
                pdVectorArray[piVectorArray[n5].m_data[n]].setTag(0);
                ++n;
            }
            PdVector[] pdVectorArray2 = pgElementSet.getElementVertices(n5);
            if (n2 > 3) {
                PiVector[] piVectorArray3 = PgUtil.triangulate((PdVector[])pdVectorArray2);
                n = 0;
                while (n < n2 - 2) {
                    PdVector.angle((double[])dArray2, (PdVector)pdVectorArray2[piVectorArray3[n].m_data[0]], (PdVector)pdVectorArray2[piVectorArray3[n].m_data[1]], (PdVector)pdVectorArray2[piVectorArray3[n].m_data[2]]);
                    n6 = 0;
                    do {
                        int n7 = piVectorArray[n5].m_data[piVectorArray3[n].m_data[n6]];
                        dArray[n7] = dArray[n7] + dArray2[n6];
                    } while (++n6 < 3);
                    ++n;
                }
            } else if (n2 == 3) {
                PdVector.angle((double[])dArray2, (PdVector)pdVectorArray2[0], (PdVector)pdVectorArray2[1], (PdVector)pdVectorArray2[2]);
                n6 = 0;
                do {
                    int n8 = piVectorArray[n5].m_data[n6];
                    dArray[n8] = dArray[n8] + dArray2[n6];
                } while (++n6 < 3);
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            n2 = piVectorArray[n5].m_data.length;
            n = 0;
            while (n < n2) {
                if (piVectorArray2[n5].m_data[n] == -1) {
                    pdVectorArray[piVectorArray[n5].m_data[(n + 1) % n2]].clearTag(0);
                    pdVectorArray[piVectorArray[n5].m_data[(n + 2) % n2]].clearTag(0);
                }
                ++n;
            }
            ++n5;
        }
        double d = 0.0;
        n5 = 0;
        while (n5 < n4) {
            if (pdVectorArray[n5].hasTag(0)) {
                pdVector.m_data[n5] = Math.PI * 2 - dArray[n5];
                d += pdVector.m_data[n5];
            } else {
                pdVector.m_data[n5] = 0.0;
            }
            ++n5;
        }
        return d;
    }
}

