/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Frame;
import java.awt.image.MemoryImageSource;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jvx.geom.PwLIC_IP;
import jvx.numeric.PnElementRK;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnLIC;
import jvx.numeric.PnVertexRK;

public class PwLIC
extends PsObject
implements Runnable {
    protected static final int m_dimOfDomain = 2;
    protected PgElementSet m_geom = null;
    protected Thread m_LIC;
    protected PuInteger m_vfIndex;
    protected PuInteger m_LICSize;
    protected PuInteger m_conv;
    protected PuInteger m_minConv;
    protected PuDouble m_coarseness;
    protected boolean m_fast = false;
    private String m_origLabel = null;
    private static /* synthetic */ Class class$jvx$geom$PwLIC;

    public boolean isComputingLIC() {
        return this.m_LIC != null && this.m_LIC.isAlive();
    }

    public void close() {
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
    }

    public PwLIC() {
        this.setName("LIC Workshop");
        this.m_LICSize = new PuInteger("LIC size", null);
        this.m_conv = new PuInteger("Convolution Width", (PsUpdateIf)this);
        this.m_minConv = new PuInteger("Min. Convolution Width", (PsUpdateIf)this);
        this.m_coarseness = new PuDouble("Noise Coarseness", null);
        this.m_vfIndex = new PuInteger("Selected vf", null);
        if (this.getClass() == (class$jvx$geom$PwLIC != null ? class$jvx$geom$PwLIC : (class$jvx$geom$PwLIC = PwLIC.class$("jvx.geom.PwLIC")))) {
            this.init();
        }
    }

    public void setFast(boolean bl) {
        this.m_fast = bl;
    }

    public void startLIC() {
        if (this.isComputingLIC()) {
            this.stopLIC();
        }
        this.m_LIC = new Thread(this);
        this.m_LIC.start();
    }

    public void stopLIC() {
        if (this.m_LIC == null) {
            return;
        }
        this.m_LIC.stop();
        this.m_LIC = null;
        System.gc();
        PsPanel psPanel = this.getInfoPanel();
        if (psPanel != null) {
            ((PwLIC_IP)psPanel).m_bMakeLIC.setLabel(this.m_origLabel);
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            super.update(null);
        } else {
            if (object == this.m_infoPanel) {
                return true;
            }
            if (object == this.m_minConv) {
                if (this.m_minConv.getValue() > this.m_conv.getValue()) {
                    this.m_minConv.setValue(this.m_conv.getValue());
                }
            } else {
                if (object == this.m_conv) {
                    if (this.m_minConv.getValue() > this.m_conv.getValue()) {
                        this.m_minConv.setValue(this.m_conv.getValue());
                    }
                    return true;
                }
                if (object == this.m_geom) {
                    int n = this.m_geom.getNumVectorFields();
                    if (n > 0) {
                        this.m_vfIndex.setBounds(1, n, 1, 2);
                        this.m_vfIndex.update((Object)this.m_vfIndex);
                    } else {
                        this.m_vfIndex.setBounds(0, 0, 1, 2);
                        this.m_vfIndex.setValue(0);
                        this.m_vfIndex.update((Object)this.m_vfIndex);
                    }
                    return super.update(null);
                }
            }
        }
        return super.update(object);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_geom = pgElementSet;
        if (this.m_geom != null) {
            PgElementSet.triangulate((PgElementSet)this.m_geom);
            this.m_geom.addUpdateListener((PsUpdateIf)this);
            this.update(this.m_geom);
        }
    }

    public void setVectorFieldIndex(int n) {
        this.m_vfIndex.setValue(n + 1);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void run() {
        PgElementSet pgElementSet = null;
        PgVectorField pgVectorField = null;
        pgElementSet = this.m_geom;
        if (this.m_vfIndex.getValue() <= 0 || this.m_vfIndex.getValue() > pgElementSet.getNumVectorFields()) {
            return;
        }
        pgVectorField = pgElementSet.getVectorField(this.m_vfIndex.getValue() - 1);
        long l = new Date().getTime();
        PwLIC_IP pwLIC_IP = (PwLIC_IP)this.getInfoPanel();
        if (pwLIC_IP != null) {
            this.m_origLabel = pwLIC_IP.m_bMakeLIC.getLabel();
        }
        if (pwLIC_IP != null) {
            pwLIC_IP.m_bMakeLIC.setLabel("LIC preparing...");
        }
        if (pwLIC_IP != null) {
            pwLIC_IP.m_bMakeLIC.setLabel("LIC make barycentric...");
        }
        PnGeodesicRK pnGeodesicRK = null;
        if (pgVectorField.getBasedOn() == 1) {
            pnGeodesicRK = new PnElementRK(pgElementSet);
            ((PnElementRK)pnGeodesicRK).setVectorField(pgVectorField);
        } else {
            pnGeodesicRK = new PnVertexRK(pgElementSet);
            ((PnVertexRK)pnGeodesicRK).setVectorField(pgVectorField);
        }
        pnGeodesicRK.setFirstOrder(this.m_fast);
        PgTexture pgTexture = new PgTexture();
        Frame frame = PsConfig.getFrame();
        int n = this.m_LICSize.getValue();
        if (pwLIC_IP != null) {
            pwLIC_IP.m_bMakeLIC.setLabel("LIC init...");
        }
        PnLIC pnLIC = new PnLIC(pgElementSet, n, 0.0, pnGeodesicRK);
        int[] nArray = null;
        int n2 = pnLIC.getTextureWidth();
        int n3 = pnLIC.getTextureHeight();
        pnLIC.setConvolutionWidth(this.m_conv.getValue());
        pnLIC.setMinConvolutionWidth(this.m_minConv.getValue());
        pnLIC.setCoarseness(this.m_coarseness.getValue());
        int n4 = pgElementSet.getNumElements();
        if (pwLIC_IP != null) {
            pwLIC_IP.m_bMakeLIC.setLabel("LIC 0%");
        }
        int n5 = n4 - 1;
        while (n5 >= 0) {
            pnLIC.makeElement(n5);
            if (n4 >= 10 && n5 % (n4 / 10) == 0 && pwLIC_IP != null) {
                pwLIC_IP.m_bMakeLIC.setLabel("LIC " + (100 - (int)((double)n5 / ((double)n4 / 10.0) * 10.0)) + "%");
            } else if (n4 < 10 && pwLIC_IP != null) {
                pwLIC_IP.m_bMakeLIC.setLabel("LIC " + (int)((double)(n4 - n5) * 100.0 / (double)n4) + "%");
            }
            --n5;
        }
        PwLIC pwLIC = this;
        synchronized (pwLIC) {
            nArray = pnLIC.getPixArray(nArray);
            pgTexture.setImage(frame.createImage(new MemoryImageSource(n2, n3, nArray, 0, n2)));
            pgElementSet.setTexture(pgTexture);
            pgElementSet.showElements(true);
            pgElementSet.showElementTexture(true);
            pgElementSet.update(null);
            pnLIC = null;
            nArray = null;
            System.gc();
            Object var17_17 = null;
        }
        if (pwLIC_IP != null) {
            pwLIC_IP.m_bMakeLIC.setLabel(this.m_origLabel);
        }
        long l2 = new Date().getTime() - l;
        if (pwLIC_IP != null) {
            pwLIC_IP.setTime(l2);
        }
    }

    public void init() {
        super.init();
        this.m_LICSize.setDefBounds(10, 500, 5, 50);
        this.m_LICSize.setDefValue(120);
        this.m_LICSize.init();
        this.m_conv.setDefBounds(2, 100, 1, 5);
        this.m_conv.setDefValue(35);
        this.m_conv.init();
        this.m_minConv.setDefBounds(1, 50, 1, 5);
        this.m_minConv.setDefValue(2);
        this.m_minConv.init();
        this.m_coarseness.setDefBounds(0.0, 1.0, 0.05, 0.1);
        this.m_coarseness.setDefValue(0.0);
        this.m_coarseness.init();
        this.m_vfIndex.setDefBounds(0, 0, 1, 2);
        this.m_vfIndex.setDefValue(0);
        this.m_vfIndex.init();
        if (this.m_geom != null) {
            this.update(this.m_geom);
        }
    }
}

