/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PwRivaraBisection
extends PsObject {
    protected PgElementSet m_geom = null;
    protected PdVector[] m_vertex;
    protected PiVector[] m_element;
    protected PiVector[] m_neighbour;
    protected int caNewSize = 50;
    protected int caElementUsedSize;
    protected int caElementMaxSize;
    protected int caVertexUsedSize;
    protected int caVertexMaxSize;
    protected int caNeighbourUsedSize;
    protected int caNeighbourMaxSize;

    protected final int rivaraRefineElement(int n, int[] nArray, int n2) {
        int n3 = this.m_neighbour[n].getEntry(1);
        ++this.caElementUsedSize;
        if (this.caElementUsedSize > this.caElementMaxSize) {
            this.m_element = PiVector.realloc((PiVector[])this.m_element, (int)(this.m_element.length + this.caNewSize), (int)3);
            this.caElementMaxSize += this.caNewSize;
        }
        int n4 = this.caElementUsedSize - 1;
        if (n2 == -1) {
            ++this.caVertexUsedSize;
            if (this.caVertexUsedSize > this.caVertexMaxSize) {
                this.m_vertex = PdVector.realloc((PdVector[])this.m_vertex, (int)(this.m_vertex.length + this.caNewSize), (int)this.m_geom.getDimOfVertices());
                this.caVertexMaxSize += this.caNewSize;
            }
            n2 = this.caVertexUsedSize - 1;
            PdVector pdVector = this.rivaraRefineEdge(n, this.m_vertex[this.m_element[n].getEntry(1)], this.m_vertex[this.m_element[n].getEntry(2)]);
            this.m_vertex[n2].copy(pdVector);
        }
        ++this.caNeighbourUsedSize;
        if (this.caNeighbourUsedSize > this.caNeighbourMaxSize) {
            this.m_neighbour = PiVector.realloc((PiVector[])this.m_neighbour, (int)(this.m_neighbour.length + this.caNewSize), (int)3);
            this.caNeighbourMaxSize += this.caNewSize;
        }
        this.m_element[n4].set(n2, this.m_element[n].getEntry(2), this.m_element[n].getEntry(0));
        this.m_element[n].set(n2, this.m_element[n].getEntry(0), this.m_element[n].getEntry(1));
        this.m_neighbour[n4].set(this.m_neighbour[n].getEntry(1), n, -1);
        this.m_neighbour[n].set(this.m_neighbour[n].getEntry(2), -1, n4);
        if (n3 >= 0) {
            int n5 = 0;
            do {
                if (this.m_neighbour[n3].getEntry(n5) != n) continue;
                this.m_neighbour[n3].setEntry(n5, n4);
            } while (++n5 < 3);
        }
        nArray[0] = n;
        nArray[1] = n4;
        return n2;
    }

    protected final int rivaraRefineElement(int n, int[] nArray, int n2, int n3) {
        int n4;
        int n5 = nArray[0];
        int n6 = nArray[1];
        if (this.m_neighbour[n2].getEntry(0) == n) {
            n4 = this.rivaraRefineElement(n2, nArray, n3);
            int n7 = nArray[1];
            this.rivaraSimpleConnect(n2, n7, n5, n6);
            nArray[0] = -1;
            nArray[1] = -1;
        } else {
            int[] nArray2 = new int[2];
            int n8 = this.m_neighbour[n2].getEntry(1) == n ? 1 : 2;
            n4 = this.rivaraRefineElement(n2, nArray, -1);
            int n9 = nArray[1];
            int n10 = n8 == 2 ? n2 : n9;
            this.rivaraRefineElement(n10, nArray2, n3);
            int n11 = nArray2[1];
            this.rivaraSimpleConnect(n10, n11, n5, n6);
            if (n8 == 2) {
                nArray[1] = n9;
                nArray[0] = nArray2[1];
            } else {
                nArray[0] = n2;
                nArray[1] = nArray2[0];
            }
        }
        return n4;
    }

    protected PdVector rivaraRefineEdge(int n, PdVector pdVector, PdVector pdVector2) {
        PdVector pdVector3 = PdVector.blendNew((double)0.5, (PdVector)pdVector, (double)0.5, (PdVector)pdVector2);
        return pdVector3;
    }

    protected final boolean shareEdge(int n, int n2, int[] nArray) {
        int n3 = 0;
        do {
            int n4 = 0;
            do {
                if ((this.m_element[n].getEntry((n3 + 1) % 3) != this.m_element[n2].getEntry((n4 + 1) % 3) || this.m_element[n].getEntry((n3 + 2) % 3) != this.m_element[n2].getEntry((n4 + 2) % 3)) && (this.m_element[n].getEntry((n3 + 1) % 3) != this.m_element[n2].getEntry((n4 + 2) % 3) || this.m_element[n].getEntry((n3 + 2) % 3) != this.m_element[n2].getEntry((n4 + 1) % 3))) continue;
                nArray[0] = n3;
                nArray[1] = n4;
                return true;
            } while (++n4 < 3);
        } while (++n3 < 3);
        return false;
    }

    protected boolean setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing geometry.");
            return false;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry does not consist of triangles.");
            return false;
        }
        this.m_geom = pgElementSet;
        int n = this.m_geom.getNumVertices();
        int n2 = this.m_geom.getNumElements();
        this.m_vertex = PdVector.copyNew((PdVector[])this.m_geom.getVertices(), (int)n);
        this.m_element = PiVector.copyNew((PiVector[])this.m_geom.getElements(), (int)n2);
        this.m_neighbour = PiVector.copyNew((PiVector[])this.m_geom.getNeighbours(), (int)n2);
        return true;
    }

    public boolean rivaraRefinement(PgElementSet pgElementSet, int[] nArray) {
        int[] nArray2 = new int[2];
        if (!this.setGeometry(pgElementSet)) {
            return false;
        }
        boolean[] blArray = new boolean[this.m_geom.getNumElements()];
        int n = 0;
        while (n < nArray.length) {
            blArray[nArray[n]] = true;
            ++n;
        }
        this.caElementUsedSize = this.caElementMaxSize = this.m_element.length;
        this.caVertexUsedSize = this.caVertexMaxSize = this.m_vertex.length;
        this.caNeighbourUsedSize = this.caNeighbourMaxSize = this.m_neighbour.length;
        n = 0;
        while (n < nArray.length) {
            if (blArray[nArray[n]]) {
                int n2 = -1;
                nArray2[1] = -1;
                nArray2[0] = -1;
                int n3 = nArray[n];
                int n4 = this.m_neighbour[n3].getEntry(0);
                int n5 = n4 != -1 ? this.m_neighbour[n4].getEntry(0) : -1;
                int n6 = this.rivaraRefineElement(n3, nArray2, -1);
                while (n4 != -1 && n5 != -1 && n5 != n3) {
                    n2 = n3;
                    n3 = n4;
                    n4 = n5;
                    n5 = this.m_neighbour[n4].getEntry(0);
                    n6 = this.rivaraRefineElement(n2, nArray2, n3, n6);
                }
                if (n4 != -1 && n5 != -1 && n5 == n3) {
                    n2 = n3;
                    n3 = n4;
                    n4 = n5;
                    n5 = this.m_neighbour[n4].getEntry(0);
                    n6 = this.rivaraRefineElement(n2, nArray2, n3, n6);
                }
            }
            ++n;
        }
        this.finish();
        return true;
    }

    protected void finish() {
        this.m_element = PiVector.realloc((PiVector[])this.m_element, (int)this.caElementUsedSize);
        this.m_vertex = PdVector.realloc((PdVector[])this.m_vertex, (int)this.caVertexUsedSize);
        this.m_neighbour = PiVector.realloc((PiVector[])this.m_neighbour, (int)this.caNeighbourUsedSize);
        this.m_geom.setNumVertices(this.m_vertex.length);
        this.m_geom.setNumElements(this.m_element.length);
        this.m_geom.setVertices(this.m_vertex);
        this.m_geom.setElements(this.m_element);
        this.m_geom.setNeighbours(this.m_neighbour);
    }

    protected final void rivaraSimpleConnect(int n, int n2, int n3, int n4) {
        int[] nArray = new int[2];
        if (this.shareEdge(n, n3, nArray)) {
            this.m_neighbour[n].setEntry(nArray[0], n3);
            this.m_neighbour[n3].setEntry(nArray[1], n);
            this.shareEdge(n2, n4, nArray);
            this.m_neighbour[n2].setEntry(nArray[0], n4);
            this.m_neighbour[n4].setEntry(nArray[1], n2);
            return;
        }
        this.shareEdge(n, n4, nArray);
        this.m_neighbour[n].setEntry(nArray[0], n4);
        this.m_neighbour[n4].setEntry(nArray[1], n);
        this.shareEdge(n2, n3, nArray);
        this.m_neighbour[n2].setEntry(nArray[0], n3);
        this.m_neighbour[n3].setEntry(nArray[1], n2);
    }
}

