/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgOffLoader
implements PgLoaderIf {
    protected boolean m_bIsAnimation = false;
    private static final String StrNL = "\n";

    protected static PgJvxSrc parse(BufferedReader bufferedReader) {
        int n;
        int n2;
        boolean bl;
        int n3 = 4;
        int n4 = 200;
        double[] dArray = new double[n3];
        int[] nArray = new int[n4];
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChars(47, 47);
        streamTokenizer.commentChar(35);
        try {
            bl = true;
            while (bl) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning((String)("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype));
                        return null;
                    }
                    case -3: {
                        if (!"OFF".equals(streamTokenizer.sval)) {
                            PsDebug.warning((String)("magic word 'OFF' missing as first token\n\t First token found = " + streamTokenizer.sval));
                            return null;
                        }
                        bl = false;
                    }
                    case 10: 
                }
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        pgJvxSrc.setType(33);
        int n5 = 3;
        try {
            bl = true;
            while (bl) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning((String)("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype));
                        return null;
                    }
                    case -2: {
                        pgJvxSrc.setDimOfVertices(n5);
                        pgJvxSrc.setNumVertices((int)streamTokenizer.nval);
                        streamTokenizer.nextToken();
                        pgJvxSrc.setDimOfElements(-1);
                        pgJvxSrc.setNumElements((int)streamTokenizer.nval);
                        streamTokenizer.nextToken();
                        bl = false;
                    }
                    case 10: 
                }
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
        int n6 = pgJvxSrc.getNumVertices();
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        try {
            bl = true;
            n2 = 0;
            while (n2 < n6) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning((String)("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype));
                        return null;
                    }
                    case -2: {
                        n = 0;
                        dArray[n] = streamTokenizer.nval;
                        ++n;
                        while (streamTokenizer.nextToken() == -2) {
                            streamTokenizer.pushBack();
                            dArray[n] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                            ++n;
                        }
                        streamTokenizer.pushBack();
                        if (n > 0) {
                            if (n > n5) {
                                pgJvxSrc.setDimOfVertices(n);
                                pgJvxSrc.setNumVertices(n6);
                                pdVectorArray = pgJvxSrc.getVertices();
                                n5 = n;
                            }
                            pdVectorArray[n2].set(dArray, n);
                            ++n2;
                        } else {
                            PsDebug.warning((String)("vertex with no coords in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype));
                        }
                        bl = false;
                    }
                    case 10: 
                }
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
        n2 = pgJvxSrc.getNumElements();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        PdVector[] pdVectorArray2 = null;
        try {
            int n7 = 0;
            while (n7 < n2) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning((String)("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype));
                        return null;
                    }
                    case -2: {
                        n = (int)streamTokenizer.nval;
                        int n8 = 0;
                        while (n8 < n) {
                            if (streamTokenizer.nextToken() != -2) {
                                PsDebug.warning((String)("parse error of face in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype));
                                return null;
                            }
                            nArray[n8] = (int)streamTokenizer.nval;
                            ++n8;
                        }
                        if (n > 0) {
                            piVectorArray[n7].setSize(n);
                            piVectorArray[n7].set(nArray, n);
                            ++n7;
                        } else {
                            PsDebug.warning((String)("face with no vertices in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype));
                        }
                        if (streamTokenizer.nextToken() == -2) {
                            if (pdVectorArray2 == null) {
                                pgJvxSrc.assureElementNormals();
                                pdVectorArray2 = pgJvxSrc.getElementNormals();
                            }
                            n = 3;
                            streamTokenizer.pushBack();
                            pdVectorArray2[n7 - 1].m_data[0] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                            n8 = 1;
                            while (n8 < n) {
                                pdVectorArray2[n7 - 1].m_data[n8] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                                ++n8;
                            }
                            pdVectorArray2[n7 - 1].normalize();
                            break;
                        }
                        streamTokenizer.pushBack();
                    }
                    case 10: 
                }
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
        if (pdVectorArray2 == null || pdVectorArray2.length == n2) {
            // empty if block
        }
        return pgJvxSrc;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = PgOffLoader.parse(bufferedReader);
        if (pgJvxSrc == null) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        PgOffLoader.geomInitType(pgJvxSrc);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    public PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        PgJvxSrc[] pgJvxSrcArray = this.read(bufferedReader);
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            if (pgJvxSrcArray.length == 1) {
                pgJvxSrcArray[0].setName(PsUtil.getFileBaseName((String)string));
            } else {
                int n = 0;
                while (n < pgJvxSrcArray.length) {
                    pgJvxSrcArray[n].setName(PsUtil.getFileBaseName((String)string) + "[" + n + "]");
                    ++n;
                }
            }
        }
        return pgJvxSrcArray;
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("OFF\n");
        writer.write("# ---- Remove following lines starting with '#' to have a valid OFF file --------\n");
        writer.write("#\n");
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = Geometry Center OFF\n");
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + StrNL);
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int n = pgJvxSrc.getNumVertices();
        writer.write("#     Number of Vertices = " + n + StrNL);
        int n2 = pgJvxSrc.getNumElements();
        writer.write("#     Number of Elements = " + n2 + StrNL);
        if (pgJvxSrc.getVertexNormals() != null) {
            writer.write("#     Additional: Element Normals\n");
        }
        writer.write("#\n# End of Header\n");
        writer.write(String.valueOf(pgJvxSrc.getNumVertices()) + " " + String.valueOf(pgJvxSrc.getNumElements()) + " 100\n");
        writer.write(PgOffLoader.writeVertices(n, pgJvxSrc.getVertices()));
        writer.write(PgOffLoader.writeElements(n2, pgJvxSrc.getElements(), pgJvxSrc.getElementNormals()));
        return true;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    protected static String writeVertices(int n, PdVector[] pdVectorArray) {
        if (n <= 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2] == null) {
                PsDebug.warning((String)("missing vertex, ind = " + n2));
                return null;
            }
            int n3 = 0;
            while (n3 < pdVectorArray[n2].m_data.length) {
                if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                    stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                } else {
                    stringBuffer.append(0.0f);
                }
                if (n3 < pdVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected static String writeElements(int n, PiVector[] piVectorArray, PdVector[] pdVectorArray) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            if (piVectorArray[n2] == null) {
                PsDebug.warning((String)("missing element, ind = " + n2));
                return null;
            }
            stringBuffer.append(String.valueOf(piVectorArray[n2].getSize()) + " ");
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                stringBuffer.append(String.valueOf(piVectorArray[n2].m_data[n3]));
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            if (pdVectorArray != null && pdVectorArray.length == piVectorArray.length) {
                stringBuffer.append(" ");
                n3 = 0;
                while (n3 < pdVectorArray[n2].m_data.length) {
                    if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                        stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                    } else {
                        stringBuffer.append(0.0f);
                    }
                    if (n3 < pdVectorArray[n2].m_data.length - 1) {
                        stringBuffer.append(" ");
                    }
                    ++n3;
                }
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

