/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;

public class PnGeodesicRK
extends PsObject {
    protected PgElementSet m_geom;
    protected boolean m_fast = false;
    private boolean m_recalc = false;
    private PdBaryDir[] yorig = new PdBaryDir[3];
    private PdBaryDir[] y = new PdBaryDir[4];
    private PgPolygonOnElementSet m_geod;
    private PgPolygonOnElementSet m_geod2;
    private PdBary m_pos;
    private int m_elem;
    protected PgPolygonOnElementSet m_outpoly;
    private PdBaryDir m_dir;
    private double m_h;
    protected double m_lastLength = 0.0;

    public boolean prepareSolve(PgPolygonOnElementSet pgPolygonOnElementSet, int n, PdBary pdBary, double d) {
        if (pgPolygonOnElementSet == null) {
            PsDebug.warning((String)"Missing output polygon.");
            return false;
        }
        if (pdBary == null) {
            PsDebug.warning((String)"Missing initial coordinates.");
            return false;
        }
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry.");
            return false;
        }
        if (n < 0 || n >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)"Invalid initial element.");
            return false;
        }
        this.m_elem = n;
        this.m_pos = new PdBary(3);
        this.m_pos.copy(pdBary);
        this.m_outpoly = pgPolygonOnElementSet;
        this.m_outpoly.setNumVertices(1);
        this.m_outpoly.setVertex(0, this.m_elem, this.m_pos);
        this.m_geod2.setNumVertices(0);
        this.m_dir = new PdBaryDir(3);
        this.m_h = d;
        return true;
    }

    public PnGeodesicRK(PgElementSet pgElementSet) {
        this.setGeometry(pgElementSet);
        int n = 0;
        do {
            this.y[n] = new PdBaryDir(3);
        } while (++n < 4);
        n = 0;
        do {
            this.yorig[n] = new PdBaryDir(3);
        } while (++n < 3);
    }

    public void setFourthOrder(boolean bl) {
        this.m_fast = !bl;
    }

    protected int rungeKutta(int n, PdBary pdBary, PdBaryDir pdBaryDir, double d) {
        int n2;
        int n3;
        this.eval(n, pdBary, this.y[0]);
        int n4 = n3 = PwBary.liesOnVertex(pdBary);
        if (n3 != -1 && !PwBary.showsIntoElement(this.y[0], n3)) {
            PsDebug.warning((String)"Direction must show into the element.");
            PsDebug.warning((String)(this.y[0].toString() + "\n" + pdBary.toString()));
            return -1;
        }
        double d2 = PwBary.norm(this.m_geom, n, this.y[0], this.m_recalc);
        this.m_recalc = false;
        double d3 = d2;
        if (d3 < 1.0E-10) {
            return -1;
        }
        if (this.m_fast) {
            pdBaryDir.copy(this.y[0]);
        } else {
            PdBaryDir pdBaryDir2 = new PdBaryDir(3);
            pdBaryDir2.copy(this.y[0]);
            PdBary pdBary2 = new PdBary(3);
            pdBary2.copy(pdBary);
            int n5 = n;
            n2 = 1;
            do {
                if (d2 < 1.0E-10) {
                    int n6 = 0;
                    do {
                        this.y[n2].m_data[n6] = 0.0;
                    } while (++n6 < 3);
                    continue;
                }
                double d4 = n2 != 3 ? d / 2.0 : d;
                PdBaryDir pdBaryDir3 = this.m_geod.exp(n5, pdBary2, pdBaryDir2, d4);
                if (pdBaryDir3 == null) {
                    PsDebug.warning((String)"Geodesic not valid.");
                    pdBaryDir.copy(this.y[0]);
                    return -1;
                }
                int n7 = this.m_geod.getNumVertices();
                if (n7 < 2) {
                    pdBaryDir.copy(this.y[0]);
                    return -1;
                }
                PdBary pdBary3 = this.m_geod.getBary(n7 - 1);
                int n8 = this.m_geod.getElemInd(n7 - 1);
                this.eval(n8, pdBary3, this.yorig[n2 - 1]);
                double d5 = PwBary.norm(this.m_geom, n8, this.yorig[n2 - 1], false);
                double d6 = 0.0;
                if ((n8 != n || n3 != -1) && d5 >= 1.0E-10) {
                    d6 = PwBary.getOrientedAngle(this.m_geom, n8, pdBaryDir3, this.yorig[n2 - 1], false);
                }
                if (n8 != n) {
                    PwBary.rotateInElement(this.m_geom, n, this.y[n2 - 1], d6, this.y[n2], false);
                    if (d2 < 1.0E-10) {
                        this.y[n2].multScalar(0.0);
                    } else {
                        this.y[n2].multScalar(1.0 / d2);
                        this.y[n2].multScalar(d5);
                        d2 = d5;
                    }
                } else if (d2 < 1.0E-10) {
                    this.y[n2].multScalar(0.0);
                } else {
                    this.y[n2].copy(this.yorig[n2 - 1]);
                    d2 = d5;
                }
                if (n3 != -1) {
                    n5 = PwBary.rotateAtVertex(this.m_geom, n5, n3, pdBaryDir2, pdBaryDir2, pdBary2, d6);
                    n3 = PwBary.liesOnVertex(pdBary2);
                    continue;
                }
                pdBaryDir2.copy(this.y[n2]);
            } while (++n2 < 4);
            n2 = 0;
            do {
                pdBaryDir.m_data[n2] = 0.16666666666666666 * (this.y[0].m_data[n2] + 2.0 * this.y[1].m_data[n2] + 2.0 * this.y[2].m_data[n2] + this.y[3].m_data[n2]);
            } while (++n2 < 3);
        }
        double d7 = PwBary.norm(this.m_geom, n, pdBaryDir, false);
        if (d7 < 1.0E-10) {
            return -1;
        }
        this.m_lastLength = d7 * this.m_h;
        if (!this.m_fast && n4 != -1) {
            double d8 = PwBary.getOrientedAngle(this.m_geom, n, this.y[0], pdBaryDir, false);
            n2 = PwBary.rotateAtVertex(this.m_geom, n, n4, this.y[0], pdBaryDir, pdBary, d8);
            pdBaryDir.multScalar(d7 / d3);
            n = n2;
        }
        return n;
    }

    public boolean nextStep() {
        int n;
        int n2;
        this.m_geod2.setNumVertices(1);
        this.m_geod2.setVertex(0, this.m_elem, this.m_pos);
        int n3 = PwBary.liesOnVertex(this.m_pos);
        if (n3 != -1) {
            this.m_pos.m_data[n3] = 1.0;
            this.m_pos.m_data[(n3 + 1) % 3] = 0.0;
            this.m_pos.m_data[(n3 + 2) % 3] = 0.0;
            this.eval(this.m_elem, this.m_pos, this.m_dir);
            if (!PwBary.showsIntoElement(this.m_dir, n3)) {
                PgVertexStar pgVertexStar = new PgVertexStar();
                pgVertexStar.makeVertexStar(this.m_geom, this.m_geom.getElement((int)this.m_elem).m_data[n3], this.m_elem);
                n2 = -1;
                int n4 = pgVertexStar.getSize();
                PiVector piVector = pgVertexStar.getElement();
                PiVector piVector2 = pgVertexStar.getVertexLocInd();
                boolean bl = false;
                do {
                    this.m_pos.m_data[piVector2.m_data[++n2]] = 1.0;
                    this.m_pos.m_data[(piVector2.m_data[n2] + 1) % 3] = 0.0;
                    this.m_pos.m_data[(piVector2.m_data[n2] + 2) % 3] = 0.0;
                    this.m_elem = piVector.m_data[n2];
                    this.eval(this.m_elem, this.m_pos, this.m_dir);
                    bl = PwBary.showsIntoElement(this.m_dir, piVector2.m_data[n2]);
                } while (n2 < n4 - 1 && !bl);
                if (n2 == n4 - 1 && !bl) {
                    return false;
                }
            }
        }
        if ((n = this.rungeKutta(this.m_elem, this.m_pos, this.m_dir, this.m_h)) < 0) {
            this.m_lastLength = 0.0;
            return false;
        }
        this.m_outpoly.setNumVertices(this.m_outpoly.getNumVertices() - 1);
        this.m_geod2.setNumVertices(0);
        this.m_geod2.exp(n, this.m_pos, this.m_dir, this.m_h);
        this.m_outpoly.addPolygon(this.m_geod2);
        n2 = this.m_geod2.getNumVertices() - 1;
        this.m_pos = this.m_geod2.getBary(n2);
        this.m_elem = this.m_geod2.getElemInd(n2);
        return true;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        this.m_geom = pgElementSet;
        this.m_recalc = true;
        this.m_geod = new PgPolygonOnElementSet(this.m_geom);
        this.m_geod2 = new PgPolygonOnElementSet(this.m_geom);
    }

    public void setFirstOrder(boolean bl) {
        this.m_fast = bl;
    }

    public PgPolygonOnElementSet getStepPolygon() {
        return this.m_geod2;
    }

    public void eval(int n, PdBary pdBary, PdBaryDir pdBaryDir) {
    }

    public double getStepLength() {
        return this.m_lastLength;
    }

    public void solve(PgPolygonOnElementSet pgPolygonOnElementSet, int n, PdBary pdBary, double d, int n2) {
        if (!this.prepareSolve(pgPolygonOnElementSet, n, pdBary, d)) {
            return;
        }
        int n3 = 0;
        while (n3 < n2 && this.nextStep()) {
            ++n3;
        }
    }
}

