/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnNoise;

public class PnLIC {
    protected PgElementSet m_geom;
    protected int m_maxhits = 5;
    protected PnGeodesicRK m_rk;
    protected double m_integralh = 0.26666666666666666;
    protected int m_width;
    protected int m_height;
    protected int[] m_pix;
    protected PdVector[][] m_texCoords;
    protected double m_steplen;
    protected int m_kernelwidth = 15;
    protected int m_minKernel = 1;
    protected double m_coarseness = 1.0;
    protected PnNoise m_noise;
    private PgPolygonOnElementSet m_poly;
    private PgPolygonOnElementSet m_lastpoly;
    private PiVector m_evalelem;
    private PdVector[] m_evalbary;
    private int m_evalsize;
    private PiVector m_evalx;
    private PiVector m_evaly;
    private PdVector m_noisecol;
    private PiVector m_kernelW;
    private int m_nextkernelw;
    private int m_nextpolysize;
    private boolean m_nextedgereached;
    private PgPolygon m_lenBuf;
    private double m_kernelFac;
    private static final int m_maxIter = 30;

    public int getTextureHeight() {
        return this.m_height;
    }

    private void makeEvalXY(int n, int n2, PdBary pdBary, PdVector[] pdVectorArray, PdVector pdVector) {
        pdVectorArray = this.m_texCoords[this.m_evalelem.m_data[n]];
        int n3 = 0;
        do {
            pdBary.m_data[n3] = this.m_evalbary[n3].m_data[n];
        } while (++n3 < 3);
        PdBary.getVertex((PdVector)pdVector, (PdBary)pdBary, (PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1], (PdVector)pdVectorArray[2]);
        this.m_evalx.m_data[n2] = (int)(pdVector.m_data[0] * (double)(this.m_width - 1));
        this.m_evaly.m_data[n2] = (int)((1.0 - pdVector.m_data[1]) * (double)(this.m_height - 1));
    }

    public int[] getPixArray(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.m_pix.length];
        }
        int n = Math.min(this.m_pix.length, nArray.length);
        int n2 = 0;
        while (n2 < n) {
            int n3 = (this.m_pix[n2] & 0xFF000000) >> 24;
            nArray[n2] = this.m_pix[n2] & 0xFFFFFF;
            if (n3 != 0) {
                int n4 = n2;
                nArray[n4] = nArray[n4] / n3;
            }
            if (nArray[n2] > 255) {
                nArray[n2] = 255;
            }
            double d = (double)nArray[n2] / 255.0;
            nArray[n2] = (int)(255.0 * d * d * (3.0 - 2.0 * d));
            int n5 = n2;
            nArray[n5] = nArray[n5] + ((nArray[n2] << 8) + (nArray[n2] << 16));
            int n6 = n2++;
            nArray[n6] = nArray[n6] + -16777216;
        }
        return nArray;
    }

    protected int getOutline(PdVector[] pdVectorArray, int n, int n2, PiVector piVector, PiVector piVector2) {
        PiVector[] piVectorArray = new PiVector[3];
        int n3 = 0;
        do {
            piVectorArray[n3] = new PiVector(2);
            piVectorArray[n3].m_data[0] = (int)(pdVectorArray[n3].m_data[0] * (double)(n - 1));
            piVectorArray[n3].m_data[1] = (int)((1.0 - pdVectorArray[n3].m_data[1]) * (double)(n2 - 1));
        } while (++n3 < 3);
        double d = piVectorArray[0].m_data[1];
        int n4 = 0;
        int n5 = 1;
        while (n5 < piVectorArray.length) {
            if (d > (double)piVectorArray[n5].m_data[1] || d >= (double)piVectorArray[n5].m_data[1] && n5 == n4 + 1) {
                d = piVectorArray[n5].m_data[1];
                n4 = n5;
            }
            ++n5;
        }
        n5 = 0;
        int n6 = n4;
        while (n6 < n4 + 3) {
            int n7 = piVectorArray[n6 % 3].m_data[0];
            int n8 = piVectorArray[n6 % 3].m_data[1];
            int n9 = piVectorArray[(n6 + 1) % 3].m_data[1] - n8;
            int n10 = Math.abs(n9);
            int n11 = piVectorArray[(n6 + 1) % 3].m_data[0] - n7;
            if (n10 != 0 || n11 != 0) {
                int n12 = 0;
                int n13 = 1;
                if (n9 < 0) {
                    n13 = -1;
                }
                n9 = Math.abs(n9);
                int n14 = 1;
                if (n11 < 0) {
                    n14 = -1;
                }
                n11 = Math.abs(n11);
                do {
                    piVector.setEntry(n5, n7);
                    piVector2.setEntry(n5, n8);
                    n8 += n13;
                    n12 += n11;
                    while (n12 >= n9 && n9 != 0) {
                        n7 += n14;
                        n12 -= n9;
                    }
                    ++n5;
                } while (--n10 > 0);
            }
            ++n6;
        }
        piVector.setEntry(n5, piVectorArray[(n4 + 3) % 3].m_data[0]);
        piVector2.setEntry(n5, piVectorArray[(n4 + 3) % 3].m_data[1]);
        return ++n5;
    }

    public int getTextureWidth() {
        return this.m_width;
    }

    public PnLIC(PgElementSet pgElementSet, int n, double d, PnGeodesicRK pnGeodesicRK) {
        this.m_geom = pgElementSet;
        this.m_rk = pnGeodesicRK;
        double[] dArray = PnLIC.triangleElemTexCoords(this.m_geom, n);
        this.m_steplen = 1.0 / dArray[0];
        this.m_width = (int)dArray[1];
        this.m_height = (int)dArray[2];
        this.m_pix = new int[this.m_width * this.m_height];
        this.m_noise = new PnNoise();
        this.m_texCoords = this.m_geom.getElementTextures();
        this.m_poly = new PgPolygonOnElementSet(this.m_geom);
        this.m_lastpoly = new PgPolygonOnElementSet(this.m_geom);
        this.m_lenBuf = new PgPolygon(this.m_geom.getDimOfVertices());
        this.m_evalsize = (this.m_width + this.m_height) / 2;
        this.m_evalbary = new PdVector[3];
        int n2 = 0;
        do {
            this.m_evalbary[n2] = new PdVector(this.m_evalsize);
        } while (++n2 < 3);
        this.m_evalelem = new PiVector(this.m_evalsize);
        this.m_evalx = new PiVector(this.m_evalsize);
        this.m_evaly = new PiVector(this.m_evalsize);
        this.m_kernelW = new PiVector(this.m_evalsize);
        this.m_noisecol = new PdVector(this.m_evalsize);
    }

    public void makeElement(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = n;
        PdBary pdBary = new PdBary(3);
        PdVector pdVector = new PdVector(2);
        PdBary pdBary2 = new PdBary(3);
        PdVector[] pdVectorArray = null;
        PiVector piVector = new PiVector(1);
        PiVector piVector2 = new PiVector(1);
        this.m_kernelFac = this.m_steplen / this.m_integralh * (double)(this.m_kernelwidth - this.m_minKernel);
        int n6 = this.m_evalx.getSize();
        PdVector[] pdVectorArray2 = this.m_texCoords[n5];
        int n7 = this.getOutline(pdVectorArray2, this.m_width, this.m_height, piVector, piVector2);
        int n8 = n7 / 2;
        int n9 = 0;
        while (n9 < n8) {
            int n10;
            if (piVector.m_data[n9] <= piVector.m_data[n7 - n9 - 1]) {
                n4 = piVector.m_data[n9];
                n3 = piVector.m_data[n7 - n9 - 1];
            } else {
                n4 = piVector.m_data[n7 - n9 - 1];
                n3 = piVector.m_data[n9];
            }
            n2 = piVector2.m_data[n9];
            int n11 = n4;
            while (n11 <= n3) {
                if ((this.m_pix[n11 + n2 * this.m_width] & 0xFF000000) >> 24 <= this.m_maxhits) {
                    int n12;
                    double d;
                    int n13;
                    int n14;
                    pdVector.m_data[0] = (double)n11 / (double)(this.m_width - 1);
                    pdVector.m_data[1] = (double)(this.m_height - n2 - 1) / (double)(this.m_height - 1);
                    PdBary.getBary((PdBary)pdBary, (PdVector)pdVector, (PdVector)pdVectorArray2[0], (PdVector)pdVectorArray2[1], (PdVector)pdVectorArray2[2]);
                    n10 = 0;
                    do {
                        if (!(pdBary.m_data[n10] < 0.0)) continue;
                        pdBary.m_data[n10] = 0.0;
                        pdBary.validate();
                    } while (++n10 < 3);
                    this.m_rk.prepareSolve(this.m_poly, n5, pdBary, this.m_integralh);
                    n10 = 0;
                    boolean bl = false;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = 0;
                    double d2 = 0.0;
                    this.makeNextStep();
                    block3: do {
                        int n18 = this.m_nextpolysize;
                        n14 = this.m_nextkernelw;
                        n10 = this.m_nextedgereached ? 1 : 0;
                        if (n6 < n17 + n18) {
                            this.m_evalx.setSize(n6 += Math.max(this.m_evalsize, n18));
                            this.m_evaly.setSize(n6);
                            this.m_kernelW.setSize(n6);
                            this.m_noisecol.setSize(n6);
                        }
                        n13 = n17 + n18;
                        int n19 = n17;
                        while (n19 < n13) {
                            double d3;
                            this.makeEvalXY(n19 - n17, n19, pdBary2, pdVectorArray, pdVector);
                            this.m_noisecol.m_data[n19] = d3 = (this.m_noise.noise(this.m_coarseness * (double)this.m_evalx.m_data[n19], this.m_coarseness * (double)this.m_evaly.m_data[n19]) / 2.0 + 0.5) * 255.0;
                            ++n19;
                        }
                        this.makeNextStep();
                        d = (double)(this.m_nextkernelw - n14) / (double)n18;
                        double d4 = n14;
                        n12 = 0;
                        while (n12 < n18) {
                            this.m_kernelW.m_data[n17] = (int)d4;
                            d4 += d;
                            ++n17;
                            ++n12;
                        }
                        n14 = this.m_kernelW.m_data[n16];
                        while (n16 < n17 && n17 - n16 >= n14) {
                            n12 = this.m_evalx.m_data[n16] + this.m_evaly.m_data[n16] * this.m_width;
                            if ((this.m_pix[n12] & 0xFF000000) >> 24 > this.m_maxhits) {
                                if (n15 > this.m_maxhits) {
                                    bl = true;
                                    continue block3;
                                }
                                ++n15;
                            }
                            d2 = 0.0;
                            n13 = n16 + n14;
                            int n20 = n16;
                            while (n20 < n13) {
                                d2 += this.m_noisecol.m_data[n20];
                                ++n20;
                            }
                            n20 = 0x1000000 + (int)(d2 /= (double)n14);
                            int n21 = n12;
                            this.m_pix[n21] = this.m_pix[n21] + n20;
                            if (n16 == 0 && (this.m_evalx.m_data[0] != n11 || this.m_evaly.m_data[0] != n2)) {
                                int n22;
                                int n23 = n22 = n2 * this.m_width + n11;
                                this.m_pix[n23] = this.m_pix[n23] + n20;
                            }
                            n14 = this.m_kernelW.m_data[++n16];
                        }
                    } while (n10 == 0 && !bl);
                    if (n10 != 0) {
                        while (n16 < n17) {
                            n13 = this.m_evalx.m_data[n16] + this.m_evaly.m_data[n16] * this.m_width;
                            n14 = this.m_kernelW.m_data[n16];
                            d = 0.0;
                            int n24 = n16 + n14;
                            int n25 = n16;
                            while (n25 < n24) {
                                d += this.m_noisecol.m_data[n25 % n17];
                                ++n25;
                            }
                            n25 = 0x1000000 + (int)(d /= (double)n14);
                            int n26 = n13;
                            this.m_pix[n26] = this.m_pix[n26] + n25;
                            if (n16 == 0 && (this.m_evalx.m_data[0] != n11 || this.m_evaly.m_data[0] != n2)) {
                                int n27 = n12 = n2 * this.m_width + n11;
                                this.m_pix[n27] = this.m_pix[n27] + n25;
                            }
                            ++n16;
                        }
                    }
                }
                ++n11;
            }
            n11 = n2 * this.m_width;
            n10 = 1;
            do {
                if (n4 - n10 >= 0) {
                    int n28 = n11 + n4 - n10;
                    this.m_pix[n28] = this.m_pix[n28] + this.m_pix[n11 + n4];
                }
                if (n3 + n10 >= this.m_width) continue;
                int n29 = n11 + n3 + n10;
                this.m_pix[n29] = this.m_pix[n29] + this.m_pix[n11 + n3];
            } while (++n10 <= 2);
            ++n9;
        }
        if (n8 >= 1 && (n9 = piVector2.m_data[n8 - 1] + 1) < this.m_height) {
            if (piVector.m_data[n8 - 1] <= piVector.m_data[n7 - n8]) {
                n4 = Math.max(piVector.m_data[n8 - 1] - 1, 0);
                n3 = Math.min(piVector.m_data[n7 - n8] + 1, this.m_width - 1);
            } else {
                n4 = Math.max(piVector.m_data[n7 - n8] - 1, 0);
                n3 = Math.min(piVector.m_data[n8 - 1] + 1, this.m_width - 1);
            }
            n2 = n4;
            while (n2 <= n3) {
                int n30 = n9 * this.m_width + n2;
                this.m_pix[n30] = this.m_pix[n30] + this.m_pix[(n9 - 1) * this.m_width + n2];
                ++n2;
            }
        }
    }

    private void makeNextStep() {
        int n = 0;
        this.m_poly.setNumVertices(1);
        this.m_lastpoly.setNumVertices(1);
        boolean bl = false;
        double d = 0.0;
        do {
            this.m_nextedgereached = !this.m_rk.nextStep();
            d += this.m_rk.getStepLength();
            this.m_lastpoly.setNumVertices(this.m_lastpoly.getNumVertices() - 1);
            this.m_lastpoly.addPolygon(this.m_rk.getStepPolygon());
            if (++n >= 30) {
                this.m_nextedgereached = true;
            }
            if (this.m_nextedgereached) {
                bl = true;
                continue;
            }
            if (!(d >= this.m_steplen)) continue;
            bl = true;
        } while (!bl);
        this.m_lastpoly.eval(this.m_evalbary[0], this.m_evalbary[1], this.m_evalbary[2], this.m_evalelem, this.m_steplen);
        this.m_nextpolysize = this.m_evalelem.getSize() - 1;
        this.m_nextkernelw = (int)(this.m_kernelFac * (double)this.m_nextpolysize / (double)n + (double)this.m_minKernel);
        if (this.m_nextpolysize <= 1) {
            this.m_nextkernelw = 1;
            if (this.m_nextpolysize < 1) {
                ++this.m_nextpolysize;
            }
        }
    }

    public boolean setConvolutionWidth(int n) {
        if (n < 1) {
            return false;
        }
        this.m_kernelwidth = n;
        return true;
    }

    public boolean setCoarseness(double d) {
        if (d < 0.0 || d > 1.0) {
            return false;
        }
        this.m_coarseness = 1.0 - d;
        return true;
    }

    public boolean setMinConvolutionWidth(int n) {
        if (n < 1 || n > this.m_kernelwidth) {
            return false;
        }
        this.m_minKernel = n;
        return true;
    }

    public void makeLIC() {
        int n = this.m_geom.getNumElements();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.makeElement(n2);
            --n2;
        }
    }

    public void setStepSize(double d) {
        this.m_integralh = d;
    }

    protected static double[] triangleElemTexCoords(PgElementSet pgElementSet, int n) {
        double d;
        pgElementSet.setDimOfTextures(2);
        pgElementSet.assureElementTextures();
        int n2 = pgElementSet.getNumElements();
        int n3 = 0;
        int n4 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        PiVector piVector = new PiVector(n2);
        PdVector pdVector = new PdVector(n2);
        PdVector pdVector2 = new PdVector(n2);
        PdVector pdVector3 = new PdVector(n2);
        PdVector pdVector4 = new PdVector(n2);
        PdVector pdVector5 = new PdVector(n2);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        int n5 = 0;
        while (n5 < n2) {
            double d4;
            piVector.m_data[n5] = 0;
            pdVector.m_data[n5] = 0.0;
            int n6 = 0;
            do {
                pdBaryDir.m_data[n6] = 0.0;
                pdBaryDir.m_data[(n6 + 1) % 3] = 1.0;
                pdBaryDir.m_data[(n6 + 2) % 3] = -1.0;
                d4 = PwBary.norm(pgElementSet, n5, pdBaryDir, n6 == 0);
                if (d4 > pdVector.m_data[n5]) {
                    piVector.m_data[n5] = n6;
                    pdVector.m_data[n5] = d4;
                }
                if (!(d4 > d2)) continue;
                d2 = d4;
                n4 = n6;
                n3 = n5;
            } while (++n6 < 3);
            n6 = piVector.m_data[n5];
            pdBaryDir.m_data[n6] = 0.0;
            pdBaryDir.m_data[(n6 + 1) % 3] = 1.0;
            pdBaryDir.m_data[(n6 + 2) % 3] = -1.0;
            pdBaryDir2.m_data[n6] = 1.0;
            pdBaryDir2.m_data[(n6 + 1) % 3] = 0.0;
            pdBaryDir2.m_data[(n6 + 2) % 3] = -1.0;
            pdVector2.m_data[n5] = PwBary.scalar(pgElementSet, n5, pdBaryDir, pdBaryDir2, false) / pdVector.m_data[n5];
            d4 = PwBary.norm(pgElementSet, n5, pdBaryDir2, false);
            d4 *= d4;
            if ((d4 -= pdVector2.m_data[n5] * pdVector2.m_data[n5]) < 0.0) {
                d4 = 0.0;
            }
            pdVector3.m_data[n5] = Math.sqrt(d4);
            if (pdVector3.m_data[n5] > d3) {
                d3 = pdVector3.m_data[n5];
            }
            if (pdVector2.m_data[n5] < 1.0E-10) {
                pdVector4.setEntry(n5, 1.5707963267948966);
            } else {
                pdVector4.setEntry(n5, Math.atan(pdVector3.m_data[n5] / pdVector2.m_data[n5]));
            }
            double d5 = pdVector.m_data[n5] - pdVector2.m_data[n5];
            if (d5 < 1.0E-10) {
                pdVector5.setEntry(n5, 1.5707963267948966);
            } else {
                pdVector5.setEntry(n5, Math.atan(pdVector3.m_data[n5] / d5));
            }
            ++n5;
        }
        double d6 = (double)n / d2;
        int n7 = (int)Math.ceil(d3 * d6 + 1.0);
        PiVector[][] piVectorArray = new PiVector[n2][3];
        int n8 = 8;
        int n9 = n8 / 2;
        int n10 = n8 / 2;
        boolean[] blArray = new boolean[n2];
        int n11 = 0;
        while (n11 < n2) {
            blArray[n11] = true;
            ++n11;
        }
        n11 = 0;
        while (n11 < n2) {
            int n12;
            int n13;
            int n14;
            double d7;
            int n15;
            double d8;
            int n16;
            double d9;
            double d10;
            int n17;
            double d11;
            double d12;
            if (n9 <= n10) {
                d = n9 == n10 ? 1.5707963267948966 : Math.atan((double)n7 / (double)(n10 - n9));
                d12 = 1000.0;
                d11 = 1000.0;
                n17 = -1;
                d10 = 1000.0;
                d9 = 1000.0;
                n16 = -1;
                int n18 = 0;
                while (n18 < n2) {
                    if (blArray[n18]) {
                        d8 = pdVector4.getEntry(n18);
                        double d13 = Math.abs(d8 - d);
                        if (d13 < d9 && d8 <= d) {
                            d9 = d13;
                            d10 = d8;
                            n16 = n18;
                        } else if (d13 < d11 && d8 > d) {
                            d11 = d13;
                            d12 = d8;
                            n17 = n18;
                        }
                    }
                    ++n18;
                }
                if (n16 == -1) {
                    n15 = n17;
                    d7 = d12;
                } else {
                    n15 = n16;
                    d7 = d10;
                }
                blArray[n15] = false;
                n14 = d7 <= d ? n9 : (int)Math.ceil((double)n10 - pdVector2.m_data[n15] * d6);
                n13 = (int)Math.ceil((double)n14 + pdVector2.m_data[n15] * d6);
                int n19 = (int)Math.floor(pdVector3.m_data[n15] * d6);
                int n20 = piVector.m_data[n15];
                piVectorArray[n15][(n20 + 2) % 3] = new PiVector(n14, 0);
                piVectorArray[n15][n20] = new PiVector(n13, n19);
                n14 = (int)Math.ceil((double)n14 + pdVector.m_data[n15] * d6);
                piVectorArray[n15][(n20 + 1) % 3] = new PiVector(n14, 0);
                n9 = n14 + n8;
                n12 = n13 + (int)Math.ceil((double)((n13 - n14) * (n7 - 1 - n19)) / (double)n19);
                if (n12 + n8 > n10) {
                    n10 = n12 + n8;
                }
            } else {
                d = Math.atan((double)n7 / (double)(n9 - n10));
                d12 = 1000.0;
                d11 = 1000.0;
                n17 = -1;
                d10 = 1000.0;
                d9 = 1000.0;
                n16 = -1;
                int n21 = 0;
                while (n21 < n2) {
                    if (blArray[n21]) {
                        d8 = pdVector5.getEntry(n21);
                        double d14 = Math.abs(d8 - d);
                        if (d14 < d9 && d8 <= d) {
                            d9 = d14;
                            d10 = d8;
                            n16 = n21;
                        } else if (d14 < d11 && d8 > d) {
                            d11 = d14;
                            d12 = d8;
                            n17 = n21;
                        }
                    }
                    ++n21;
                }
                if (n16 == -1) {
                    n15 = n17;
                    d7 = d12;
                } else {
                    n15 = n16;
                    d7 = d10;
                }
                blArray[n15] = false;
                double d15 = pdVector.m_data[n15] - pdVector2.m_data[n15];
                n13 = d7 <= d ? n10 : (int)Math.ceil((double)n9 - d15 * d6);
                n14 = (int)Math.ceil((double)n13 + d15 * d6);
                n12 = (int)Math.ceil((double)(n7 - 1) - pdVector3.m_data[n15] * d6);
                int n22 = piVector.m_data[n15];
                piVectorArray[n15][(n22 + 1) % 3] = new PiVector(n13, n7 - 1);
                piVectorArray[n15][n22] = new PiVector(n14, n12);
                n13 = (int)Math.ceil((double)n13 + pdVector.m_data[n15] * d6);
                piVectorArray[n15][(n22 + 2) % 3] = new PiVector(n13, n7 - 1);
                n10 = n13 + n8;
                int n23 = n14 + (int)Math.ceil((double)((n14 - n13) * n12) / (double)(n7 - 1 - n12));
                if (n23 + n8 > n9) {
                    n9 = n23 + n8;
                }
            }
            ++n11;
        }
        n11 = 0;
        n11 = n10 > n9 ? n10 + 1 : n9 + 1;
        double d16 = 1.0 / (double)(n7 - 1);
        d = 1.0 / (double)(n11 - 1);
        PdVector[][] pdVectorArray = new PdVector[n2][3];
        int n24 = 0;
        while (n24 < n2) {
            int n25 = 0;
            do {
                pdVectorArray[n24][n25] = new PdVector((double)piVectorArray[n24][n25].m_data[0] * d, 1.0 - (double)piVectorArray[n24][n25].m_data[1] * d16);
            } while (++n25 < 3);
            ++n24;
        }
        pgElementSet.setElementTextures(pdVectorArray);
        double[] dArray = new double[]{d6, n11, n7};
        return dArray;
    }
}

