/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

public class PnNoise {
    private static final int TABSIZE = 256;
    private double[] gradTab = new double[512];
    private double[] valueTab = new double[256];
    private int[] perm = new int[256];

    public PnNoise() {
        int n = 0;
        do {
            this.perm[n] = (int)(Math.random() * 255.0 + 0.5);
        } while (++n < 256);
        n = 0;
        do {
            this.valueTab[n] = Math.random() * 2.0 - 1.0;
        } while (++n < 256);
        n = 0;
        do {
            double d = Math.PI * 2 * Math.random();
            this.gradTab[n * 2] = Math.cos(d);
            this.gradTab[n * 2 + 1] = Math.sin(d);
        } while (++n < 256);
    }

    protected int index(int n, int n2) {
        return this.perm[(n + this.perm[n2]) % 256];
    }

    public double noise(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = 1.0 - d3;
        double d5 = d2 - (double)n2;
        double d6 = 1.0 - d5;
        double d7 = this.glattice(n %= 255, n2 %= 255, d3, d5);
        double d8 = this.glattice(n + 1, n2, d4, d5);
        double d9 = this.glattice(n, n2 + 1, d3, d6);
        double d10 = this.glattice(n + 1, n2 + 1, d4, d6);
        double d11 = d7 + this.smoothstep(d3) * (d8 - d7);
        double d12 = d9 + this.smoothstep(d3) * (d10 - d9);
        double d13 = d11 + this.smoothstep(d5) * (d12 - d11);
        double d14 = this.valueTab[this.index(n, n2)];
        double d15 = this.valueTab[this.index(n + 1, n2)];
        double d16 = this.valueTab[this.index(n, n2 + 1)];
        double d17 = this.valueTab[this.index(n + 1, n2 + 1)];
        double d18 = d14 + this.smoothstep(d3) * (d15 - d14);
        double d19 = d16 + this.smoothstep(d3) * (d17 - d16);
        double d20 = d18 + this.smoothstep(d5) * (d19 - d18);
        d13 += 2.0 * d20;
        return d13 /= 3.0;
    }

    protected double smoothstep(double d) {
        return d * d * (3.0 - 2.0 * d);
    }

    protected double glattice(int n, int n2, double d, double d2) {
        int n3 = 2 * this.index(n, n2);
        return this.gradTab[n3] * d + this.gradTab[n3 + 1] * d2;
    }
}

