/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jv.geom.PgElementSet;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.loader.PjMathView;
import jv.loader.PvDisplayLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.object.PsObject;
import jv.objectGui.GuiStackLayout;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickListenerIf;
import jv.viewer.PvViewer;

public class javaview
extends Applet
implements Runnable {
    protected Frame m_frame = null;
    protected PvViewer m_viewer;
    protected PvDisplayIf m_disp;
    private String m_drawString = "Initializing ...";
    private Thread thread = null;

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    public PvViewer getViewer() {
        return this.m_viewer;
    }

    public boolean removePickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_disp == null) {
            PsDebug.warning("missing display");
            return false;
        }
        return this.m_disp.removePickListener(pvPickListenerIf);
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        javaview javaview2 = new javaview();
        PsMainFrame psMainFrame = new PsMainFrame(javaview2, stringArray);
        psMainFrame.pack();
        String string = System.getProperty("os.name");
        if (string != null && string.toLowerCase().startsWith("win")) {
            ((Component)psMainFrame).setBounds(new Rectangle(400, 5, 620, 540));
        } else {
            ((Component)psMainFrame).setSize(620, 540);
        }
        javaview2.m_frame = psMainFrame;
        javaview2.init();
        if (javaview2.m_viewer != null) {
            try {
                int n;
                int n2;
                String[] stringArray2;
                String string2 = javaview2.m_viewer.getParameter("Size");
                if (string2 != null) {
                    stringArray2 = PuString.splitString(string2, 'x');
                    if (stringArray2 != null && stringArray2.length == 2) {
                        n2 = Integer.parseInt(stringArray2[0]);
                        n = Integer.parseInt(stringArray2[1]);
                        Insets insets = psMainFrame.getInsets();
                        if (insets != null) {
                            ((Component)psMainFrame).setSize(n2 + insets.left + insets.right, n + insets.top + insets.bottom);
                        } else {
                            PsDebug.warning("failed to obtain insets from frame.");
                        }
                    } else {
                        PsDebug.warning("wrong format in size of display = " + string2);
                    }
                }
                if ((string2 = javaview2.m_viewer.getParameter("Position")) != null) {
                    stringArray2 = PuString.splitString(string2, 'x');
                    if (stringArray2 != null && stringArray2.length == 2) {
                        n2 = Integer.parseInt(stringArray2[0]);
                        n = Integer.parseInt(stringArray2[1]);
                        ((Component)psMainFrame).setLocation(n2, n);
                    } else {
                        PsDebug.warning("wrong format in size of display = " + string2);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format in size/position of display");
            }
        }
        ((Component)psMainFrame).setVisible(true);
    }

    public void addPickListener(PvPickListenerIf pvPickListenerIf) {
        try {
            while (this.m_disp == null) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {}
        this.m_disp.addPickListener(pvPickListenerIf);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier\r\n" + "Version: " + "3.00\r\n" + "Applet/Application for loading most JavaView projects,\r\n" + "and optional Mathematica/Maple/DXF/etc parsing" + "\r\n";
    }

    public synchronized void run() {
        Object object;
        if (this.m_viewer == null) {
            PsDebug.error("must call init() before invoking this method, viewer not instantiated.");
            return;
        }
        String string = null;
        String string2 = this.m_viewer.getParameter("CodeBase");
        if (string2 != null && !string2.equals("")) {
            PsDebug.message("encountered external parameter: codebase = " + string2);
            PsConfig.setCodeBase(string2);
        }
        this.m_disp = this.m_viewer.getDisplay();
        String string3 = this.m_viewer.getParameter("displayFile");
        if (string3 != null) {
            PvDisplayOption[] pvDisplayOptionArray = PvDisplayLoader.read(PsConfig.getCodeBase() + string3);
            if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0) {
                PsDebug.warning("reading of display configuration failed, file = " + string3);
            } else {
                pvDisplayOptionArray[0].configure(this.m_disp);
            }
        }
        boolean bl = true;
        string = this.m_viewer.getParameter("Model");
        if (string != null) {
            object = new PjImportModel();
            this.m_viewer.addProject((PjProject)object);
            this.m_viewer.selectProject(((PsObject)object).getName());
            this.drawMessage("Loading " + string + " ...");
            if (!PsConfig.isApplication()) {
                ((PjImportModel)object).setFileName(PsConfig.getCodeBase() + string);
                if ("Show".equalsIgnoreCase(this.getParameter("ProjectPanel"))) {
                    if ("Small".equalsIgnoreCase(this.getParameter("ProjectPanelType"))) {
                        ((PjImportModel)object).setTypeOfInfoPanel(PjImportModel.SMALL_INFO_PANEL);
                        this.setLayout(new BorderLayout());
                        this.add("Center", (Component)((Object)this.m_disp));
                        this.add("South", this.m_viewer.getPanel(10));
                    } else {
                        this.setLayout(new GuiStackLayout(0));
                        this.add("FILL WIDE*5", (Component)((Object)this.m_disp));
                        this.add("FILL WIDE*4", this.m_viewer.getPanel(10));
                    }
                    this.m_viewer.showPanel(13);
                } else {
                    this.setLayout(new BorderLayout());
                    this.add("Center", (Component)((Object)this.m_disp));
                }
            } else {
                ((PjImportModel)object).setFileName(string);
                if (((PjImportModel)object).load(string)) {
                    PsConfig.getFrame().setTitle(string);
                }
                ((PjImportModel)object).setFileName(null);
                this.setLayout(new BorderLayout());
                this.add("Center", (Component)((Object)this.m_disp));
            }
            bl = false;
        } else if (this.m_frame != null && this.m_viewer.getParameter("File") != null) {
            object = new BufferedReader(new InputStreamReader(System.in));
            try {
                if (((BufferedReader)object).ready()) {
                    PsDebug.message("Mathematica ready at stdin.");
                    PjMathView pjMathView = new PjMathView("Import project for Mathematica");
                    pjMathView.setBufferedReader((BufferedReader)object);
                    if (pjMathView.read()) {
                        this.m_viewer.addProject(pjMathView);
                        this.m_viewer.selectProject(pjMathView.getName());
                        this.setLayout(new BorderLayout());
                        this.add("Center", (Component)((Object)this.m_disp));
                        bl = false;
                    }
                }
            }
            catch (IOException iOException) {
                PsDebug.warning("exception = " + iOException.toString());
                PsDebug.message("failed reading Mathematica from stdin.");
            }
        }
        string = this.m_viewer.getParameter("mathematica");
        if (string != null) {
            object = PgLoader.load(null, string, "mgs");
            if (object != null) {
                int n = 0;
                while (n < ((Object)object).length) {
                    this.m_disp.addGeometry((PgGeometryIf)object[n]);
                    ++n;
                }
                bl = false;
                this.setLayout(new BorderLayout());
                this.add("Center", (Component)((Object)this.m_disp));
            } else {
                PsDebug.warning("Loading of Mathematica data from string failed");
            }
        }
        if ((string = this.m_viewer.getParameter("maple")) != null) {
            object = PgLoader.load(null, string, "mpl");
            if (object != null) {
                int n = 0;
                while (n < ((Object)object).length) {
                    this.m_disp.addGeometry((PgGeometryIf)object[n]);
                    ++n;
                }
                bl = false;
                this.setLayout(new BorderLayout());
                this.add("Center", (Component)((Object)this.m_disp));
            } else {
                PsDebug.warning("Loading of Maple data from string failed");
            }
        }
        if (bl) {
            object = new PgElementSet(3);
            ((PsObject)object).setName("Snail");
            ((PgElementSet)object).computeSnail(20, 15, 2.0);
            ((PgElementSet)object).makeElementColorsFromXYZ();
            ((PgElementSet)object).showElementColors(true);
            this.m_disp.addGeometry((PgGeometryIf)object);
            this.setLayout(new BorderLayout());
            this.add("Center", (Component)((Object)this.m_disp));
        }
        this.validate();
        this.m_viewer.showPanel(13);
        this.startFromThread();
    }

    public void init() {
        if (this.m_frame == null) {
            this.repaint();
        }
        this.drawMessage("Loading viewer ...");
        this.m_viewer = new PvViewer(this, this.m_frame);
        this.thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        this.thread.setPriority(5);
        this.thread.start();
    }
}

