/*
 * Decompiled with CFR 0.152.
 */
package jv.anim;

import java.util.Enumeration;
import java.util.Vector;
import jv.anim.PsKey;
import jv.anim.PsKeyframeIf;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometry;

public class PsKeyframe
extends PgGeometry
implements PsKeyframeIf,
PsTimeListenerIf {
    protected double m_currentTime;
    protected PgGeometry m_inter;
    protected Vector m_list = new Vector();
    protected String m_className;
    protected boolean m_bShowKeysOnly;
    private static /* synthetic */ Class class$jv$anim$PsKeyframe;

    public void setObject(PgGeometry pgGeometry) {
        this.m_inter = pgGeometry;
    }

    public PgGeometry getObject(int n) {
        PsKey psKey = this.getKey(n);
        if (psKey == null) {
            return null;
        }
        return psKey.getObject();
    }

    public PgGeometry getObject(double d) {
        PsKey psKey = this.getKey(d);
        if (psKey == null) {
            return null;
        }
        return psKey.getObject();
    }

    public double getTimeOfLastKey() {
        return this.getKey(this.getNumOfKeys() - 1).getTime();
    }

    public int addKey(PgGeometry pgGeometry, double d) {
        String string = pgGeometry.getClass().getName();
        if (this.getNumOfKeys() == 0) {
            if (this.m_inter == null || !this.m_inter.getClass().equals(string)) {
                this.m_inter = (PgGeometry)pgGeometry.clone();
            }
            if (this.m_inter == null) {
                PsDebug.warning("could not allocate class = " + string);
                return -1;
            }
            this.m_inter.setName("Interpol of " + this.getName());
            PsKey psKey = new PsKey(d, pgGeometry);
            this.m_list.addElement(psKey);
            this.m_className = string;
            return 0;
        }
        if (!this.m_className.equals(string)) {
            PsDebug.warning("try to add wrong class = " + string + "\n\t current class type = " + this.m_className);
            return -1;
        }
        PsKey psKey = this.getKey(d);
        if (psKey != null && Math.abs(psKey.getTime() - d) < 1.0E-10) {
            psKey.setObject(pgGeometry);
            psKey.setTime(d);
        }
        PsKey psKey2 = new PsKey(d, pgGeometry);
        if (psKey == null) {
            this.m_list.insertElementAt(psKey2, 0);
            return 0;
        }
        PsKey psKey3 = this.getNextKey(d);
        if (psKey3 == null) {
            this.m_list.addElement(psKey2);
            return this.getNumOfKeys() - 1;
        }
        int n = this.m_list.indexOf(psKey3);
        this.m_list.insertElementAt(psKey2, n);
        return n;
    }

    public int getNumOfKeys() {
        if (this.m_list == null) {
            return 0;
        }
        return this.m_list.size();
    }

    public PsKeyframe() {
        if (this.getClass() == (class$jv$anim$PsKeyframe != null ? class$jv$anim$PsKeyframe : (class$jv$anim$PsKeyframe = PsKeyframe.class$("jv.anim.PsKeyframe")))) {
            this.init();
        }
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        double d = psTimeEvent.getTime();
        this.setTime(d);
        this.update(this);
        return true;
    }

    public boolean setTime(double d) {
        if (this.getNumOfKeys() == 0) {
            return false;
        }
        if (Math.abs(this.m_currentTime - d) < 1.0E-10) {
            return true;
        }
        PsKey psKey = this.getKey(d);
        if (psKey != null && Math.abs(psKey.getTime() - d) < 1.0E-10) {
            this.m_inter.copy(psKey.getObject());
            this.m_currentTime = psKey.getTime();
            return true;
        }
        PsKey psKey2 = this.getNextKey(d);
        if (psKey == null) {
            this.m_inter.copy(psKey2.getObject());
            this.m_currentTime = psKey2.getTime();
            return true;
        }
        if (psKey2 == null) {
            this.m_inter.copy(psKey.getObject());
            this.m_currentTime = psKey.getTime();
            return true;
        }
        double d2 = psKey2.getTime() - psKey.getTime();
        double d3 = (psKey2.getTime() - d) / d2;
        double d4 = (d - psKey.getTime()) / d2;
        if (!this.m_bShowKeysOnly) {
            this.m_inter.blend(d3, psKey.getObject(), d4, psKey2.getObject());
            this.m_currentTime = d;
        } else {
            int n = this.getIndexOfKey(psKey2);
            if (d3 * (double)(this.getNumOfKeys() - n) >= d4 * (double)n) {
                this.m_inter.copy(psKey.getObject());
                this.m_currentTime = psKey.getTime();
            } else {
                this.m_inter.copy(psKey2.getObject());
                this.m_currentTime = psKey2.getTime();
            }
        }
        return true;
    }

    public double getTimeOfFirstKey() {
        return this.getKey(0).getTime();
    }

    protected PsKey getNextKey(double d) {
        Enumeration enumeration = this.m_list.elements();
        while (enumeration.hasMoreElements()) {
            PsKey psKey = (PsKey)enumeration.nextElement();
            if (!(psKey.getTime() > d + 1.0E-10)) continue;
            return psKey;
        }
        return null;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setName(String string) {
        super.setName(string);
        if (this.m_inter != null) {
            this.m_inter.setName("Interpol of " + string);
        }
    }

    public PgGeometry getNextObject(double d) {
        PsKey psKey = this.getNextKey(d);
        if (psKey == null) {
            return null;
        }
        return psKey.getObject();
    }

    protected int getIndexOfKey(PsKey psKey) {
        return this.m_list.indexOf(psKey);
    }

    protected PsKey getKey(double d) {
        PsKey psKey = null;
        Enumeration enumeration = this.m_list.elements();
        while (enumeration.hasMoreElements()) {
            PsKey psKey2 = (PsKey)enumeration.nextElement();
            if (Math.abs(psKey2.getTime() - d) < 1.0E-10) {
                return psKey2;
            }
            if (psKey2.getTime() < d) {
                psKey = psKey2;
                continue;
            }
            return psKey;
        }
        return psKey;
    }

    protected PsKey getKey(int n) {
        return (PsKey)this.m_list.elementAt(n);
    }

    public double getTimeOfPreviousKey() {
        if (Math.abs(this.getKey(this.m_currentTime).getTime() - this.m_currentTime) < 1.0E-10 && this.getIndexOfKey(this.getKey(this.m_currentTime)) != 0) {
            return this.getKey(this.getIndexOfKey(this.getKey(this.m_currentTime)) - 1).getTime();
        }
        return this.getKey(this.m_currentTime).getTime();
    }

    public double getTimeOfNextKey() {
        if (this.getNextKey(this.m_currentTime) != null) {
            return this.getNextKey(this.m_currentTime).getTime();
        }
        return this.getTimeOfLastKey();
    }

    public void init() {
        super.init();
        this.m_list.setSize(0);
        this.m_currentTime = Double.POSITIVE_INFINITY;
        this.m_inter = null;
        this.m_className = null;
        this.m_bShowKeysOnly = false;
    }

    public void removeKey(double d) {
        PsKey psKey = this.getKey(d);
        if (Math.abs(psKey.getTime() - d) > 1.0E-10) {
            return;
        }
        this.m_list.removeElement(psKey);
    }

    public void removeKey(int n) {
        this.m_list.removeElementAt(n);
    }

    public void showKeysOnly(boolean bl) {
        this.m_bShowKeysOnly = bl;
    }

    public boolean showKeysOnly() {
        return this.m_bShowKeysOnly;
    }

    public boolean alloc(int n, double d, double d2, String string) {
        if (n < 1) {
            PsDebug.warning("void number of keys");
            return false;
        }
        if (this.m_inter == null || !this.m_inter.getClass().getName().equals(string)) {
            this.m_inter = (PgGeometry)PsUtil.newInstance(string);
        }
        if (this.m_inter == null) {
            PsDebug.warning("could not allocate class = " + string);
            return false;
        }
        this.m_inter.setName("Interpol of " + this.getName());
        this.m_className = new String(string);
        double d3 = d;
        double d4 = (d2 - d) / ((double)n - 1.0);
        int n2 = 0;
        while (n2 < n) {
            PgGeometry pgGeometry = (PgGeometry)PsUtil.newInstance(string);
            pgGeometry.setName(this.getName() + "." + String.valueOf(n2));
            PsKey psKey = new PsKey(d3, pgGeometry);
            this.m_list.addElement(psKey);
            d3 += d4;
            ++n2;
        }
        this.getKey(n - 1).setTime(d2);
        return true;
    }

    public PgGeometry getObject() {
        return this.m_inter;
    }
}

