/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.util.Enumeration;
import jv.geom.PgPointSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.objectGui.PsMethodMenu;
import jv.project.PgGeometry_Menu;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PgPointSet_Menu
extends PgGeometry_Menu {
    public static final int MTHD_PRINT_CENTER = 0;
    public static final int MTHD_PRINT_BNDBOX = 1;
    public static final int MTHD_REMOVE_VECTOR_FIELDS = 2;
    public static final int MTHD_MOVE_TO_ORIGIN = 3;
    public static final int MTHD_PROJECT_TO_SPHERE = 4;
    public static final int MTHD_FLIP_ORIENTATION = 5;
    public static final int MTHD_SHOW_VECTOR_ARROWS = 6;
    public static final int MTHD_MARK_VERTICES = 7;
    public static final int MTHD_UNMARK_VERTICES = 8;
    public static final int MTHD_REMOVE_MARKED_VERTICES = 9;
    public static final int MTHD_SHOW_MARKED_VERTICES = 10;
    public static final int MTHD_SHOW_TITLE = 11;
    public static final int MTHD_SHOW_VERTEX_LABELS = 12;
    public static final int MTHD_ENABLE_DEFAULT_LABEL = 13;
    public static final int MTHD_SHOW_GLOBAL_VERTEX_COLOR = 14;
    public static final int MTHD_VERTEX_COLOR_FROM_VECTOR = 15;
    public static final int MTHD_VERTEX_COLOR_FROM_XYZ = 16;
    public static final int MTHD_VERTEX_COLOR_FROM_Z = 17;
    public static final int MTHD_VERTEX_COLOR_FROM_Z_HUE = 18;
    public static final int MTHD_SHOW_VERTEX_NORMAL_ARROW = 19;
    public static final String[] m_pointSetMethod = new String[]{PsConfig.getMessage("PrintCenter"), PsConfig.getMessage("PrintBndBox"), PsConfig.getMessage("RemoveAllVectorFields"), PsConfig.getMessage("MoveToOrigin"), PsConfig.getMessage("ProjectToSphere1"), PsConfig.getMessage("FlipOrientation"), PsConfig.getMessage("ShowVectorArrows"), PsConfig.getMessage("MarkVertices"), PsConfig.getMessage("UnmarkVertices"), PsConfig.getMessage("RemoveMarkedVertices"), PsConfig.getMessage("ShowMarkedVertices"), PsConfig.getMessage("ShowTitle"), PsConfig.getMessage("ShowVertexLabels"), PsConfig.getMessage("EnableDefaultLabel"), PsConfig.getMessage("ShowGlobalVertexColor"), PsConfig.getMessage("MakeVertexColorFromVector"), PsConfig.getMessage("MakeVertexColorFromXYZ"), PsConfig.getMessage("MakeVertexColorFromZ"), PsConfig.getMessage("MakeVertexColorFromZHue"), PsConfig.getMessage("ShowVertexNormalArrow")};
    protected PgPointSet m_pointSet;

    public boolean applyMethod(String string) {
        if (super.applyMethod(string)) {
            return true;
        }
        int n = PsMethodMenu.getIndexOfMethod(m_pointSetMethod, string);
        switch (n) {
            case 11: {
                this.m_pointSet.showTitle(!this.m_pointSet.isShowingTitle());
                break;
            }
            case 12: {
                this.m_pointSet.showVertexLabels(!this.m_pointSet.isShowingVertexLabels());
                break;
            }
            case 13: {
                this.m_pointSet.setDefaultLabelEnabled(!this.m_pointSet.isDefaultLabelEnabled());
                break;
            }
            case 3: {
                PdVector pdVector = new PdVector(this.m_pointSet.getDimOfVertices());
                this.m_pointSet.setCenterOfBndBox(pdVector);
                break;
            }
            case 5: {
                this.m_pointSet.flipOrientation();
                break;
            }
            case 4: {
                this.m_pointSet.projectToSphere(this.m_pointSet.getCenter(), 1.0);
                break;
            }
            case 7: {
                Enumeration enumeration = this.m_pointSet.getDisplays();
                while (enumeration.hasMoreElements()) {
                    PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                    pvDisplayIf.setMajorMode(9);
                }
                break;
            }
            case 8: {
                Enumeration enumeration = this.m_pointSet.getDisplays();
                while (enumeration.hasMoreElements()) {
                    PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                    pvDisplayIf.setMajorMode(11);
                }
                break;
            }
            case 9: {
                PdVector[] pdVectorArray = this.m_pointSet.getVertices();
                int n2 = this.m_pointSet.getNumVertices() - 1;
                while (n2 >= 0) {
                    if (pdVectorArray[n2].hasTag(1)) {
                        pdVectorArray[n2].setTag(2);
                    }
                    --n2;
                }
                this.m_pointSet.removeMarkedVertices();
                break;
            }
            case 10: {
                this.m_pointSet.showTaggedVertices(!this.m_pointSet.isShowingTaggedVertices());
                break;
            }
            case 2: {
                this.m_pointSet.removeAllVectorFields();
                break;
            }
            case 15: {
                boolean bl = this.m_pointSet.makeColorFromVectorLength();
                this.m_pointSet.showVertices(true);
                this.m_pointSet.showVertexColors(bl);
                break;
            }
            case 14: {
                this.m_pointSet.showVertexColors(!this.m_pointSet.isShowingVertexColors());
                break;
            }
            case 16: {
                this.m_pointSet.makeVertexColorsFromXYZ();
                this.m_pointSet.showVertexColors(true);
                this.m_pointSet.showVertices(true);
                break;
            }
            case 17: {
                this.m_pointSet.makeVertexColorsFromZ();
                this.m_pointSet.showVertexColors(true);
                this.m_pointSet.showVertices(true);
                break;
            }
            case 18: {
                this.m_pointSet.makeVertexColorsFromZHue();
                this.m_pointSet.showVertexColors(true);
                this.m_pointSet.showVertices(true);
                break;
            }
            case 1: {
                PsDebug.message("PgPointSet = " + this.m_pointSet.getName());
                PsDebug.message("\t Bounding Box: ");
                PdVector[] pdVectorArray = this.m_pointSet.getBounds();
                if (pdVectorArray == null) {
                    PsDebug.message("\t missing bounding box");
                    return true;
                }
                PsDebug.message(pdVectorArray[0].toShortString());
                PsDebug.message(pdVectorArray[1].toShortString());
                return true;
            }
            case 0: {
                PsDebug.message("PgPointSet = " + this.m_pointSet.getName());
                PsDebug.message("\t Center: ");
                PdVector pdVector = this.m_pointSet.getCenter();
                if (pdVector == null) {
                    PsDebug.message("\t missing center");
                    return true;
                }
                PsDebug.message(pdVector.toShortString());
                return true;
            }
            case 19: {
                this.m_pointSet.showVertexNormalArrow(!this.m_pointSet.isShowingVertexNormalArrow());
                return true;
            }
            case 6: {
                this.m_pointSet.showVectorArrow(!this.m_pointSet.isShowingVectorArrow());
                return true;
            }
            case -1: {
                return false;
            }
            default: {
                PsDebug.error("PgPointSet_Menu.applyMethod: method string = " + string + " does not match a constant", this);
                return false;
            }
        }
        return true;
    }

    public void init(PsObject psObject) {
        super.init(psObject);
        this.m_pointSet = (PgPointSet)psObject;
        this.addMenu(PsConfig.getMessage("Info"));
        this.addMenuItem(PsConfig.getMessage("Info"), m_pointSetMethod[0]);
        this.addMenuItem(PsConfig.getMessage("Info"), m_pointSetMethod[1]);
        this.addMenu(PsConfig.getMessage("Show"));
        this.addMenuItem(PsConfig.getMessage("Show"), m_pointSetMethod[11], this.m_pointSet.isShowingTitle());
        this.addMenuItem(PsConfig.getMessage("Show"), m_pointSetMethod[12], this.m_pointSet.isShowingVertexLabels());
        this.addMenuItem(PsConfig.getMessage("Show"), m_pointSetMethod[13], this.m_pointSet.isDefaultLabelEnabled());
        this.addMenuItem(PsConfig.getMessage("Show"), m_pointSetMethod[19], this.m_pointSet.isShowingVertexNormalArrow());
        this.addMenuItem(PsConfig.getMessage("Show"), m_pointSetMethod[6], this.m_pointSet.isShowingVectorArrow());
        this.addMenuItem(PsConfig.getMessage("Show"), m_pointSetMethod[10], this.m_pointSet.isShowingTaggedVertices());
        this.addMenu(PsConfig.getMessage("Color"));
        this.addMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[14]);
        this.addMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[15]);
        this.addMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[16]);
        this.addMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[17]);
        this.addMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[18]);
        this.addMenu(PsConfig.getMessage("Mark"));
        this.addMenuItem(PsConfig.getMessage("Mark"), m_pointSetMethod[7]);
        this.addMenuItem(PsConfig.getMessage("Mark"), m_pointSetMethod[8]);
        this.addMenuItem(PsConfig.getMessage("Mark"), m_pointSetMethod[9]);
        this.addMenu(PsConfig.getMessage("Apply"));
        this.addMenuItem(PsConfig.getMessage("Apply"), m_pointSetMethod[3]);
        this.addMenuItem(PsConfig.getMessage("Apply"), m_pointSetMethod[4]);
        this.addMenuItem(PsConfig.getMessage("Apply"), m_pointSetMethod[5]);
        this.addMenuItem(PsConfig.getMessage("Apply"), m_pointSetMethod[2]);
    }
}

