/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgPolygonSet
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowPolygonLabels;
    protected int m_dimOfPolygons;
    protected int m_numPolygons;
    protected int m_maxNumPolygons;
    protected PiVector[] m_polygon;
    protected Color[] m_polygonColor;
    protected PdVector[] m_polygonNormal;
    protected boolean m_bShowPolygons;
    protected boolean m_bShowTaggedPolygons;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected boolean m_bShowPolygonNormals;
    protected boolean m_bShowPolygonNormalArrow;
    protected PuDouble m_globalPolygonNormalLength;
    protected PuDouble m_globalPolygonNormalSize;
    protected PdColor m_globalPolygonNormalColor;
    protected boolean m_bShowPolygonColors;
    protected PdColor m_globalPolygonColor;
    protected PdColor m_globalPolygonTagColor;
    protected PuDouble m_globalPolygonSize;
    protected boolean m_useGlobalPolygonSize;
    private static /* synthetic */ Class class$jv$geom$PgPolygonSet;

    public int addPolygon(PiVector piVector) {
        this.setNumPolygons(this.m_numPolygons + 1);
        this.setPolygon(this.m_numPolygons - 1, piVector);
        return this.m_numPolygons - 1;
    }

    public boolean hasTagPolygon(int n, int n2) {
        if (n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_polygon[n].hasTag(n2);
    }

    public double getLengthOfPolygon(int n) {
        PdVector[] pdVectorArray = this.getPolygonVertices(n);
        if (pdVectorArray == null || pdVectorArray.length < 2) {
            return 0.0;
        }
        double d = 0.0;
        int n2 = 1;
        while (n2 < pdVectorArray.length) {
            d += PdVector.dist(pdVectorArray[n2 - 1], pdVectorArray[n2]);
            ++n2;
        }
        return d;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        int n = -1;
        int n2 = -1;
        double d = Double.MAX_VALUE;
        PdVector pdVector5 = new PdVector(this.m_dim);
        PdBary pdBary = new PdBary(2);
        PdBary pdBary2 = new PdBary(2);
        int n3 = 0;
        while (n3 < this.m_numPolygons) {
            PdVector[] pdVectorArray = this.getPolygonVertices(n3);
            if (pdVectorArray != null && pdVectorArray.length >= 2) {
                int n4 = 1;
                while (n4 < pdVectorArray.length) {
                    pdVector3.sub(pdVectorArray[n4], pdVectorArray[n4 - 1]);
                    double d2 = PuVectorGeom.distOfLineToLine(pdVector, pdVector2, pdVectorArray[n4 - 1], pdVector3);
                    if (!(d2 >= d)) {
                        PdBary.getBary(pdBary, pdVector, pdVectorArray[n4], pdVectorArray[n4 - 1]);
                        if (pdBary.isInside()) {
                            d = d2;
                            n = n3;
                            n2 = n4;
                            pdBary2.copy(pdBary);
                            pdVector4.copy(pdVector3);
                            pdVector5.blend(pdBary.getEntry(0), pdVectorArray[n4], pdBary.getEntry(1), pdVectorArray[n4 - 1]);
                        }
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        if (n == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setVertex(pdVector5);
        pvPickEvent.setElementInd(n);
        pvPickEvent.setElementSubInd(n2);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector4);
        return pvPickEvent;
    }

    public PdVector[] getPolygonNormals() {
        return this.m_polygonNormal;
    }

    public boolean isShowingPolygonNormals() {
        return this.m_bShowPolygonNormals;
    }

    public void showPolygonNormals(boolean bl) {
        this.m_bShowPolygonNormals = bl;
    }

    public void assurePolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, this.m_maxNumPolygons, this.m_dim);
        }
    }

    public void setPolygonNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_polygonNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of normal array");
            return;
        }
        this.assurePolygonNormals();
        PdVector.copy(this.m_polygonNormal, 0, pdVectorArray, 0, this.m_numPolygons);
    }

    public void makeNormals() {
        this.assureVertexNormals();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        int n = this.getNumPolygons();
        int n2 = 0;
        while (n2 < n) {
            if (this.m_polygon[n2] == null || this.m_polygon[n2].getSize() < 3) {
                PsDebug.warning("polygon[" + n2 + "] null or less than 3 vertices");
            } else {
                int n3 = 0;
                int n4 = this.m_polygon[n2].getEntry(n3);
                int n5 = 1;
                int n6 = this.m_polygon[n2].getEntry(n5);
                pdVector.sub(this.m_vertex[n6], this.m_vertex[n4]);
                while (pdVector.sqrLength() < 1.0E-10) {
                    if (++n5 >= this.m_numVertices) {
                        PsDebug.warning("polygon[" + n2 + "] is degenerated to a point");
                        pdVector3.set(0.0, 0.0, 1.0);
                        PdVector.setConstant(this.m_vertexNormal, pdVector3);
                        return;
                    }
                    n6 = this.m_polygon[n2].getEntry(n5);
                    pdVector.sub(this.m_vertex[n6], this.m_vertex[n4]);
                }
                pdVector4.normalToVector(pdVector);
                if (n5 >= this.m_numVertices - 1) {
                    PsDebug.warning("polygon[" + n2 + "] is a line");
                    PdVector.setConstant(this.m_vertexNormal, pdVector4);
                    return;
                }
                int n7 = n5 + 1;
                int n8 = this.m_polygon[n2].getEntry(n7);
                pdVector2.sub(this.m_vertex[n8], this.m_vertex[n6]);
                while (pdVector2.sqrLength() < 1.0E-10) {
                    if ((n8 = this.m_polygon[n2].getEntry(++n7)) >= this.m_numVertices) {
                        PsDebug.warning("polygon is a line");
                        PdVector.setConstant(this.m_vertexNormal, pdVector4);
                        return;
                    }
                    pdVector2.sub(this.m_vertex[n8], this.m_vertex[n6]);
                }
                pdVector3.cross(pdVector, pdVector2);
                boolean bl = pdVector3.normalize();
                int n9 = n3;
                while (n9 <= n7 - 1) {
                    this.m_vertexNormal[this.m_polygon[n2].getEntry(n9)].copy(pdVector3);
                    ++n9;
                }
                pdVector4.copy(pdVector3);
                pdVector.copy(pdVector2);
                n3 = n7 - 1;
                n4 = this.m_polygon[n2].getEntry(n7 - 1);
                while (n7 < this.m_polygon[n2].getSize() - 1) {
                    n6 = n8;
                    n8 = this.m_polygon[n2].getEntry(++n7);
                    pdVector2.sub(this.m_vertex[n8], this.m_vertex[n6]);
                    if (pdVector2.sqrLength() < 1.0E-10) continue;
                    pdVector2.sub(this.m_vertex[n8], this.m_vertex[n6]);
                    pdVector3.cross(pdVector, pdVector2);
                    if (!pdVector3.normalize()) continue;
                    if (PdVector.dot(pdVector3, pdVector4) < 0.0) {
                        pdVector3.multScalar(-1.0);
                    }
                    n9 = n3 + 1;
                    while (n9 <= n5) {
                        this.m_vertexNormal[this.m_polygon[n2].getEntry(n9)].copy(pdVector3);
                        ++n9;
                    }
                    pdVector4.copy(pdVector3);
                    n4 = n6;
                    n3 = n5;
                    pdVector.copy(pdVector2);
                }
                n9 = n3 + 1;
                while (n9 < this.m_polygon[n2].getSize()) {
                    this.m_vertexNormal[this.m_polygon[n2].getEntry(n9)].copy(pdVector3);
                    ++n9;
                }
            }
            ++n2;
        }
    }

    public boolean makePolygonColorsFromZ() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assurePolygonColors();
        Color[] colorArray = this.getPolygonColors();
        PdVector[] pdVectorArray = this.getBounds();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_polygon[n2].m_data), pdVectorArray[0]);
            float f = (float)(pdVector.m_data[n] / dArray[n]);
            colorArray[n2] = new Color((float)(1.0 - (double)f), 0.0f, f);
            ++n2;
        }
        return true;
    }

    public boolean makePolygonColorsFromZHue() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assurePolygonColors();
        Color[] colorArray = this.getPolygonColors();
        PdVector[] pdVectorArray = this.getBounds();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_polygon[n2].m_data), pdVectorArray[0]);
            float f = (float)(pdVector.m_data[n] / dArray[n]);
            colorArray[n2] = new Color(Color.HSBtoRGB((float)(1.0 - (double)f), 1.0f, 1.0f));
            ++n2;
        }
        return true;
    }

    public Color getPolygonColor(int n) {
        if (n < 0 || n >= this.m_numPolygons) {
            return null;
        }
        return this.m_polygonColor[n];
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public boolean hasPolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            return false;
        }
        return this.m_polygonNormal.length <= 0 || !(Math.abs(this.m_polygonNormal[0].sqrLength() - 1.0) > 1.0E-10);
    }

    public boolean setPolygonColor(int n, Color color) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assurePolygonColors();
        this.m_polygonColor[n] = color;
        return true;
    }

    public boolean isShowingPolygonNormalArrow() {
        return this.m_bShowPolygonNormalArrow;
    }

    public void showPolygonNormalArrow(boolean bl) {
        this.m_bShowPolygonNormalArrow = bl;
    }

    public void useGlobalPolygonSize(boolean bl) {
        this.m_useGlobalPolygonSize = bl;
    }

    public Object clone() {
        PgPolygonSet pgPolygonSet = (PgPolygonSet)super.clone();
        if (pgPolygonSet == null) {
            return null;
        }
        pgPolygonSet.m_globalPolygonSize = (PuDouble)this.m_globalPolygonSize.clone();
        pgPolygonSet.m_globalPolygonColor = (PdColor)this.m_globalPolygonColor.clone();
        pgPolygonSet.m_globalPolygonTagColor = (PdColor)this.m_globalPolygonTagColor.clone();
        pgPolygonSet.m_globalPolygonSize.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonColor.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonTagColor.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonNormalLength = (PuDouble)this.m_globalPolygonNormalLength.clone();
        pgPolygonSet.m_globalPolygonNormalSize = (PuDouble)this.m_globalPolygonNormalSize.clone();
        pgPolygonSet.m_globalPolygonNormalColor = (PdColor)this.m_globalPolygonNormalColor.clone();
        pgPolygonSet.m_globalPolygonNormalLength.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonNormalSize.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonNormalColor.setParent(pgPolygonSet);
        if (this.m_polygon != null) {
            pgPolygonSet.m_polygon = (PiVector[])P_Vector.clone(this.m_polygon);
        }
        if (this.m_polygonColor != null) {
            pgPolygonSet.m_polygonColor = (Color[])this.m_polygonColor.clone();
        }
        if (this.m_polygonNormal != null) {
            pgPolygonSet.m_polygonNormal = (PdVector[])P_Vector.clone(this.m_polygonNormal);
        }
        return pgPolygonSet;
    }

    public PdVector getPolygonNormal(int n) {
        if (n < 0 || n >= this.m_numPolygons) {
            return null;
        }
        return this.m_polygonNormal[n];
    }

    public boolean setPolygonNormal(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assurePolygonNormals();
        this.m_polygonNormal[n].copy(pdVector);
        return true;
    }

    public double getLength() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numPolygons) {
            d += this.getLengthOfPolygon(n);
            ++n;
        }
        return d;
    }

    public int getNumEdges() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            n += this.m_polygon[n2].getSize();
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPolygonSet *********\n");
        stringBuffer.append("\t m_numPolygons    = " + this.m_numPolygons + "\n");
        stringBuffer.append("\t ******* m_polygon *******\n");
        if (this.m_polygon != null) {
            int n = 0;
            while (n < this.m_numPolygons) {
                stringBuffer.append("\t [" + n + "] = " + this.m_polygon[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_polygon = null\n");
        }
        return stringBuffer.toString();
    }

    public boolean setClosed(int n, boolean bl) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (this.isClosed(n)) {
            return true;
        }
        this.m_polygon[n].addEntry(this.m_polygon[n].getFirstEntry());
        return true;
    }

    public boolean isShowingPolygonLabels() {
        return this.m_bShowPolygonLabels;
    }

    public void showPolygonLabels(boolean bl) {
        this.m_bShowPolygonLabels = bl;
    }

    public void copy(PgGeometry pgGeometry) {
        super.copy(pgGeometry);
        if (!(pgGeometry instanceof PgPolygonSet)) {
            return;
        }
        this.copyPolygonSet((PgPolygonSet)pgGeometry);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || this.m_dimOfColors == n) {
            return;
        }
        super.setDimOfColors(n);
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        super.setDimOfVectors(n);
        if (this.m_polygonNormal != null) {
            int n2 = 0;
            while (n2 < this.m_maxNumPolygons) {
                this.m_polygonNormal[n2].setSize(n);
                ++n2;
            }
        }
    }

    public void init() {
        super.init();
        this.m_bShowEdgeLabels = false;
        this.m_bShowPolygonLabels = false;
        this.m_bShowVertices = true;
        this.setGlobalVertexColor(Color.yellow);
        this.setGlobalVertexSize(2);
        this.m_polygonNormal = null;
        this.m_bShowPolygonNormals = false;
        this.m_bShowPolygonNormalArrow = false;
        this.m_globalPolygonNormalSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonNormalSize.setDefValue(1.0);
        this.m_globalPolygonNormalSize.init();
        this.m_globalPolygonNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalPolygonNormalLength.setDefValue(0.5);
        this.m_globalPolygonNormalLength.init();
        this.m_globalPolygonNormalColor.setColor(Color.red);
        this.m_dimOfPolygons = -1;
        this.setMaxNumPolygons(0);
        this.m_bShowPolygons = true;
        this.m_bShowTaggedPolygons = true;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_polygonColor = null;
        this.m_bShowPolygonColors = false;
        this.m_globalPolygonColor.setColor(new Color(25, 20, 200));
        this.m_globalPolygonTagColor.setColor(Color.magenta);
        this.m_useGlobalPolygonSize = true;
        this.m_globalPolygonSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonSize.setDefValue(2.0);
        this.m_globalPolygonSize.init();
    }

    public void showPolygonEndArrow(boolean bl) {
        this.m_bShowPolygonEndArrow = bl;
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalPolygonColor.getColor();
    }

    public Color getGlobalPolygonNormalColor() {
        return this.m_globalPolygonNormalColor.getColor();
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalPolygonColor.setColor(color);
    }

    public void setGlobalPolygonNormalColor(Color color) {
        this.m_globalPolygonNormalColor.setColor(color);
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        int n = this.getNumVertices();
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPolygonSet)) {
            return false;
        }
        PgPolygonSet pgPolygonSet = (PgPolygonSet)pgGeometryIf;
        if (this.m_numPolygons == 0) {
            this.setDimOfPolygons(pgPolygonSet.m_dimOfPolygons);
        } else if (pgPolygonSet.m_dimOfPolygons != this.m_dimOfPolygons) {
            this.setDimOfPolygons(-1);
        }
        int n2 = this.m_numPolygons;
        int n3 = this.m_numPolygons + pgPolygonSet.m_numPolygons;
        this.setNumPolygons(n3);
        PiVector.copy(this.m_polygon, n2, pgPolygonSet.m_polygon, 0, pgPolygonSet.m_numPolygons);
        int n4 = 0;
        while (n4 < pgPolygonSet.m_numPolygons) {
            int n5 = pgPolygonSet.m_polygon[n4].getSize();
            this.m_polygon[n2 + n4].setSize(n5);
            int n6 = 0;
            while (n6 < n5) {
                int n7 = n6++;
                this.m_polygon[n2 + n4].m_data[n7] = this.m_polygon[n2 + n4].m_data[n7] + n;
            }
            ++n4;
        }
        if (pgPolygonSet.m_polygonNormal != null) {
            this.assurePolygonNormals();
            PdVector.copy(this.m_polygonNormal, n2, pgPolygonSet.m_polygonNormal, 0, pgPolygonSet.m_numPolygons);
        }
        if (pgPolygonSet.m_polygonColor != null) {
            this.assurePolygonColors();
            PdColor.copy(this.m_polygonColor, n2, pgPolygonSet.m_polygonColor, 0, pgPolygonSet.m_numPolygons);
        }
        return true;
    }

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public void showPolygonStartArrow(boolean bl) {
        this.m_bShowPolygonStartArrow = bl;
    }

    public int getNumPolygons() {
        return this.m_numPolygons;
    }

    public void setNumPolygons(int n) {
        if (n > this.m_maxNumPolygons) {
            this.setMaxNumPolygons(n);
        } else if (n < this.m_numPolygons && this.m_dimOfPolygons == -1) {
            int n2 = n;
            while (n2 < this.m_numPolygons) {
                this.m_polygon[n2].setSize(0);
                ++n2;
            }
        }
        this.m_numPolygons = n;
    }

    public int[] removeMarkedVertices() {
        int n = -1;
        int[] nArray = super.removeMarkedVertices();
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            int n3 = 0;
            int n4 = this.m_polygon[n2].getSize();
            int n5 = 0;
            while (n5 < n4) {
                if (nArray[this.m_polygon[n2].m_data[n5]] != n) {
                    this.m_polygon[n2].m_data[n3] = nArray[this.m_polygon[n2].m_data[n5]];
                    ++n3;
                }
                ++n5;
            }
            if (n3 <= 1) {
                this.m_polygon[n2].setTag(2);
            } else {
                this.m_polygon[n2].setSize(n3);
            }
            ++n2;
        }
        this.removeMarkedPolygons();
        this.assureDimOfPolygons();
        return nArray;
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2 = 1;
        int n3 = -1;
        PiVector piVector = new PiVector(this.m_numVertices);
        piVector.setConstant(n3);
        int[] nArray = piVector.m_data;
        int n4 = 0;
        while (n4 < this.m_numPolygons) {
            n = 0;
            while (n < this.m_polygon[n4].m_data.length) {
                nArray[this.m_polygon[n4].m_data[n]] = n2;
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] == n2) {
                nArray[n4] = n5++;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] != n3 && nArray[n4] < n4) {
                this.m_vertex[nArray[n4]] = this.m_vertex[n4];
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numPolygons) {
            n = 0;
            while (n < this.m_polygon[n4].m_data.length) {
                this.m_polygon[n4].m_data[n] = nArray[this.m_polygon[n4].m_data[n]];
                ++n;
            }
            ++n4;
        }
        if (this.m_vertexNormal != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexNormal[nArray[n4]] = this.m_vertexNormal[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexColor != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexColor[nArray[n4]] = this.m_vertexColor[n4];
                }
                ++n4;
            }
        }
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonColor) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonSize) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonNormalColor) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonNormalLength) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonNormalSize) {
            return super.update(null);
        }
        return super.update(object);
    }

    public void clearTagPolygon(int n, int n2) {
        if (n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_polygon[n].clearTag(n2);
    }

    public PiVector getPolygon(int n) {
        if (n < 0 || n >= this.m_numPolygons) {
            return null;
        }
        return this.m_polygon[n];
    }

    public boolean setPolygon(int n, PiVector piVector) {
        if (n < 0) {
            PsDebug.error("index out of range, corrupt argument", this);
            return false;
        }
        if (piVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " > " + this.m_numPolygons + "=m_numPolygons, bad programming style");
            this.setNumPolygons(n + 1);
        }
        this.setSizeOfPolygon(n, piVector.getSize());
        this.m_polygon[n].copy(piVector);
        return true;
    }

    public boolean makePolygonColorsFromXYZ() {
        if (this.m_numPolygons == 0) {
            return true;
        }
        this.assurePolygonColors();
        Color[] colorArray = this.getPolygonColors();
        PdVector[] pdVectorArray = this.getBounds();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numPolygons) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_polygon[n].m_data), pdVectorArray[0]);
            if (this.m_dim == 1) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), 0.0f, 0.0f);
            } else if (this.m_dim == 2) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), 0.0f);
            } else if (this.m_dim >= 3) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), (float)(pdVector.m_data[2] / dArray[2]));
            }
            ++n;
        }
        return true;
    }

    public void copyPolygonSet(PgPolygonSet pgPolygonSet) {
        this.setNumPolygons(pgPolygonSet.getNumPolygons());
        int n = 0;
        while (n < this.m_numPolygons) {
            this.m_polygon[n].setSize(pgPolygonSet.getPolygon(n).getSize());
            ++n;
        }
        PiVector.copy(this.m_polygon, 0, pgPolygonSet.getPolygons(), 0, this.m_numPolygons);
        if (pgPolygonSet.m_polygonNormal != null) {
            this.assurePolygonNormals();
            PdVector.copy(this.m_polygonNormal, 0, pgPolygonSet.getPolygonNormals(), 0, this.m_numPolygons);
        }
        if (pgPolygonSet.m_polygonColor != null) {
            this.assurePolygonColors();
            PdColor.copy(this.m_polygonColor, 0, pgPolygonSet.getPolygonColors(), 0, this.m_numPolygons);
        }
    }

    public boolean isClosed(int n) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        return this.m_polygon[n].getFirstEntry() == this.m_polygon[n].getLastEntry();
    }

    public Color[] getPolygonColors() {
        return this.m_polygonColor;
    }

    public boolean isShowingPolygonColors() {
        return this.m_bShowPolygonColors;
    }

    public void showPolygonColors(boolean bl) {
        this.m_bShowPolygonColors = bl;
    }

    public void assurePolygonColors() {
        if (this.m_polygonColor == null || this.m_polygonColor.length != this.m_maxNumPolygons) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, this.m_maxNumPolygons);
        }
    }

    public void setPolygonColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_polygonColor = null;
            return;
        }
        if (colorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of color array");
            return;
        }
        this.assurePolygonColors();
        PdColor.copy(this.m_polygonColor, 0, colorArray, 0, this.m_numPolygons);
    }

    public void setSizeOfPolygon(int n, int n2) {
        if (n < 0 || this.m_numPolygons <= n) {
            PsDebug.warning("index out of bounds, index = " + n);
            return;
        }
        if (n2 > -1) {
            this.m_polygon[n].setSize(n2);
        }
        if (this.m_dimOfPolygons != n2) {
            this.m_dimOfPolygons = -1;
        }
    }

    public int[] removePolygon(int n) {
        this.m_polygon[n].setTag(2);
        return this.removeMarkedPolygons();
    }

    public void setTagPolygon(int n, int n2) {
        if (n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_polygon[n].setTag(n2);
    }

    public boolean hasPolygonColors() {
        return this.m_polygonColor != null && this.m_polygonColor.length == this.m_maxNumPolygons;
    }

    public PgPolygonSet() {
        this(3);
    }

    public PgPolygonSet(int n) {
        super(n);
        this.setDimOfSimplex(1);
        this.m_polygon = new PiVector[0];
        this.m_globalPolygonColor = new PdColor(PsConfig.getMessage("globalPolygonColor"), this);
        this.m_globalPolygonTagColor = new PdColor(PsConfig.getMessage("globalPolygonTagColor"), this);
        this.m_globalPolygonSize = new PuDouble(PsConfig.getMessage("globalPolygonSize"), this);
        this.m_globalPolygonNormalLength = new PuDouble(PsConfig.getMessage("globalPolygonNormalLength"), this);
        this.m_globalPolygonNormalSize = new PuDouble(PsConfig.getMessage("globalPolygonNormalSize"), this);
        this.m_globalPolygonNormalColor = new PdColor(PsConfig.getMessage("globalPolygonNormalColor"), this);
        if (this.getClass() == (class$jv$geom$PgPolygonSet != null ? class$jv$geom$PgPolygonSet : (class$jv$geom$PgPolygonSet = PgPolygonSet.class$("jv.geom.PgPolygonSet")))) {
            this.init();
        }
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalPolygonTagColor.getColor();
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalPolygonTagColor.setColor(color);
    }

    public void useGlobalPolygonColor(boolean bl) {
        this.m_bShowPolygonColors = !bl;
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(83, this.isShowingEdgeLabels());
        pvGeometryIf.setState(82, this.isShowingPolygonLabels());
        pvGeometryIf.setState(54, this.m_bShowPolygons);
        pvGeometryIf.setState(88, this.m_bShowPolygonStartArrow);
        pvGeometryIf.setState(89, this.m_bShowPolygonEndArrow);
        pvGeometryIf.setState(92, this.m_bShowPolygonColors);
        if (this.m_bShowPolygons) {
            if (this.m_globalPolygonSize != null) {
                pvGeometryIf.setGlobalPolygonSize(this.m_globalPolygonSize.getValue());
            }
            if (this.m_globalPolygonColor != null) {
                pvGeometryIf.setGlobalPolygonColor(this.m_globalPolygonColor.getColor());
            }
            if (this.m_globalPolygonTagColor != null) {
                pvGeometryIf.setGlobalPolygonTagColor(this.m_globalPolygonTagColor.getColor());
            }
        }
        pvGeometryIf.setNumPolygons(this.m_numPolygons);
        pvGeometryIf.setPolygons(this.m_polygon);
        pvGeometryIf.setPolygonColors(this.m_polygonColor);
        pvGeometryIf.setState(64, this.m_bShowPolygonNormals);
        pvGeometryIf.setState(65, this.m_bShowPolygonNormalArrow);
        pvGeometryIf.setPolygonNormals(this.m_polygonNormal);
        if (this.m_globalPolygonNormalSize != null) {
            pvGeometryIf.setGlobalPolygonNormalSize(this.m_globalPolygonNormalSize.getValue());
        }
        if (this.m_globalPolygonNormalLength != null) {
            pvGeometryIf.setGlobalPolygonNormalLength(this.m_globalPolygonNormalLength.getValue());
        }
        if (this.m_globalPolygonNormalColor != null) {
            pvGeometryIf.setGlobalPolygonNormalColor(this.m_globalPolygonNormalColor.getColor());
        }
    }

    public int getPolygonWithVertex(int n) {
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            if (this.m_polygon[n2].getIndexOf(n) > -1) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPolygonSet)) {
            return false;
        }
        PgPolygonSet pgPolygonSet = (PgPolygonSet)pgGeometry;
        PgPolygonSet pgPolygonSet2 = (PgPolygonSet)pgGeometry2;
        if (pgPolygonSet.m_numPolygons != pgPolygonSet2.m_numPolygons) {
            PsDebug.warning("unequal number of polygons", this);
            return false;
        }
        this.setNumPolygons(pgPolygonSet.m_numPolygons);
        int n = 0;
        while (n < this.m_numPolygons) {
            this.m_polygon[n].copy(pgPolygonSet.m_polygon[n]);
            ++n;
        }
        if (pgPolygonSet.m_polygonNormal != null && pgPolygonSet2.m_polygonNormal != null) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, this.m_numPolygons, this.m_dim);
            n = 0;
            while (n < this.m_numPolygons) {
                this.m_polygonNormal[n].blend(d, pgPolygonSet.m_polygonNormal[n], d2, pgPolygonSet2.m_polygonNormal[n]);
                this.m_polygonNormal[n].normalize();
                ++n;
            }
        }
        if (pgPolygonSet.m_polygonColor != null && pgPolygonSet2.m_polygonColor != null) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, this.m_numPolygons);
            n = 0;
            while (n < this.m_numPolygons) {
                this.m_polygonColor[n] = PdColor.blend(d, pgPolygonSet.m_polygonColor[n], d2, pgPolygonSet2.m_polygonColor[n]);
                ++n;
            }
        }
        return true;
    }

    public double getGlobalPolygonNormalLength() {
        return this.m_globalPolygonNormalLength.getValue();
    }

    public void setGlobalPolygonNormalLength(double d) {
        this.m_globalPolygonNormalLength.setValue(d);
    }

    public double getVertexAngle(int n, int n2) {
        int n3 = this.m_polygon[n].getSize();
        PdVector pdVector = this.m_vertex[this.m_polygon[n].m_data[n2]];
        PdVector pdVector2 = this.m_vertex[this.m_polygon[n].m_data[(n2 + 1) % n3]];
        PdVector pdVector3 = this.m_vertex[this.m_polygon[n].m_data[(n2 - 1 + n3) % n3]];
        return PdVector.angle(pdVector, pdVector2, pdVector3);
    }

    public int getDimOfPolygons() {
        return this.m_dimOfPolygons;
    }

    public boolean assureDimOfPolygons() {
        int n = PiVector.getSameSize(this.m_polygon, this.m_numPolygons);
        if (n != this.m_dimOfPolygons) {
            this.m_dimOfPolygons = n;
            return false;
        }
        return true;
    }

    public int[] removeMarkedPolygons() {
        int n = 1;
        int n2 = -1;
        PiVector piVector = new PiVector(this.m_numPolygons);
        piVector.setConstant(n2);
        int[] nArray = piVector.m_data;
        int n3 = 0;
        while (n3 < this.m_numPolygons) {
            if (!this.m_polygon[n3].hasTag(2)) {
                nArray[n3] = n;
            }
            ++n3;
        }
        int n4 = 0;
        n3 = 0;
        while (n3 < this.m_numPolygons) {
            if (nArray[n3] == n) {
                nArray[n3] = n4++;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_numPolygons) {
            if (nArray[n3] != n2 && nArray[n3] < n3) {
                this.m_polygon[nArray[n3]].setSize(this.m_polygon[n3].getSize());
                this.m_polygon[nArray[n3]].copy(this.m_polygon[n3]);
            }
            ++n3;
        }
        if (this.m_polygonNormal != null) {
            n3 = 0;
            while (n3 < this.m_numPolygons) {
                if (nArray[n3] != n2 && nArray[n3] < n3) {
                    this.m_polygonNormal[nArray[n3]].setSize(this.m_polygonNormal[n3].getSize());
                    this.m_polygonNormal[nArray[n3]].copy(this.m_polygonNormal[n3]);
                }
                ++n3;
            }
        }
        if (this.m_polygonColor != null) {
            n3 = 0;
            while (n3 < this.m_numPolygons) {
                if (nArray[n3] != n2 && nArray[n3] < n3) {
                    this.m_polygonColor[nArray[n3]] = this.m_polygonColor[n3];
                }
                ++n3;
            }
        }
        this.setNumPolygons(n4);
        this.setMaxNumPolygons(n4);
        return nArray;
    }

    public PiVector[] getPolygons() {
        return this.m_polygon;
    }

    public double getGlobalPolygonSize() {
        return this.m_globalPolygonSize.getValue();
    }

    public double getGlobalPolygonNormalSize() {
        return this.m_globalPolygonNormalSize.getValue();
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize.setValue(d);
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(32);
        pgJvxSrc.showEdgeLabels(this.isShowingEdgeLabels());
        pgJvxSrc.showPolygonLabels(this.isShowingPolygonLabels());
        pgJvxSrc.showPolygons(this.isShowingPolygons());
        pgJvxSrc.showPolygonStartArrow(this.isShowingPolygonStartArrow());
        pgJvxSrc.showPolygonEndArrow(this.isShowingPolygonEndArrow());
        pgJvxSrc.setDimOfPolygons(-1);
        pgJvxSrc.setNumPolygons(this.getNumPolygons());
        pgJvxSrc.setPolygons(this.getPolygons());
        pgJvxSrc.setPolygonColors(this.getPolygonColors());
        pgJvxSrc.setGlobalPolygonColor(this.getGlobalPolygonColor());
        pgJvxSrc.setGlobalPolygonTagColor(this.getGlobalPolygonTagColor());
        pgJvxSrc.setGlobalPolygonSize(this.getGlobalPolygonSize());
        if (this.hasPolygonColors()) {
            pgJvxSrc.showPolygonColors(this.isShowingPolygonColors());
            pgJvxSrc.setPolygonColors(this.getPolygonColors());
        } else {
            pgJvxSrc.showPolygonColors(false);
        }
        if (this.hasPolygonNormals()) {
            pgJvxSrc.showPolygonNormals(this.isShowingPolygonNormals());
            pgJvxSrc.setPolygonNormals(this.getPolygonNormals());
        } else {
            pgJvxSrc.showPolygonNormals(false);
        }
        pgJvxSrc.showPolygonNormalArrow(this.isShowingPolygonNormalArrow());
        pgJvxSrc.setGlobalPolygonNormalColor(this.getGlobalPolygonNormalColor());
        pgJvxSrc.setGlobalPolygonNormalLength(this.getGlobalPolygonNormalLength());
        pgJvxSrc.setGlobalPolygonNormalSize(this.getGlobalPolygonNormalSize());
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showPolygons(pgJvxSrc.isShowingPolygons());
        this.showPolygonStartArrow(pgJvxSrc.isShowingPolygonStartArrow());
        this.showPolygonEndArrow(pgJvxSrc.isShowingPolygonEndArrow());
        this.setNumPolygons(pgJvxSrc.getNumPolygons());
        int n = PiVector.getSameSize(pgJvxSrc.getPolygons(), pgJvxSrc.getNumPolygons());
        this.setDimOfPolygons(n);
        this.setPolygons(pgJvxSrc.getPolygons());
        if (pgJvxSrc.getPolygonColors() != null) {
            this.setPolygonColors(pgJvxSrc.getPolygonColors());
            this.showPolygonColors(true);
        } else {
            this.showPolygonColors(false);
        }
        if (pgJvxSrc.getGlobalPolygonColor() != null) {
            this.setGlobalPolygonColor(pgJvxSrc.getGlobalPolygonColor());
        }
        if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
            this.setGlobalPolygonTagColor(pgJvxSrc.getGlobalPolygonTagColor());
        }
        if (pgJvxSrc.getGlobalPolygonSize() != 0.0) {
            this.setGlobalPolygonSize(pgJvxSrc.getGlobalPolygonSize());
        }
        this.showPolygonNormals(pgJvxSrc.isShowingPolygonNormals());
        this.showPolygonNormalArrow(pgJvxSrc.isShowingPolygonNormalArrow());
        if (pgJvxSrc.getPolygonNormals() != null) {
            this.setPolygonNormals(pgJvxSrc.getPolygonNormals());
        }
        if (pgJvxSrc.getGlobalPolygonNormalColor() != null) {
            this.setGlobalPolygonNormalColor(pgJvxSrc.getGlobalPolygonNormalColor());
        }
        if (pgJvxSrc.getGlobalPolygonNormalLength() != 0.0) {
            this.setGlobalPolygonNormalLength(pgJvxSrc.getGlobalPolygonNormalLength());
        }
        if (pgJvxSrc.getGlobalPolygonNormalSize() != 0.0) {
            this.setGlobalPolygonNormalSize(pgJvxSrc.getGlobalPolygonNormalSize());
        }
    }

    public void setGlobalPolygonNormalSize(double d) {
        this.m_globalPolygonNormalSize.setValue(d);
    }

    public boolean isShowingPolygons() {
        return this.m_bShowPolygons;
    }

    public void showPolygons(boolean bl) {
        this.m_bShowPolygons = bl;
    }

    public int getMaxNumPolygons() {
        return this.m_maxNumPolygons;
    }

    protected void setMaxNumPolygons(int n) {
        if (this.m_maxNumPolygons == n) {
            return;
        }
        this.m_polygon = this.m_dimOfPolygons > -1 ? PiVector.realloc(this.m_polygon, n, this.m_dimOfPolygons) : PiVector.realloc(this.m_polygon, n);
        if (this.m_polygonNormal != null) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, n, this.m_dim);
        }
        if (this.m_polygonColor != null) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, n);
        }
        this.m_maxNumPolygons = n;
        if (this.m_maxNumPolygons < this.m_numPolygons) {
            this.m_numPolygons = this.m_maxNumPolygons;
        }
    }

    public void setDimOfPolygons(int n) {
        if (n > -1) {
            int n2 = 0;
            while (n2 < this.m_maxNumPolygons) {
                this.m_polygon[n2].setSize(n);
                ++n2;
            }
        }
        this.m_dimOfPolygons = n;
    }

    public PdVector[] getPolygonVertices(int n) {
        if (n < 0 || this.m_numPolygons <= n) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return null;
        }
        if (this.m_polygon[n].getSize() == 0) {
            return null;
        }
        int n2 = this.m_polygon[n].getSize();
        PdVector[] pdVectorArray = new PdVector[n2];
        --n2;
        while (n2 >= 0) {
            pdVectorArray[n2] = this.m_vertex[this.m_polygon[n].m_data[n2]];
            --n2;
        }
        return pdVectorArray;
    }

    public boolean setPolygonVertices(int n, PdVector[] pdVectorArray) {
        int n2 = this.m_polygon[n].getSize();
        if (n2 != pdVectorArray.length) {
            PsDebug.warning("polygon and array have different length");
            return false;
        }
        --n2;
        while (n2 >= 0) {
            this.m_vertex[this.m_polygon[n].m_data[n2]].copy(pdVectorArray[n2]);
            --n2;
        }
        return true;
    }

    public void setPolygons(PiVector[] piVectorArray) {
        if (piVectorArray == null || piVectorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of polygon array");
            return;
        }
        int n = piVectorArray[0].getSize();
        int n2 = 0;
        while (n2 < this.m_numPolygons) {
            int n3 = piVectorArray[n2].getSize();
            this.m_polygon[n2].setSize(n3);
            if (n != -1 && n3 != n) {
                n = -1;
            }
            ++n2;
        }
        PiVector.copy(this.m_polygon, 0, piVectorArray, 0, this.m_numPolygons);
    }
}

