/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import jv.geom.PgPointSet_IP;
import jv.geom.PgPolygonSet;
import jv.number.PiArray_IP;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;

public class PgPolygonSet_IP
extends PgPointSet_IP {
    protected PgPolygonSet m_polygonSet;
    protected TextField m_tNumPolygons;
    protected Label m_tDimPolygons;
    protected Panel m_pNumPolygons;
    protected PiArray_IP m_polygonPanel;
    protected int m_maxVisibleVectors = 5;
    protected int m_maxVisibleDim = 5;
    protected static String[] m_header = new String[]{"0", "1", "2", "3", "4"};
    private static /* synthetic */ Class class$jv$geom$PgPolygonSet_IP;

    public PgPolygonSet_IP() {
        if (this.getClass() == (class$jv$geom$PgPolygonSet_IP != null ? class$jv$geom$PgPolygonSet_IP : (class$jv$geom$PgPolygonSet_IP = PgPolygonSet_IP.class$("jv.geom.PgPolygonSet_IP")))) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_polygonSet = (PgPolygonSet)psUpdateIf;
    }

    public boolean update(Object object) {
        if (this.m_polygonSet == null) {
            PsDebug.warning("PgPolygonSet_IP.update(): missing polygonSet");
            return true;
        }
        if (object == this.m_polygonSet) {
            this.m_bInteractive = false;
            ((TextComponent)this.m_tNumPolygons).setText(String.valueOf(this.m_polygonSet.getNumPolygons()));
            int n = this.m_polygonSet.m_dimOfPolygons;
            if (n == -1) {
                this.m_tDimPolygons.setText(PsConfig.getMessage("tDimPolygons"));
            } else {
                this.m_tDimPolygons.setText(String.valueOf(n));
            }
            this.m_polygonPanel.setBounds(0, this.m_polygonSet.getNumVertices() - 1);
            this.m_polygonPanel.setVector(this.m_polygonSet.getPolygons(), m_header, this.m_polygonSet.getNumPolygons(), this.m_polygonSet.m_dimOfPolygons);
            this.m_bInteractive = true;
            return super.update(object);
        }
        if (object == this.m_polygonPanel) {
            this.m_polygonSet.update(this);
            return true;
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.addLine(1);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 2));
        this.add(panel);
        Label label = new Label(PsConfig.getMessage("lNumPolygons"));
        panel.add(label);
        this.m_tNumPolygons = new TextField("0", 7);
        this.m_tNumPolygons.addTextListener(this);
        panel.add(this.m_tNumPolygons);
        Label label2 = new Label(PsConfig.getMessage("lDimPolygons"));
        panel.add(label2);
        this.m_tDimPolygons = new Label("");
        panel.add(this.m_tDimPolygons);
        this.m_polygonPanel = new PiArray_IP(this.m_maxVisibleVectors, this.m_maxVisibleDim);
        this.m_polygonPanel.setParent(this);
        this.add(this.m_polygonPanel);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.m_bInteractive) {
            return;
        }
        Object object = textEvent.getSource();
        if (object == this.m_tNumPolygons) {
            String string = this.m_tNumPolygons.getText();
            if (string == null || string.equals("")) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n != this.m_polygonSet.getNumPolygons()) {
                    this.m_polygonSet.setNumPolygons(n);
                    this.m_polygonPanel.setBounds(0, this.m_polygonSet.getNumVertices() - 1);
                    this.m_polygonPanel.setVector(this.m_polygonSet.getPolygons(), m_header, n, this.m_polygonSet.m_dimOfPolygons);
                }
                this.m_polygonSet.update(this);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("PgPolygonSet_IP.textValueChanged(): wrong format = " + string);
                return;
            }
        }
        super.textValueChanged(textEvent);
    }
}

