/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import jv.loader.PgMacroPatch;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgBdLoader {
    protected String m_task;
    protected int m_startFrame;
    protected int m_endFrame;
    protected int m_numIntegerParms;
    protected int m_numDoubleParms;
    protected int m_numPatches;
    protected int m_numVertices;
    protected PdVector[] m_vertex;
    protected PiVector[] m_vertexType;
    protected PgMacroPatch[] m_patch;

    /*
     * Enabled aggressive block sorting
     */
    private int nextToken(StreamTokenizer streamTokenizer) throws IOException {
        block6: while (true) {
            switch (streamTokenizer.nextToken()) {
                case 10: {
                    continue block6;
                }
                case -3: {
                    return -3;
                }
                case -2: {
                    return -2;
                }
                case -1: {
                    return -1;
                }
            }
            PsDebug.warning("token not identified", this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean read(String string) {
        BufferedReader bufferedReader;
        block10: {
            boolean bl;
            bufferedReader = PsUtil.open(string);
            if (bufferedReader == null) {
                PsDebug.error("could not open = " + string, this);
                return false;
            }
            try {
                try {
                    boolean bl2 = this.parseBuild(bufferedReader);
                    if (bl2) break block10;
                    PsDebug.error("error when reading file = " + string, this);
                    bl = false;
                    Object var5_8 = null;
                }
                catch (IOException iOException) {
                    PsDebug.error("error when reading file = " + string, this);
                    iOException.printStackTrace();
                    boolean bl3 = false;
                    Object var5_9 = null;
                    try {
                        bufferedReader.close();
                        return bl3;
                    }
                    catch (IOException iOException2) {}
                    return bl3;
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                try {}
                catch (IOException iOException) {}
                bufferedReader.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedReader.close();
            return bl;
        }
        Object var5_10 = null;
        try {}
        catch (IOException iOException) {
            return true;
        }
        bufferedReader.close();
        return true;
    }

    public PgMacroPatch getPatch(int n) {
        if (this.m_patch == null) {
            PsDebug.error("m_Patch==null", this);
            return null;
        }
        if (n < 0 || this.m_patch.length <= n) {
            PsDebug.error("index out of range", this);
            return null;
        }
        return this.m_patch[n];
    }

    protected boolean parseBuild(BufferedReader bufferedReader) throws IOException {
        int n;
        if (bufferedReader == null) {
            PsDebug.error("missing argumnt", this);
            return false;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.whitespaceChars(59, 59);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        if (this.nextToken(streamTokenizer) != -3) {
            PsDebug.error("failed reading m_task", this);
            return false;
        }
        this.m_task = new String(streamTokenizer.sval);
        if (this.nextToken(streamTokenizer) != -2) {
            PsDebug.error("failed reading m_startFrame", this);
            return false;
        }
        this.m_startFrame = (int)streamTokenizer.nval;
        if (this.nextToken(streamTokenizer) != -2) {
            PsDebug.error("failed reading m_endFrame", this);
            return false;
        }
        this.m_endFrame = (int)streamTokenizer.nval;
        if (this.nextToken(streamTokenizer) != -2) {
            PsDebug.error("failed reading m_numIntegerParms", this);
            return false;
        }
        this.m_numIntegerParms = (int)streamTokenizer.nval;
        if (this.nextToken(streamTokenizer) != -2) {
            PsDebug.error("failed reading m_numDoubleParms", this);
            return false;
        }
        this.m_numDoubleParms = (int)streamTokenizer.nval;
        if (this.nextToken(streamTokenizer) != -2) {
            PsDebug.error("failed reading numPatches", this);
            return false;
        }
        this.m_numPatches = (int)streamTokenizer.nval;
        this.m_patch = new PgMacroPatch[this.m_numPatches];
        if (this.nextToken(streamTokenizer) != -2) {
            PsDebug.error("", this);
            return false;
        }
        this.m_numVertices = (int)streamTokenizer.nval;
        this.m_vertexType = new PiVector[this.m_numVertices];
        this.m_vertex = new PdVector[this.m_numVertices];
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            this.m_vertexType[n2] = new PiVector(3);
            this.m_vertex[n2] = new PdVector(3);
            n = 0;
            do {
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.error("failed reading m_vertexType[" + n2 + "].m_data[" + n + "]", this);
                    return false;
                }
                this.m_vertexType[n2].m_data[n] = (int)streamTokenizer.nval;
            } while (++n < 3);
            n = 0;
            do {
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.error("failed reading m_vertex[" + n2 + "].m_data[" + n + "]", this);
                    return false;
                }
                this.m_vertex[n2].m_data[n] = streamTokenizer.nval;
            } while (++n < 3);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_numPatches) {
            int n3;
            int n4;
            String string;
            this.m_patch[n2] = new PgMacroPatch(3);
            this.m_patch[n2].setVertexType(this.m_vertexType);
            this.m_patch[n2].setVertex(this.m_vertex);
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.error("error reading orientation in patch[" + n2 + "]", this);
                return false;
            }
            this.m_patch[n2].setOrientation((int)streamTokenizer.nval);
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.error("error reading bndType in patch[" + n2 + "]", this);
                return false;
            }
            this.m_patch[n2].setBndType((int)streamTokenizer.nval);
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.error("error reading patchLength in patch[" + n2 + "]", this);
                return false;
            }
            this.m_patch[n2].setNumVertices((int)streamTokenizer.nval);
            int n5 = this.m_patch[n2].getNumVertices();
            int n6 = 0;
            while (n6 < n5) {
                if (this.nextToken(streamTokenizer) != -2) {
                    PsDebug.error("error reading element[" + n6 + "] in patch[" + n2 + "]", this);
                    return false;
                }
                this.m_patch[n2].m_element.m_data[n6] = (int)streamTokenizer.nval;
                ++n6;
            }
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.error("error reading numULines in patch[" + n2 + "]", this);
                return false;
            }
            this.m_patch[n2].m_numULines = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.error("error reading numVLines in patch[" + n2 + "]", this);
                return false;
            }
            this.m_patch[n2].m_numVLines = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.error("error reading numUSubs in patch[" + n2 + "]", this);
                return false;
            }
            this.m_patch[n2].m_numUSubs = (int)streamTokenizer.nval;
            if (this.nextToken(streamTokenizer) != -2) {
                PsDebug.error("error reading numVSubs in patch[" + n2 + "]", this);
                return false;
            }
            this.m_patch[n2].m_numVSubs = (int)streamTokenizer.nval;
            if (this.m_patch[n2].getBndType() == 1) {
                n6 = 0;
                while (n6 < n5) {
                    if (this.nextToken(streamTokenizer) != -2) {
                        PsDebug.error("error reading bndShape[" + n6 + "][0] in patch[" + n2 + "]", this);
                        return false;
                    }
                    string = Integer.toString((int)streamTokenizer.nval);
                    n4 = Integer.parseInt(string, 8);
                    string = Integer.toBinaryString(n4);
                    n3 = string.length();
                    n = 0;
                    while (n < n3) {
                        if (string.charAt(n3 - 1 - n) == '1') {
                            this.m_patch[n2].m_bndShapeBits[n6].set(n);
                        } else {
                            this.m_patch[n2].m_bndShapeBits[n6].clear(n);
                        }
                        ++n;
                    }
                    if (this.nextToken(streamTokenizer) != -2) {
                        PsDebug.error("error reading bndShape[" + n6 + "][" + 0 + "] in patch[" + n2 + "]", this);
                        return false;
                    }
                    this.m_patch[n2].m_bndShape[n6].m_data[0] = (int)streamTokenizer.nval;
                    if (!this.m_patch[n2].m_bndShapeBits[n6].get(7) || this.m_patch[n2].m_bndShapeBits[n6].get(7) && this.m_patch[n2].m_bndShapeBits[n6].get(5)) {
                        n = 1;
                        do {
                            if (this.nextToken(streamTokenizer) != -2) {
                                PsDebug.error("error reading bndShape[" + n6 + "][" + n + "] in patch[" + n2 + "]", this);
                                return false;
                            }
                            this.m_patch[n2].m_bndShape[n6].m_data[n] = (int)streamTokenizer.nval;
                        } while (++n < 3);
                    }
                    ++n6;
                }
            } else {
                n6 = 0;
                while (n6 < n5) {
                    string = Integer.toString(220);
                    n4 = Integer.parseInt(string, 8);
                    string = Integer.toBinaryString(n4);
                    n3 = string.length();
                    n = 0;
                    while (n < n3) {
                        if (string.charAt(n3 - 1 - n) == '1') {
                            this.m_patch[n2].m_bndShapeBits[n6].set(n);
                        } else {
                            this.m_patch[n2].m_bndShapeBits[n6].clear(n);
                        }
                        ++n;
                    }
                    ++n6;
                }
            }
            ++n2;
        }
        return true;
    }

    public int getNumPatches() {
        return this.m_numPatches;
    }
}

