/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgDxfLoader {
    protected static final int ENTITY_LINE = 100;
    protected static final int ENTITY_POINT = 101;
    protected static final int ENTITY_CIRCLE = 102;
    protected static final int ENTITY_ARC = 103;
    protected static final int ENTITY_TRACE = 104;
    protected static final int ENTITY_SOLID = 105;
    protected static final int ENTITY_TEXT = 106;
    protected static final int ENTITY_SHAPE = 107;
    protected static final int ENTITY_BLOCK = 108;
    protected static final int ENTITY_ENDBLK = 109;
    protected static final int ENTITY_INSERT = 110;
    protected static final int ENTITY_ATTDEF = 111;
    protected static final int ENTITY_ATTRIB = 112;
    protected static final int ENTITY_POLYLINE = 113;
    protected static final int ENTITY_VERTEX = 114;
    protected static final int ENTITY_SEQEND = 115;
    protected static final int ENTITY_3DFACE = 116;
    protected static final int ENTITY_VIEWPORT = 117;
    protected static final int ENTITY_DIMENSION = 118;
    protected static final int ENTITY_LINEAR = 119;
    protected static final int ENTITY_ANGULAR = 120;
    protected static final int ENTITY_DIAMETER = 121;
    protected static final int ENTITY_RADIUS = 122;
    protected static final int ENTITY_ORDINATE = 123;
    protected int m_numVertices = 0;
    protected int m_numVertexNormals = 0;
    protected int m_numVertexTextures = 0;
    protected int m_numVertexVectors = 0;
    protected int m_numPolygons = 0;
    protected int m_numElements = 0;
    protected int m_numMeshType = 0;
    protected Vector m_vVertex;
    protected Vector m_vVertexColor;
    protected PiVector m_vVertexColorInd;
    protected Vector m_vVertexNormal;
    protected Vector m_vVertexTexture;
    protected Vector m_vVertexVector;
    protected int[] m_meshType;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected Vector m_vElementColor;
    protected PiVector m_vElementColorInd;
    protected Vector m_vElementNormal;
    protected int m_dimOfPolygons = -1;
    protected Vector m_vPolygon;
    protected Vector m_vPolygonColor;
    protected PiVector m_vPolygonColorInd;
    protected int m_lineNo = 0;
    private int m_code;
    private int m_ival;
    private double m_dval;
    private String m_sval;
    private static final String StrNL = "\n";
    protected static boolean m_bVertexNormals = false;
    protected static boolean m_bVertexTextures = false;
    protected static boolean m_bVertexVector = false;
    protected static boolean m_bElements = false;
    protected static boolean m_bPolygons = false;
    protected static boolean m_bPolygonColors = false;
    protected static boolean m_bPolygonNormals = false;

    protected static String writePolygons(int n, PiVector[] piVectorArray) {
        if (n <= 0 && piVectorArray == null && n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# Polygon List\n");
        stringBuffer.append("# Number of Polygons = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("l ");
            if (piVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                int n4 = piVectorArray[n2].m_data[n3] + 1;
                stringBuffer.append(n4);
                if (m_bPolygonNormals) {
                    stringBuffer.append("/" + n4);
                }
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parse(BufferedReader var1_1) throws IOException {
        var2_2 = 3;
        var3_3 = 200;
        var4_4 = 4;
        new float[var2_2];
        new double[var4_4];
        new double[var4_4];
        new double[var4_4];
        new int[var3_3];
        new int[var3_3];
        new int[var3_3];
        new int[var3_3];
        this.m_vVertex = new Vector<E>();
        this.m_vVertexColor = new Vector<E>();
        this.m_vVertexColorInd = new PiVector();
        this.m_vVertexNormal = new Vector<E>();
        this.m_vVertexTexture = new Vector<E>();
        this.m_vVertexVector = new Vector<E>();
        this.m_vElement = new Vector<E>();
        this.m_vElementColor = new Vector<E>();
        this.m_vElementColorInd = new PiVector();
        this.m_vElementNormal = new Vector<E>();
        this.m_vPolygon = new Vector<E>();
        this.m_vPolygonColor = new Vector<E>();
        this.m_vPolygonColorInd = new PiVector();
        try {
            this.m_numVertices = 0;
            this.m_numVertexNormals = 0;
            this.m_numVertexTextures = 0;
            this.m_numElements = 0;
            this.m_lineNo = 0;
            block3: while (true) {
                block119: {
                    if ((var5_5 = this.parseGroup(var1_1)) == 999) {
                        continue;
                    }
                    if (var5_5 == 0) {
                        if (this.m_sval.equals("SECTION") || this.m_sval.equals("TABLE") || this.m_sval.equals("ENDTAB")) continue;
                        if (this.m_sval.equals("EOF")) {
                            if (this.m_vVertexColorInd.getSize() > 0) {
                                this.m_vVertexColorInd.setEntry(this.m_vVertexColor.size(), this.m_numVertices);
                            }
                            if (this.m_vElementColorInd.getSize() > 0) {
                                this.m_vElementColorInd.setEntry(this.m_vElementColor.size(), this.m_numElements);
                            }
                            if (this.m_vPolygonColorInd.getSize() > 0) {
                                this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
                            }
                            return true;
                        }
                        if (this.m_sval.equals("LINE") || this.m_sval.equals("3DFACE") || !this.m_sval.equals("LAYER")) continue;
                        continue;
                    }
                    if (var5_5 != 2) continue;
                    if (!this.m_sval.equals("HEADER")) break block119;
                    var5_5 = this.parseGroup(var1_1);
                    while (true) {
                        block120: {
                            if (var5_5 == 0 && this.m_sval.equals("ENDSEC")) continue block3;
                            if (var5_5 != 9) break block120;
                            if (!this.m_sval.equals("$ACADVER")) ** GOTO lbl67
                            var5_5 = this.parseGroup(var1_1);
                            if (var5_5 == 1) {
                                if (!this.m_sval.equals("AC1006") && !this.m_sval.equals("AC1008") && this.m_sval.equals("AC1009")) {
                                    // empty if block
                                }
                            } else {
                                throw new IOException("unexpected code=" + var5_5 + " in group=" + this.m_sval + " at line=" + this.m_lineNo);
lbl67:
                                // 1 sources

                                if (!(this.m_sval.equals("$ANGBASE") || this.m_sval.equals("$ANGDIR") || this.m_sval.equals("$ATTDIA") || this.m_sval.equals("$ATTMODE") || this.m_sval.equals("$ATTREQ") || this.m_sval.equals("$AUNITS") || this.m_sval.equals("$AUPREC") || this.m_sval.equals("$AXISMODE") || this.m_sval.equals("$AXISUNIT") || this.m_sval.equals("$BLIPMODE") || this.m_sval.equals("$CECOLOR") || this.m_sval.equals("$CELTYPE") || this.m_sval.equals("$CHAMFERA") || this.m_sval.equals("$CHAMFERB") || this.m_sval.equals("$CLAYER") || this.m_sval.equals("$COORDS") || this.m_sval.equals("$DIMALT") || this.m_sval.equals("$DIMALTD") || this.m_sval.equals("$DIMALTF") || this.m_sval.equals("$DIMAPOST") || this.m_sval.equals("$DIMASO") || this.m_sval.equals("$DIMASZ") || this.m_sval.equals("$DIMBLK") || this.m_sval.equals("$DIMBLK1") || this.m_sval.equals("$DIMBLK2") || this.m_sval.equals("$DIMCEN") || this.m_sval.equals("$DIMCLRD") || this.m_sval.equals("$DIMCLRE") || this.m_sval.equals("$DIMCLRT") || this.m_sval.equals("$DIMDLE") || this.m_sval.equals("$DIMDLI") || this.m_sval.equals("$DIMEXE") || this.m_sval.equals("$DIMEXO") || this.m_sval.equals("$DIMGAP") || this.m_sval.equals("$DIMLFAC") || this.m_sval.equals("$DIMLIM") || this.m_sval.equals("$DIMPOST") || this.m_sval.equals("$DIMRND") || this.m_sval.equals("$DIMSAH") || this.m_sval.equals("$DIMSCALE") || this.m_sval.equals("$DIMSE1") || this.m_sval.equals("$DIMSE2") || this.m_sval.equals("$DIMSHO") || this.m_sval.equals("$DIMSOXD") || this.m_sval.equals("$DIMSTYLE") || this.m_sval.equals("$DIMTAD") || this.m_sval.equals("$DIMTFAC") || this.m_sval.equals("$DIMTIH") || this.m_sval.equals("$DIMTIX") || this.m_sval.equals("$DIMTM") || this.m_sval.equals("$DIMTOFL") || this.m_sval.equals("$DIMTOH") || this.m_sval.equals("$DIMTOL") || this.m_sval.equals("$DIMTP") || this.m_sval.equals("$DIMTSZ") || this.m_sval.equals("$DIMTVP") || this.m_sval.equals("$DIMTXT") || this.m_sval.equals("$DIMZIN") || this.m_sval.equals("$DWGCODEPAGE") || this.m_sval.equals("$DRAGMODE") || this.m_sval.equals("$ELEVATION") || this.m_sval.equals("$EXTMAX") || this.m_sval.equals("$EXTMIN") || this.m_sval.equals("$FILLETRAD") || this.m_sval.equals("$FILLMODE") || this.m_sval.equals("$HANDLING") || this.m_sval.equals("$HANDSEED") || this.m_sval.equals("$INSBASE") || this.m_sval.equals("$LIMCHECK") || this.m_sval.equals("$LIMMAX") || this.m_sval.equals("$LIMMIN") || this.m_sval.equals("$LTSCALE") || this.m_sval.equals("$LUNITS") || this.m_sval.equals("$LUPREC") || this.m_sval.equals("$MAXACTVP") || this.m_sval.equals("$MENU") || this.m_sval.equals("$MIRRTEXT") || this.m_sval.equals("$ORTHOMODE") || this.m_sval.equals("$OSMODE") || this.m_sval.equals("$PDMODE") || this.m_sval.equals("$PDSIZE") || this.m_sval.equals("$PELEVATION") || this.m_sval.equals("$PEXTMAX") || this.m_sval.equals("$PEXTMIN") || this.m_sval.equals("$PLIMCHECK") || this.m_sval.equals("$PLIMMAX") || this.m_sval.equals("$PLIMMIN") || this.m_sval.equals("$PLINEGEN") || this.m_sval.equals("$PLINEWID") || this.m_sval.equals("$PSLTSCALE") || this.m_sval.equals("$PUCSNAME") || this.m_sval.equals("$PUCSORG") || this.m_sval.equals("$PUCSXDIR") || this.m_sval.equals("$PUCSYDIR") || this.m_sval.equals("$QTEXTMODE") || this.m_sval.equals("$REGENMODE") || this.m_sval.equals("$SHADEDGE") || this.m_sval.equals("$SHADEDIF") || this.m_sval.equals("$SKETCHINC") || this.m_sval.equals("$SKPOLY") || this.m_sval.equals("$SPLFRAME") || this.m_sval.equals("$SPLINESEGS") || this.m_sval.equals("$SPLINETYPE") || this.m_sval.equals("$SURFTAB1") || this.m_sval.equals("$SURFTAB2") || this.m_sval.equals("$SURFTYPE") || this.m_sval.equals("$SURFU") || this.m_sval.equals("$SURFV") || this.m_sval.equals("$TDCREATE") || this.m_sval.equals("$TDINDWG") || this.m_sval.equals("$TDUPDATE") || this.m_sval.equals("$TDUSRTIMER") || this.m_sval.equals("$TEXTSIZE") || this.m_sval.equals("$TEXTSTYLE") || this.m_sval.equals("$THICKNESS") || this.m_sval.equals("$TILEMODE") || this.m_sval.equals("$TRACEWID") || this.m_sval.equals("$UCSNAME") || this.m_sval.equals("$UCSORG") || this.m_sval.equals("$UCSXDIR") || this.m_sval.equals("$UCSYDIR") || this.m_sval.equals("$UNITMODE") || this.m_sval.equals("$USERI1 - 5") || this.m_sval.equals("$USERR1 - 5") || this.m_sval.equals("$USRTIMER") || this.m_sval.equals("$VISRETAIN") || this.m_sval.equals("$WORLDVIEW"))) {
                                    throw new IOException("unexpected group=" + this.m_sval + " at line=" + this.m_lineNo);
                                }
                            }
                        }
                        var5_5 = this.parseGroup(var1_1);
                    }
                }
                if (this.m_sval.equals("TABLES")) {
                    var5_5 = this.parseGroup(var1_1);
                    while (true) {
                        if (var5_5 == 0 && this.m_sval.equals("ENDSEC")) continue block3;
                        var5_5 = this.parseGroup(var1_1);
                    }
                }
                if (this.m_sval.equals("BLOCKS")) {
                    var5_5 = this.parseGroup(var1_1);
                    while (true) {
                        if (var5_5 == 0 && this.m_sval.equals("ENDSEC")) continue block3;
                        var5_5 = this.parseGroup(var1_1);
                    }
                }
                if (!this.m_sval.equals("ENTITIES")) break;
                var7_9 = 0;
                var8_10 = new double[4][3];
                var9_11 = -1;
                var10_12 = -1;
                var5_5 = this.parseGroup(var1_1);
                var11_13 = new PiVector(10);
                var12_14 = var11_13.getEntries();
                var13_15 = new PiVector(10);
                var14_16 = var13_15.getEntries();
                var11_13.setConstant(0);
                var13_15.setConstant(0);
                var15_17 = 0;
                var16_18 = 0;
                var17_19 = 0;
                var18_20 = 0;
                while (true) {
                    if (var5_5 != 0) ** GOTO lbl251
                    if (var9_11 != -1) {
                        if (var9_11 != 100 && var9_11 != 101 && var9_11 != 102 && var9_11 != 103 && var9_11 != 104 && var9_11 != 105 && var9_11 != 106 && var9_11 != 107 && var9_11 != 108 && var9_11 != 109 && var9_11 != 110 && var9_11 != 111 && var9_11 != 112) {
                            if (var9_11 == 113) {
                                if ((var14_16[0] & 64) != 0) {
                                    var17_19 = var14_16[1];
                                    var18_20 = var14_16[2];
                                }
                            } else if (var9_11 == 114) {
                                if (var10_12 == 113) {
                                    if ((var14_16[0] & 128) != 0) {
                                        if ((var14_16[0] & 64) != 0) {
                                            var19_21 = new PdVector(var8_10[0]);
                                            this.m_vVertex.addElement(var19_21);
                                            ++this.m_numVertices;
                                            ++var15_17;
                                        } else {
                                            var19_21 = new PiVector();
                                            if (var14_16[4] == 0) {
                                                var19_21.setSize(3);
                                                var19_21.set(Math.abs(var14_16[1]) - 1, Math.abs(var14_16[2]) - 1, Math.abs(var14_16[3]) - 1);
                                            } else {
                                                var19_21.setSize(4);
                                                var19_21.set(Math.abs(var14_16[1]) - 1, Math.abs(var14_16[2]) - 1, Math.abs(var14_16[3]) - 1, Math.abs(var14_16[4]) - 1);
                                            }
                                            this.m_vElement.addElement(var19_21);
                                            ++this.m_numElements;
                                            ++var16_18;
                                        }
                                    }
                                } else {
                                    if (var7_9 != 1) {
                                        throw new IOException("missing vertex, nov = " + var7_9);
                                    }
                                    var19_21 = new PdVector(var8_10[0]);
                                    this.m_vVertex.addElement(var19_21);
                                    ++this.m_numVertices;
                                }
                            } else if (var9_11 == 115) {
                                if (var10_12 == 113) {
                                    if (var15_17 != var17_19) {
                                        PsDebug.warning("unexpected number of vertices in polymesh: (expected/found)=(" + var17_19 + "/" + var15_17);
                                    }
                                    if (var16_18 != var18_20) {
                                        PsDebug.warning("unexpected number of vertices in polymesh: (expected/found)=(" + var18_20 + "/" + var16_18);
                                    }
                                    var15_17 = 0;
                                    var16_18 = 0;
                                    var17_19 = 0;
                                    var18_20 = 0;
                                }
                                var10_12 = -1;
                            } else if (var9_11 == 116) {
                                if (var7_9 != 4) {
                                    throw new IOException("missing vertex, nov = " + var7_9);
                                }
                                var6_6 = 0;
                                do {
                                    var19_21 = new PdVector(var8_10[var6_6]);
                                    this.m_vVertex.addElement(var19_21);
                                } while (++var6_6 < 4);
                                var19_21 = new PiVector(var7_9);
                                var19_21.set(this.m_numVertices, this.m_numVertices + 1, this.m_numVertices + 2, this.m_numVertices + 3);
                                this.m_vElement.addElement(var19_21);
                                this.m_numVertices += 4;
                                ++this.m_numElements;
                                if (var14_16[0] != 0) {
                                    // empty if block
                                }
                            } else if (var9_11 == 117 || var9_11 == 118 || var9_11 == 119 || var9_11 == 120 || var9_11 == 120 || var9_11 == 121 || var9_11 == 122 || var9_11 != 123) {
                                // empty if block
                            }
                        }
                        var9_11 = -1;
                        var11_13.setConstant(0);
                        var13_15.setConstant(0);
                    }
                    if (!this.m_sval.equals("ENDSEC")) ** break;
                    continue block3;
                    var7_9 = 0;
                    if (this.m_sval.equals("POINT")) {
                        var9_11 = 100;
                    } else if (this.m_sval.equals("POINT")) {
                        var9_11 = 101;
                    } else if (this.m_sval.equals("CIRCLE")) {
                        var9_11 = 102;
                    } else if (this.m_sval.equals("ARC")) {
                        var9_11 = 103;
                    } else if (this.m_sval.equals("TRACE")) {
                        var9_11 = 104;
                    } else if (this.m_sval.equals("SOLID")) {
                        var9_11 = 105;
                    } else if (this.m_sval.equals("TEXT")) {
                        var9_11 = 106;
                    } else if (this.m_sval.equals("SHAPE")) {
                        var9_11 = 107;
                    } else if (this.m_sval.equals("BLOCK")) {
                        var9_11 = 108;
                    } else if (this.m_sval.equals("ENDBLK")) {
                        var9_11 = 109;
                    } else if (this.m_sval.equals("INSERT")) {
                        var9_11 = 110;
                    } else if (this.m_sval.equals("ATTDEF")) {
                        var9_11 = 111;
                    } else if (this.m_sval.equals("ATTRIB")) {
                        var9_11 = 112;
                    } else if (this.m_sval.equals("POLYLINE")) {
                        var10_12 = 113;
                        var9_11 = 113;
                    } else if (this.m_sval.equals("VERTEX")) {
                        var9_11 = 114;
                    } else if (this.m_sval.equals("SEQEND")) {
                        var9_11 = 115;
                    } else if (this.m_sval.equals("3DFACE")) {
                        var9_11 = 116;
                    } else if (this.m_sval.equals("VIEWPORT")) {
                        var9_11 = 117;
                    } else if (this.m_sval.equals("DIMENSION")) {
                        var9_11 = 118;
                    } else if (this.m_sval.equals("LINEAR")) {
                        var9_11 = 119;
                    } else if (this.m_sval.equals("ANGULAR")) {
                        var9_11 = 120;
                    } else if (this.m_sval.equals("ANGULAR")) {
                        var9_11 = 120;
                    } else if (this.m_sval.equals("DIAMETER")) {
                        var9_11 = 121;
                    } else if (this.m_sval.equals("RADIUS")) {
                        var9_11 = 122;
                    } else if (this.m_sval.equals("ORDINATE")) {
                        var9_11 = 123;
                    } else {
                        throw new IOException("unexpected group=" + this.m_sval + " at line=" + this.m_lineNo);
lbl251:
                        // 1 sources

                        if (var5_5 != 5 && var5_5 != 6 && var5_5 != 8) {
                            if (var5_5 == 10) {
                                var8_10[var7_9][0] = this.m_dval;
                                var5_5 = this.parseGroup(var1_1);
                                if (var5_5 != 20) {
                                    throw new IOException("missing y component of vertex");
                                }
                                var8_10[var7_9][1] = this.m_dval;
                                var5_5 = this.parseGroup(var1_1);
                                if (var5_5 != 30) {
                                    throw new IOException("missing z component of vertex");
                                }
                                var8_10[var7_9][2] = this.m_dval;
                                ++var7_9;
                            } else if (var5_5 == 11) {
                                var8_10[var7_9][0] = this.m_dval;
                                var5_5 = this.parseGroup(var1_1);
                                if (var5_5 != 21) {
                                    throw new IOException("missing y component of vertex");
                                }
                                var8_10[var7_9][1] = this.m_dval;
                                var5_5 = this.parseGroup(var1_1);
                                if (var5_5 != 31) {
                                    throw new IOException("missing z component of vertex");
                                }
                                var8_10[var7_9][2] = this.m_dval;
                                ++var7_9;
                            } else if (var5_5 == 12) {
                                var8_10[var7_9][0] = this.m_dval;
                                var5_5 = this.parseGroup(var1_1);
                                if (var5_5 != 22) {
                                    throw new IOException("missing y component of vertex");
                                }
                                var8_10[var7_9][1] = this.m_dval;
                                var5_5 = this.parseGroup(var1_1);
                                if (var5_5 != 32) {
                                    throw new IOException("missing z component of vertex");
                                }
                                var8_10[var7_9][2] = this.m_dval;
                                ++var7_9;
                            } else if (var5_5 == 13) {
                                var8_10[var7_9][0] = this.m_dval;
                                var5_5 = this.parseGroup(var1_1);
                                if (var5_5 != 23) {
                                    throw new IOException("missing y component of vertex");
                                }
                                var8_10[var7_9][1] = this.m_dval;
                                var5_5 = this.parseGroup(var1_1);
                                if (var5_5 != 33) {
                                    throw new IOException("missing z component of vertex");
                                }
                                var8_10[var7_9][2] = this.m_dval;
                                ++var7_9;
                            } else if (var5_5 != 38 && var5_5 != 39) {
                                if (60 <= var5_5 && var5_5 <= 69) {
                                    var12_14[var5_5 % 10] = this.m_ival;
                                } else if (70 <= var5_5 && var5_5 <= 79) {
                                    var14_16[var5_5 % 10] = this.m_ival;
                                } else if (var5_5 == 210 || var5_5 == 220 || var5_5 != 230) {
                                    // empty if block
                                }
                            }
                        }
                    }
                    var5_5 = this.parseGroup(var1_1);
                }
                break;
            }
            throw new IOException("unexpected group=" + this.m_sval + " at line=" + this.m_lineNo);
        }
        catch (NumberFormatException var6_7) {
            PsDebug.warning("IOException thrown in line=" + this.m_lineNo + ", Exception = " + var6_7);
            return false;
        }
        catch (IOException var6_8) {
            PsDebug.warning("IOException thrown in line=" + this.m_lineNo + ", Exception = " + var6_8);
            return false;
        }
    }

    private int parseInt(BufferedReader bufferedReader) throws IOException, NumberFormatException {
        String string = this.readLine(bufferedReader);
        if (string == null) {
            throw new NumberFormatException("Missing String");
        }
        return Integer.parseInt(string.trim());
    }

    private String parseString(BufferedReader bufferedReader) throws IOException {
        String string = this.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PgJvxSrc read(String string) {
        int n;
        Enumeration enumeration;
        Object object;
        PdVector[] pdVectorArray;
        int n2;
        PgJvxSrc pgJvxSrc;
        BufferedReader bufferedReader;
        block47: {
            PgJvxSrc pgJvxSrc2;
            bufferedReader = PsUtil.open(string);
            if (bufferedReader == null) {
                PsDebug.warning("could not open = " + string);
                return null;
            }
            pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setName(PsUtil.getFileBaseName(string));
            try {
                try {
                    n2 = this.parse(bufferedReader);
                    if (n2 != 0) break block47;
                    PsDebug.warning("error when reading file = " + string);
                    pgJvxSrc2 = null;
                    Object var12_9 = null;
                }
                catch (IOException iOException) {
                    PsDebug.warning("error when reading file = " + string);
                    iOException.printStackTrace();
                    PgJvxSrc pgJvxSrc3 = null;
                    Object var12_10 = null;
                    try {
                        bufferedReader.close();
                        return pgJvxSrc3;
                    }
                    catch (IOException iOException2) {}
                    return pgJvxSrc3;
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {}
                catch (IOException iOException) {}
                bufferedReader.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedReader.close();
            return pgJvxSrc2;
        }
        Object var12_11 = null;
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        if (this.m_numMeshType > 0 && this.m_meshType[0] == 1) {
            switch (this.m_meshType[1]) {
                case 1: {
                    pgJvxSrc.setType(32);
                    break;
                }
                case 2: {
                    pgJvxSrc.setType(33);
                    break;
                }
                case 3: {
                    pgJvxSrc.setType(34);
                    break;
                }
                default: {
                    pgJvxSrc.setType(30);
                    break;
                }
            }
        } else if (this.m_numElements > 0) {
            pgJvxSrc.setType(33);
        } else if (this.m_numPolygons > 0) {
            pgJvxSrc.setType(32);
        } else {
            pgJvxSrc.setType(30);
        }
        if (this.m_numVertices > 0) {
            pdVectorArray = (PdVector[])this.m_vVertex.elementAt(0);
            pgJvxSrc.setDimOfVertices(pdVectorArray.getSize());
            pgJvxSrc.setNumVertices(this.m_numVertices);
            object = pgJvxSrc.getVertices();
            n2 = 0;
            enumeration = this.m_vVertex.elements();
            while (enumeration.hasMoreElements()) {
                ((PdVector)object[n2++]).copy((PdVector)enumeration.nextElement());
            }
        }
        if (this.m_numVertexNormals > 0) {
            if (this.m_numVertexNormals == this.m_numVertices) {
                pgJvxSrc.assureVertexNormals();
                pdVectorArray = pgJvxSrc.getVertexNormals();
                n2 = 0;
                object = this.m_vVertexNormal.elements();
                while (object.hasMoreElements()) {
                    pdVectorArray[n2++].copy((PdVector)object.nextElement());
                }
            } else {
                PsDebug.warning("0!=numVertexNormals != numVertices");
            }
        }
        if (this.m_numVertexTextures > 0) {
            if (this.m_numVertexTextures == this.m_numVertices) {
                pgJvxSrc.assureVertexTextures();
                pdVectorArray = pgJvxSrc.getVertexTextures();
                n2 = 0;
                object = this.m_vVertexTexture.elements();
                while (object.hasMoreElements()) {
                    pdVectorArray[n2++].copy((PdVector)object.nextElement());
                }
            } else {
                PsDebug.warning("0!=numVertexTextures != numVertices");
            }
        }
        if (this.m_numVertexVectors > 0) {
            if (this.m_numVertexVectors % this.m_numVertices == 0) {
                int n3 = this.m_numVertexVectors / this.m_numVertices;
                pgJvxSrc.setNumVectorFields(n3);
                object = this.m_vVertexVector.elements();
                int n4 = 0;
                block17: while (n4 < n3) {
                    PdVector pdVector = (PdVector)this.m_vVertexVector.elementAt(n4 * this.m_numVertices);
                    pgJvxSrc.setNumVectors(n4, this.m_numVertices, pdVector.getSize());
                    PdVector[] pdVectorArray2 = pgJvxSrc.getVectors(n4);
                    n2 = 0;
                    n = 0;
                    while (true) {
                        if (n >= this.m_numVertices) {
                            ++n4;
                            continue block17;
                        }
                        pdVectorArray2[n2++] = (PdVector)object.nextElement();
                        ++n;
                    }
                }
            } else {
                PsDebug.warning("numVertexVectors%numVertices!=0");
            }
        }
        if (this.m_numElements > 0) {
            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
            pgJvxSrc.setNumElements(this.m_numElements);
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            n2 = 0;
            object = this.m_vElement.elements();
            while (object.hasMoreElements()) {
                piVectorArray[n2++].copy((PiVector)object.nextElement());
            }
        }
        if (this.m_numPolygons > 0) {
            pgJvxSrc.setDimOfPolygons(this.m_dimOfPolygons);
            pgJvxSrc.setNumPolygons(this.m_numPolygons);
            PiVector[] piVectorArray = pgJvxSrc.getPolygons();
            n2 = 0;
            object = this.m_vPolygon.elements();
            while (object.hasMoreElements()) {
                piVectorArray[n2++].copy((PiVector)object.nextElement());
            }
        }
        if (this.m_vPolygonColor != null && this.m_vPolygonColor.size() > 0) {
            pgJvxSrc.assurePolygonColors();
            Color[] colorArray = pgJvxSrc.getPolygonColors();
            n2 = 0;
            object = (Color)this.m_vPolygonColor.firstElement();
            n = 0;
            while (true) {
                if (n >= this.m_vPolygonColorInd.getEntry(0)) {
                    enumeration = this.m_vPolygonColor.elements();
                    break;
                }
                colorArray[n] = object;
                ++n;
            }
            block22: while (enumeration.hasMoreElements()) {
                object = (Color)enumeration.nextElement();
                n = this.m_vPolygonColorInd.getEntry(n2);
                while (true) {
                    if (n >= this.m_vPolygonColorInd.getEntry(n2 + 1)) {
                        ++n2;
                        continue block22;
                    }
                    colorArray[n] = object;
                    ++n;
                }
            }
        }
        PgDxfLoader.geomInitType(pgJvxSrc);
        return pgJvxSrc;
    }

    protected static String writePdVectors(String string, String string2, int n, PdVector[] pdVectorArray) {
        if (n <= 0 && pdVectorArray == null && n > pdVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# " + string + " List\n");
        stringBuffer.append("# Number of " + string + "s = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string2 + " ");
            if (pdVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < pdVectorArray[n2].m_data.length) {
                if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                    stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                } else {
                    stringBuffer.append(0.0f);
                }
                if (n3 < pdVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        ++this.m_lineNo;
        return bufferedReader.readLine();
    }

    public static String write(PgJvxSrc pgJvxSrc) {
        String string;
        int n;
        if (pgJvxSrc == null) {
            PsDebug.warning("missing geometry");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("# Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + StrNL);
        stringBuffer.append("# File Format = Wavefront OBJ\n");
        stringBuffer.append("# Geometry = " + pgJvxSrc.getName() + StrNL);
        stringBuffer.append("# Date = " + new Date().toString() + "\n#\n");
        int n2 = pgJvxSrc.getNumVertices();
        stringBuffer.append("# Number of Vertices = " + n2 + StrNL);
        int n3 = pgJvxSrc.getNumElements();
        if (n3 > 0) {
            stringBuffer.append("# Number of Elements = " + n3 + StrNL);
        }
        if ((n = pgJvxSrc.getNumPolygons()) > 0) {
            stringBuffer.append("# Number of Polygons = " + n + StrNL);
        }
        if (pgJvxSrc.getVertexNormals() != null) {
            stringBuffer.append("# Additional: Vertex Normals\n");
        }
        if (pgJvxSrc.getVertexTextures() != null) {
            stringBuffer.append("# Additional: Vertex Texture Coordinates\n");
        }
        stringBuffer.append("#\n# End of Header\n");
        stringBuffer.append(PgDxfLoader.writePdVectors("Vertex", "v", n2, pgJvxSrc.getVertices()));
        m_bVertexNormals = false;
        if (pgJvxSrc.getVertexNormals() != null && (string = PgDxfLoader.writePdVectors("Vertex Normal", "vn", n2, pgJvxSrc.getVertexNormals())) != null) {
            stringBuffer.append(string);
            m_bVertexNormals = true;
        }
        m_bVertexTextures = false;
        if (pgJvxSrc.getVertexTextures() != null && (string = PgDxfLoader.writePdVectors("Vertex Texture", "vt", n2, pgJvxSrc.getVertexTextures())) != null) {
            stringBuffer.append(string);
            m_bVertexTextures = true;
        }
        m_bElements = false;
        if (pgJvxSrc.getElements() != null && (string = PgDxfLoader.writeElements(n3, pgJvxSrc.getElements())) != null) {
            stringBuffer.append(string);
            m_bElements = true;
        }
        m_bPolygonNormals = false;
        if (pgJvxSrc.getPolygonNormals() != null && (string = PgDxfLoader.writePdVectors("Polygon Normal", "ln", n, pgJvxSrc.getPolygonNormals())) != null) {
            stringBuffer.append(string);
            m_bPolygonNormals = true;
        }
        m_bPolygons = false;
        if (pgJvxSrc.getPolygons() != null && (string = PgDxfLoader.writePolygons(n, pgJvxSrc.getPolygons())) != null) {
            stringBuffer.append(string);
            m_bPolygons = true;
        }
        return stringBuffer.toString();
    }

    private int parseCode(BufferedReader bufferedReader) throws IOException, NumberFormatException {
        return this.parseInt(bufferedReader);
    }

    private double parseDouble(BufferedReader bufferedReader) throws IOException, NumberFormatException {
        String string = this.readLine(bufferedReader);
        if (string == null) {
            throw new NumberFormatException("Missing String");
        }
        return Double.valueOf(string.trim());
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    private int parseGroup(BufferedReader bufferedReader) throws IOException, NumberFormatException {
        while ((this.m_code = this.parseCode(bufferedReader)) == 999) {
            this.readLine(bufferedReader);
        }
        this.m_sval = null;
        this.m_ival = 0;
        this.m_dval = 0.0;
        if (this.m_code >= 0 && this.m_code <= 9) {
            this.m_sval = this.parseString(bufferedReader);
        } else if (10 <= this.m_code && this.m_code <= 59) {
            this.m_dval = this.parseDouble(bufferedReader);
        } else if (60 <= this.m_code && this.m_code <= 79) {
            this.m_ival = this.parseInt(bufferedReader);
        } else if (140 <= this.m_code && this.m_code <= 147) {
            this.m_dval = this.parseDouble(bufferedReader);
        } else if (170 <= this.m_code && this.m_code <= 175) {
            this.m_ival = this.parseInt(bufferedReader);
        } else if (210 <= this.m_code && this.m_code <= 239) {
            this.m_dval = this.parseDouble(bufferedReader);
        } else if (999 == this.m_code) {
            this.m_sval = this.parseString(bufferedReader);
        } else if (1010 <= this.m_code && this.m_code <= 1059) {
            this.m_dval = this.parseDouble(bufferedReader);
        } else if (1060 <= this.m_code && this.m_code <= 1079) {
            this.m_ival = this.parseInt(bufferedReader);
        } else if (1000 <= this.m_code && this.m_code <= 1009) {
            this.m_sval = this.parseString(bufferedReader);
        } else {
            throw new IOException("group code out of range");
        }
        return this.m_code;
    }

    private double[] parseCoords(BufferedReader bufferedReader) throws IOException, NumberFormatException {
        double[] dArray = new double[3];
        int n = 0;
        do {
            int n2;
            if ((n2 = this.parseGroup(bufferedReader)) != (n + 1) * 10) {
                throw new IOException("missing coordinate component");
            }
            dArray[n] = this.m_dval;
        } while (++n < 3);
        return dArray;
    }

    protected static String writeElements(int n, PiVector[] piVectorArray) {
        if (n <= 0 && piVectorArray == null && n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# Face List\n");
        stringBuffer.append("# Number of Faces = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("f ");
            if (piVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                int n4 = piVectorArray[n2].m_data[n3] + 1;
                stringBuffer.append(n4);
                if (m_bVertexNormals) {
                    stringBuffer.append("/" + n4);
                    if (m_bVertexTextures) {
                        stringBuffer.append("/" + n4);
                    }
                } else if (!m_bVertexNormals && m_bVertexTextures) {
                    stringBuffer.append("//" + n4);
                }
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

