/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgFeLoader {
    private static final int MESH_EDGE = 1;
    private static final int MESH_SIMPLEX = 2;
    private static final int ITEM_MODE_NONE = 1;
    private static final int ITEM_MODE_VERTEX = 2;
    private static final int ITEM_MODE_EDGE = 3;
    private static final int ITEM_MODE_FACE = 4;
    private static final int ITEM_MODE_BODY = 5;
    protected int m_meshType;
    protected int m_meshRepresentation;
    protected int m_dimOfVertices = -1;
    protected int m_numVertices = 0;
    protected Vector m_vVertex;
    protected int m_numEdges = 0;
    protected Vector m_vEdge;
    protected int m_dimOfElements = -1;
    protected int m_numElements = 0;
    protected Vector m_vElement;
    protected int m_numTetras = 0;
    protected Vector m_vTetra;
    protected boolean m_bLinear = false;
    protected double m_scale = 1.0;
    protected double m_totalTime = -1.0;
    protected PdMatrix m_viewMat = null;

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parse(BufferedReader var1_1, PgJvxSrc var2_2) throws IOException {
        var3_3 = 4;
        var4_4 = 200;
        var5_5 = new double[var3_3];
        var6_6 = new int[var4_4];
        this.m_vVertex = new Vector<E>();
        this.m_vEdge = new Vector<E>();
        this.m_vElement = new Vector<E>();
        this.m_vTetra = new Vector<E>();
        this.m_dimOfVertices = 3;
        this.m_meshType = 33;
        this.m_meshRepresentation = 1;
        this.m_numVertices = 0;
        this.m_numEdges = 0;
        this.m_numElements = 0;
        this.m_numTetras = 0;
        var10_7 = 0;
        var11_8 = 0;
        var12_9 = 0;
        var13_10 = 0;
        var14_11 = null;
        var15_12 = false;
        var16_13 = 1;
        var17_14 = new StreamTokenizer(var1_1);
        var17_14.eolIsSignificant(true);
        var17_14.wordChars(95, 95);
        var17_14.commentChar(47);
        var17_14.commentChar(35);
        try {
            if (true) ** GOTO lbl280
        }
        catch (Exception var18_19) {
            PsDebug.warning("Exception thrown in line=" + var17_14.lineno() + ", Exception = " + var18_19);
            return false;
        }
        block19: do {
            var18_18 = var17_14.nextToken();
            cfr_temp_0 = 0;
            block20: do {
                block1 : switch (cfr_temp_0 == 0 ? var18_18 : cfr_temp_0) {
                    default: {
                        PsDebug.warning("parsing broke abnormally in line=" + var17_14.lineno() + " reading st.sval=" + var17_14.sval + ", st.ttype=" + var17_14.ttype);
                        cfr_temp_0 = 10;
                        continue block20;
                    }
                    case -3: {
                        if ("SIMPLEX_REPRESENTATION".equalsIgnoreCase(var17_14.sval)) {
                            this.m_meshRepresentation = 2;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("SPACE_DIMENSION".equalsIgnoreCase(var17_14.sval)) {
                            cfr_temp_0 = 10;
                            if (var17_14.nextToken() != -2) continue block20;
                            this.m_dimOfVertices = (int)var17_14.nval;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("SURFACE_DIMENSION".equalsIgnoreCase(var17_14.sval)) {
                            cfr_temp_0 = 10;
                            if (var17_14.nextToken() != -2) continue block20;
                            switch ((int)var17_14.nval) {
                                case 3: {
                                    this.m_meshType = 34;
                                    this.m_dimOfElements = 4;
                                    break;
                                }
                                case 2: {
                                    this.m_meshType = 33;
                                    this.m_dimOfElements = 3;
                                    break;
                                }
                                case 1: {
                                    this.m_meshType = 32;
                                    break;
                                }
                                default: {
                                    this.m_meshType = 30;
                                    break;
                                }
                            }
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("STRING".equalsIgnoreCase(var17_14.sval)) {
                            this.m_meshType = 32;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("SOAPFILM".equalsIgnoreCase(var17_14.sval)) {
                            this.m_meshType = 33;
                            cfr_temp_0 = 10;
                            if (this.m_meshRepresentation != 2) continue block20;
                            this.m_dimOfElements = 3;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("fixed".equalsIgnoreCase(var17_14.sval) && var14_11 != null) {
                            var14_11.setTag(3);
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("vertices".equalsIgnoreCase(var17_14.sval)) {
                            var16_13 = 2;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("edges".equalsIgnoreCase(var17_14.sval)) {
                            var16_13 = 3;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("faces".equalsIgnoreCase(var17_14.sval)) {
                            var16_13 = 4;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("bodies".equalsIgnoreCase(var17_14.sval)) {
                            var16_13 = 5;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("boundary".equalsIgnoreCase(var17_14.sval)) {
                            cfr_temp_0 = 10;
                            if (var17_14.nextToken() != -2) continue block20;
                            var10_7 = (int)var17_14.nval - 1;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("read".equalsIgnoreCase(var17_14.sval)) {
                            return true;
                        }
                        if ("tension".equalsIgnoreCase(var17_14.sval)) {
                            cfr_temp_0 = 10;
                            if (var17_14.nextToken() != -2) continue block20;
                            var10_7 = (int)var17_14.nval - 1;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if ("wrap".equalsIgnoreCase(var17_14.sval)) {
                            cfr_temp_0 = 10;
                            if (var17_14.nextToken() != -2) continue block20;
                            var10_7 = (int)var17_14.nval - 1;
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        cfr_temp_0 = 10;
                        if ("bare".equalsIgnoreCase(var17_14.sval)) continue block20;
                        if ("nodisplay".equalsIgnoreCase(var17_14.sval)) {
                            var14_11.setTag(14);
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        if (!"constraints".equalsIgnoreCase(var17_14.sval)) {
                            if ("volume".equalsIgnoreCase(var17_14.sval)) {
                                cfr_temp_0 = 10;
                                if (var17_14.nextToken() != -2) continue block20;
                                PgLoader.parseDouble(var17_14);
                                cfr_temp_0 = 10;
                                continue block20;
                            }
                            if ("area".equalsIgnoreCase(var17_14.sval)) {
                                cfr_temp_0 = 10;
                                if (var17_14.nextToken() != -2) continue block20;
                                PgLoader.parseDouble(var17_14);
                                cfr_temp_0 = 10;
                                continue block20;
                            }
                            if ("length".equalsIgnoreCase(var17_14.sval)) {
                                cfr_temp_0 = 10;
                                if (var17_14.nextToken() != -2) continue block20;
                                PgLoader.parseDouble(var17_14);
                                cfr_temp_0 = 10;
                                continue block20;
                            }
                            if ("LINEAR".equalsIgnoreCase(var17_14.sval)) {
                                this.m_bLinear = true;
                                cfr_temp_0 = 10;
                                continue block20;
                            }
                            if ("SCALE".equalsIgnoreCase(var17_14.sval)) {
                                cfr_temp_0 = 10;
                                if (var17_14.nextToken() != -2) continue block20;
                                this.m_scale = PgLoader.parseDouble(var17_14);
                                cfr_temp_0 = 10;
                                continue block20;
                            }
                            if ("TOTAL_TIME".equalsIgnoreCase(var17_14.sval)) {
                                cfr_temp_0 = 10;
                                if (var17_14.nextToken() != -2) continue block20;
                                this.m_totalTime = PgLoader.parseDouble(var17_14);
                                cfr_temp_0 = 10;
                                continue block20;
                            }
                            if ("VIEW_MATRIX".equalsIgnoreCase(var17_14.sval)) {
                                this.m_viewMat = new PdMatrix(4);
                                var7_15 = 0;
                                do {
                                    var8_16 = 0;
                                    do {
                                        var17_14.nextToken();
                                        this.m_viewMat.setEntry(var7_15, var8_16, PgLoader.parseDouble(var17_14));
                                    } while (++var8_16 < 4);
                                } while (++var7_15 < 4);
                                cfr_temp_0 = 10;
                                continue block20;
                            }
                            PsDebug.warning("unknown expression = " + var17_14.sval);
                            cfr_temp_0 = 10;
                            continue block20;
                        }
                        ** GOTO lbl274
                    }
                    case -2: {
                        var10_7 = (int)var17_14.nval - 1;
                        switch (var16_13) {
                            case 2: {
                                var9_17 = 0;
                                var7_15 = 0;
                                while (true) {
                                    if (var7_15 >= this.m_dimOfVertices) {
                                        if (var9_17 != this.m_dimOfVertices) break;
                                        ++this.m_numVertices;
                                        var19_20 = new PdVector(this.m_dimOfVertices);
                                        var19_20.copy(var5_5, this.m_dimOfVertices);
                                        if (this.m_vVertex.size() < var10_7 + 1) {
                                            this.m_vVertex.setSize(Math.max(var10_7 + 1, 2 * this.m_vVertex.size()));
                                        }
                                        var11_8 = Math.max(var11_8, var10_7);
                                        this.m_vVertex.setElementAt(var19_20, var10_7);
                                        var14_11 = var19_20;
                                        break block1;
                                    }
                                    var17_14.nextToken();
                                    var5_5[var7_15] = PgLoader.parseDouble(var17_14);
                                    ++var9_17;
                                    ++var7_15;
                                }
                                var14_11 = null;
                                PsDebug.warning("vertex with no coords in line=" + var17_14.lineno());
                                break block1;
                            }
                            case 3: {
                                var19_21 = -1;
                                var20_22 = -1;
                                if (var17_14.nextToken() == -2) {
                                    var19_21 = (int)var17_14.nval - 1;
                                }
                                if (var17_14.nextToken() == -2) {
                                    var20_22 = (int)var17_14.nval - 1;
                                }
                                if (var19_21 == -1 || var20_22 == -1) {
                                    PsDebug.warning("edge with void vertex index in line=" + var17_14.lineno());
                                    break block1;
                                }
                                ++this.m_numEdges;
                                var9_17 = 2;
                                var21_23 = new PiVector(var19_21, var20_22);
                                this.m_vEdge.addElement(var21_23);
                                if (this.m_vEdge.size() < var10_7 + 1) {
                                    this.m_vEdge.setSize(Math.max(var10_7 + 1, 2 * this.m_vEdge.size()));
                                }
                                var12_9 = Math.max(var12_9, var10_7);
                                this.m_vEdge.setElementAt(var21_23, var10_7);
                                var14_11 = var21_23;
                                break block1;
                            }
                            case 4: {
                                var9_17 = 0;
                                while (true) {
                                    if (var17_14.nextToken() != -2) {
                                        var17_14.pushBack();
                                        if (var9_17 != 0) break;
                                        var14_11 = null;
                                        PsDebug.warning("element with missing vertex index in line=" + var17_14.lineno());
                                        return true;
                                    }
                                    var6_6[var9_17] = (int)var17_14.nval;
                                    if (this.m_meshRepresentation == 2) {
                                        v0 = var9_17;
                                        var6_6[v0] = var6_6[v0] + -1;
                                    }
                                    ++var9_17;
                                }
                                var22_24 = new PiVector(var9_17);
                                if (this.m_meshRepresentation != 1) ** GOTO lbl251
                                var7_15 = 0;
                                if (true) ** GOTO lbl286
lbl251:
                                // 1 sources

                                var22_24.copy(var6_6, var9_17);
lbl252:
                                // 2 sources

                                while (true) {
                                    if (this.m_vElement.size() < var10_7 + 1) {
                                        this.m_vElement.setSize(Math.max(var10_7 + 1, 2 * this.m_vElement.size()));
                                    }
                                    var13_10 = Math.max(var13_10, var10_7);
                                    this.m_vElement.setElementAt(var22_24, var10_7);
                                    var14_11 = var22_24;
                                    if (this.m_numElements == 0) {
                                        this.m_dimOfElements = var9_17;
                                    } else if (this.m_dimOfElements != var9_17) {
                                        this.m_dimOfElements = -1;
                                    }
                                    ++this.m_numElements;
                                    break block1;
                                    break;
                                }
                            }
                            default: {
                                PsDebug.warning("found number without being in mode, line=" + var17_14.lineno());
                            }
                            case 5: {
                                break;
                            }
                        }
                        cfr_temp_0 = 10;
                        continue block20;
                    }
                    case -1: {
                        return true;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var10_7 = (int)var17_14.nval - 1;
lbl274:
                        // 2 sources

                        ** while (var17_14.nextToken() == -2)
                    }
lbl275:
                    // 1 sources

                    cfr_temp_0 = 10;
                    var17_14.pushBack();
                    case 10: 
                }
                continue block19;
            } while (true);
lbl280:
            // 3 sources

        } while (!var15_12);
        return true;
        do {
            var21_23 = (PiVector)this.m_vEdge.elementAt(Math.abs(var6_6[var7_15]));
            var22_24.m_data[var7_15] = var6_6[var7_15] > 0 ? var21_23.m_data[0] - 1 : var21_23.m_data[1] - 1;
            ++var7_15;
lbl286:
            // 2 sources

        } while (var7_15 < var9_17);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PgJvxSrc read(String string) {
        Enumeration enumeration;
        P_Vector[] p_VectorArray;
        int n;
        PgJvxSrc pgJvxSrc;
        BufferedReader bufferedReader;
        block14: {
            PgJvxSrc pgJvxSrc2;
            bufferedReader = PsUtil.open(string);
            if (bufferedReader == null) {
                PsDebug.warning("could not open = " + string);
                return null;
            }
            pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setName(PsUtil.getFileBaseName(string));
            try {
                try {
                    n = this.parse(bufferedReader, pgJvxSrc);
                    if (n != 0) break block14;
                    PsDebug.warning("error when reading file = " + string);
                    pgJvxSrc2 = null;
                    Object var8_9 = null;
                }
                catch (IOException iOException) {
                    PsDebug.warning("error when reading file = " + string);
                    iOException.printStackTrace();
                    PgJvxSrc pgJvxSrc3 = null;
                    Object var8_10 = null;
                    try {
                        bufferedReader.close();
                        return pgJvxSrc3;
                    }
                    catch (IOException iOException2) {}
                    return pgJvxSrc3;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {}
                catch (IOException iOException) {}
                bufferedReader.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedReader.close();
            return pgJvxSrc2;
        }
        Object var8_11 = null;
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        pgJvxSrc.setType(this.m_meshType);
        if (this.m_numVertices > 0) {
            pgJvxSrc.setDimOfVertices(this.m_dimOfVertices);
            pgJvxSrc.setNumVertices(this.m_numVertices);
            p_VectorArray = pgJvxSrc.getVertices();
            n = 0;
            enumeration = this.m_vVertex.elements();
            while (n < this.m_numVertices && enumeration.hasMoreElements()) {
                ((PdVector)p_VectorArray[n++]).copy((PdVector)enumeration.nextElement());
            }
        }
        if (this.m_numElements > 0) {
            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
            pgJvxSrc.setNumElements(this.m_numElements);
            p_VectorArray = pgJvxSrc.getElements();
            n = 0;
            enumeration = this.m_vElement.elements();
            while (n < this.m_numElements && enumeration.hasMoreElements()) {
                ((PiVector)p_VectorArray[n++]).copy((PiVector)enumeration.nextElement());
            }
        }
        PgFeLoader.geomInitType(pgJvxSrc);
        return pgJvxSrc;
    }

    public static String write(PgJvxSrc pgJvxSrc) {
        if (pgJvxSrc == null) {
            PsDebug.warning("missing geometry");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("// Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + "\n");
        stringBuffer.append("//     File Format = Surface Evolver FE\n");
        stringBuffer.append("//     Geometry    = " + pgJvxSrc.getName() + "\n");
        stringBuffer.append("//     Date        = " + new Date().toString() + "\n//\n");
        int n = pgJvxSrc.getNumVertices();
        stringBuffer.append("//     Number of Vertices = " + n + "\n");
        int n2 = pgJvxSrc.getNumElements();
        if (n2 > 0) {
            stringBuffer.append("//     Number of Elements = " + n2 + "\n");
        }
        if (pgJvxSrc.getVertexNormals() != null) {
            stringBuffer.append("//     Additional: Vertex Normals\n");
        }
        stringBuffer.append("//\n// End of Header\n");
        int n3 = pgJvxSrc.getDimOfSimplex();
        if (n3 == 0 || n3 == 1) {
            stringBuffer.append("STRING\n");
        } else if (n3 == 2) {
            stringBuffer.append("SOAPFILM\n");
        } else if (n3 > 2) {
            stringBuffer.append("SURFACE_DIMENSION " + n3 + "\n");
        }
        stringBuffer.append("SPACE_DIMENSION " + pgJvxSrc.getDimOfVertices() + "\n");
        stringBuffer.append("SIMPLEX_REPRESENTATION\n");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        PiVector[] piVectorArray2 = pgJvxSrc.getNeighbours();
        if (piVectorArray2 != null) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = piVectorArray[n4].getSize();
                int n6 = 0;
                while (n6 < n5) {
                    if (piVectorArray2[n4].m_data[n6] < 0) {
                        pdVectorArray[piVectorArray[n4].m_data[(n6 + 1) % n5]].setTag(3);
                        pdVectorArray[piVectorArray[n4].m_data[(n6 + 2) % n5]].setTag(3);
                    }
                    ++n6;
                }
                ++n4;
            }
        }
        stringBuffer.append(PgFeLoader.writeVertices(n, pdVectorArray));
        stringBuffer.append(PgFeLoader.writeElements(n2, piVectorArray));
        return stringBuffer.toString();
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    protected static String writeVertices(int n, PdVector[] pdVectorArray) {
        if (n <= 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("vertices\n");
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2] == null) {
                PsDebug.error("missing vertex, ind = " + n2);
                return null;
            }
            stringBuffer.append(String.valueOf(n2 + 1));
            int n3 = 0;
            while (n3 < pdVectorArray[n2].m_data.length) {
                stringBuffer.append("   ");
                if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                    stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                } else {
                    stringBuffer.append(0.0f);
                }
                ++n3;
            }
            if (pdVectorArray[n2].hasTag(3)) {
                stringBuffer.append("  fixed\n");
            } else {
                stringBuffer.append("\n");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected static String writeElements(int n, PiVector[] piVectorArray) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("faces\n");
        int n2 = 0;
        while (n2 < n) {
            if (piVectorArray[n2] == null) {
                PsDebug.warning("missing element, ind = " + n2);
                return null;
            }
            stringBuffer.append(String.valueOf(n2 + 1));
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                stringBuffer.append("  " + String.valueOf(piVectorArray[n2].m_data[n3] + 1));
                ++n3;
            }
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

