/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.util.BitSet;
import jv.geom.PgBndConstraint;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgMacroPatch
extends PsObject {
    protected PiVector[] m_vertexType;
    protected PdVector[] m_vertex;
    protected PiVector m_element;
    protected BitSet[] m_bndShapeBits;
    protected PiVector[] m_bndShape;
    protected int m_dim;
    protected int m_bndType;
    protected int m_orientation;
    protected int m_numULines;
    protected int m_numVLines;
    protected int m_numUSubs;
    protected int m_numVSubs;
    private static /* synthetic */ Class class$jv$loader$PgMacroPatch;

    public void setOrientation(int n) {
        this.m_orientation = n;
    }

    public PgPolygon makePolygon(PgPolygon pgPolygon, int n) {
        if (n < 0 || this.getNumVertices() <= n) {
            PsDebug.error("PgBdLoader.makePolygon: polygon index=" + n + " out of range", this);
            return pgPolygon;
        }
        int n2 = this.m_element.getSize();
        int n3 = n2 == 4 && n % 2 == 1 ? this.m_numVLines : this.m_numULines;
        if (pgPolygon == null) {
            pgPolygon = new PgPolygon(this.m_dim);
        }
        pgPolygon.setNumVertices(n3);
        PdVector pdVector = this.m_vertex[this.m_element.m_data[n]];
        PdVector pdVector2 = this.m_vertex[this.m_element.m_data[(n + 1) % n2]];
        PiVector piVector = this.m_bndShape[n];
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        if (this.m_bndShapeBits[n].get(7)) {
            int n4 = 0;
            while (n4 < n3) {
                double d = (double)n4 / ((double)n3 - 1.0);
                pdVectorArray[n4].blend(1.0 - d, pdVector, d, pdVector2);
                ++n4;
            }
        } else if (this.m_bndShapeBits[n].get(8)) {
            PdVector pdVector3 = this.m_vertex[piVector.m_data[1]];
            PdVector pdVector4 = this.m_vertex[piVector.m_data[2]];
            int n5 = 0;
            while (n5 < n3) {
                double d = (double)n5 / ((double)n3 - 1.0);
                PuVectorGeom.evalCircle(pdVectorArray[n5], pdVector3, pdVector4, pdVector, pdVector2, d);
                ++n5;
            }
        } else if (this.m_bndShapeBits[n].get(9)) {
            PdVector pdVector5 = this.m_vertex[piVector.m_data[1]];
            PdVector pdVector6 = this.m_vertex[piVector.m_data[2]];
            int n6 = 0;
            while (n6 < n3) {
                double d = (double)n6 / ((double)n3 - 1.0);
                PuVectorGeom.evalHelix(pdVectorArray[n6], pdVector5, pdVector6, pdVector, pdVector2, d);
                ++n6;
            }
        } else if (this.m_bndShapeBits[n].get(10)) {
            PsDebug.error("evalSpline not yet written, use line instead", this);
        } else {
            PsDebug.error("PgMacroPatch.makePolygon: unrecognized edge type", this);
        }
        return pgPolygon;
    }

    public int getNumVertices() {
        return this.m_element.getSize();
    }

    public void setNumVertices(int n) {
        this.m_element.setSize(n);
        this.m_bndShapeBits = new BitSet[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_bndShapeBits[n2] = new BitSet(32);
            ++n2;
        }
        this.m_bndShape = PiVector.realloc(this.m_bndShape, n, 3);
    }

    public PgMacroPatch(int n) {
        this.m_dim = n;
        if (this.getClass() == (class$jv$loader$PgMacroPatch != null ? class$jv$loader$PgMacroPatch : (class$jv$loader$PgMacroPatch = PgMacroPatch.class$("jv.loader.PgMacroPatch")))) {
            this.init();
        }
    }

    public PgElementSet buildElementSet(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            pgElementSet = new PgElementSet(3);
        }
        int n = this.getNumVertices();
        PgPolygon[] pgPolygonArray = new PgPolygon[n];
        int n2 = 0;
        while (n2 < n) {
            pgPolygonArray[n2] = new PgPolygon(this.m_dim);
            pgPolygonArray[n2] = this.makePolygon(pgPolygonArray[n2], n2);
            ++n2;
        }
        PgBndConstraint[] pgBndConstraintArray = new PgBndConstraint[n];
        int n3 = 0;
        while (n3 < n) {
            pgBndConstraintArray[n3] = new PgBndConstraint(this.m_dim);
            pgBndConstraintArray[n3] = this.makeBndConstraint(pgBndConstraintArray[n3], n3);
            ++n3;
        }
        switch (n) {
            case 3: {
                pgElementSet.buildTriangleFromCurve(pgPolygonArray, pgBndConstraintArray);
                break;
            }
            case 4: {
                pgElementSet.buildQuadrFromCurve(pgPolygonArray, pgBndConstraintArray);
                break;
            }
            default: {
                pgElementSet.buildPolygonFromCurve(pgPolygonArray);
            }
        }
        return pgElementSet;
    }

    public void setVertex(PdVector[] pdVectorArray) {
        this.m_vertex = pdVectorArray;
    }

    public int getBndType() {
        return this.m_bndType;
    }

    public void setBndType(int n) {
        this.m_bndType = n;
    }

    public PgBndConstraint makeBndConstraint(PgBndConstraint pgBndConstraint, int n) {
        if (n < 0 || this.getNumVertices() <= n) {
            PsDebug.error("PgBdLoader.makeBndConstraint: BndConstraint index=" + n + " out of range", this);
            return pgBndConstraint;
        }
        int n2 = this.m_element.getSize();
        if (pgBndConstraint == null) {
            pgBndConstraint = new PgBndConstraint(this.m_dim);
        }
        pgBndConstraint.m_start = this.m_vertex[this.m_element.m_data[n]];
        pgBndConstraint.m_end = this.m_vertex[this.m_element.m_data[(n + 1) % n2]];
        pgBndConstraint.setShape(this.m_bndShapeBits[n]);
        pgBndConstraint.m_vec1 = this.m_vertex[this.m_bndShape[n].m_data[1]];
        pgBndConstraint.m_vec2 = this.m_vertex[this.m_bndShape[n].m_data[2]];
        if (pgBndConstraint.m_startDir == null) {
            pgBndConstraint.m_startDir = new PdVector(this.m_dim);
        }
        pgBndConstraint.m_startDir.setConstant(0.0);
        if (pgBndConstraint.m_endDir == null) {
            pgBndConstraint.m_endDir = new PdVector(this.m_dim);
        }
        pgBndConstraint.m_endDir.setConstant(0.0);
        if (this.m_bndShapeBits[n].get(4)) {
            pgBndConstraint.m_dir = PdVector.subNew(pgBndConstraint.m_end, pgBndConstraint.m_start);
            pgBndConstraint.m_dir.normalize();
        } else if (this.m_bndShapeBits[n].get(5)) {
            PdVector pdVector;
            pgBndConstraint.m_dir = this.m_vertex[this.m_bndShape[n].m_data[2]];
            pgBndConstraint.m_dir.normalize();
            if (this.m_bndShapeBits[(n - 1 + n2) % n2].get(5)) {
                pdVector = this.m_vertex[this.m_bndShape[(n - 1 + n2) % n2].m_data[2]];
                pgBndConstraint.m_startDir = PdVector.crossNew(pgBndConstraint.m_dir, pdVector);
                pgBndConstraint.m_startDir.normalize();
            }
            if (this.m_bndShapeBits[(n + 1) % n2].get(5)) {
                pdVector = this.m_vertex[this.m_bndShape[(n + 1) % n2].m_data[2]];
                pgBndConstraint.m_endDir = PdVector.crossNew(pgBndConstraint.m_dir, pdVector);
                pgBndConstraint.m_endDir.normalize();
            }
        } else if (!this.m_bndShapeBits[n].get(11) && !this.m_bndShapeBits[n].get(12)) {
            if (this.m_bndShapeBits[n].get(3)) {
                pgBndConstraint.m_dir = new PdVector(this.m_dim);
                pgBndConstraint.m_dir.setConstant(0.0);
            } else {
                PsDebug.error("PgMacroPatch.makeBndConstraint: unrecognized edge type", this);
                pgBndConstraint.m_dir.setConstant(0.0);
            }
        }
        return pgBndConstraint;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setVertexType(PiVector[] piVectorArray) {
        this.m_vertexType = piVectorArray;
    }

    public void init() {
        super.init();
        this.m_orientation = 0;
        this.m_vertexType = null;
        this.m_vertex = null;
        this.m_element = new PiVector();
        this.m_bndShapeBits = null;
        this.m_bndShape = null;
    }

    public int getOrientation() {
        return this.m_orientation;
    }
}

