/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgMapleLoader {
    protected static boolean m_bAnimation;

    private static int[] parse2ArrayOfDoubles(StreamTokenizer streamTokenizer, Vector vector) {
        int n = 0;
        int n2 = 0;
        try {
            streamTokenizer.nextToken();
            while (streamTokenizer.ttype != 93) {
                streamTokenizer.nextToken();
                ++n2;
                int n3 = n;
                n = 0;
                while (streamTokenizer.ttype != 93) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected in line = " + streamTokenizer.lineno());
                        return null;
                    }
                    ++n;
                    Double d = new Double(PgLoader.parseDouble(streamTokenizer));
                    vector.addElement(d);
                    streamTokenizer.nextToken();
                }
                if (n2 > 1 && n3 != n) {
                    PsDebug.warning("numULines differ in line = " + streamTokenizer.lineno());
                    return null;
                }
                streamTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + ", line = " + streamTokenizer.lineno());
        }
        return new int[]{n, n2};
    }

    private static PdVector parsePoint(StreamTokenizer streamTokenizer, int n) {
        PdVector pdVector = new PdVector(n);
        try {
            streamTokenizer.nextToken();
            int n2 = 0;
            while (n2 < n) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning("Number expected in line = " + streamTokenizer.lineno());
                    return null;
                }
                pdVector.m_data[n2] = PgLoader.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
                ++n2;
            }
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + ", line = " + streamTokenizer.lineno());
            return null;
        }
        return pdVector;
    }

    public static PgJvxSrc[] read(String string) {
        m_bAnimation = false;
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        return PgMapleLoader.read(bufferedReader);
    }

    public static PgJvxSrc[] read(BufferedReader bufferedReader) {
        m_bAnimation = false;
        if (bufferedReader == null) {
            PsDebug.warning("BufferedReader == null");
            return null;
        }
        Vector vector = null;
        try {
            vector = PgMapleLoader.parseMaple(bufferedReader);
            if (vector == null || vector.size() == 0) {
                PsDebug.warning("Reading failed");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("Reading failed");
            iOException.printStackTrace();
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            pgJvxSrcArray[n] = (PgJvxSrc)enumeration.nextElement();
            switch (pgJvxSrcArray[n].getType()) {
                case 33: {
                    if (pgJvxSrcArray[n].getElementColors() == null) {
                        pgJvxSrcArray[n].makeElementColorsFromXYZ();
                    }
                    pgJvxSrcArray[n].showElementColors(true);
                }
            }
            PgMapleLoader.geomInitType(pgJvxSrcArray[n]);
            ++n;
        }
        return pgJvxSrcArray;
    }

    private static PdVector parsePoint(StreamTokenizer streamTokenizer) {
        int n = 10;
        int n2 = 0;
        PdVector pdVector = new PdVector(n);
        try {
            streamTokenizer.nextToken();
            while (streamTokenizer.ttype != 91) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning("Number expected in line = " + streamTokenizer.lineno());
                    return null;
                }
                if (n2 == n) {
                    pdVector.setSize(n *= 2);
                }
                pdVector.m_data[n2++] = PgLoader.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + ", line = " + streamTokenizer.lineno());
            return null;
        }
        pdVector.setSize(n2);
        return pdVector;
    }

    private static int[] parse2ArrayOfPoints(StreamTokenizer streamTokenizer, Vector vector, int n) {
        int n2 = 0;
        int n3 = 0;
        try {
            streamTokenizer.nextToken();
            while (streamTokenizer.ttype != 93) {
                streamTokenizer.nextToken();
                streamTokenizer.pushBack();
                if (streamTokenizer.ttype == 91) {
                    ++n3;
                    int n4 = n2;
                    n2 = 0;
                    streamTokenizer.nextToken();
                    while (streamTokenizer.ttype != 93) {
                        PdVector pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                        vector.addElement(pdVector);
                        ++n2;
                        streamTokenizer.nextToken();
                    }
                    if (n3 > 1 && n4 != n2) {
                        PsDebug.warning("numULines differ in line = " + streamTokenizer.lineno());
                        return null;
                    }
                } else {
                    PgMapleLoader.parseUnknown(streamTokenizer);
                }
                streamTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + ", line = " + streamTokenizer.lineno());
        }
        return new int[]{n2, n3};
    }

    public static String write(PgJvxSrc pgJvxSrc) {
        int n;
        String string;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        if (pgJvxSrc == null) {
            PsDebug.warning("missing geometry");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("# Produced with JavaView v." + PsConfig.getVersion() + "\n");
        stringBuffer.append("#    JavaView software by " + PsConfig.getAuthors() + "\n");
        stringBuffer.append("#    Info about JavaView at URL = " + PsConfig.getHomepage() + "\n");
        stringBuffer.append("#    File Format = Maple Graphics MPL\n");
        stringBuffer.append("#    Geometry    = " + pgJvxSrc.getName() + "\n");
        stringBuffer.append("#    Date        = " + new Date().toString() + "\n");
        int n6 = pgJvxSrc.getNumVertices();
        stringBuffer.append("#    Number of Vertices = " + n6 + "\n");
        int n7 = pgJvxSrc.getNumElements();
        if (n7 > 0) {
            stringBuffer.append("#    Number of Elements = " + n7 + "\n");
        }
        if ((n5 = pgJvxSrc.getNumPolygons()) > 0) {
            stringBuffer.append("#    Number of Polygons = " + n5 + "\n");
        }
        stringBuffer.append("# End of Header\n");
        if (pgJvxSrc.getDimOfVertices() == 3) {
            stringBuffer.append("PLOT3D(");
        } else {
            stringBuffer.append("PLOT(");
        }
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        String string2 = null;
        Color[] colorArray = null;
        stringBuffer.append("TITLE('`" + pgJvxSrc.getName() + "`')");
        if (n5 > 0) {
            stringBuffer.append(",\nCURVES(");
            object = pgJvxSrc.getPolygons();
            n4 = 0;
            while (n4 < n5) {
                if (n4 > 0) {
                    stringBuffer.append(",\n");
                }
                stringBuffer.append("[");
                n3 = object[n4].getSize();
                n2 = 0;
                while (n2 < n3) {
                    if (n2 > 0) {
                        stringBuffer.append(",");
                    }
                    string = PgMapleLoader.writeVertex(pdVectorArray[object[n4].m_data[n2]]);
                    stringBuffer.append(string);
                    ++n2;
                }
                stringBuffer.append("]");
                ++n4;
            }
            stringBuffer.append(",\n");
            if (pgJvxSrc.isShowingPolygonColors()) {
                colorArray = pgJvxSrc.getPolygonColors();
                stringBuffer.append("COLOR(RGB");
                n = 0;
                while (n < n5) {
                    stringBuffer.append(",\n" + String.valueOf((double)colorArray[n].getRed() / 255.0) + "," + String.valueOf((double)colorArray[n].getGreen() / 255.0) + "," + String.valueOf((double)colorArray[n].getBlue() / 255.0));
                    ++n;
                }
                stringBuffer.append(")");
            } else {
                string2 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalPolygonColor());
                stringBuffer.append(string2);
            }
            if (pgJvxSrc.getGlobalPolygonSize() > 1.0) {
                stringBuffer.append(",THICKNESS(" + (int)pgJvxSrc.getGlobalPolygonSize() + ")");
            }
            if (pgJvxSrc.isShowingPolygons()) {
                stringBuffer.append(",STYLE(PATCH)");
            } else {
                stringBuffer.append(",STYLE(POINT)");
            }
            stringBuffer.append(")");
        } else if (n7 > 0) {
            stringBuffer.append(",\nPOLYGONS(");
            object = pgJvxSrc.getElements();
            n4 = 0;
            while (n4 < n7) {
                if (n4 > 0) {
                    stringBuffer.append(",\n");
                }
                stringBuffer.append("[");
                n3 = object[n4].getSize();
                n2 = 0;
                while (n2 < n3) {
                    if (n2 > 0) {
                        stringBuffer.append(",");
                    }
                    string = PgMapleLoader.writeVertex(pdVectorArray[object[n4].m_data[n2]]);
                    stringBuffer.append(string);
                    ++n2;
                }
                stringBuffer.append("]");
                ++n4;
            }
            stringBuffer.append(",\n");
            if (pgJvxSrc.isShowingElementColors()) {
                colorArray = pgJvxSrc.getElementColors();
                stringBuffer.append("COLOR(RGB");
                n = 0;
                while (n < n7) {
                    stringBuffer.append(",\n" + String.valueOf((double)colorArray[n].getRed() / 255.0) + "," + String.valueOf((double)colorArray[n].getGreen() / 255.0) + "," + String.valueOf((double)colorArray[n].getBlue() / 255.0));
                    ++n;
                }
                stringBuffer.append(")");
            } else if (pgJvxSrc.isShowingElements()) {
                string2 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalElementColor());
                stringBuffer.append(string2);
            } else if (!pgJvxSrc.isShowingElements()) {
                string2 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalEdgeColor());
                stringBuffer.append(string2);
            }
            if (pgJvxSrc.getGlobalEdgeSize() > 1.0) {
                stringBuffer.append(",THICKNESS(" + (int)pgJvxSrc.getGlobalEdgeSize() + ")");
            }
            if (pgJvxSrc.isShowingElements() && pgJvxSrc.isShowingEdges()) {
                stringBuffer.append(",STYLE(PATCH)");
            } else if (pgJvxSrc.isShowingElements() && !pgJvxSrc.isShowingEdges()) {
                stringBuffer.append(",STYLE(PATCHNOGRID)");
            } else if (!pgJvxSrc.isShowingElements() && pgJvxSrc.isShowingEdges()) {
                stringBuffer.append(",STYLE(LINE)");
            } else {
                stringBuffer.append(",STYLE(POINT)");
            }
            stringBuffer.append(")");
        }
        if (n6 > 0 && pgJvxSrc.isShowingVertices()) {
            stringBuffer.append(",\nPOINTS(");
            n4 = 0;
            while (n4 < n6) {
                if (n4 > 0) {
                    stringBuffer.append(",\n");
                }
                object = PgMapleLoader.writeVertex(pdVectorArray[n4]);
                stringBuffer.append((String)object);
                ++n4;
            }
            stringBuffer.append(",\n");
            if (pgJvxSrc.isShowingVertexColors()) {
                colorArray = pgJvxSrc.getVertexColors();
                stringBuffer.append("COLOR(RGB");
                n = 0;
                while (n < n6) {
                    stringBuffer.append(",\n" + String.valueOf((double)colorArray[n].getRed() / 255.0) + "," + String.valueOf((double)colorArray[n].getGreen() / 255.0) + "," + String.valueOf((double)colorArray[n].getBlue() / 255.0));
                    ++n;
                }
                stringBuffer.append(")");
            } else {
                string2 = PgMapleLoader.writeColor(pgJvxSrc.getGlobalVertexColor());
                stringBuffer.append(string2);
            }
            if (pgJvxSrc.getGlobalVertexSize() > 1.0) {
                stringBuffer.append(",THICKNESS(" + (int)pgJvxSrc.getGlobalVertexSize() + ")");
                stringBuffer.append(",SYMBOL(CIRCLE," + 2 * (int)pgJvxSrc.getGlobalVertexSize() + ")");
            } else {
                stringBuffer.append(",SYMBOL(CIRCLE)");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(",SCALING(CONSTRAINED)");
        stringBuffer.append(",LIGHTMODEL(LIGHT_3)");
        stringBuffer.append(");");
        return stringBuffer.toString();
    }

    private static String writeColor(Color color) {
        if (color == null) {
            PsDebug.error("missing color");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("COLOR(RGB,");
        stringBuffer.append(String.valueOf((double)color.getRed() / 255.0) + ", " + String.valueOf((double)color.getGreen() / 255.0) + ", " + String.valueOf((double)color.getBlue() / 255.0) + ")");
        return stringBuffer.toString();
    }

    private static String writeVertex(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.error("missing vertex");
            return null;
        }
        int n = pdVector.getSize();
        if (n < 2) {
            PsDebug.warning("dimension of vertex smaller than 2, return emtpy string.");
            return "";
        }
        if (n > 3) {
            PsDebug.warning("dimension of vertex larger than 3, truncated.");
            n = 3;
        }
        StringBuffer stringBuffer = new StringBuffer("[" + String.valueOf(pdVector.m_data[0]));
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(",");
            if (Math.abs(pdVector.m_data[n2]) > 1.0E-10) {
                stringBuffer.append((float)pdVector.m_data[n2]);
            } else {
                stringBuffer.append(0.0f);
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static boolean isAnimation() {
        return m_bAnimation;
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    private static double[] parseRange(StreamTokenizer streamTokenizer) {
        double d;
        double d2;
        try {
            streamTokenizer.nextToken();
            d2 = PgLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
            d = PgLoader.parseDouble(streamTokenizer);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -2) {
                double d3 = PgLoader.parseDouble(streamTokenizer);
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -2) {
                    double d4 = PgLoader.parseDouble(streamTokenizer);
                    streamTokenizer.nextToken();
                    d = 10.0 * d3 + d4;
                } else {
                    d = d == 0.0 ? 10.0 * d3 : 10.0 * d + d3;
                }
            } else {
                d *= 10.0;
            }
            streamTokenizer.pushBack();
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + ", line = " + streamTokenizer.lineno());
            return null;
        }
        return new double[]{d2, d};
    }

    public static Vector readGraphics(StreamTokenizer streamTokenizer, int n, Vector vector) {
        try {
            String string = "";
            Vector<PdVector> vector2 = new Vector<PdVector>();
            Vector<PiVector> vector3 = new Vector<PiVector>();
            Vector<PiVector> vector4 = new Vector<PiVector>();
            PgJvxSrc pgJvxSrc = null;
            String string2 = null;
            int n2 = 0;
            int n3 = 0;
            do {
                int n4;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 41) {
                    --n2;
                    continue;
                }
                if (streamTokenizer.ttype == 40) {
                    ++n2;
                    continue;
                }
                if (streamTokenizer.ttype == 91) {
                    ++n3;
                    continue;
                }
                if (streamTokenizer.ttype == 93) {
                    --n3;
                    continue;
                }
                if (streamTokenizer.ttype == 44) continue;
                if (streamTokenizer.ttype != -3) {
                    PsDebug.warning("Graphics primitive identifyer expected, line = " + streamTokenizer.lineno());
                    return null;
                }
                if ("TITLE".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    string2 = streamTokenizer.sval;
                    streamTokenizer.nextToken();
                    while (streamTokenizer.ttype != 41) {
                        string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                        streamTokenizer.nextToken();
                    }
                } else if ("POLYGONS".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    int n5 = 0;
                    while (streamTokenizer.ttype != 41) {
                        PiVector piVector;
                        PdVector pdVector;
                        int n6;
                        streamTokenizer.nextToken();
                        streamTokenizer.pushBack();
                        if (streamTokenizer.ttype == 91) {
                            n6 = 0;
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 93) {
                                pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                                vector2.addElement(pdVector);
                                ++n6;
                                streamTokenizer.nextToken();
                            }
                            piVector = new PiVector(n6);
                            int n7 = 0;
                            while (n7 < n6) {
                                piVector.setEntry(n7, n5 + n7);
                                ++n7;
                            }
                            n5 += n6;
                            vector3.addElement(piVector);
                        } else if ("Array".equals(streamTokenizer.sval) || "hfarray".equals(streamTokenizer.sval)) {
                            while ("Array".equals(streamTokenizer.sval)) {
                                n6 = 0;
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                                double[] dArray = PgMapleLoader.parseRange(streamTokenizer);
                                streamTokenizer.nextToken();
                                dArray = PgMapleLoader.parseRange(streamTokenizer);
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                                while (streamTokenizer.ttype != 93) {
                                    pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                                    vector2.addElement(pdVector);
                                    ++n6;
                                    streamTokenizer.nextToken();
                                }
                                streamTokenizer.nextToken();
                                while (streamTokenizer.ttype != 41) {
                                    string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                                    streamTokenizer.nextToken();
                                }
                                piVector = new PiVector(n6);
                                int n8 = 0;
                                while (n8 < n6) {
                                    piVector.setEntry(n8, n5 + n8);
                                    ++n8;
                                }
                                n5 += n6;
                                vector3.addElement(piVector);
                            }
                        } else if (streamTokenizer.ttype != 44) {
                            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                        }
                        streamTokenizer.nextToken();
                    }
                    if (vector3.size() == 0) continue;
                    pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setDimOfVertices(n);
                    pgJvxSrc.setNumVertices(vector2.size());
                    n4 = 0;
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        pgJvxSrc.setVertex(n4++, (PdVector)enumeration.nextElement());
                    }
                    pgJvxSrc.setDimOfElements(-1);
                    pgJvxSrc.setNumElements(vector3.size());
                    n4 = 0;
                    enumeration = vector3.elements();
                    while (enumeration.hasMoreElements()) {
                        pgJvxSrc.setElement(n4++, (PiVector)enumeration.nextElement());
                    }
                    pgJvxSrc.setName("ElementSet imported from Maple");
                    pgJvxSrc.setType(33);
                    vector.addElement(pgJvxSrc);
                    vector2.removeAllElements();
                    vector3.removeAllElements();
                } else if ("POINTS".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    while (streamTokenizer.ttype != 41) {
                        streamTokenizer.nextToken();
                        streamTokenizer.pushBack();
                        if (streamTokenizer.ttype == 91) {
                            PdVector pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                            vector2.addElement(pdVector);
                        } else {
                            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                        }
                        streamTokenizer.nextToken();
                    }
                    pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setDimOfVertices(n);
                    pgJvxSrc.setNumVertices(vector2.size());
                    n4 = 0;
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        pgJvxSrc.setVertex(n4++, (PdVector)enumeration.nextElement());
                    }
                    pgJvxSrc.setName("PointSet imported from Maple");
                    pgJvxSrc.setType(30);
                    vector.addElement(pgJvxSrc);
                    vector2.removeAllElements();
                } else if ("CURVES".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    int n9 = 0;
                    double d = 0.0;
                    while (streamTokenizer.ttype != 41) {
                        streamTokenizer.nextToken();
                        streamTokenizer.pushBack();
                        if (streamTokenizer.ttype == 91) {
                            int n10 = 0;
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 93) {
                                PdVector pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                                vector2.addElement(pdVector);
                                ++n10;
                                streamTokenizer.nextToken();
                            }
                            PiVector piVector = new PiVector(n10);
                            int n11 = 0;
                            while (n11 < n10) {
                                piVector.setEntry(n11, n9 + n11);
                                ++n11;
                            }
                            n9 += n10;
                            vector4.addElement(piVector);
                        } else if ("THICKNESS".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d = PgLoader.parseDouble(streamTokenizer);
                            streamTokenizer.nextToken();
                        } else {
                            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                        }
                        streamTokenizer.nextToken();
                    }
                    pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setDimOfVertices(n);
                    pgJvxSrc.setNumVertices(vector2.size());
                    n4 = 0;
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        pgJvxSrc.setVertex(n4++, (PdVector)enumeration.nextElement());
                    }
                    pgJvxSrc.setDimOfPolygons(-1);
                    pgJvxSrc.setNumPolygons(vector4.size());
                    n4 = 0;
                    enumeration = vector4.elements();
                    while (enumeration.hasMoreElements()) {
                        pgJvxSrc.setPolygon(n4++, (PiVector)enumeration.nextElement());
                    }
                    pgJvxSrc.setName("PolygonSet imported from Maple");
                    pgJvxSrc.setType(32);
                    pgJvxSrc.showVertices(false);
                    if (d > 0.0) {
                        pgJvxSrc.setGlobalPolygonSize(d);
                    }
                    vector.addElement(pgJvxSrc);
                    vector2.removeAllElements();
                    vector4.removeAllElements();
                } else if ("TEXT".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    PdVector pdVector = null;
                    while (streamTokenizer.ttype != 41) {
                        streamTokenizer.nextToken();
                        streamTokenizer.pushBack();
                        if (streamTokenizer.ttype == 91) {
                            pdVector = PgMapleLoader.parsePoint(streamTokenizer, n);
                            vector2.addElement(pdVector);
                        } else if (streamTokenizer.ttype == 39) {
                            streamTokenizer.nextToken();
                            if (pdVector != null) {
                                pdVector.setName(streamTokenizer.sval);
                            } else {
                                PsDebug.warning("text position must occur before label, line = " + streamTokenizer.lineno());
                            }
                        } else {
                            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                        }
                        streamTokenizer.nextToken();
                    }
                    pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setDimOfVertices(n);
                    pgJvxSrc.setNumVertices(vector2.size());
                    n4 = 0;
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        pgJvxSrc.setVertex(n4++, (PdVector)enumeration.nextElement());
                    }
                    if (pdVector != null) {
                        pgJvxSrc.setName("Text: " + pdVector.getName());
                    }
                    pgJvxSrc.setType(30);
                    pgJvxSrc.showIndices(true);
                    pgJvxSrc.setGlobalVertexSize(0.0);
                    vector.addElement(pgJvxSrc);
                    vector2.removeAllElements();
                } else if ("GRID".equals(streamTokenizer.sval)) {
                    int n12;
                    streamTokenizer.nextToken();
                    int n13 = 0;
                    int n14 = 0;
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    while (streamTokenizer.ttype != 41) {
                        Object[] objectArray;
                        streamTokenizer.nextToken();
                        streamTokenizer.pushBack();
                        if (streamTokenizer.ttype == -2) {
                            objectArray = PgMapleLoader.parseRange(streamTokenizer);
                            d = objectArray[0];
                            d2 = objectArray[1];
                            streamTokenizer.nextToken();
                            objectArray = PgMapleLoader.parseRange(streamTokenizer);
                            d3 = objectArray[0];
                            d4 = objectArray[1];
                        } else if ("Array".equals(streamTokenizer.sval) || "hfarray".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            objectArray = PgMapleLoader.parseRange(streamTokenizer);
                            streamTokenizer.nextToken();
                            objectArray = PgMapleLoader.parseRange(streamTokenizer);
                            streamTokenizer.nextToken();
                            int[] nArray = PgMapleLoader.parse2ArrayOfDoubles(streamTokenizer, vector2);
                            if (nArray != null) {
                                n13 = nArray[0];
                                n14 = nArray[1];
                            }
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 41) {
                                string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                                streamTokenizer.nextToken();
                            }
                        } else if (streamTokenizer.ttype == 91) {
                            objectArray = PgMapleLoader.parse2ArrayOfDoubles(streamTokenizer, vector2);
                            if (objectArray != null) {
                                n13 = (int)objectArray[0];
                                n14 = (int)objectArray[1];
                            }
                        } else {
                            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                        }
                        streamTokenizer.nextToken();
                    }
                    if (n13 == 0 || n14 == 0) continue;
                    double d5 = (d2 - d) / (double)(n13 - 1);
                    double d6 = (d4 - d3) / (double)(n14 - 1);
                    n4 = 0;
                    pgJvxSrc = new PgJvxSrc(3);
                    pgJvxSrc.setDimOfVertices(3);
                    pgJvxSrc.setNumVertices(n13 * n14);
                    int n15 = 0;
                    while (n15 < n14) {
                        n12 = 0;
                        while (n12 < n13) {
                            Double d7 = (Double)vector2.elementAt(n4);
                            pgJvxSrc.getVertex(n4++).set(d + (double)n12 * d5, d3 + (double)n15 * d6, d7);
                            ++n12;
                        }
                        ++n15;
                    }
                    pgJvxSrc.setDimOfElements(4);
                    pgJvxSrc.setNumElements((n13 - 1) * (n14 - 1));
                    n4 = 0;
                    n15 = 0;
                    while (n15 < n14 - 1) {
                        n12 = 0;
                        while (n12 < n13 - 1) {
                            pgJvxSrc.getElement(n4++).set(n15 * n13 + n12, (n15 + 1) * n13 + n12, (n15 + 1) * n13 + n12 + 1, n15 * n13 + n12 + 1);
                            ++n12;
                        }
                        ++n15;
                    }
                    pgJvxSrc.setName("Grid imported from Maple");
                    pgJvxSrc.setType(33);
                    vector.addElement(pgJvxSrc);
                    vector2.removeAllElements();
                } else if ("MESH".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    int n16 = 0;
                    int n17 = 0;
                    while (streamTokenizer.ttype != 41) {
                        Object[] objectArray;
                        streamTokenizer.nextToken();
                        streamTokenizer.pushBack();
                        if ("Array".equals(streamTokenizer.sval) || "hfarray".equals(streamTokenizer.sval)) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            objectArray = PgMapleLoader.parseRange(streamTokenizer);
                            streamTokenizer.nextToken();
                            objectArray = PgMapleLoader.parseRange(streamTokenizer);
                            streamTokenizer.nextToken();
                            objectArray = PgMapleLoader.parseRange(streamTokenizer);
                            streamTokenizer.nextToken();
                            int[] nArray = PgMapleLoader.parse2ArrayOfPoints(streamTokenizer, vector2, n);
                            if (nArray != null) {
                                n16 = nArray[0];
                                n17 = nArray[1];
                            }
                            streamTokenizer.nextToken();
                            while (streamTokenizer.ttype != 41) {
                                string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                                streamTokenizer.nextToken();
                            }
                        } else if (streamTokenizer.ttype == 91) {
                            objectArray = PgMapleLoader.parse2ArrayOfPoints(streamTokenizer, vector2, n);
                            if (objectArray != null) {
                                n16 = objectArray[0];
                                n17 = (int)objectArray[1];
                            }
                        } else {
                            string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                        }
                        streamTokenizer.nextToken();
                    }
                    if (n16 == 0 || n17 == 0) continue;
                    pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setDimOfVertices(n);
                    pgJvxSrc.setNumVertices(vector2.size());
                    n4 = 0;
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        pgJvxSrc.setVertex(n4++, (PdVector)enumeration.nextElement());
                    }
                    pgJvxSrc.setDimOfElements(4);
                    pgJvxSrc.setNumElements((n16 - 1) * (n17 - 1));
                    n4 = 0;
                    int n18 = 0;
                    while (n18 < n17 - 1) {
                        int n19 = 0;
                        while (n19 < n16 - 1) {
                            pgJvxSrc.getElement(n4++).set(n18 * n16 + n19, (n18 + 1) * n16 + n19, (n18 + 1) * n16 + n19 + 1, n18 * n16 + n19 + 1);
                            ++n19;
                        }
                        ++n18;
                    }
                    pgJvxSrc.setName("Mesh imported from Maple");
                    pgJvxSrc.setType(33);
                    vector.addElement(pgJvxSrc);
                    vector2.removeAllElements();
                } else if ("ANIMATE".equals(streamTokenizer.sval)) {
                    m_bAnimation = true;
                } else {
                    streamTokenizer.pushBack();
                    string = string + PgMapleLoader.parseUnknown(streamTokenizer);
                }
                if (string2 == null || pgJvxSrc == null) continue;
                pgJvxSrc.setTitle(string2);
                pgJvxSrc.setName(string2);
                pgJvxSrc.showTitle(true);
            } while (n2 > 0);
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + ", line = " + streamTokenizer.lineno());
            return null;
        }
        return vector;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Vector parseMaple(BufferedReader bufferedReader) throws IOException {
        int n;
        int n2;
        StreamTokenizer streamTokenizer;
        Vector vector = new Vector();
        try {
            streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.ordinaryChar(91);
            streamTokenizer.ordinaryChar(93);
            streamTokenizer.ordinaryChar(40);
            streamTokenizer.ordinaryChar(41);
            streamTokenizer.ordinaryChar(42);
            streamTokenizer.ordinaryChar(94);
            streamTokenizer.ordinaryChar(44);
            streamTokenizer.commentChar(35);
            streamTokenizer.parseNumbers();
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.whitespaceChars(92, 92);
            streamTokenizer.whitespaceChars(96, 96);
            streamTokenizer.quoteChar(39);
            n2 = 0;
            n = 0;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception);
            return null;
        }
        block11: while (true) {
            int n3 = 0;
            block12: do {
                switch (n3 == 0 ? streamTokenizer.nextToken() : n3) {
                    default: {
                        PsDebug.warning("parsing broke abnormally  reading st.sval = " + streamTokenizer.sval + ", st.ttype = " + streamTokenizer.ttype + ", line = " + streamTokenizer.lineno());
                        break;
                    }
                    case -1: {
                        if (n2 != 0) {
                            PsDebug.warning("'}' missing");
                            return null;
                        }
                        if (n == 0) return vector;
                        PsDebug.warning("']' missing");
                        return null;
                    }
                    case -3: {
                        if ("PLOT".equals(streamTokenizer.sval)) {
                            n3 = 44;
                            if ((vector = PgMapleLoader.readGraphics(streamTokenizer, 2, vector)) != null) continue block12;
                            PsDebug.warning("failed reading PLOT");
                            return null;
                        }
                        if ("PLOT3D".equals(streamTokenizer.sval)) {
                            n3 = 44;
                            if ((vector = PgMapleLoader.readGraphics(streamTokenizer, 3, vector)) != null) continue block12;
                            PsDebug.warning("failed reading PLOT3D");
                            return null;
                        }
                        PsDebug.warning("Unknown command:" + streamTokenizer.sval);
                        break;
                    }
                    case 123: {
                        ++n2;
                        break;
                    }
                    case 125: {
                        n3 = 44;
                        if (--n2 >= 0) continue block12;
                        PsDebug.warning("More '}' than '{'");
                        return null;
                    }
                    case 91: {
                        ++n;
                        break;
                    }
                    case 93: {
                        if (--n < 0) {
                            PsDebug.warning("More ']' than '['");
                            return null;
                        }
                    }
                    case 44: 
                    case 59: 
                }
                continue block11;
            } while (true);
        }
    }

    private static String parseUnknown(StreamTokenizer streamTokenizer) {
        String string = "";
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 41) {
                streamTokenizer.pushBack();
                return string;
            }
            if (streamTokenizer.ttype != 40) {
                int n = 0;
                int n2 = 0;
                while (streamTokenizer.ttype != 44 && streamTokenizer.ttype != -1 && n >= 0 && n2 >= 0) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 40) {
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.ttype == 41) {
                        --n;
                        continue;
                    }
                    if (streamTokenizer.ttype == 91) {
                        ++n2;
                        continue;
                    }
                    if (streamTokenizer.ttype != 93) continue;
                    --n2;
                }
                if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 41 || streamTokenizer.ttype == 93) {
                    streamTokenizer.pushBack();
                }
                return string;
            }
            int n = 1;
            while (n != 0) {
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("')' missing.");
                    return string;
                }
                if (streamTokenizer.nextToken() == -1) {
                    PsDebug.warning("premature end of file.");
                    return string;
                }
                if (streamTokenizer.ttype == 40) {
                    ++n;
                    continue;
                }
                if (streamTokenizer.ttype == 41) {
                    --n;
                    continue;
                }
                if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 39 || streamTokenizer.ttype == -2) continue;
                if (streamTokenizer.ttype == 91) {
                    string = string + "[";
                    continue;
                }
                if (streamTokenizer.ttype == 93) {
                    string = string + "]";
                    continue;
                }
                if (streamTokenizer.ttype == 44) {
                    string = string + ",";
                    continue;
                }
                if (streamTokenizer.ttype == 42) {
                    string = string + "*";
                    continue;
                }
                if (streamTokenizer.ttype != 94) continue;
                string = string + "^";
            }
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + ", line = " + streamTokenizer.lineno());
        }
        return string;
    }
}

