/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.Vector;
import jv.loader.PcViewerOptions;
import jv.loader.PgMathData;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgMathLoader {
    protected int m_dim = 0;
    protected PdVector[] m_circle;
    protected PdVector[] m_disk;
    protected boolean m_isKeyAnimation = false;
    protected boolean m_isAnimation = false;
    protected PgJvxSrc[] m_geom;
    protected int m_geomType;
    protected PgMathData[] m_mathData;
    protected Vector mathVector;
    protected int m_numGraphics = 0;

    public boolean isKeyAnimation() {
        return this.m_isKeyAnimation;
    }

    public PgMathLoader(int n) {
        this.m_dim = n;
    }

    public PgMathLoader() {
    }

    public PgMathData[] read(BufferedReader bufferedReader) {
        int n;
        if (bufferedReader == null) {
            PsDebug.warning("BufferedReader == null");
            return null;
        }
        this.mathVector = new Vector();
        try {
            n = this.parseMath(bufferedReader);
            if (n == 0) {
                PsDebug.warning("Reading failed");
                return null;
            }
            if (this.m_numGraphics == 0) {
                PsDebug.warning("missing graphics");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("Reading failed");
            iOException.printStackTrace();
            return null;
        }
        this.m_mathData = new PgMathData[this.m_numGraphics];
        n = 0;
        while (n < this.m_numGraphics) {
            this.m_mathData[n] = (PgMathData)this.mathVector.elementAt(n);
            ++n;
        }
        return this.m_mathData;
    }

    public PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string, this);
            return null;
        }
        PgMathData[] pgMathDataArray = this.read(bufferedReader);
        if (pgMathDataArray == null || pgMathDataArray.length == 0 || pgMathDataArray[0] == null) {
            PsDebug.warning("missing mathData");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = pgMathDataArray[0].getGeom();
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return null;
        }
        PiVector piVector = pgMathDataArray[0].getGeomType();
        int n = 0;
        while (n < pgJvxSrcArray.length) {
            pgJvxSrcArray[n].setType(piVector.m_data[n]);
            if (pgJvxSrcArray[n].getName() == null) {
                pgJvxSrcArray[n].setName(PsUtil.getFileBaseName(string));
            }
            PgMathLoader.geomInitType(pgJvxSrcArray[n]);
            ++n;
        }
        this.m_geomType = piVector.m_data[0];
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] convert(PgMathData[] pgMathDataArray) {
        if (pgMathDataArray == null || pgMathDataArray.length == 0 || pgMathDataArray[0] == null) {
            PsDebug.warning("missing mathData");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = pgMathDataArray[0].getGeom();
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return null;
        }
        PiVector piVector = pgMathDataArray[0].getGeomType();
        int n = 0;
        while (n < pgJvxSrcArray.length) {
            pgJvxSrcArray[n].setType(piVector.m_data[n]);
            ++n;
        }
        return pgJvxSrcArray;
    }

    protected void setDefaultOptions(PcViewerOptions pcViewerOptions) {
        pcViewerOptions.showAxes(true);
        pcViewerOptions.showAxesLabel(false);
        pcViewerOptions.showDepth(true);
        pcViewerOptions.showLighting(true);
        Color[] colorArray = new Color[]{new Color(0, 255, 0), new Color(255, 0, 0), new Color(0, 0, 255)};
        PdVector[] pdVectorArray = new PdVector[]{new PdVector(1.0, 1.0, 1.0), new PdVector(1.0, 0.0, 1.0), new PdVector(0.0, 1.0, 1.0)};
        pcViewerOptions.setLightSourceColors(colorArray);
        pcViewerOptions.setLightSourcePoints(pdVectorArray);
        pcViewerOptions.showBoundingBox(true);
        pcViewerOptions.setBoundingBoxRatios(new PdVector(0.0, 0.0, 0.0));
        pcViewerOptions.setAmbientLight(new Color(255, 255, 255));
        pcViewerOptions.setViewPoint(new PdVector(1.3, -2.4, 2.0));
        pcViewerOptions.setViewCenter(new PdVector(0.5, 0.5, 0.5));
        PiVector piVector = new PiVector(6);
        piVector.m_data[0] = 0;
        piVector.m_data[1] = 0;
        piVector.m_data[2] = 0;
        piVector.m_data[3] = 0;
        piVector.m_data[4] = 0;
        piVector.m_data[5] = 0;
        pcViewerOptions.setAxesEdge(piVector);
    }

    public static String write(PgJvxSrc pgJvxSrc) {
        String string;
        int n;
        int n2;
        int n3;
        PiVector[] piVectorArray;
        int n4;
        if (pgJvxSrc == null) {
            PsDebug.warning("missing geometry");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("(* Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + "\n");
        stringBuffer.append("     File Format = Mathematica Graphics MGS\n");
        stringBuffer.append("     Geometry    = " + pgJvxSrc.getName() + "\n");
        stringBuffer.append("     Date        = " + new Date().toString() + "\n//\n");
        int n5 = pgJvxSrc.getNumVertices();
        stringBuffer.append("     Number of Vertices = " + n5 + "\n");
        int n6 = pgJvxSrc.getNumElements();
        if (n6 > 0) {
            stringBuffer.append("     Number of Elements = " + n6 + "\n");
        }
        if ((n4 = pgJvxSrc.getNumPolygons()) > 0) {
            stringBuffer.append("     Number of Polygons = " + n4 + "\n");
        }
        stringBuffer.append("\n End of Header *)\n");
        stringBuffer.append("Graphics3D[{");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        String string2 = null;
        Color[] colorArray = null;
        boolean bl = false;
        if (n4 > 0) {
            bl = true;
            if (!pgJvxSrc.isShowingPolygonColors()) {
                string2 = PgMathLoader.writeColor(pgJvxSrc.getGlobalPolygonColor());
                stringBuffer.append(string2 + ",");
            } else {
                colorArray = pgJvxSrc.getPolygonColors();
            }
            piVectorArray = pgJvxSrc.getPolygons();
            n3 = 0;
            while (n3 < n4) {
                if (pgJvxSrc.isShowingPolygonColors()) {
                    string2 = PgMathLoader.writeColor(colorArray[n3]);
                    stringBuffer.append("{" + string2 + ",");
                }
                stringBuffer.append("Line[{");
                n2 = piVectorArray[n3].getSize();
                n = 0;
                while (n < n2) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    string = PgMathLoader.writeVertex(pdVectorArray[piVectorArray[n3].m_data[n]]);
                    stringBuffer.append(string);
                    ++n;
                }
                stringBuffer.append("}]");
                if (pgJvxSrc.isShowingPolygonColors()) {
                    stringBuffer.append("}");
                }
                if (n3 < n4 - 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("\n");
                ++n3;
            }
        } else if (n6 > 0) {
            bl = true;
            if (!pgJvxSrc.isShowingEdges()) {
                stringBuffer.append("EdgeForm[],");
            }
            if (!pgJvxSrc.isShowingElementColors()) {
                string2 = PgMathLoader.writeColor(pgJvxSrc.getGlobalElementColor());
                stringBuffer.append("SurfaceColor[" + string2 + "],");
            } else {
                colorArray = pgJvxSrc.getElementColors();
            }
            piVectorArray = pgJvxSrc.getElements();
            n3 = 0;
            while (n3 < n6) {
                if (pgJvxSrc.isShowingElementColors()) {
                    string2 = PgMathLoader.writeColor(colorArray[n3]);
                    stringBuffer.append("{" + string2 + ",");
                }
                stringBuffer.append("Polygon[{");
                n2 = piVectorArray[n3].getSize();
                n = 0;
                while (n < n2) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    string = PgMathLoader.writeVertex(pdVectorArray[piVectorArray[n3].m_data[n]]);
                    stringBuffer.append(string);
                    ++n;
                }
                stringBuffer.append("}]");
                if (pgJvxSrc.isShowingElementColors()) {
                    stringBuffer.append("}");
                }
                if (n3 < n6 - 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("\n");
                ++n3;
            }
        }
        if (n5 > 0 && pgJvxSrc.isShowingVertices()) {
            if (bl) {
                stringBuffer.append(",\n");
            }
            int n7 = 0;
            while (n7 < n5) {
                stringBuffer.append("Point[");
                String string3 = PgMathLoader.writeVertex(pdVectorArray[n7]);
                stringBuffer.append(string3);
                stringBuffer.append("]");
                if (n7 < n5 - 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("\n");
                ++n7;
            }
        }
        stringBuffer.append("}]\n");
        return stringBuffer.toString();
    }

    public Color readRGBColor(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            double d = this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            double d2 = this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            double d3 = this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            return new Color((float)d, (float)d2, (float)d3);
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return new Color(1.0f, 0.0f, 0.0f);
        }
    }

    public int readSurfaceColor(StreamTokenizer streamTokenizer, Color[] colorArray) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            int n = 1;
            if ("RGBColor".equals(streamTokenizer.sval)) {
                colorArray[0] = this.readRGBColor(streamTokenizer);
            } else if ("Hue".equals(streamTokenizer.sval)) {
                colorArray[0] = this.readHueColor(streamTokenizer);
            } else if ("GrayLevel".equals(streamTokenizer.sval)) {
                colorArray[0] = this.readGrayLevel(streamTokenizer);
            } else {
                PsDebug.warning("RGBColor, Hue or GrayLevel expected in line " + streamTokenizer.lineno());
            }
            colorArray[1] = new Color(colorArray[0].getRGB());
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 44) {
                streamTokenizer.nextToken();
                if ("RGBColor".equals(streamTokenizer.sval)) {
                    colorArray[1] = this.readRGBColor(streamTokenizer);
                } else if ("Hue".equals(streamTokenizer.sval)) {
                    colorArray[1] = this.readHueColor(streamTokenizer);
                } else if ("GrayLevel".equals(streamTokenizer.sval)) {
                    colorArray[1] = this.readGrayLevel(streamTokenizer);
                } else {
                    PsDebug.warning("RGBColor, Hue or GrayLevel expected in line " + streamTokenizer.lineno());
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 44) {
                    streamTokenizer.nextToken();
                    n = (int)this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                }
            }
            return n;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return 1;
        }
    }

    private static String writeColor(Color color) {
        if (color == null) {
            PsDebug.error("PgMathLoader.writeColor(): missing color");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("RGBColor[");
        stringBuffer.append(String.valueOf((double)color.getRed() / 255.0) + ", " + String.valueOf((double)color.getGreen() / 255.0) + ", " + String.valueOf((double)color.getBlue() / 255.0) + "]");
        return stringBuffer.toString();
    }

    public double readNumber(StreamTokenizer streamTokenizer) {
        try {
            double d = streamTokenizer.nval;
            streamTokenizer.ordinaryChar(69);
            streamTokenizer.ordinaryChar(101);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 42) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 94) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        streamTokenizer.wordChars(69, 69);
                        streamTokenizer.wordChars(101, 101);
                        return d;
                    }
                    d *= Math.pow(10.0, streamTokenizer.nval);
                }
            } else if (streamTokenizer.ttype == 69 || streamTokenizer.ttype == 101) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                    streamTokenizer.wordChars(69, 69);
                    streamTokenizer.wordChars(101, 101);
                    return d;
                }
                d *= Math.pow(10.0, streamTokenizer.nval);
            } else {
                streamTokenizer.pushBack();
            }
            streamTokenizer.wordChars(69, 69);
            streamTokenizer.wordChars(101, 101);
            return d;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            streamTokenizer.wordChars(69, 69);
            streamTokenizer.wordChars(101, 101);
            return 0.0;
        }
    }

    private static String writeVertex(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.error("missing vertex");
            return null;
        }
        int n = pdVector.getSize();
        if (n < 2) {
            PsDebug.warning("dimension of vertex smaller than 2, return emtpy string.");
            return "";
        }
        if (n > 3) {
            PsDebug.warning("dimension of vertex larger than 3, truncated.");
            n = 3;
        }
        StringBuffer stringBuffer = new StringBuffer("{" + String.valueOf(pdVector.m_data[0]));
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(", ");
            if (Math.abs(pdVector.m_data[n2]) > 1.0E-10) {
                stringBuffer.append((float)pdVector.m_data[n2]);
            } else {
                stringBuffer.append(0.0f);
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean isAnimation() {
        return this.m_isAnimation;
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    public boolean readParametricSurface(StreamTokenizer streamTokenizer) {
        try {
            int n;
            Object object;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            Vector<Object> vector = new Vector<Object>();
            String string = "";
            Vector<Object> vector2 = new Vector<Object>();
            Vector<Object> vector3 = new Vector<Object>();
            Vector<Object> vector4 = new Vector<Object>();
            Vector<Object> vector5 = new Vector<Object>();
            PiVector piVector = new PiVector();
            PiVector piVector2 = new PiVector();
            Color color = new Color(0, 0, 0);
            double d = 1.0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            int n2 = 0;
            int n3 = 0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            while (streamTokenizer.ttype != 125) {
                streamTokenizer.nextToken();
                ++n3;
                int n4 = n2;
                n2 = 0;
                while (streamTokenizer.ttype != 125) {
                    ++n2;
                    object = new PdVector(3);
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    ((PdVector)object).m_data[2] = this.readNumber(streamTokenizer);
                    vector.addElement(object);
                    streamTokenizer.nextToken();
                }
                if (n3 > 1 && n4 != n2) {
                    PsDebug.warning("Number of U-Lines not constant - V-Line: " + n3 + " Line: " + streamTokenizer.lineno());
                    return false;
                }
                streamTokenizer.nextToken();
            }
            object = new PgMathData();
            ((PgMathData)object).setDim(this.m_dim);
            PcViewerOptions pcViewerOptions = new PcViewerOptions();
            this.setDefaultOptions(pcViewerOptions);
            streamTokenizer.nextToken();
            int n5 = 1;
            while (n5 != 0) {
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("PgMathLoader.readElementSet: ']' missing Line: " + streamTokenizer.lineno());
                    return false;
                }
                if (streamTokenizer.ttype == 93) {
                    --n5;
                }
                if (streamTokenizer.ttype == 91) {
                    ++n5;
                }
                if (streamTokenizer.ttype == -3 && !this.readOptions(streamTokenizer, pcViewerOptions)) {
                    Object object2;
                    if ("AxesLabel".equals(streamTokenizer.sval)) {
                        this.readAxesLabel(streamTokenizer, pcViewerOptions, this.m_dim);
                    } else if ("Mesh".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl3 = "True".equals(streamTokenizer.sval);
                    } else if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                        object2 = new Color(0);
                        bl = true;
                        if ("RGBColor".equals(streamTokenizer.sval)) {
                            object2 = this.readRGBColor(streamTokenizer);
                        }
                        if ("Hue".equals(streamTokenizer.sval)) {
                            object2 = this.readHueColor(streamTokenizer);
                        }
                        if ("GrayLevel".equals(streamTokenizer.sval)) {
                            object2 = this.readGrayLevel(streamTokenizer);
                        }
                        vector2.addElement(object2);
                        vector3.addElement(new Color(((Color)object2).getRGB()));
                        vector4.addElement(new Color(((Color)object2).getRGB()));
                        vector5.addElement(new Color(((Color)object2).getRGB()));
                        piVector.addEntry(1);
                        piVector2.addEntry(1);
                    } else if ("SurfaceColor".equals(streamTokenizer.sval)) {
                        bl = true;
                        object2 = new Color[2];
                        int n6 = this.readSurfaceColor(streamTokenizer, (Color[])object2);
                        piVector.addEntry(n6);
                        piVector2.addEntry(n6);
                        vector2.addElement(object2[0]);
                        vector3.addElement(new Color(((Color)object2[0]).getRGB()));
                        vector4.addElement(object2[1]);
                        vector5.addElement(new Color(((Color)object2[1]).getRGB()));
                    } else if ("FaceForm".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                        }
                        bl = true;
                        if ("SurfaceColor".equals(streamTokenizer.sval)) {
                            object2 = new Color[2];
                            piVector.addEntry(this.readSurfaceColor(streamTokenizer, (Color[])object2));
                            vector2.addElement(object2[0]);
                            vector4.addElement(object2[1]);
                        } else {
                            object2 = new Color(0);
                            if ("RGBColor".equals(streamTokenizer.sval)) {
                                object2 = this.readRGBColor(streamTokenizer);
                            }
                            if ("GrayLevel".equals(streamTokenizer.sval)) {
                                object2 = this.readGrayLevel(streamTokenizer);
                            }
                            if ("Hue".equals(streamTokenizer.sval)) {
                                object2 = this.readHueColor(streamTokenizer);
                            }
                            if ("CMYKColor".equals(streamTokenizer.sval)) {
                                object2 = this.readGrayLevel(streamTokenizer);
                            }
                            vector2.addElement(object2);
                            vector4.addElement(new Color(((Color)object2).getRGB()));
                            piVector.addEntry(1);
                        }
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                        }
                        if ("SurfaceColor".equals(streamTokenizer.sval)) {
                            object2 = new Color[2];
                            piVector2.addEntry(this.readSurfaceColor(streamTokenizer, (Color[])object2));
                            vector3.addElement(object2[0]);
                            vector5.addElement(object2[1]);
                        } else {
                            object2 = new Color(0);
                            if ("RGBColor".equals(streamTokenizer.sval)) {
                                object2 = this.readRGBColor(streamTokenizer);
                            }
                            if ("GrayLevel".equals(streamTokenizer.sval)) {
                                object2 = this.readGrayLevel(streamTokenizer);
                            }
                            if ("Hue".equals(streamTokenizer.sval)) {
                                object2 = this.readHueColor(streamTokenizer);
                            }
                            if ("CMYKColor".equals(streamTokenizer.sval)) {
                                object2 = this.readGrayLevel(streamTokenizer);
                            }
                            vector3.addElement(object2);
                            vector5.addElement(new Color(((Color)object2).getRGB()));
                            piVector2.addEntry(1);
                        }
                        streamTokenizer.nextToken();
                    } else if ("EdgeForm".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 93) {
                            bl3 = false;
                        }
                        while (streamTokenizer.ttype != 93) {
                            if (streamTokenizer.ttype != -3) continue;
                            if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                                bl2 = true;
                                color = new Color(0);
                                if ("RGBColor".equals(streamTokenizer.sval)) {
                                    color = this.readRGBColor(streamTokenizer);
                                }
                                if ("CMYKColor".equals(streamTokenizer.sval)) {
                                    color = this.readCMYKColor(streamTokenizer);
                                }
                                if ("Hue".equals(streamTokenizer.sval)) {
                                    color = this.readHueColor(streamTokenizer);
                                }
                                if ("GrayLevel".equals(streamTokenizer.sval)) {
                                    color = this.readGrayLevel(streamTokenizer);
                                }
                            }
                            if (!"Thickness".equals(streamTokenizer.sval)) continue;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            d = 1000.0 * this.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                        }
                    } else if ("MeshRange".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.parseNumbers();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -2) {
                            PsDebug.warning("number expected Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        d2 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -2) {
                            PsDebug.warning("number expected Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        d3 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -2) {
                            PsDebug.warning("number expected Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        d4 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -2) {
                            PsDebug.warning("number expected Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        d5 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                    }
                }
                streamTokenizer.ordinaryChar(45);
                streamTokenizer.nextToken();
            }
            ((PgMathData)object).setOptions(pcViewerOptions);
            double d6 = (d3 - d2) / (double)(n2 - 1);
            double d7 = (d5 - d4) / (double)(n3 - 1);
            int n7 = 0;
            PgJvxSrc pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setDimOfVertices(3);
            pgJvxSrc.setNumVertices(n2 * n3);
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            int n8 = 0;
            while (n8 < n3) {
                n = 0;
                while (n < n2) {
                    pdVectorArray[n8 * n2 + n].copy((PdVector)vector.elementAt(n7));
                    pdVectorArray[n8 * n2 + n].m_data[0] = d2 + (double)n * d6;
                    pdVectorArray[n8 * n2 + n].m_data[1] = d4 + (double)n8 * d7;
                    ++n7;
                    ++n;
                }
                ++n8;
            }
            pgJvxSrc.setDimOfElements(4);
            pgJvxSrc.setNumElements((n2 - 1) * (n3 - 1));
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            n = 0;
            int n9 = 0;
            while (n9 < n3 - 1) {
                int n10 = 0;
                while (n10 < n2 - 1) {
                    piVectorArray[n].m_data[0] = n9 * n2 + n10;
                    piVectorArray[n].m_data[1] = (n9 + 1) * n2 + n10;
                    piVectorArray[n].m_data[2] = (n9 + 1) * n2 + n10 + 1;
                    piVectorArray[n].m_data[3] = n9 * n2 + n10 + 1;
                    ++n;
                    ++n10;
                }
                ++n9;
            }
            if (bl3) {
                pgJvxSrc.showEdges(true);
            } else {
                pgJvxSrc.showEdges(false);
            }
            if (bl) {
                n9 = (n2 - 1) * (n3 - 1);
                if (vector2.size() == n9) {
                    Color[] colorArray = new Color[n9];
                    Color[] colorArray2 = new Color[n9];
                    Color[] colorArray3 = new Color[n9];
                    Color[] colorArray4 = new Color[n9];
                    int n11 = 0;
                    while (n11 < n9) {
                        colorArray[n11] = (Color)vector2.elementAt(n11);
                        colorArray2[n11] = (Color)vector3.elementAt(n11);
                        colorArray3[n11] = (Color)vector4.elementAt(n11);
                        colorArray4[n11] = (Color)vector5.elementAt(n11);
                        ++n11;
                    }
                    pgJvxSrc.setElementColors(colorArray);
                } else {
                    pgJvxSrc.setGlobalElementColor((Color)vector2.elementAt(0));
                }
            }
            if (bl2) {
                pgJvxSrc.setGlobalEdgeColor(color);
            }
            pgJvxSrc.setGlobalEdgeSize(d);
            this.m_geom = new PgJvxSrc[1];
            this.m_geom[0] = pgJvxSrc;
            PiVector piVector3 = new PiVector(1);
            piVector3.m_data[0] = 33;
            ((PgMathData)object).setGeom(this.m_geom, piVector3);
            this.mathVector.addElement(object);
            ((PgMathData)object).setText(string);
            streamTokenizer.parseNumbers();
            streamTokenizer.pushBack();
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    protected boolean readOptions(StreamTokenizer streamTokenizer, PcViewerOptions pcViewerOptions) {
        try {
            if ("Boxed".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval)) {
                    pcViewerOptions.showBoundingBox(true);
                } else {
                    pcViewerOptions.showBoundingBox(false);
                }
                return true;
            }
            if ("Axes".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval) || "Automatic".equals(streamTokenizer.sval)) {
                    pcViewerOptions.showAxes(true);
                } else {
                    pcViewerOptions.showAxes(false);
                }
                return true;
            }
            if ("Shading".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval)) {
                    pcViewerOptions.showDepth(true);
                } else {
                    pcViewerOptions.showDepth(false);
                }
                return true;
            }
            if ("Lighting".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval)) {
                    pcViewerOptions.showLighting(true);
                } else {
                    pcViewerOptions.showLighting(false);
                }
                return true;
            }
            if ("LightSources".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 125) {
                    pcViewerOptions.setLightSourcePoints(new PdVector[0]);
                    pcViewerOptions.setLightSourceColors(new Color[0]);
                } else {
                    Color[] colorArray;
                    PdVector[] pdVectorArray;
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        pdVectorArray = new PdVector[1];
                        colorArray = new Color[1];
                        pdVectorArray[0] = new PdVector(3);
                        int n = 0;
                        do {
                            pdVectorArray[0].m_data[n] = this.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        } while (++n < 3);
                        streamTokenizer.nextToken();
                        if ("RGBColor".equals(streamTokenizer.sval)) {
                            colorArray[0] = this.readRGBColor(streamTokenizer);
                        } else if ("GrayLevel".equals(streamTokenizer.sval)) {
                            colorArray[0] = this.readGrayLevel(streamTokenizer);
                        } else if ("Hue".equals(streamTokenizer.sval)) {
                            colorArray[0] = this.readHueColor(streamTokenizer);
                        }
                        streamTokenizer.nextToken();
                    } else {
                        Vector<PdVector> vector = new Vector<PdVector>();
                        Vector<Color> vector2 = new Vector<Color>();
                        while (streamTokenizer.ttype != 125) {
                            streamTokenizer.nextToken();
                            PdVector pdVector = new PdVector(3);
                            Color color = new Color(1.0f, 0.0f, 0.0f);
                            int n = 0;
                            do {
                                pdVector.m_data[n] = this.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                                streamTokenizer.nextToken();
                            } while (++n < 3);
                            streamTokenizer.nextToken();
                            if ("RGBColor".equals(streamTokenizer.sval)) {
                                color = this.readRGBColor(streamTokenizer);
                            } else if ("GrayLevel".equals(streamTokenizer.sval)) {
                                color = this.readGrayLevel(streamTokenizer);
                            } else if ("Hue".equals(streamTokenizer.sval)) {
                                color = this.readHueColor(streamTokenizer);
                            }
                            streamTokenizer.nextToken();
                            vector.addElement(pdVector);
                            vector2.addElement(color);
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != 44) continue;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        }
                        pdVectorArray = new PdVector[vector.size()];
                        colorArray = new Color[vector2.size()];
                        int n = 0;
                        while (n < vector.size()) {
                            pdVectorArray[n] = (PdVector)vector.elementAt(n);
                            colorArray[n] = (Color)vector2.elementAt(n);
                            ++n;
                        }
                    }
                    pcViewerOptions.setLightSourcePoints(pdVectorArray);
                    pcViewerOptions.setLightSourceColors(colorArray);
                }
                return true;
            }
            if ("ViewPoint".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                PdVector pdVector = new PdVector(3);
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                pdVector.m_data[0] = this.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                pdVector.m_data[1] = this.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                pdVector.m_data[2] = this.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                pcViewerOptions.setViewPoint(pdVector);
                return true;
            }
            if ("ViewCenter".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && "Automatic".equals(streamTokenizer.sval)) {
                    pcViewerOptions.setViewCenter(new PdVector(0.5, 0.5, 0.5));
                } else {
                    PdVector pdVector = new PdVector(3);
                    streamTokenizer.nextToken();
                    pdVector.m_data[0] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    pdVector.m_data[1] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    pdVector.m_data[2] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    pcViewerOptions.setViewCenter(pdVector);
                }
                return true;
            }
            if ("AxesEdge".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                PiVector piVector = new PiVector(6);
                if (streamTokenizer.ttype == -3 && "Automatic".equals(streamTokenizer.sval)) {
                    int n = 0;
                    do {
                        piVector.m_data[n] = -1;
                    } while (++n < 6);
                } else {
                    int n = 0;
                    do {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == -3) {
                            if ("Automatic".equals(streamTokenizer.sval)) {
                                piVector.m_data[n * 2] = -1;
                                piVector.m_data[n * 2 + 1] = -1;
                            } else {
                                piVector.m_data[n * 2] = 0;
                                piVector.m_data[n * 2 + 1] = 0;
                            }
                        } else {
                            streamTokenizer.nextToken();
                            piVector.m_data[n * 2] = (int)streamTokenizer.nval;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            piVector.m_data[n * 2 + 1] = (int)streamTokenizer.nval;
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                    } while (++n < 3);
                }
                pcViewerOptions.setAxesEdge(piVector);
                return true;
            }
            if ("AmbientLight".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                if ("RGBColor".equals(streamTokenizer.sval)) {
                    pcViewerOptions.setAmbientLight(this.readRGBColor(streamTokenizer));
                } else if ("GrayLevel".equals(streamTokenizer.sval)) {
                    pcViewerOptions.setAmbientLight(this.readGrayLevel(streamTokenizer));
                } else if ("Hue".equals(streamTokenizer.sval)) {
                    pcViewerOptions.setAmbientLight(this.readHueColor(streamTokenizer));
                }
                return true;
            }
            if ("BoxRatios".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                PdVector pdVector = new PdVector(3);
                if (streamTokenizer.ttype == -3 && "Automatic".equals(streamTokenizer.sval)) {
                    int n = 0;
                    do {
                        pdVector.m_data[n] = 0.0;
                    } while (++n < 3);
                } else {
                    streamTokenizer.nextToken();
                    pdVector.m_data[0] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    pdVector.m_data[1] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    pdVector.m_data[2] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                }
                pcViewerOptions.setBoundingBoxRatios(pdVector);
                return true;
            }
            if ("Background".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && ("Automatic".equals(streamTokenizer.sval) || "None".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval))) {
                    if ("RGBColor".equals(streamTokenizer.sval)) {
                        pcViewerOptions.setBackgroundColor(this.readRGBColor(streamTokenizer));
                    } else if ("Hue".equals(streamTokenizer.sval)) {
                        pcViewerOptions.setBackgroundColor(this.readHueColor(streamTokenizer));
                    } else if ("GrayLevel".equals(streamTokenizer.sval)) {
                        pcViewerOptions.setBackgroundColor(this.readGrayLevel(streamTokenizer));
                    } else if ("CMYKColor".equals(streamTokenizer.sval)) {
                        pcViewerOptions.setBackgroundColor(this.readCMYKColor(streamTokenizer));
                    }
                }
                return true;
            }
            if ("PolygonIntersections".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval)) {
                    pcViewerOptions.polygonIntersections(true);
                } else {
                    pcViewerOptions.polygonIntersections(false);
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    public Color readGrayLevel(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            double d = this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            return new Color((float)d, (float)d, (float)d);
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return new Color(0.5f, 0.5f, 0.5f);
        }
    }

    protected void readAxesLabel(StreamTokenizer streamTokenizer, PcViewerOptions pcViewerOptions, int n) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            String[] stringArray = new String[n];
            if (streamTokenizer.ttype == -3 && "None".equals(streamTokenizer.sval)) {
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = "";
                    ++n2;
                }
                pcViewerOptions.showAxesLabel(false);
            } else if (streamTokenizer.ttype == 123) {
                int n3 = 0;
                while (n3 < n) {
                    streamTokenizer.nextToken();
                    stringArray[n3] = this.readString(streamTokenizer);
                    streamTokenizer.nextToken();
                    ++n3;
                }
                pcViewerOptions.showAxesLabel(true);
            } else {
                int n4 = 0;
                while (n4 < n - 1) {
                    stringArray[n4] = "";
                    ++n4;
                }
                stringArray[n] = this.readString(streamTokenizer);
                pcViewerOptions.showAxesLabel(true);
            }
            pcViewerOptions.setAxesLabel(stringArray);
            return;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return;
        }
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parseMath(BufferedReader bufferedReader) throws IOException {
        int n;
        int n2;
        StreamTokenizer streamTokenizer;
        try {
            streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.ordinaryChar(91);
            streamTokenizer.ordinaryChar(93);
            streamTokenizer.ordinaryChar(123);
            streamTokenizer.ordinaryChar(125);
            streamTokenizer.ordinaryChar(42);
            streamTokenizer.ordinaryChar(94);
            streamTokenizer.ordinaryChar(44);
            streamTokenizer.parseNumbers();
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.whitespaceChars(92, 92);
            n2 = 0;
            n = 0;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception);
            return false;
        }
        block12: while (true) {
            int n3 = 0;
            block13: do {
                switch (n3 == 0 ? streamTokenizer.nextToken() : n3) {
                    default: {
                        PsDebug.warning("parsing broke abnormally  reading st.sval = " + streamTokenizer.sval + ", st.ttype = " + streamTokenizer.ttype + " Line: " + streamTokenizer.lineno());
                        break;
                    }
                    case -1: {
                        if (n2 != 0) {
                            PsDebug.warning("'}' missing");
                            return false;
                        }
                        if (n == 0) return true;
                        PsDebug.warning("']' missing");
                        return false;
                    }
                    case -3: {
                        n3 = 44;
                        if ("InputForm".equals(streamTokenizer.sval)) continue block13;
                        if ("Graphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 2;
                            if (!this.readGraphics(streamTokenizer)) {
                                PsDebug.warning("failed reading Graphics");
                                return false;
                            }
                            ++this.m_numGraphics;
                            break;
                        }
                        if ("Graphics3D".equals(streamTokenizer.sval)) {
                            this.m_dim = 3;
                            if (!this.readGraphics(streamTokenizer)) {
                                PsDebug.warning("failed reading Graphics3D");
                                return false;
                            }
                            ++this.m_numGraphics;
                            break;
                        }
                        if ("SurfaceGraphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 3;
                            if (!this.readParametricSurface(streamTokenizer)) {
                                PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                return false;
                            }
                            ++this.m_numGraphics;
                            break;
                        }
                        if (!"KeyAnimation".equals(streamTokenizer.sval) && !"Animation".equals(streamTokenizer.sval)) {
                            PsDebug.warning("Unknown command:" + streamTokenizer.sval + " Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        if ("KeyAnimation".equals(streamTokenizer.sval)) {
                            this.m_isKeyAnimation = true;
                        }
                        if ("Animation".equals(streamTokenizer.sval)) {
                            this.m_isAnimation = true;
                        }
                        streamTokenizer.nextToken();
                        while (streamTokenizer.ttype != 93) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != -3 || !"Graphics".equals(streamTokenizer.sval) && !"Graphics3D".equals(streamTokenizer.sval) && !"SurfaceGraphics".equals(streamTokenizer.sval)) {
                                PsDebug.warning("Expected 'Graphics', 'Graphics3D' or 'SurfaceGraphics' Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            if ("Graphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 2;
                                if (!this.readGraphics(streamTokenizer)) {
                                    PsDebug.warning("failed reading Graphics");
                                    return false;
                                }
                                ++this.m_numGraphics;
                            }
                            if ("Graphics3D".equals(streamTokenizer.sval)) {
                                this.m_dim = 3;
                                if (!this.readGraphics(streamTokenizer)) {
                                    PsDebug.warning("failed reading Graphics3D");
                                    return false;
                                }
                                ++this.m_numGraphics;
                            }
                            if ("SurfaceGraphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 3;
                                if (!this.readParametricSurface(streamTokenizer)) {
                                    PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                    return false;
                                }
                                ++this.m_numGraphics;
                            }
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 93) continue;
                            PsDebug.warning("Expected ',' or ']' Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        break;
                    }
                    case 40: {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != 42) {
                            streamTokenizer.pushBack();
                            break;
                        }
                        boolean bl = true;
                        while (bl) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != 42) continue;
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == 41) {
                                bl = false;
                                continue;
                            }
                            streamTokenizer.pushBack();
                        }
                        break;
                    }
                    case 123: {
                        ++n2;
                        break;
                    }
                    case 125: {
                        n3 = 44;
                        if (--n2 >= 0) continue block13;
                        PsDebug.warning("More '}' than '{' Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    case 91: {
                        ++n;
                        break;
                    }
                    case 93: {
                        if (--n < 0) {
                            PsDebug.warning("More ']' than '[' Line: " + streamTokenizer.lineno());
                            return false;
                        }
                    }
                    case 44: 
                }
                continue block12;
            } while (true);
        }
    }

    public String readString(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            String string = new String("");
            while (streamTokenizer.ttype != 34) {
                if (streamTokenizer.ttype == -3) {
                    string = string + streamTokenizer.sval;
                    continue;
                }
                if (streamTokenizer.ttype == -2) {
                    string = string + Double.toString(this.readNumber(streamTokenizer));
                    continue;
                }
                if (streamTokenizer.ttype == 91) {
                    string = string + "[";
                    continue;
                }
                if (streamTokenizer.ttype == 93) {
                    string = string + "]";
                    continue;
                }
                if (streamTokenizer.ttype == 44) {
                    string = string + ",";
                    continue;
                }
                if (streamTokenizer.ttype == 42) {
                    string = string + "*";
                    continue;
                }
                if (streamTokenizer.ttype == 94) {
                    string = string + "^";
                    continue;
                }
                if (streamTokenizer.ttype == 123) {
                    string = string + "{";
                    continue;
                }
                if (streamTokenizer.ttype == 125) {
                    string = string + "}";
                    continue;
                }
                if (streamTokenizer.ttype == 40) {
                    string = string + "(";
                    continue;
                }
                if (streamTokenizer.ttype == 41) {
                    string = string + ")";
                    continue;
                }
                if (streamTokenizer.ttype == 45) {
                    string = string + "-";
                    continue;
                }
                if (streamTokenizer.ttype != 62) continue;
                string = string + ">";
            }
            return string;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return "";
        }
    }

    public Color readHueColor(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            double d = this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            double d2 = this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            double d3 = this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            Color color = new Color(Color.HSBtoRGB((float)d, (float)d2, (float)d3));
            return color;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return new Color(1.0f, 0.0f, 0.0f);
        }
    }

    public Color readCMYKColor(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            PsDebug.warning("Reading of CMYKColor not implemented yet.");
            Color color = new Color(255, 255, 255);
            return color;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return new Color(255, 255, 255);
        }
    }

    public boolean readGraphics(StreamTokenizer streamTokenizer) {
        try {
            Object object;
            Object object2;
            int n;
            PiVector piVector = new PiVector(1);
            piVector.m_data[0] = 255;
            PiVector piVector2 = new PiVector(1);
            piVector2.m_data[0] = 255;
            PiVector piVector3 = new PiVector(1);
            piVector3.m_data[0] = 255;
            PiVector piVector4 = new PiVector(1);
            piVector4.m_data[0] = 255;
            PiVector piVector5 = new PiVector(1);
            piVector5.m_data[0] = 255;
            PiVector piVector6 = new PiVector(1);
            piVector6.m_data[0] = 255;
            PiVector piVector7 = new PiVector(1);
            piVector7.m_data[0] = 255;
            PiVector piVector8 = new PiVector(1);
            piVector8.m_data[0] = 255;
            PiVector piVector9 = new PiVector(1);
            piVector9.m_data[0] = 255;
            PiVector piVector10 = new PiVector(1);
            piVector10.m_data[0] = 255;
            PiVector piVector11 = new PiVector(1);
            piVector11.m_data[0] = 255;
            PiVector piVector12 = new PiVector(1);
            piVector12.m_data[0] = 255;
            PiVector piVector13 = new PiVector(1);
            piVector13.m_data[0] = 255;
            PiVector piVector14 = new PiVector(1);
            piVector14.m_data[0] = 255;
            PiVector piVector15 = new PiVector(1);
            piVector15.m_data[0] = 255;
            PiVector piVector16 = new PiVector(1);
            piVector16.m_data[0] = 1;
            PiVector piVector17 = new PiVector(1);
            piVector17.m_data[0] = 1;
            PiVector piVector18 = new PiVector(1);
            piVector18.m_data[0] = 0;
            PiVector piVector19 = new PiVector(1);
            piVector19.m_data[0] = 0;
            PiVector piVector20 = new PiVector(1);
            piVector20.m_data[0] = 0;
            boolean bl = false;
            boolean bl2 = false;
            Vector<Color> vector = new Vector<Color>();
            Vector<Color> vector2 = new Vector<Color>();
            Vector<Color> vector3 = new Vector<Color>();
            Vector<Color> vector4 = new Vector<Color>();
            Vector<Color> vector5 = new Vector<Color>();
            Vector<Color> vector6 = new Vector<Color>();
            Vector<Color> vector7 = new Vector<Color>();
            PiVector piVector21 = new PiVector();
            PiVector piVector22 = new PiVector();
            Vector<Object> vector8 = new Vector<Object>();
            Vector<Object> vector9 = new Vector<Object>();
            Vector<PdVector> vector10 = new Vector<PdVector>();
            Vector<PgJvxSrc> vector11 = new Vector<PgJvxSrc>();
            Vector<PdVector> vector12 = new Vector<PdVector>();
            Vector<PdVector> vector13 = new Vector<PdVector>();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            boolean bl3 = true;
            double d = 1.0;
            int n8 = 0;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != 91) {
                PsDebug.warning("'['Expected Line: " + streamTokenizer.lineno());
                return false;
            }
            String string = "";
            int n9 = -1;
            while (n9 != 0) {
                P_Vector p_Vector;
                double d2;
                double d3;
                if (n9 == -1) {
                    n9 = 0;
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 123) {
                    if (++n9 + 1 > piVector.getSize()) {
                        piVector.setSize(n9 + 1);
                        piVector2.setSize(n9 + 1);
                        piVector3.setSize(n9 + 1);
                        piVector4.setSize(n9 + 1);
                        piVector5.setSize(n9 + 1);
                        piVector6.setSize(n9 + 1);
                        piVector7.setSize(n9 + 1);
                        piVector8.setSize(n9 + 1);
                        piVector9.setSize(n9 + 1);
                        piVector10.setSize(n9 + 1);
                        piVector11.setSize(n9 + 1);
                        piVector12.setSize(n9 + 1);
                        piVector13.setSize(n9 + 1);
                        piVector14.setSize(n9 + 1);
                        piVector15.setSize(n9 + 1);
                        piVector18.setSize(n9 + 1);
                        piVector19.setSize(n9 + 1);
                        piVector20.setSize(n9 + 1);
                        piVector16.setSize(n9 + 1);
                        piVector17.setSize(n9 + 1);
                    }
                    piVector.m_data[n9] = piVector.m_data[n9 - 1];
                    piVector2.m_data[n9] = piVector2.m_data[n9 - 1];
                    piVector3.m_data[n9] = piVector3.m_data[n9 - 1];
                    piVector4.m_data[n9] = piVector4.m_data[n9 - 1];
                    piVector5.m_data[n9] = piVector5.m_data[n9 - 1];
                    piVector6.m_data[n9] = piVector6.m_data[n9 - 1];
                    piVector7.m_data[n9] = piVector7.m_data[n9 - 1];
                    piVector8.m_data[n9] = piVector8.m_data[n9 - 1];
                    piVector9.m_data[n9] = piVector9.m_data[n9 - 1];
                    piVector10.m_data[n9] = piVector10.m_data[n9 - 1];
                    piVector11.m_data[n9] = piVector11.m_data[n9 - 1];
                    piVector12.m_data[n9] = piVector12.m_data[n9 - 1];
                    piVector13.m_data[n9] = piVector13.m_data[n9 - 1];
                    piVector14.m_data[n9] = piVector14.m_data[n9 - 1];
                    piVector15.m_data[n9] = piVector15.m_data[n9 - 1];
                    piVector18.m_data[n9] = piVector18.m_data[n9 - 1];
                    piVector19.m_data[n9] = piVector19.m_data[n9 - 1];
                    piVector20.m_data[n9] = piVector20.m_data[n9 - 1];
                    piVector16.m_data[n9] = piVector16.m_data[n9 - 1];
                    piVector17.m_data[n9] = piVector17.m_data[n9 - 1];
                    continue;
                }
                if (streamTokenizer.ttype == 125) {
                    --n9;
                    continue;
                }
                if (streamTokenizer.ttype == 44) continue;
                if (streamTokenizer.ttype != -3) {
                    PsDebug.warning("Graphics primitive identifyer expected Line: " + streamTokenizer.lineno());
                    return false;
                }
                if ("Polygon".equals(streamTokenizer.sval)) {
                    int n10;
                    P_Vector p_Vector2;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    int n11 = 0;
                    while (streamTokenizer.ttype != 125) {
                        streamTokenizer.nextToken();
                        p_Vector2 = new PdVector(this.m_dim);
                        n10 = 0;
                        while (n10 < this.m_dim) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != -2) {
                                PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            ((PdVector)p_Vector2).m_data[n10] = this.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            ++n10;
                        }
                        vector8.addElement(p_Vector2);
                        ++n11;
                        ++n2;
                        streamTokenizer.nextToken();
                    }
                    p_Vector2 = new PiVector(n11);
                    n10 = 0;
                    while (n10 < n11) {
                        p_Vector2.m_data[n10] = n8 + n10;
                        ++n10;
                    }
                    n8 += n11;
                    vector9.addElement(p_Vector2);
                    ++n3;
                    streamTokenizer.nextToken();
                    vector.addElement(new Color(piVector4.m_data[n9], piVector5.m_data[n9], piVector6.m_data[n9]));
                    vector2.addElement(new Color(piVector7.m_data[n9], piVector8.m_data[n9], piVector9.m_data[n9]));
                    vector3.addElement(new Color(piVector10.m_data[n9], piVector11.m_data[n9], piVector12.m_data[n9]));
                    vector4.addElement(new Color(piVector13.m_data[n9], piVector14.m_data[n9], piVector15.m_data[n9]));
                    vector5.addElement(new Color(piVector18.m_data[n9], piVector19.m_data[n9], piVector20.m_data[n9]));
                    piVector21.addEntry(piVector16.m_data[n9]);
                    piVector22.addEntry(piVector17.m_data[n9]);
                    continue;
                }
                if ("Point".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    PdVector pdVector = new PdVector(this.m_dim);
                    int n12 = 0;
                    while (n12 < this.m_dim) {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -2) {
                            PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        pdVector.m_data[n12] = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        ++n12;
                    }
                    vector10.addElement(pdVector);
                    ++n4;
                    streamTokenizer.nextToken();
                    vector6.addElement(new Color(piVector.m_data[n9], piVector2.m_data[n9], piVector3.m_data[n9]));
                    continue;
                }
                if ("Line".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    Vector<PdVector> vector14 = new Vector<PdVector>();
                    int n13 = 0;
                    while (streamTokenizer.ttype != 125) {
                        streamTokenizer.nextToken();
                        PdVector pdVector = new PdVector(this.m_dim);
                        n = 0;
                        while (n < this.m_dim) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != -2) {
                                PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            pdVector.m_data[n] = this.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            ++n;
                        }
                        vector14.addElement(pdVector);
                        ++n13;
                        streamTokenizer.nextToken();
                    }
                    PgJvxSrc pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setDimOfVertices(this.m_dim);
                    pgJvxSrc.setNumVertices(n13);
                    n = 0;
                    while (n < n13) {
                        pgJvxSrc.setVertex(n, (PdVector)vector14.elementAt(n));
                        ++n;
                    }
                    ++n5;
                    vector11.addElement(pgJvxSrc);
                    streamTokenizer.nextToken();
                    vector7.addElement(new Color(piVector.m_data[n9], piVector2.m_data[n9], piVector3.m_data[n9]));
                    continue;
                }
                if ("Circle".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    PdVector pdVector = new PdVector(3);
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    pdVector.m_data[0] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    pdVector.m_data[1] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    pdVector.m_data[2] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    ++n6;
                    vector12.addElement(pdVector);
                    continue;
                }
                if ("Disk".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    PdVector pdVector = new PdVector(3);
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    pdVector.m_data[0] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    pdVector.m_data[1] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    pdVector.m_data[2] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    ++n7;
                    vector13.addElement(pdVector);
                    continue;
                }
                if ("Rectangle".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    double d4 = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    double d5 = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    d3 = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    d2 = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        if (this.m_dim != 2) {
                            PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        object2 = new PiVector(4);
                        int n14 = 0;
                        do {
                            object2.m_data[n14] = n8 + n14;
                        } while (++n14 < 4);
                        vector9.addElement(object2);
                        ++n3;
                        PdVector pdVector = new PdVector(2);
                        pdVector.m_data[0] = d4;
                        pdVector.m_data[1] = d5;
                        object = new PdVector(2);
                        object.m_data[0] = d3;
                        object.m_data[1] = d5;
                        PdVector pdVector2 = new PdVector(2);
                        pdVector2.m_data[0] = d3;
                        pdVector2.m_data[1] = d2;
                        p_Vector = new PdVector(2);
                        ((PdVector)p_Vector).m_data[0] = d4;
                        ((PdVector)p_Vector).m_data[1] = d2;
                        vector8.addElement(pdVector);
                        vector8.addElement(object);
                        vector8.addElement(pdVector2);
                        vector8.addElement(p_Vector);
                        n2 += 4;
                        n8 += 4;
                        vector.addElement(new Color(piVector4.m_data[n9], piVector5.m_data[n9], piVector6.m_data[n9]));
                        vector2.addElement(new Color(piVector7.m_data[n9], piVector8.m_data[n9], piVector9.m_data[n9]));
                        vector3.addElement(new Color(piVector10.m_data[n9], piVector11.m_data[n9], piVector12.m_data[n9]));
                        vector4.addElement(new Color(piVector13.m_data[n9], piVector14.m_data[n9], piVector15.m_data[n9]));
                        vector5.addElement(new Color(piVector18.m_data[n9], piVector19.m_data[n9], piVector20.m_data[n9]));
                        piVector21.addEntry(piVector16.m_data[n9]);
                        piVector22.addEntry(piVector17.m_data[n9]);
                        continue;
                    }
                    string = string + "Rectangle[{" + d4 + "," + d5 + "},{" + d3 + "," + d2 + "}" + streamTokenizer.sval;
                    int n15 = 1;
                    while (n15 != 0) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 93) {
                            --n15;
                            string = string + "]";
                        }
                        if (streamTokenizer.ttype == 91) {
                            ++n15;
                            string = string + "[";
                        }
                        if (streamTokenizer.ttype == -3) {
                            string = string + streamTokenizer.sval;
                            continue;
                        }
                        if (streamTokenizer.ttype == -2) {
                            string = string + Double.toString(this.readNumber(streamTokenizer));
                            continue;
                        }
                        if (streamTokenizer.ttype == 123) {
                            string = string + "{";
                            continue;
                        }
                        if (streamTokenizer.ttype == 125) {
                            string = string + "}";
                            continue;
                        }
                        if (streamTokenizer.ttype == 44) {
                            string = string + ",";
                            continue;
                        }
                        if (streamTokenizer.ttype == 42) {
                            string = string + "*";
                            continue;
                        }
                        if (streamTokenizer.ttype != 94) continue;
                        string = string + "^";
                    }
                    continue;
                }
                if ("Cuboid".equals(streamTokenizer.sval)) {
                    double d6;
                    double d7;
                    if (this.m_dim != 3) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    double d8 = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    double d9 = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    d3 = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 44) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -2) {
                            PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        d2 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -2) {
                            PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        d7 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -2) {
                            PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        d6 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                    } else {
                        d2 = d8 + 1.0;
                        d7 = d9 + 1.0;
                        d6 = d3 + 1.0;
                    }
                    p_Vector = new PiVector(4);
                    PiVector piVector23 = new PiVector(4);
                    PiVector piVector24 = new PiVector(4);
                    PiVector piVector25 = new PiVector(4);
                    PiVector piVector26 = new PiVector(4);
                    PiVector piVector27 = new PiVector(4);
                    p_Vector.m_data[0] = n8;
                    p_Vector.m_data[1] = n8 + 4;
                    p_Vector.m_data[2] = n8 + 5;
                    p_Vector.m_data[3] = n8 + 1;
                    piVector23.m_data[0] = n8 + 3;
                    piVector23.m_data[1] = n8 + 2;
                    piVector23.m_data[2] = n8 + 6;
                    piVector23.m_data[3] = n8 + 7;
                    piVector24.m_data[0] = n8;
                    piVector24.m_data[1] = n8 + 1;
                    piVector24.m_data[2] = n8 + 2;
                    piVector24.m_data[3] = n8 + 3;
                    piVector25.m_data[0] = n8 + 4;
                    piVector25.m_data[1] = n8 + 7;
                    piVector25.m_data[2] = n8 + 6;
                    piVector25.m_data[3] = n8 + 5;
                    piVector26.m_data[0] = n8 + 1;
                    piVector26.m_data[1] = n8 + 5;
                    piVector26.m_data[2] = n8 + 6;
                    piVector26.m_data[3] = n8 + 2;
                    piVector27.m_data[0] = n8;
                    piVector27.m_data[1] = n8 + 3;
                    piVector27.m_data[2] = n8 + 7;
                    piVector27.m_data[3] = n8 + 4;
                    vector9.addElement(p_Vector);
                    vector9.addElement(piVector23);
                    vector9.addElement(piVector24);
                    vector9.addElement(piVector25);
                    vector9.addElement(piVector26);
                    vector9.addElement(piVector27);
                    n3 += 6;
                    n8 += 8;
                    PdVector pdVector = new PdVector(3);
                    PdVector pdVector3 = new PdVector(3);
                    PdVector pdVector4 = new PdVector(3);
                    PdVector pdVector5 = new PdVector(3);
                    PdVector pdVector6 = new PdVector(3);
                    PdVector pdVector7 = new PdVector(3);
                    PdVector pdVector8 = new PdVector(3);
                    PdVector pdVector9 = new PdVector(3);
                    pdVector.m_data[0] = d8;
                    pdVector.m_data[1] = d9;
                    pdVector.m_data[2] = d3;
                    pdVector3.m_data[0] = d2;
                    pdVector3.m_data[1] = d9;
                    pdVector3.m_data[2] = d3;
                    pdVector4.m_data[0] = d2;
                    pdVector4.m_data[1] = d9;
                    pdVector4.m_data[2] = d6;
                    pdVector5.m_data[0] = d8;
                    pdVector5.m_data[1] = d9;
                    pdVector5.m_data[2] = d6;
                    pdVector6.m_data[0] = d8;
                    pdVector6.m_data[1] = d7;
                    pdVector6.m_data[2] = d3;
                    pdVector7.m_data[0] = d2;
                    pdVector7.m_data[1] = d7;
                    pdVector7.m_data[2] = d3;
                    pdVector8.m_data[0] = d2;
                    pdVector8.m_data[1] = d7;
                    pdVector8.m_data[2] = d6;
                    pdVector9.m_data[0] = d8;
                    pdVector9.m_data[1] = d7;
                    pdVector9.m_data[2] = d6;
                    vector8.addElement(pdVector);
                    vector8.addElement(pdVector3);
                    vector8.addElement(pdVector4);
                    vector8.addElement(pdVector5);
                    vector8.addElement(pdVector6);
                    vector8.addElement(pdVector7);
                    vector8.addElement(pdVector8);
                    vector8.addElement(pdVector9);
                    n2 += 8;
                    vector.addElement(new Color(piVector4.m_data[n9], piVector5.m_data[n9], piVector6.m_data[n9]));
                    vector2.addElement(new Color(piVector7.m_data[n9], piVector8.m_data[n9], piVector9.m_data[n9]));
                    vector3.addElement(new Color(piVector10.m_data[n9], piVector11.m_data[n9], piVector12.m_data[n9]));
                    vector4.addElement(new Color(piVector13.m_data[n9], piVector14.m_data[n9], piVector15.m_data[n9]));
                    vector5.addElement(new Color(piVector18.m_data[n9], piVector19.m_data[n9], piVector20.m_data[n9]));
                    piVector21.addEntry(piVector16.m_data[n9]);
                    piVector22.addEntry(piVector17.m_data[n9]);
                    continue;
                }
                if ("RGBColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                    bl = true;
                    Color color = new Color(0);
                    if ("RGBColor".equals(streamTokenizer.sval)) {
                        color = this.readRGBColor(streamTokenizer);
                    }
                    if ("GrayLevel".equals(streamTokenizer.sval)) {
                        color = this.readGrayLevel(streamTokenizer);
                    }
                    if ("Hue".equals(streamTokenizer.sval)) {
                        color = this.readHueColor(streamTokenizer);
                    }
                    if ("CMYKColor".equals(streamTokenizer.sval)) {
                        color = this.readGrayLevel(streamTokenizer);
                    }
                    piVector.m_data[n9] = color.getRed();
                    piVector2.m_data[n9] = color.getGreen();
                    piVector3.m_data[n9] = color.getBlue();
                    piVector4.m_data[n9] = piVector.m_data[n9];
                    piVector5.m_data[n9] = piVector2.m_data[n9];
                    piVector6.m_data[n9] = piVector3.m_data[n9];
                    piVector7.m_data[n9] = piVector.m_data[n9];
                    piVector8.m_data[n9] = piVector2.m_data[n9];
                    piVector9.m_data[n9] = piVector3.m_data[n9];
                    piVector10.m_data[n9] = piVector.m_data[n9];
                    piVector11.m_data[n9] = piVector2.m_data[n9];
                    piVector12.m_data[n9] = piVector3.m_data[n9];
                    piVector13.m_data[n9] = piVector.m_data[n9];
                    piVector14.m_data[n9] = piVector2.m_data[n9];
                    piVector15.m_data[n9] = piVector3.m_data[n9];
                    piVector16.m_data[n9] = 1;
                    piVector17.m_data[n9] = 1;
                    continue;
                }
                if ("SurfaceColor".equals(streamTokenizer.sval)) {
                    bl = true;
                    Color[] colorArray = new Color[2];
                    piVector16.m_data[n9] = this.readSurfaceColor(streamTokenizer, colorArray);
                    Color color = colorArray[0];
                    Color color2 = colorArray[1];
                    piVector17.m_data[n9] = piVector16.m_data[n9];
                    piVector4.m_data[n9] = color.getRed();
                    piVector5.m_data[n9] = color.getGreen();
                    piVector6.m_data[n9] = color.getBlue();
                    piVector7.m_data[n9] = piVector4.m_data[n9];
                    piVector8.m_data[n9] = piVector5.m_data[n9];
                    piVector9.m_data[n9] = piVector6.m_data[n9];
                    piVector10.m_data[n9] = color2.getRed();
                    piVector11.m_data[n9] = color2.getGreen();
                    piVector12.m_data[n9] = color2.getBlue();
                    piVector13.m_data[n9] = piVector10.m_data[n9];
                    piVector14.m_data[n9] = piVector11.m_data[n9];
                    piVector15.m_data[n9] = piVector12.m_data[n9];
                    continue;
                }
                if ("EdgeForm".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        bl3 = false;
                    }
                    while (streamTokenizer.ttype != 93) {
                        if (streamTokenizer.ttype != -3) continue;
                        if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                            bl2 = true;
                            Color color = new Color(0);
                            if ("RGBColor".equals(streamTokenizer.sval)) {
                                color = this.readRGBColor(streamTokenizer);
                            }
                            if ("CMYKColor".equals(streamTokenizer.sval)) {
                                color = this.readCMYKColor(streamTokenizer);
                            }
                            if ("Hue".equals(streamTokenizer.sval)) {
                                color = this.readHueColor(streamTokenizer);
                            }
                            if ("GrayLevel".equals(streamTokenizer.sval)) {
                                color = this.readGrayLevel(streamTokenizer);
                            }
                            piVector18.m_data[n9] = color.getRed();
                            piVector19.m_data[n9] = color.getGreen();
                            piVector20.m_data[n9] = color.getBlue();
                        }
                        if (!"Thickness".equals(streamTokenizer.sval)) continue;
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        d = 1000.0 * this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                    }
                    continue;
                }
                if ("FaceForm".equals(streamTokenizer.sval)) {
                    Object object3;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                        PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                    }
                    bl = true;
                    if ("SurfaceColor".equals(streamTokenizer.sval)) {
                        object3 = new Color[2];
                        piVector16.m_data[n9] = this.readSurfaceColor(streamTokenizer, (Color[])object3);
                        Color color = object3[0];
                        Color color3 = object3[1];
                        piVector4.m_data[n9] = color.getRed();
                        piVector5.m_data[n9] = color.getGreen();
                        piVector6.m_data[n9] = color.getBlue();
                        piVector10.m_data[n9] = color3.getRed();
                        piVector11.m_data[n9] = color3.getGreen();
                        piVector12.m_data[n9] = color3.getBlue();
                    } else {
                        object3 = new Color(0);
                        if ("RGBColor".equals(streamTokenizer.sval)) {
                            object3 = this.readRGBColor(streamTokenizer);
                        }
                        if ("GrayLevel".equals(streamTokenizer.sval)) {
                            object3 = this.readGrayLevel(streamTokenizer);
                        }
                        if ("Hue".equals(streamTokenizer.sval)) {
                            object3 = this.readHueColor(streamTokenizer);
                        }
                        if ("CMYKColor".equals(streamTokenizer.sval)) {
                            object3 = this.readGrayLevel(streamTokenizer);
                        }
                        piVector4.m_data[n9] = ((Color)object3).getRed();
                        piVector5.m_data[n9] = ((Color)object3).getGreen();
                        piVector6.m_data[n9] = ((Color)object3).getBlue();
                        piVector10.m_data[n9] = piVector4.m_data[n9];
                        piVector11.m_data[n9] = piVector5.m_data[n9];
                        piVector12.m_data[n9] = piVector6.m_data[n9];
                        piVector16.m_data[n9] = 1;
                    }
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                        PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                    }
                    if ("SurfaceColor".equals(streamTokenizer.sval)) {
                        object3 = new Color[2];
                        piVector17.m_data[n9] = this.readSurfaceColor(streamTokenizer, (Color[])object3);
                        Object object4 = object3[0];
                        Object object5 = object3[1];
                        piVector7.m_data[n9] = ((Color)object4).getRed();
                        piVector8.m_data[n9] = ((Color)object4).getGreen();
                        piVector9.m_data[n9] = ((Color)object4).getBlue();
                        piVector13.m_data[n9] = ((Color)object5).getRed();
                        piVector14.m_data[n9] = ((Color)object5).getGreen();
                        piVector15.m_data[n9] = ((Color)object5).getBlue();
                    } else {
                        object3 = new Color(0);
                        if ("RGBColor".equals(streamTokenizer.sval)) {
                            object3 = this.readRGBColor(streamTokenizer);
                        }
                        if ("GrayLevel".equals(streamTokenizer.sval)) {
                            object3 = this.readGrayLevel(streamTokenizer);
                        }
                        if ("Hue".equals(streamTokenizer.sval)) {
                            object3 = this.readHueColor(streamTokenizer);
                        }
                        if ("CMYKColor".equals(streamTokenizer.sval)) {
                            object3 = this.readGrayLevel(streamTokenizer);
                        }
                        piVector7.m_data[n9] = ((Color)object3).getRed();
                        piVector8.m_data[n9] = ((Color)object3).getGreen();
                        piVector9.m_data[n9] = ((Color)object3).getBlue();
                        piVector13.m_data[n9] = piVector7.m_data[n9];
                        piVector14.m_data[n9] = piVector8.m_data[n9];
                        piVector15.m_data[n9] = piVector9.m_data[n9];
                        piVector17.m_data[n9] = 1;
                    }
                    streamTokenizer.nextToken();
                    continue;
                }
                PsDebug.warning("skipping " + streamTokenizer.sval + " Line: " + streamTokenizer.lineno());
                string = string + streamTokenizer.sval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 91) {
                    PsDebug.warning("'[' expected Line: " + streamTokenizer.lineno());
                    return false;
                }
                int n16 = 1;
                string = string + "[";
                while (n16 != 0) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        --n16;
                        string = string + "]";
                    }
                    if (streamTokenizer.ttype == 91) {
                        ++n16;
                        string = string + "[";
                    }
                    if (streamTokenizer.ttype == -3) {
                        string = string + streamTokenizer.sval;
                        continue;
                    }
                    if (streamTokenizer.ttype == -2) {
                        string = string + Double.toString(this.readNumber(streamTokenizer));
                        continue;
                    }
                    if (streamTokenizer.ttype == 123) {
                        string = string + "{";
                        continue;
                    }
                    if (streamTokenizer.ttype == 125) {
                        string = string + "}";
                        continue;
                    }
                    if (streamTokenizer.ttype == 44) {
                        string = string + ",";
                        continue;
                    }
                    if (streamTokenizer.ttype == 42) {
                        string = string + "*";
                        continue;
                    }
                    if (streamTokenizer.ttype != 94) continue;
                    string = string + "^";
                }
            }
            PgMathData pgMathData = new PgMathData();
            int n17 = 0;
            if (n3 != 0) {
                ++n17;
            }
            if (n4 != 0) {
                ++n17;
            }
            if (n5 != 0) {
                ++n17;
            }
            this.m_geom = new PgJvxSrc[n17];
            PiVector piVector28 = new PiVector(n17);
            n = 0;
            if (n3 != 0) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n2);
                int n18 = 0;
                while (n18 < n2) {
                    pgJvxSrc.setVertex(n18, (PdVector)vector8.elementAt(n18));
                    ++n18;
                }
                pgJvxSrc.setDimOfElements(-1);
                pgJvxSrc.setNumElements(n3);
                n18 = 0;
                while (n18 < n3) {
                    pgJvxSrc.setElement(n18, (PiVector)vector9.elementAt(n18));
                    ++n18;
                }
                pgJvxSrc.assureNeighbours();
                if (bl3) {
                    pgJvxSrc.showEdges(true);
                } else {
                    pgJvxSrc.showEdges(false);
                }
                pgJvxSrc.setGlobalEdgeSize(d);
                if (bl) {
                    Color[] colorArray = new Color[n3];
                    Color[] colorArray2 = new Color[n3];
                    Color[] colorArray3 = new Color[n3];
                    object2 = new Color[n3];
                    int n19 = 0;
                    while (n19 < n3) {
                        colorArray[n19] = (Color)vector.elementAt(n19);
                        colorArray2[n19] = (Color)vector2.elementAt(n19);
                        colorArray3[n19] = (Color)vector3.elementAt(n19);
                        object2[n19] = (Color)vector4.elementAt(n19);
                        ++n19;
                    }
                    pgJvxSrc.setElementColors(colorArray);
                    if (bl2) {
                        Color[] colorArray4 = new Color[n3];
                        int n20 = 0;
                        while (n20 < n3) {
                            colorArray4[n20] = (Color)vector5.elementAt(n20);
                            ++n20;
                        }
                    }
                }
                this.m_geom[n] = pgJvxSrc;
                this.m_geom[n].setName("ElementSet imported from Mathematica");
                piVector28.m_data[n] = 33;
                ++n;
            }
            if (n4 != 0) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n4);
                int n21 = 0;
                while (n21 < n4) {
                    pgJvxSrc.setVertex(n21, (PdVector)vector10.elementAt(n21));
                    ++n21;
                }
                if (bl) {
                    Color[] colorArray = new Color[n4];
                    int n22 = 0;
                    while (n22 < n4) {
                        colorArray[n22] = (Color)vector6.elementAt(n22);
                        ++n22;
                    }
                    pgJvxSrc.setVertexColors(colorArray);
                }
                this.m_geom[n] = pgJvxSrc;
                this.m_geom[n].setName("PointSet imported from Mathematica");
                piVector28.m_data[n] = 30;
                ++n;
            }
            if (n5 != 0) {
                PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[n5];
                int n23 = 0;
                int n24 = 0;
                while (n24 < n5) {
                    pgJvxSrcArray[n24] = (PgJvxSrc)vector11.elementAt(n24);
                    n23 += pgJvxSrcArray[n24].getNumVertices();
                    ++n24;
                }
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n23);
                int n25 = 0;
                int n26 = 0;
                while (n26 < n5) {
                    int n27 = pgJvxSrcArray[n26].getNumVertices();
                    object = pgJvxSrcArray[n26].getVertices();
                    int n28 = 0;
                    while (n28 < n27) {
                        pgJvxSrc.setVertex(n25, object[n28]);
                        ++n25;
                        ++n28;
                    }
                    ++n26;
                }
                pgJvxSrc.setDimOfPolygons(-1);
                pgJvxSrc.setNumPolygons(n5);
                object2 = pgJvxSrc.getPolygons();
                int n29 = 0;
                int n30 = 0;
                while (n30 < n5) {
                    int n31 = pgJvxSrcArray[n30].getNumVertices();
                    ((PiVector)object2[n30]).setSize(n31);
                    int n32 = 0;
                    while (n32 < n31) {
                        ((PiVector)object2[n30]).m_data[n32] = n32 + n29;
                        ++n32;
                    }
                    n29 += n31;
                    ++n30;
                }
                if (bl) {
                    Color[] colorArray = new Color[n5];
                    int n33 = 0;
                    while (n33 < n5) {
                        colorArray[n33] = (Color)vector7.elementAt(n33);
                        ++n33;
                    }
                    pgJvxSrc.setPolygonColors(colorArray);
                }
                this.m_geom[n] = pgJvxSrc;
                this.m_geom[n].setName("PgPolygonSet imported from Mathematica");
                piVector28.m_data[n] = 32;
                ++n;
            }
            pgMathData.setDim(this.m_dim);
            pgMathData.setGeom(this.m_geom, piVector28);
            if (n6 != 0) {
                this.m_circle = new PdVector[n6];
                int n34 = 0;
                while (n34 < n6) {
                    this.m_circle[n34] = new PdVector(3);
                    this.m_circle[n34].copy((PdVector)vector12.elementAt(n34));
                    ++n34;
                }
                pgMathData.setCircles(this.m_circle);
            }
            if (n7 != 0) {
                this.m_disk = new PdVector[n7];
                int n35 = 0;
                while (n35 < n7) {
                    this.m_disk[n35] = new PdVector(3);
                    this.m_disk[n35].copy((PdVector)vector13.elementAt(n35));
                    ++n35;
                }
                pgMathData.setDisks(this.m_disk);
            }
            this.mathVector.addElement(pgMathData);
            PcViewerOptions pcViewerOptions = new PcViewerOptions();
            this.setDefaultOptions(pcViewerOptions);
            streamTokenizer.nextToken();
            int n36 = 1;
            while (n36 != 0) {
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                    return false;
                }
                if (streamTokenizer.ttype == 93) {
                    --n36;
                }
                if (streamTokenizer.ttype == 91) {
                    ++n36;
                }
                if (streamTokenizer.ttype == -3 && !this.readOptions(streamTokenizer, pcViewerOptions) && "AxesLabel".equals(streamTokenizer.sval)) {
                    this.readAxesLabel(streamTokenizer, pcViewerOptions, this.m_dim);
                }
                streamTokenizer.ordinaryChar(45);
                streamTokenizer.nextToken();
            }
            pgMathData.setOptions(pcViewerOptions);
            pgMathData.setText(string);
            streamTokenizer.parseNumbers();
            streamTokenizer.pushBack();
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }
}

