/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgObjLoader {
    protected int m_numVertices = 0;
    protected int m_numVertexNormals = 0;
    protected int m_numVertexTextures = 0;
    protected int m_numVertexVectors = 0;
    protected int m_numPolygons = 0;
    protected int m_numElements = 0;
    protected int m_numMeshType = 0;
    protected Vector m_vVertex;
    protected Vector m_vVertexColor;
    protected PiVector m_vVertexColorInd;
    protected Vector m_vVertexNormal;
    protected Vector m_vVertexTexture;
    protected Vector m_vVertexVector;
    protected int[] m_meshType;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected Vector m_vElementColor;
    protected PiVector m_vElementColorInd;
    protected Vector m_vElementNormal;
    protected int m_dimOfPolygons = -1;
    protected Vector m_vPolygon;
    protected Vector m_vPolygonColor;
    protected PiVector m_vPolygonColorInd;
    private static final String StrNL = "\n";
    protected static boolean m_bVertexNormals = false;
    protected static boolean m_bVertexTextures = false;
    protected static boolean m_bVertexVector = false;
    protected static boolean m_bElements = false;
    protected static boolean m_bPolygons = false;
    protected static boolean m_bPolygonColors = false;
    protected static boolean m_bPolygonNormals = false;

    protected static String writePolygons(int n, PiVector[] piVectorArray) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# Polygon List\n");
        stringBuffer.append("# Number of Polygons = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("l  ");
            if (piVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                int n4 = piVectorArray[n2].m_data[n3] + 1;
                stringBuffer.append(n4);
                if (m_bPolygonNormals) {
                    stringBuffer.append("/" + n4);
                }
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parse(BufferedReader var1_1) throws IOException {
        block51: {
            var2_2 = 3;
            var3_3 = 200;
            var4_4 = 4;
            var5_5 = 5;
            var6_6 = new float[var2_2];
            var7_7 = new double[var4_4];
            var8_8 = new double[var4_4];
            var9_9 = new double[var4_4];
            var10_10 = new double[var4_4];
            var11_11 = new int[var3_3];
            var12_12 = new int[var3_3];
            var13_13 = new int[var3_3];
            var14_14 = new int[var3_3];
            this.m_vVertex = new Vector<E>();
            this.m_vVertexColor = new Vector<E>();
            this.m_vVertexColorInd = new PiVector();
            this.m_vVertexNormal = new Vector<E>();
            this.m_vVertexTexture = new Vector<E>();
            this.m_vVertexVector = new Vector<E>();
            this.m_vElement = new Vector<E>();
            this.m_vElementColor = new Vector<E>();
            this.m_vElementColorInd = new PiVector();
            this.m_vElementNormal = new Vector<E>();
            this.m_vPolygon = new Vector<E>();
            this.m_vPolygonColor = new Vector<E>();
            this.m_vPolygonColorInd = new PiVector();
            var16_15 = 1;
            try {
                var17_16 = new StreamTokenizer(var1_1);
                var17_16.eolIsSignificant(true);
                var17_16.ordinaryChars(47, 47);
                var17_16.commentChar(35);
                this.m_numVertices = 0;
                this.m_numVertexNormals = 0;
                this.m_numVertexTextures = 0;
                this.m_numElements = 0;
                block7: while (true) {
                    switch (var17_16.nextToken()) {
                        default: {
                            PsDebug.warning("parsing broke abnormally in line=" + var16_15 + " reading st.sval=" + var17_16.sval + ", st.ttype=" + var17_16.ttype);
                            return false;
                        }
                        case 10: {
                            ++var16_15;
                            continue block7;
                        }
                        case -3: {
                            if (!"mt".equals(var17_16.sval)) ** GOTO lbl54
                            this.m_numMeshType = 0;
                            this.m_meshType = new int[var5_5];
                            while (var17_16.nextToken() == -2) {
                                this.m_meshType[this.m_numMeshType] = (int)var17_16.nval;
                                ++this.m_numMeshType;
                            }
                            ** GOTO lbl226
lbl54:
                            // 1 sources

                            if (!"v".equals(var17_16.sval)) ** GOTO lbl68
                            var15_18 = 0;
                            while (var17_16.nextToken() == -2) {
                                var7_7[var15_18] = PgLoader.parseDouble(var17_16);
                                ++var15_18;
                            }
                            if (var15_18 > 0) {
                                ++this.m_numVertices;
                                var18_19 = new PdVector(var15_18);
                                var18_19.copy(var7_7, var15_18);
                                this.m_vVertex.addElement(var18_19);
                            } else {
                                PsDebug.warning("vertex with no coords in line=" + var16_15);
                            }
                            ** GOTO lbl226
lbl68:
                            // 1 sources

                            if (!"vc".equals(var17_16.sval)) ** GOTO lbl84
                            var15_18 = 0;
                            while (var17_16.nextToken() == -2) {
                                var6_6[var15_18] = (float)PgLoader.parseDouble(var17_16);
                                ++var15_18;
                            }
                            if (var15_18 == 3) {
                                var18_19 = new Color(var6_6[0], var6_6[1], var6_6[2]);
                                if (this.m_vVertexColorInd.getSize() <= this.m_vVertexColor.size() + 1) {
                                    this.m_vVertexColorInd.setSize(this.m_vVertexColor.size() + 1000);
                                }
                                this.m_vVertexColorInd.setEntry(this.m_vVertexColor.size(), this.m_numVertices);
                                this.m_vVertexColor.addElement(var18_19);
                            } else {
                                PsDebug.warning("vertex color with wrong num coords in line=" + var16_15);
                            }
                            ** GOTO lbl226
lbl84:
                            // 1 sources

                            if (!"vn".equals(var17_16.sval)) ** GOTO lbl98
                            var15_18 = 0;
                            while (var17_16.nextToken() == -2) {
                                var8_8[var15_18] = PgLoader.parseDouble(var17_16);
                                ++var15_18;
                            }
                            if (var15_18 > 0) {
                                ++this.m_numVertexNormals;
                                var18_19 = new PdVector(var15_18);
                                var18_19.copy(var8_8, var15_18);
                                this.m_vVertexNormal.addElement(var18_19);
                            } else {
                                PsDebug.warning("vertex normal with no coords in line=" + var16_15);
                            }
                            ** GOTO lbl226
lbl98:
                            // 1 sources

                            if (!"vt".equals(var17_16.sval)) ** GOTO lbl111
                            var15_18 = 0;
                            while (var17_16.nextToken() == -2) {
                                var9_9[var15_18++] = PgLoader.parseDouble(var17_16);
                            }
                            if (var15_18 > 0) {
                                ++this.m_numVertexTextures;
                                var18_19 = new PdVector(var15_18);
                                var18_19.copy(var9_9, var15_18);
                                this.m_vVertexTexture.addElement(var18_19);
                            } else {
                                PsDebug.warning("vertex texture with no coords in line=" + var16_15);
                            }
                            ** GOTO lbl226
lbl111:
                            // 1 sources

                            if (!"vd".equals(var17_16.sval)) ** GOTO lbl124
                            var15_18 = 0;
                            while (var17_16.nextToken() == -2) {
                                var10_10[var15_18++] = PgLoader.parseDouble(var17_16);
                            }
                            if (var15_18 > 0) {
                                ++this.m_numVertexVectors;
                                var18_19 = new PdVector(var15_18);
                                var18_19.copy(var10_10, var15_18);
                                this.m_vVertexVector.addElement(var18_19);
                            } else {
                                PsDebug.warning("vertex user data with no values in line=" + var16_15);
                            }
                            ** GOTO lbl226
lbl124:
                            // 1 sources

                            if (!"f".equals(var17_16.sval) && !"fo".equals(var17_16.sval)) ** GOTO lbl166
                            var15_18 = 0;
                            while (var17_16.nextToken() == -2) {
                                var11_11[var15_18] = (int)var17_16.nval - 1;
                                var17_16.nextToken();
                                if (var17_16.ttype != 47) ** GOTO lbl151
                                if (var17_16.nextToken() != -2) ** GOTO lbl143
                                var13_13[var15_18] = (int)var17_16.nval - 1;
                                var17_16.nextToken();
                                if (var17_16.ttype != 47) ** GOTO lbl141
                                if (var17_16.nextToken() == -2) {
                                    var12_12[var15_18] = (int)var17_16.nval - 1;
                                } else {
                                    PsDebug.warning("PgObjLoader: parse error of face in line=" + var16_15);
                                    break;
lbl141:
                                    // 1 sources

                                    var17_16.pushBack();
                                }
                                ** GOTO lbl152
lbl143:
                                // 1 sources

                                if (var17_16.ttype != 47) ** GOTO lbl149
                                if (var17_16.nextToken() == -2) {
                                    var12_12[var15_18] = (int)var17_16.nval - 1;
                                } else {
                                    PsDebug.warning("PgObjLoader: parse error of face in line=" + var16_15);
                                    break;
lbl149:
                                    // 1 sources

                                    PsDebug.warning("PgObjLoader: parse error in face/ = " + this.m_numElements + "/" + var15_18);
                                    break;
lbl151:
                                    // 1 sources

                                    var17_16.pushBack();
                                }
lbl152:
                                // 4 sources

                                ++var15_18;
                            }
                            if (var15_18 > 0) {
                                ++this.m_numElements;
                                var18_19 = new PiVector(var15_18);
                                var18_19.copy(var11_11, var15_18);
                                this.m_vElement.addElement(var18_19);
                            } else {
                                PsDebug.warning("face with no vertex in line=" + var16_15);
                            }
                            while (var17_16.ttype != 10 && var17_16.ttype != -1) {
                                var17_16.nextToken();
                            }
                            ** GOTO lbl226
lbl166:
                            // 1 sources

                            if (!"l".equals(var17_16.sval) && !"lo".equals(var17_16.sval)) ** GOTO lbl208
                            var15_18 = 0;
                            while (var17_16.nextToken() == -2) {
                                var14_14[var15_18] = (int)var17_16.nval - 1;
                                var17_16.nextToken();
                                if (var17_16.ttype != 47) ** GOTO lbl193
                                if (var17_16.nextToken() != -2) ** GOTO lbl185
                                var13_13[var15_18] = (int)var17_16.nval - 1;
                                var17_16.nextToken();
                                if (var17_16.ttype != 47) ** GOTO lbl183
                                if (var17_16.nextToken() == -2) {
                                    var12_12[var15_18] = (int)var17_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of polygon in line=" + var16_15);
                                    break;
lbl183:
                                    // 1 sources

                                    var17_16.pushBack();
                                }
                                ** GOTO lbl194
lbl185:
                                // 1 sources

                                if (var17_16.ttype != 47) ** GOTO lbl191
                                if (var17_16.nextToken() == -2) {
                                    var12_12[var15_18] = (int)var17_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of polygon in line=" + var16_15);
                                    break;
lbl191:
                                    // 1 sources

                                    PsDebug.warning("parse error in polygon/ = " + this.m_numPolygons + "/" + var15_18);
                                    break;
lbl193:
                                    // 1 sources

                                    var17_16.pushBack();
                                }
lbl194:
                                // 4 sources

                                ++var15_18;
                            }
                            if (var15_18 > 0) {
                                ++this.m_numPolygons;
                                var18_19 = new PiVector(var15_18);
                                var18_19.copy(var14_14, var15_18);
                                this.m_vPolygon.addElement(var18_19);
                            } else {
                                PsDebug.warning("polygon with no vertex in line=" + var16_15);
                            }
                            while (var17_16.ttype != 10 && var17_16.ttype != -1) {
                                var17_16.nextToken();
                            }
                            ** GOTO lbl226
lbl208:
                            // 1 sources

                            if ("lc".equals(var17_16.sval)) {
                                var15_18 = 0;
                                while (var17_16.nextToken() == -2) {
                                    var6_6[var15_18] = (float)PgLoader.parseDouble(var17_16);
                                    ++var15_18;
                                }
                                if (var15_18 == 3) {
                                    var18_19 = new Color(var6_6[0], var6_6[1], var6_6[2]);
                                    if (this.m_vPolygonColorInd.getSize() <= this.m_vPolygonColor.size() + 1) {
                                        this.m_vPolygonColorInd.setSize(this.m_vPolygonColor.size() + 1000);
                                    }
                                    this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
                                    this.m_vPolygonColor.addElement(var18_19);
                                } else {
                                    PsDebug.warning("polygon color with wrong num coords in line=" + var16_15);
                                }
                            } else if ("g".equals(var17_16.sval)) {
                                // empty if block
                            }
lbl226:
                            // 19 sources

                            while (var17_16.ttype != 10 && var17_16.ttype != -1) {
                                var17_16.nextToken();
                            }
                            ++var16_15;
                            continue block7;
                        }
                        case -1: {
                            if (this.m_vVertexColorInd.getSize() <= 0) break block51;
                        }
                    }
                    break;
                }
            }
            catch (Exception var17_17) {
                PsDebug.warning("Exception thrown in line=" + var16_15 + ", Exception = " + var17_17);
                return false;
            }
            this.m_vVertexColorInd.setEntry(this.m_vVertexColor.size(), this.m_numVertices);
        }
        if (this.m_vElementColorInd.getSize() > 0) {
            this.m_vElementColorInd.setEntry(this.m_vElementColor.size(), this.m_numElements);
        }
        if (this.m_vPolygonColorInd.getSize() > 0) {
            this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
        }
        return true;
    }

    protected static String writePdVectors(String string, String string2, int n, PdVector[] pdVectorArray) {
        if (n <= 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# " + string + " List\n");
        stringBuffer.append("# Number of " + string + "s = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string2 + " ");
            if (pdVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < pdVectorArray[n2].m_data.length) {
                if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                    stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                } else {
                    stringBuffer.append(0.0f);
                }
                if (n3 < pdVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PgJvxSrc read(String string) {
        int n;
        Enumeration enumeration;
        Object object;
        PdVector[] pdVectorArray;
        int n2;
        PgJvxSrc pgJvxSrc;
        BufferedReader bufferedReader;
        block47: {
            PgJvxSrc pgJvxSrc2;
            bufferedReader = PsUtil.open(string);
            if (bufferedReader == null) {
                PsDebug.warning("could not open = " + string, this);
                return null;
            }
            pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setName(PsUtil.getFileBaseName(string));
            try {
                try {
                    n2 = this.parse(bufferedReader);
                    if (n2 != 0) break block47;
                    PsDebug.warning("error when reading file = " + string, this);
                    pgJvxSrc2 = null;
                    Object var12_9 = null;
                }
                catch (IOException iOException) {
                    PsDebug.warning("error when reading file = " + string, this);
                    iOException.printStackTrace();
                    PgJvxSrc pgJvxSrc3 = null;
                    Object var12_10 = null;
                    try {
                        bufferedReader.close();
                        return pgJvxSrc3;
                    }
                    catch (IOException iOException2) {}
                    return pgJvxSrc3;
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {}
                catch (IOException iOException) {}
                bufferedReader.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedReader.close();
            return pgJvxSrc2;
        }
        Object var12_11 = null;
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        if (this.m_numMeshType > 0 && this.m_meshType[0] == 1) {
            switch (this.m_meshType[1]) {
                case 1: {
                    pgJvxSrc.setType(32);
                    break;
                }
                case 2: {
                    pgJvxSrc.setType(33);
                    break;
                }
                case 3: {
                    pgJvxSrc.setType(34);
                    break;
                }
                default: {
                    pgJvxSrc.setType(30);
                    break;
                }
            }
        } else if (this.m_numElements > 0) {
            pgJvxSrc.setType(33);
        } else if (this.m_numPolygons > 0) {
            pgJvxSrc.setType(32);
        } else {
            pgJvxSrc.setType(30);
        }
        if (this.m_numVertices > 0) {
            pdVectorArray = (PdVector[])this.m_vVertex.elementAt(0);
            pgJvxSrc.setDimOfVertices(pdVectorArray.getSize());
            pgJvxSrc.setNumVertices(this.m_numVertices);
            object = pgJvxSrc.getVertices();
            n2 = 0;
            enumeration = this.m_vVertex.elements();
            while (enumeration.hasMoreElements()) {
                ((PdVector)object[n2++]).copy((PdVector)enumeration.nextElement());
            }
        }
        if (this.m_numVertexNormals > 0) {
            if (this.m_numVertexNormals == this.m_numVertices) {
                pgJvxSrc.assureVertexNormals();
                pdVectorArray = pgJvxSrc.getVertexNormals();
                n2 = 0;
                object = this.m_vVertexNormal.elements();
                while (object.hasMoreElements()) {
                    pdVectorArray[n2++].copy((PdVector)object.nextElement());
                }
            } else {
                PsDebug.warning("0!=numVertexNormals=" + this.m_numVertexNormals + " != " + this.m_numVertices + "=numVertices");
            }
        }
        if (this.m_numVertexTextures > 0) {
            if (this.m_numVertexTextures == this.m_numVertices) {
                pgJvxSrc.assureVertexTextures();
                pdVectorArray = pgJvxSrc.getVertexTextures();
                n2 = 0;
                object = this.m_vVertexTexture.elements();
                while (object.hasMoreElements()) {
                    pdVectorArray[n2++].copy((PdVector)object.nextElement());
                }
            } else {
                PsDebug.warning("0!=numVertexTextures != numVertices");
            }
        }
        if (this.m_numVertexVectors > 0) {
            if (this.m_numVertexVectors % this.m_numVertices == 0) {
                int n3 = this.m_numVertexVectors / this.m_numVertices;
                pgJvxSrc.setNumVectorFields(n3);
                object = this.m_vVertexVector.elements();
                int n4 = 0;
                block17: while (n4 < n3) {
                    PdVector pdVector = (PdVector)this.m_vVertexVector.elementAt(n4 * this.m_numVertices);
                    pgJvxSrc.setNumVectors(n4, this.m_numVertices, pdVector.getSize());
                    PdVector[] pdVectorArray2 = pgJvxSrc.getVectors(n4);
                    n2 = 0;
                    n = 0;
                    while (true) {
                        if (n >= this.m_numVertices) {
                            ++n4;
                            continue block17;
                        }
                        pdVectorArray2[n2++] = (PdVector)object.nextElement();
                        ++n;
                    }
                }
            } else {
                PsDebug.warning("numVertexVectors%numVertices!=0");
            }
        }
        if (this.m_numElements > 0) {
            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
            pgJvxSrc.setNumElements(this.m_numElements);
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            n2 = 0;
            object = this.m_vElement.elements();
            while (object.hasMoreElements()) {
                piVectorArray[n2++].copy((PiVector)object.nextElement());
            }
        }
        if (this.m_numPolygons > 0) {
            pgJvxSrc.setDimOfPolygons(this.m_dimOfPolygons);
            pgJvxSrc.setNumPolygons(this.m_numPolygons);
            PiVector[] piVectorArray = pgJvxSrc.getPolygons();
            n2 = 0;
            object = this.m_vPolygon.elements();
            while (object.hasMoreElements()) {
                piVectorArray[n2++].copy((PiVector)object.nextElement());
            }
        }
        if (this.m_vPolygonColor != null && this.m_vPolygonColor.size() > 0) {
            pgJvxSrc.assurePolygonColors();
            Color[] colorArray = pgJvxSrc.getPolygonColors();
            n2 = 0;
            object = (Color)this.m_vPolygonColor.firstElement();
            n = 0;
            while (true) {
                if (n >= this.m_vPolygonColorInd.getEntry(0)) {
                    enumeration = this.m_vPolygonColor.elements();
                    break;
                }
                colorArray[n] = object;
                ++n;
            }
            block22: while (enumeration.hasMoreElements()) {
                object = (Color)enumeration.nextElement();
                n = this.m_vPolygonColorInd.getEntry(n2);
                while (true) {
                    if (n >= this.m_vPolygonColorInd.getEntry(n2 + 1)) {
                        ++n2;
                        continue block22;
                    }
                    colorArray[n] = object;
                    ++n;
                }
            }
        }
        PgObjLoader.geomInitType(pgJvxSrc);
        return pgJvxSrc;
    }

    public static String write(PgJvxSrc pgJvxSrc) {
        String string;
        int n;
        if (pgJvxSrc == null) {
            PsDebug.warning("missing geometry");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("# Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + StrNL);
        stringBuffer.append("#     File Format = Wavefront OBJ\n");
        stringBuffer.append("#     Geometry    = " + pgJvxSrc.getName() + StrNL);
        stringBuffer.append("#     Date        = " + new Date().toString() + "\n#\n");
        int n2 = pgJvxSrc.getNumVertices();
        stringBuffer.append("#     Number of Vertices = " + n2 + StrNL);
        int n3 = pgJvxSrc.getNumElements();
        if (n3 > 0) {
            stringBuffer.append("#     Number of Elements = " + n3 + StrNL);
        }
        if ((n = pgJvxSrc.getNumPolygons()) > 0) {
            stringBuffer.append("#     Number of Polygons = " + n + StrNL);
        }
        if (pgJvxSrc.getVertexNormals() != null) {
            stringBuffer.append("#     Additional: Vertex Normals\n");
        }
        if (pgJvxSrc.getVertexTextures() != null) {
            stringBuffer.append("#     Additional: Vertex Texture Coordinates\n");
        }
        stringBuffer.append("#\n# End of Header\n");
        stringBuffer.append(PgObjLoader.writePdVectors("Vertex", "v", n2, pgJvxSrc.getVertices()));
        m_bVertexNormals = false;
        if (pgJvxSrc.getVertexNormals() != null && (string = PgObjLoader.writePdVectors("Vertex Normal", "vn", n2, pgJvxSrc.getVertexNormals())) != null) {
            stringBuffer.append(string);
            m_bVertexNormals = true;
        }
        m_bVertexTextures = false;
        if (pgJvxSrc.getVertexTextures() != null && (string = PgObjLoader.writePdVectors("Vertex Texture", "vt", n2, pgJvxSrc.getVertexTextures())) != null) {
            stringBuffer.append(string);
            m_bVertexTextures = true;
        }
        m_bElements = false;
        if (pgJvxSrc.getElements() != null && (string = PgObjLoader.writeElements(n3, pgJvxSrc.getElements())) != null) {
            stringBuffer.append(string);
            m_bElements = true;
        }
        m_bPolygonNormals = false;
        if (pgJvxSrc.getPolygonNormals() != null && (string = PgObjLoader.writePdVectors("Polygon Normal", "ln", n, pgJvxSrc.getPolygonNormals())) != null) {
            stringBuffer.append(string);
            m_bPolygonNormals = true;
        }
        m_bPolygons = false;
        if (pgJvxSrc.getPolygons() != null && (string = PgObjLoader.writePolygons(n, pgJvxSrc.getPolygons())) != null) {
            stringBuffer.append(string);
            m_bPolygons = true;
        }
        return stringBuffer.toString();
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    protected static String writeElements(int n, PiVector[] piVectorArray) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# Face List\n");
        stringBuffer.append("# Number of Faces = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("f  ");
            if (piVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                int n4 = piVectorArray[n2].m_data[n3] + 1;
                stringBuffer.append(n4);
                if (m_bVertexNormals) {
                    stringBuffer.append("/" + n4);
                    if (m_bVertexTextures) {
                        stringBuffer.append("/" + n4);
                    }
                } else if (!m_bVertexNormals && m_bVertexTextures) {
                    stringBuffer.append("//" + n4);
                }
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

