/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Date;
import jv.loader.PgLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgOffLoader {
    private static final String StrNL = "\n";

    protected static boolean parse(BufferedReader bufferedReader, PgJvxSrc pgJvxSrc) throws IOException {
        int n;
        int n2;
        boolean bl;
        int n3 = 4;
        int n4 = 200;
        double[] dArray = new double[n3];
        int[] nArray = new int[n4];
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChars(47, 47);
        streamTokenizer.commentChar(35);
        try {
            bl = true;
            while (bl) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                        return false;
                    }
                    case -3: {
                        if (!"OFF".equals(streamTokenizer.sval)) {
                            PsDebug.warning("magic word 'OFF' missing as first token\n\t First token found = " + streamTokenizer.sval);
                            return false;
                        }
                        bl = false;
                    }
                    case 10: 
                }
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException);
            return false;
        }
        int n5 = 3;
        try {
            bl = true;
            while (bl) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                        return false;
                    }
                    case -2: {
                        pgJvxSrc.setDimOfVertices(n5);
                        pgJvxSrc.setNumVertices((int)streamTokenizer.nval);
                        streamTokenizer.nextToken();
                        pgJvxSrc.setDimOfElements(-1);
                        pgJvxSrc.setNumElements((int)streamTokenizer.nval);
                        streamTokenizer.nextToken();
                        bl = false;
                    }
                    case 10: 
                }
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException);
            return false;
        }
        int n6 = pgJvxSrc.getNumVertices();
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        try {
            bl = true;
            n2 = 0;
            while (n2 < n6) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                        return false;
                    }
                    case -2: {
                        n = 0;
                        dArray[n] = streamTokenizer.nval;
                        ++n;
                        while (streamTokenizer.nextToken() == -2) {
                            dArray[n] = PgLoader.parseDouble(streamTokenizer);
                            ++n;
                        }
                        streamTokenizer.pushBack();
                        if (n > 0) {
                            if (n > n5) {
                                pgJvxSrc.setDimOfVertices(n);
                                pgJvxSrc.setNumVertices(n6);
                                pdVectorArray = pgJvxSrc.getVertices();
                                n5 = n;
                            }
                            pdVectorArray[n2].set(dArray, n);
                            ++n2;
                        } else {
                            PsDebug.warning("vertex with no coords in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                        }
                        bl = false;
                    }
                    case 10: 
                }
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException);
            return false;
        }
        n2 = pgJvxSrc.getNumElements();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        PdVector[] pdVectorArray2 = null;
        try {
            int n7 = 0;
            while (n7 < n2) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning("parsing broke abnormally in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                        return false;
                    }
                    case -2: {
                        n = (int)streamTokenizer.nval;
                        int n8 = 0;
                        while (n8 < n) {
                            if (streamTokenizer.nextToken() != -2) {
                                PsDebug.warning("parse error of face in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                                return false;
                            }
                            nArray[n8] = (int)streamTokenizer.nval;
                            ++n8;
                        }
                        if (n > 0) {
                            piVectorArray[n7].setSize(n);
                            piVectorArray[n7].set(nArray, n);
                            ++n7;
                        } else {
                            PsDebug.warning("face with no vertices in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                        }
                        if (streamTokenizer.nextToken() == -2) {
                            if (pdVectorArray2 == null) {
                                pgJvxSrc.assureElementNormals();
                                pdVectorArray2 = pgJvxSrc.getElementNormals();
                            }
                            n = 3;
                            pdVectorArray2[n7 - 1].m_data[0] = streamTokenizer.nval;
                            n8 = 1;
                            while (n8 < n) {
                                if (streamTokenizer.nextToken() != -2) {
                                    PsDebug.warning("parse error of face in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                                    return false;
                                }
                                pdVectorArray2[n7 - 1].m_data[n8] = streamTokenizer.nval;
                                ++n8;
                            }
                            pdVectorArray2[n7 - 1].normalize();
                            break;
                        }
                        streamTokenizer.pushBack();
                    }
                    case 10: 
                }
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException);
            return false;
        }
        if (pdVectorArray2 == null || pdVectorArray2.length == n2) {
            // empty if block
        }
        return true;
    }

    public static PgJvxSrc read(String string) {
        if (string == null) {
            PsDebug.warning("missing file name.");
            return null;
        }
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        PgJvxSrc pgJvxSrc = PgOffLoader.read(bufferedReader);
        if (pgJvxSrc == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        pgJvxSrc.setName(PsUtil.getFileBaseName(string));
        return pgJvxSrc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PgJvxSrc read(BufferedReader bufferedReader) {
        PgJvxSrc pgJvxSrc;
        block10: {
            PgJvxSrc pgJvxSrc2;
            if (bufferedReader == null) {
                PsDebug.warning("missing buffered reader, could not open.");
                return null;
            }
            pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setType(33);
            try {
                try {
                    boolean bl = PgOffLoader.parse(bufferedReader, pgJvxSrc);
                    if (bl) break block10;
                    PsDebug.warning("error when reading input");
                    pgJvxSrc2 = null;
                    Object var4_7 = null;
                }
                catch (IOException iOException) {
                    PsDebug.warning("error when reading input");
                    iOException.printStackTrace();
                    PgJvxSrc pgJvxSrc3 = null;
                    Object var4_8 = null;
                    try {
                        bufferedReader.close();
                        return pgJvxSrc3;
                    }
                    catch (IOException iOException2) {}
                    return pgJvxSrc3;
                }
            }
            catch (Throwable throwable) {
                Object var4_10 = null;
                try {}
                catch (IOException iOException) {}
                bufferedReader.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedReader.close();
            return pgJvxSrc2;
        }
        Object var4_9 = null;
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        PgOffLoader.geomInitType(pgJvxSrc);
        return pgJvxSrc;
    }

    public static String write(PgJvxSrc pgJvxSrc) {
        if (pgJvxSrc == null) {
            PsDebug.warning("missing geometry");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("OFF\n");
        stringBuffer.append("# ---- Remove following lines starting with '#' to have a valid OFF file --------\n");
        stringBuffer.append("#\n");
        stringBuffer.append("# Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + StrNL);
        stringBuffer.append("#     File Format = Geometry Center OFF\n");
        stringBuffer.append("#     Geometry    = " + pgJvxSrc.getName() + StrNL);
        stringBuffer.append("#     Date        = " + new Date().toString() + "\n#\n");
        int n = pgJvxSrc.getNumVertices();
        stringBuffer.append("#     Number of Vertices = " + n + StrNL);
        int n2 = pgJvxSrc.getNumElements();
        stringBuffer.append("#     Number of Elements = " + n2 + StrNL);
        if (pgJvxSrc.getVertexNormals() != null) {
            stringBuffer.append("#     Additional: Element Normals\n");
        }
        stringBuffer.append("#\n# End of Header\n");
        stringBuffer.append(String.valueOf(pgJvxSrc.getNumVertices()) + " " + String.valueOf(pgJvxSrc.getNumElements()) + " 100\n");
        stringBuffer.append(PgOffLoader.writeVertices(n, pgJvxSrc.getVertices()));
        stringBuffer.append(PgOffLoader.writeElements(n2, pgJvxSrc.getElements(), pgJvxSrc.getElementNormals()));
        return stringBuffer.toString();
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    protected static String writeVertices(int n, PdVector[] pdVectorArray) {
        if (n <= 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2] == null) {
                PsDebug.warning("missing vertex, ind = " + n2);
                return null;
            }
            int n3 = 0;
            while (n3 < pdVectorArray[n2].m_data.length) {
                if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                    stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                } else {
                    stringBuffer.append(0.0f);
                }
                if (n3 < pdVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected static String writeElements(int n, PiVector[] piVectorArray, PdVector[] pdVectorArray) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            if (piVectorArray[n2] == null) {
                PsDebug.warning("missing element, ind = " + n2);
                return null;
            }
            stringBuffer.append(String.valueOf(piVectorArray[n2].getSize()) + " ");
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                stringBuffer.append(String.valueOf(piVectorArray[n2].m_data[n3]));
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            if (pdVectorArray != null && pdVectorArray.length == piVectorArray.length) {
                stringBuffer.append(" ");
                n3 = 0;
                while (n3 < pdVectorArray[n2].m_data.length) {
                    if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                        stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                    } else {
                        stringBuffer.append(0.0f);
                    }
                    if (n3 < pdVectorArray[n2].m_data.length - 1) {
                        stringBuffer.append(" ");
                    }
                    ++n3;
                }
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

