/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.util.Date;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgWrlLoader {
    private static final String StrSpace = " ";
    private static final String StrNL = "\n";
    private static final String Str1CBracket = "}\n";
    private static final String Str2CBracket = "}\n}\n";
    private static final String Str1Bracket = "]\n";
    private static final String StrNegOne = "-1";
    private static final String Str1Zero = "0";
    private static final String Str2Zero = "0 0";
    private static final String Str3Zero = "0 0 0";
    private static final String Str1One = "1";
    private static final String Str3One = "1 1 1";
    private static final String FALSE = "FALSE\n";
    private static final String TRUE = "TRUE\n";
    private static final String App = "appearance Appearance {\nmaterial Material {\n";
    private static final String Colors = "color Color {\ncolor [\n";
    private static final String ColorPV = "colorPerVertex ";
    private static final String Coord = "coord Coordinate {\n";
    private static final String CoordIdx = "coordIndex [\n";
    private static final String Diff = "diffuseColor ";
    private static final String Emiss = "emissiveColor ";
    private static final String Group = "Group {\nchildren [\n";
    private static final String IdxFS = "IndexedFaceSet {\n";
    private static final String IdxLS = "IndexedLineSet {\n";
    private static final String PointSet = "PointSet {\n";
    private static final String Solid = "solid ";
    private static final String Point = "point [\n";
    private static final String Shape = "Shape {\ngeometry ";
    private static final String ID = "#VRML V2.0 utf8\n";

    private static void appendColor(StringBuffer stringBuffer, Color color) {
        if (color == null) {
            stringBuffer.append(Str3One);
        } else {
            stringBuffer.append((float)color.getRed() / 255.0f);
            stringBuffer.append(StrSpace);
            stringBuffer.append((float)color.getGreen() / 255.0f);
            stringBuffer.append(StrSpace);
            stringBuffer.append((float)color.getBlue() / 255.0f);
        }
        stringBuffer.append(StrNL);
    }

    protected static void createDiffuseColor(StringBuffer stringBuffer, Color color) {
        stringBuffer.append(App);
        stringBuffer.append(Diff);
        PgWrlLoader.appendColor(stringBuffer, color);
        stringBuffer.append(Str2CBracket);
    }

    protected static void createEmissiveColor(StringBuffer stringBuffer, Color color) {
        stringBuffer.append(App);
        stringBuffer.append(Emiss);
        PgWrlLoader.appendColor(stringBuffer, color);
        stringBuffer.append(Str2CBracket);
    }

    protected static void createIdxCoord(StringBuffer stringBuffer, int n, PdVector[] pdVectorArray, PiVector[] piVectorArray) {
        PgWrlLoader.createCoord(stringBuffer, n, pdVectorArray);
        stringBuffer.append(CoordIdx);
        int n2 = 0;
        while (n2 < piVectorArray.length) {
            int[] nArray = piVectorArray[n2].m_data;
            int n3 = 0;
            while (n3 < nArray.length) {
                stringBuffer.append(nArray[n3]);
                stringBuffer.append(n3 < nArray.length - 1 && n3 % 11 == 10 ? StrNL : StrSpace);
                ++n3;
            }
            stringBuffer.append(StrNegOne);
            stringBuffer.append(StrNL);
            ++n2;
        }
        stringBuffer.append(Str1Bracket);
    }

    protected static void createCoord(StringBuffer stringBuffer, int n, PdVector[] pdVectorArray) {
        stringBuffer.append(Coord);
        stringBuffer.append(Point);
        int n2 = 0;
        while (n2 < pdVectorArray.length) {
            double[] dArray = pdVectorArray[n2].m_data;
            if (n < 1) {
                stringBuffer.append(Str3Zero);
            } else {
                stringBuffer.append((float)dArray[0]);
                stringBuffer.append(StrSpace);
                if (n < 2) {
                    stringBuffer.append(Str2Zero);
                } else {
                    stringBuffer.append((float)dArray[1]);
                    stringBuffer.append(StrSpace);
                    if (n < 3) {
                        stringBuffer.append(Str1Zero);
                    } else {
                        stringBuffer.append((float)dArray[2]);
                    }
                }
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }

    protected static String createVRMLdesc(PgJvxSrc pgJvxSrc) {
        if (pgJvxSrc == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (pgJvxSrc.getNumElements() != 0) {
            PgWrlLoader.drawElements(stringBuffer, pgJvxSrc);
        } else if (pgJvxSrc.getNumPolygons() != 0) {
            PgWrlLoader.drawPolygons(stringBuffer, pgJvxSrc);
        } else {
            PgWrlLoader.drawVertices(stringBuffer, pgJvxSrc);
        }
        return stringBuffer.toString();
    }

    protected static void drawVertices(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        boolean bl = pgJvxSrc.getVertexColors() == null;
        stringBuffer.append(Shape);
        stringBuffer.append(PointSet);
        PgWrlLoader.createCoord(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getVertices());
        if (!bl) {
            PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumVertices(), pgJvxSrc.getVertexColors());
        }
        stringBuffer.append(Str1CBracket);
        PgWrlLoader.createDiffuseColor(stringBuffer, pgJvxSrc.getGlobalVertexColor());
        stringBuffer.append(Str1CBracket);
    }

    protected static void drawElements(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        boolean bl = pgJvxSrc.getElementColors() == null;
        stringBuffer.append(Shape);
        stringBuffer.append(IdxFS);
        stringBuffer.append(Solid);
        stringBuffer.append(FALSE);
        PgWrlLoader.createIdxCoord(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getVertices(), pgJvxSrc.getElements());
        if (!bl) {
            stringBuffer.append(ColorPV);
            stringBuffer.append(FALSE);
            PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumElements(), pgJvxSrc.getElementColors());
        }
        stringBuffer.append(Str1CBracket);
        PgWrlLoader.createDiffuseColor(stringBuffer, pgJvxSrc.getGlobalElementColor());
        stringBuffer.append(Str1CBracket);
    }

    public static String write(PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("PgWrlLoader.export(): missing geometries");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(ID);
        stringBuffer.append("# Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + StrNL);
        stringBuffer.append("#     File Format = WRL\n");
        stringBuffer.append("#     Date        = " + new Date().toString() + "\n#\n");
        int n = 0;
        while (n < pgJvxSrcArray.length) {
            if (pgJvxSrcArray[n] != null) {
                stringBuffer.append("#     Geometry    = " + pgJvxSrcArray[n].getName() + StrNL);
                stringBuffer.append("#     Number of Vertices = " + pgJvxSrcArray[n].getNumVertices() + StrNL);
                stringBuffer.append("#     Number of Polygons = " + pgJvxSrcArray[n].getNumPolygons() + StrNL);
                stringBuffer.append("#     Number of Elements = " + pgJvxSrcArray[n].getNumElements() + StrNL);
            }
            ++n;
        }
        stringBuffer.append("#\n# End of Header\n");
        stringBuffer.append(Group);
        n = 0;
        while (n < pgJvxSrcArray.length) {
            String string = PgWrlLoader.createVRMLdesc(pgJvxSrcArray[n]);
            if (string != null) {
                stringBuffer.append(string);
            }
            ++n;
        }
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
        return stringBuffer.toString();
    }

    protected static void drawPolygons(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        boolean bl = pgJvxSrc.getPolygonColors() == null;
        stringBuffer.append(Shape);
        stringBuffer.append(IdxLS);
        PgWrlLoader.createIdxCoord(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getVertices(), pgJvxSrc.getPolygons());
        if (!bl) {
            stringBuffer.append(ColorPV);
            stringBuffer.append(FALSE);
            PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumPolygons(), pgJvxSrc.getPolygonColors());
        }
        stringBuffer.append(Str1CBracket);
        PgWrlLoader.createDiffuseColor(stringBuffer, pgJvxSrc.getGlobalPolygonColor());
        stringBuffer.append(Str1CBracket);
    }

    protected static void createColors(StringBuffer stringBuffer, int n, Color[] colorArray) {
        Color color = null;
        stringBuffer.append(Colors);
        int n2 = 0;
        while (n2 < n) {
            if (n2 < colorArray.length) {
                color = colorArray[n2];
            }
            PgWrlLoader.appendColor(stringBuffer, color);
            ++n2;
        }
        stringBuffer.append(StrNL);
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }
}

