/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.BufferedReader;
import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.anim.PsKeyframeIf;
import jv.anim.PsTimeEvent;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.loader.PgMathData;
import jv.loader.PgMathLoader;
import jv.project.PgGeometry;
import jv.project.PjProject;

public class PjMathView
extends PjProject
implements PsKeyframeIf {
    protected PgGeometry[] m_geom;
    protected PgMathData[] m_mathData;
    protected boolean m_isKeyAnimation;
    protected boolean m_isAnimation;
    protected boolean m_bShowAnimationPanel = true;
    protected PsKeyframe m_elemKeyframe;
    protected PsKeyframe m_pointKeyframe;
    protected PsKeyframe m_polyKeyframe;
    protected BufferedReader m_bufIn;
    private static /* synthetic */ Class class$jv$loader$PjMathView;

    public double getTimeOfLastKey() {
        if (this.m_elemKeyframe != null) {
            return this.m_elemKeyframe.getTimeOfLastKey();
        }
        if (this.m_pointKeyframe != null) {
            return this.m_pointKeyframe.getTimeOfLastKey();
        }
        return this.m_polyKeyframe.getTimeOfLastKey();
    }

    public PjMathView(String string) {
        super(string);
        if (this.getClass() == (class$jv$loader$PjMathView != null ? class$jv$loader$PjMathView : (class$jv$loader$PjMathView = PjMathView.class$("jv.loader.PjMathView")))) {
            this.init();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean read() {
        int n;
        PgMathLoader pgMathLoader = new PgMathLoader();
        this.m_mathData = pgMathLoader.read(this.m_bufIn);
        if (this.m_mathData == null) {
            return false;
        }
        this.m_isKeyAnimation = pgMathLoader.isKeyAnimation();
        this.m_isAnimation = pgMathLoader.isAnimation();
        if (!this.m_isKeyAnimation && !this.m_isAnimation) {
            int n2 = 0;
            if (this.m_mathData != null) {
                int n3 = 0;
                while (n3 < this.m_mathData.length) {
                    n2 += this.m_mathData[n3].getGeom().length;
                    ++n3;
                }
                this.m_geom = new PgGeometry[n2];
                n3 = 0;
                int n4 = 0;
                while (n4 < this.m_mathData.length) {
                    int n5 = 0;
                    while (n5 < this.m_mathData[n4].getGeom().length) {
                        switch (this.m_mathData[n4].getGeomType().m_data[n5]) {
                            case 33: {
                                this.m_geom[n3] = new PgElementSet(this.m_mathData[n4].getDim());
                                break;
                            }
                            case 32: {
                                this.m_geom[n3] = new PgPolygonSet(this.m_mathData[n4].getDim());
                                break;
                            }
                            default: {
                                this.m_geom[n3] = new PgPointSet(this.m_mathData[n4].getDim());
                            }
                        }
                        this.m_geom[n3].setJvx(this.m_mathData[n4].getGeom()[n5]);
                        ++n3;
                        ++n5;
                    }
                    ++n4;
                }
                n4 = 0;
                while (n4 < this.m_geom.length) {
                    this.m_geom[n4].setName("Geometry imported from Mathematica " + n4);
                    this.addGeometry(this.m_geom[n4]);
                    ++n4;
                }
                if (this.m_geom.length <= 0) return true;
                this.selectGeometry(this.m_geom[0]);
                return true;
            }
            this.m_geom = null;
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.m_elemKeyframe = new PsKeyframe();
        this.m_pointKeyframe = new PsKeyframe();
        this.m_polyKeyframe = new PsKeyframe();
        if (this.m_mathData.length > 1) {
            n = 0;
            while (n < this.m_mathData.length) {
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                int n6 = 0;
                while (n6 < this.m_mathData[n].getGeom().length) {
                    switch (this.m_mathData[n].getGeomType().m_data[n6]) {
                        case 33: {
                            bl = true;
                            bl4 = true;
                            PgElementSet pgElementSet = new PgElementSet(this.m_mathData[n].getDim());
                            pgElementSet.setJvx(this.m_mathData[n].getGeom()[n6]);
                            this.m_elemKeyframe.addKey(pgElementSet, 100.0 * (double)n / ((double)this.m_mathData.length - 1.0));
                            break;
                        }
                        case 30: {
                            bl2 = true;
                            bl5 = true;
                            PgPointSet pgPointSet = new PgPointSet(this.m_mathData[n].getDim());
                            pgPointSet.setJvx(this.m_mathData[n].getGeom()[n6]);
                            this.m_pointKeyframe.addKey(pgPointSet, 100.0 * (double)n / ((double)this.m_mathData.length - 1.0));
                            break;
                        }
                        case 32: {
                            bl3 = true;
                            bl6 = true;
                            PgPolygonSet pgPolygonSet = new PgPolygonSet(this.m_mathData[n].getDim());
                            pgPolygonSet.setJvx(this.m_mathData[n].getGeom()[n6]);
                            this.m_polyKeyframe.addKey(pgPolygonSet, 100.0 * (double)n / ((double)this.m_mathData.length - 1.0));
                        }
                    }
                    ++n6;
                }
                if (!bl4) {
                    this.m_elemKeyframe.addKey(new PgElementSet(this.m_mathData[n].getDim()), 100.0 * (double)n / ((double)this.m_mathData.length - 1.0));
                }
                if (!bl5) {
                    this.m_pointKeyframe.addKey(new PgPointSet(this.m_mathData[n].getDim()), 100.0 * (double)n / ((double)this.m_mathData.length - 1.0));
                }
                if (!bl6) {
                    this.m_polyKeyframe.addKey(new PgPolygonSet(this.m_mathData[n].getDim()), 100.0 * (double)n / ((double)this.m_mathData.length - 1.0));
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < this.m_mathData[0].getGeom().length) {
                switch (this.m_mathData[0].getGeomType().m_data[n]) {
                    case 33: {
                        bl = true;
                        PgElementSet pgElementSet = new PgElementSet(this.m_mathData[0].getDim());
                        pgElementSet.setJvx(this.m_mathData[0].getGeom()[n]);
                        this.m_elemKeyframe.addKey(pgElementSet, 0.0);
                        break;
                    }
                    case 30: {
                        bl2 = true;
                        PgPointSet pgPointSet = new PgPointSet(this.m_mathData[0].getDim());
                        pgPointSet.setJvx(this.m_mathData[0].getGeom()[n]);
                        this.m_pointKeyframe.addKey(pgPointSet, 0.0);
                        break;
                    }
                    case 32: {
                        bl3 = true;
                        PgPolygonSet pgPolygonSet = new PgPolygonSet(this.m_mathData[0].getDim());
                        pgPolygonSet.setJvx(this.m_mathData[0].getGeom()[n]);
                        this.m_polyKeyframe.addKey(pgPolygonSet, 0.0);
                    }
                }
                ++n;
            }
        }
        this.m_elemKeyframe.setObject(new PgElementSet(this.m_mathData[0].getDim()));
        this.m_pointKeyframe.setObject(new PgPointSet(this.m_mathData[0].getDim()));
        this.m_polyKeyframe.setObject(new PgPolygonSet(this.m_mathData[0].getDim()));
        if (!bl) {
            this.m_elemKeyframe = null;
        } else {
            this.m_elemKeyframe.setTime(0.0);
        }
        if (!bl2) {
            this.m_pointKeyframe = null;
        } else {
            this.m_pointKeyframe.setTime(0.0);
        }
        if (!bl3) {
            this.m_polyKeyframe = null;
        } else {
            this.m_polyKeyframe.setTime(0.0);
        }
        PsAnimation psAnimation = new PsAnimation();
        psAnimation.setName("Animation imported from Mathematica ");
        psAnimation.addTimeListener(this);
        this.setAnimation(psAnimation);
        psAnimation.enableKeys(true);
        if (this.m_bShowAnimationPanel) {
            psAnimation.getAnimationPanel().show();
        }
        if (this.m_isAnimation) {
            this.m_anim.setTimeInterval(0.0, 100.0, 100.0 / ((double)this.m_mathData.length - 1.0), 200.0 / ((double)this.m_mathData.length - 1.0));
        } else {
            this.m_anim.setTimeInterval(0.0, 100.0, 10.0 / ((double)this.m_mathData.length - 1.0), 50.0 / ((double)this.m_mathData.length - 1.0));
        }
        if (bl) {
            this.m_elemKeyframe.getObject().setName("Animated PgElementSet imported from Mathematica");
            this.addGeometry(this.m_elemKeyframe.getObject());
            if (this.m_isAnimation) {
                this.m_elemKeyframe.showKeysOnly(true);
            }
        }
        if (bl2) {
            this.m_pointKeyframe.getObject().setName("Animated PgPointSet imported from Mathematica");
            this.addGeometry(this.m_pointKeyframe.getObject());
            if (this.m_isAnimation) {
                this.m_pointKeyframe.showKeysOnly(true);
            }
        }
        if (!bl3) return true;
        this.m_polyKeyframe.getObject().setName("Animated PgPolygonSet imported from Mathematica");
        this.addGeometry(this.m_polyKeyframe.getObject());
        if (!this.m_isAnimation) return true;
        this.m_polyKeyframe.showKeysOnly(true);
        return true;
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        double d = psTimeEvent.getTime();
        if (this.m_elemKeyframe != null) {
            this.m_elemKeyframe.setTime(d);
            this.m_elemKeyframe.getObject().update(this.m_elemKeyframe.getObject());
        }
        if (this.m_pointKeyframe != null) {
            this.m_pointKeyframe.setTime(d);
            this.m_pointKeyframe.getObject().update(this.m_pointKeyframe.getObject());
        }
        if (this.m_polyKeyframe != null) {
            this.m_polyKeyframe.setTime(d);
            this.m_polyKeyframe.getObject().update(this.m_polyKeyframe.getObject());
        }
        return true;
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.m_bufIn = bufferedReader;
    }

    public double getTimeOfFirstKey() {
        if (this.m_elemKeyframe != null) {
            return this.m_elemKeyframe.getTimeOfFirstKey();
        }
        if (this.m_pointKeyframe != null) {
            return this.m_pointKeyframe.getTimeOfFirstKey();
        }
        return this.m_polyKeyframe.getTimeOfFirstKey();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public double getTimeOfPreviousKey() {
        if (this.m_elemKeyframe != null) {
            return this.m_elemKeyframe.getTimeOfPreviousKey();
        }
        if (this.m_pointKeyframe != null) {
            return this.m_pointKeyframe.getTimeOfPreviousKey();
        }
        return this.m_polyKeyframe.getTimeOfPreviousKey();
    }

    public double getTimeOfNextKey() {
        if (this.m_elemKeyframe != null) {
            return this.m_elemKeyframe.getTimeOfNextKey();
        }
        if (this.m_pointKeyframe != null) {
            return this.m_pointKeyframe.getTimeOfNextKey();
        }
        return this.m_polyKeyframe.getTimeOfNextKey();
    }

    public void init() {
        super.init();
    }

    public void showAnimationPanel(boolean bl) {
        this.m_bShowAnimationPanel = bl;
    }
}

