/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class PsXmlNode
implements Serializable {
    protected String m_type;
    protected Hashtable m_attribute;
    protected String m_content;
    protected PsXmlNode m_father;
    protected PsXmlNode m_sibling;
    protected PsXmlNode m_child;
    private boolean m_isExpanded;

    public PsXmlNode getChild(String string) {
        Object object;
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            object = psXmlNode.getType();
            if (object != null && ((String)object).equals(string)) {
                return psXmlNode;
            }
            psXmlNode = psXmlNode.getSibling();
        }
        psXmlNode = this.m_child;
        while (psXmlNode != null) {
            object = psXmlNode.getChild(string);
            if (object != null) {
                return object;
            }
            psXmlNode = psXmlNode.getSibling();
        }
        return null;
    }

    public PsXmlNode getChild() {
        return this.m_child;
    }

    public void setChild(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            this.m_child = null;
            return;
        }
        this.m_child = psXmlNode;
        psXmlNode.setFather(this);
    }

    public String getContent() {
        if (this.m_content == null) {
            return null;
        }
        return new String(this.m_content);
    }

    public void setContent(String string) {
        if (string == null) {
            this.m_content = null;
            return;
        }
        this.m_content = new String(string);
    }

    public String appendContent(String string) {
        this.m_content = this.m_content == null ? new String(string) : this.m_content.concat(string);
        return this.m_content;
    }

    public String getAttribute(String string) {
        if (this.m_attribute == null) {
            return null;
        }
        return (String)this.m_attribute.get(string);
    }

    public PsXmlNode(String string) {
        this.m_type = string;
        this.m_isExpanded = true;
    }

    public boolean isExpanded() {
        return this.m_isExpanded;
    }

    public void expand(boolean bl) {
        this.m_isExpanded = bl;
    }

    public int getNumChildren() {
        int n = 0;
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            ++n;
            psXmlNode = psXmlNode.getSibling();
        }
        return n;
    }

    public PsXmlNode getSibling() {
        return this.m_sibling;
    }

    public void setSibling(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            this.m_sibling = null;
            return;
        }
        this.m_sibling = psXmlNode;
        psXmlNode.setFather(this.m_father);
    }

    public void removeAttribute(String string) {
        if (this.m_attribute == null) {
            return;
        }
        this.m_attribute.remove(string);
    }

    public PsXmlNode getFather() {
        return this.m_father;
    }

    public void setFather(PsXmlNode psXmlNode) {
        this.m_father = psXmlNode;
    }

    public Hashtable getAttributes() {
        return this.m_attribute;
    }

    public PsXmlNode[] getChildren() {
        int n = this.getNumChildren();
        if (n == 0) {
            return null;
        }
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[n];
        PsXmlNode psXmlNode = this.m_child;
        int n2 = 0;
        while (n2 < n) {
            psXmlNodeArray[n2] = psXmlNode;
            psXmlNode = psXmlNode.getSibling();
            ++n2;
        }
        return psXmlNodeArray;
    }

    public PsXmlNode[] getChildren(String string) {
        int n = this.getNumChildren();
        Vector<PsXmlNode> vector = null;
        PsXmlNode psXmlNode = this.m_child;
        int n2 = 0;
        while (n2 < n) {
            if (psXmlNode.getType().equals(string)) {
                if (vector == null) {
                    vector = new Vector<PsXmlNode>();
                }
                vector.addElement(psXmlNode);
            }
            psXmlNode = psXmlNode.getSibling();
            ++n2;
        }
        if (vector != null) {
            Object[] objectArray = new PsXmlNode[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public void addAttribute(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return;
        }
        if (this.m_attribute == null) {
            this.m_attribute = new Hashtable();
        }
        this.m_attribute.put(string, string2);
    }

    public PsXmlNode addChild(String string, String string2) {
        PsXmlNode psXmlNode = this.addChild(string);
        if (psXmlNode == null) {
            return null;
        }
        psXmlNode.setContent(string2);
        return psXmlNode;
    }

    public PsXmlNode addChild(String string, boolean bl) {
        return this.addChild(string, String.valueOf(bl));
    }

    public PsXmlNode addChild(String string, double d) {
        return this.addChild(string, String.valueOf(d));
    }

    public PsXmlNode addChild(String string, float f) {
        return this.addChild(string, String.valueOf(f));
    }

    public PsXmlNode addChild(String string, int n) {
        return this.addChild(string, String.valueOf(n));
    }

    public PsXmlNode addChild(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        PsXmlNode psXmlNode = new PsXmlNode(string);
        this.addChild(psXmlNode);
        return psXmlNode;
    }

    public void addChild(PsXmlNode psXmlNode) {
        if (this.m_child == null) {
            this.m_child = psXmlNode;
            return;
        }
        PsXmlNode psXmlNode2 = this.m_child;
        while (psXmlNode2.m_sibling != null) {
            psXmlNode2 = psXmlNode2.m_sibling;
        }
        psXmlNode2.m_sibling = psXmlNode;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public void removeChildren() {
        this.m_child = null;
    }
}

