/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.Serializable;
import java.util.StringTokenizer;
import jv.loader.PsXmlNode;
import jv.object.PsDebug;

public class PsXmlSrc
implements Serializable {
    protected String m_docName = null;
    protected String m_docType = null;
    protected PsXmlNode m_root = null;
    protected String m_rsrcFile = null;

    public static PsXmlNode assureChild(PsXmlNode psXmlNode, String string) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            psXmlNode2 = new PsXmlNode(string);
            psXmlNode.addChild(psXmlNode2);
        }
        return psXmlNode2;
    }

    public static boolean getRsrcAsBoolean(PsXmlNode psXmlNode, String string) {
        String string2 = PsXmlSrc.getRsrc(psXmlNode, string);
        if (string2 == null || string2.equals("")) {
            return false;
        }
        return string2.equalsIgnoreCase("true");
    }

    public static String getRsrc(PsXmlNode psXmlNode, String string) {
        if (psXmlNode == null) {
            PsDebug.warning("missing node argument.");
            return null;
        }
        String string2 = psXmlNode.getType();
        if (string2 != null && string2.equals(string)) {
            return psXmlNode.getContent();
        }
        PsXmlNode psXmlNode2 = psXmlNode.getChild(string);
        if (psXmlNode2 == null) {
            return null;
        }
        return psXmlNode2.getContent();
    }

    public PsXmlNode getRootNode() {
        return this.m_root;
    }

    public void setRootNode(PsXmlNode psXmlNode) {
        this.m_root = psXmlNode;
    }

    public static PsXmlNode getRsrcNode(PsXmlNode psXmlNode, String string) {
        if (psXmlNode == null) {
            PsDebug.warning("missing node argument.");
            return null;
        }
        String string2 = psXmlNode.getType();
        if (string2 != null && string2.equals(string)) {
            return psXmlNode;
        }
        PsXmlNode psXmlNode2 = psXmlNode.getChild(string);
        if (psXmlNode2 == null) {
            return null;
        }
        return psXmlNode2;
    }

    public String getDocName() {
        return this.m_docName;
    }

    public void setDocName(String string) {
        this.m_docName = string;
    }

    public String getDocType() {
        return this.m_docType;
    }

    public void setDocType(String string) {
        this.m_docType = string;
    }

    public static double getRsrcAsDouble(PsXmlNode psXmlNode, String string) {
        String string2 = PsXmlSrc.getRsrc(psXmlNode, string);
        if (string2 == null || string2.equals("")) {
            return 0.0;
        }
        try {
            double d = new Double(string2);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format, rsrc = " + string2);
            return 0.0;
        }
    }

    public static int getRsrcAsInteger(PsXmlNode psXmlNode, String string) {
        String string2 = PsXmlSrc.getRsrc(psXmlNode, string);
        if (string2 == null || string2.equals("")) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format, rsrc = " + string2);
            return 0;
        }
    }

    public static PsXmlNode[] getRsrcNodes(PsXmlNode psXmlNode, String string) {
        if (psXmlNode == null) {
            PsDebug.warning("missing node argument.");
            return null;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode.getChildren(string);
        if (psXmlNodeArray == null) {
            return null;
        }
        return psXmlNodeArray;
    }

    public static PsXmlNode[] getRsrcNodes(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            PsDebug.warning("missing node argument.");
            return null;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode.getChildren();
        if (psXmlNodeArray == null) {
            return null;
        }
        return psXmlNodeArray;
    }

    public String getParameter(String string) {
        PsXmlNode psXmlNode;
        if (this.m_root == null) {
            PsDebug.warning("missing resource tree.");
            return null;
        }
        if (string == null || string.equals("")) {
            PsDebug.warning("missing argument = " + string);
            return null;
        }
        int n = -1;
        try {
            psXmlNode = this.getRootNode();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            do {
                String string2;
                if ((psXmlNode = PsXmlSrc.getRsrcNode(psXmlNode, string2 = stringTokenizer.nextToken())) != null) continue;
                PsDebug.warning("failed to find node = " + string2 + " while parsing = " + string);
                return null;
            } while ((n = string.indexOf(47, n + 1)) != -1);
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown at position=" + n + " while parsing = " + string);
            return null;
        }
        if (psXmlNode == null) {
            PsDebug.warning("failure during parsing = " + string);
            return null;
        }
        return psXmlNode.getContent();
    }

    public String getRsrcFile() {
        return this.m_rsrcFile;
    }

    public void setRsrcFile(String string) {
        this.m_rsrcFile = string;
    }
}

