/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.loader.PsXmlNode;
import jv.loader.PsXmlSrc;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class PvDisplayLoader {
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    private static void parseOption(PvDisplayOption pvDisplayOption, int n, String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("show")) {
            pvDisplayOption.setOption(n, true);
            return;
        }
        pvDisplayOption.setOption(n, false);
    }

    protected static PvDisplayOption[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        String string = null;
        String string2 = null;
        String string3 = null;
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning("missing root node.");
            return null;
        }
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, "version");
        if (psXmlNode2 == null) {
            PsDebug.warning("missing version information, using default.");
            string = "0.0";
            string2 = "dump";
        } else {
            string = psXmlNode2.getContent();
            string2 = psXmlNode2.getAttribute("type");
        }
        string3 = PsXmlSrc.getRsrc(psXmlNode, "abstract");
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode, "displays");
        if (psXmlNode3 == null) {
            PsDebug.warning("missing displays node");
            return null;
        }
        String[] stringArray = new String[]{"tag", "name"};
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode3, "display");
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            PsDebug.warning("missing display node");
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = new PvDisplayOption[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            PsXmlNode psXmlNode4;
            Object object;
            Object object2;
            int n2;
            Object object3;
            Object object4;
            PsXmlNode psXmlNode5;
            pvDisplayOptionArray[n] = new PvDisplayOption();
            pvDisplayOptionArray[n].setVersion(string);
            pvDisplayOptionArray[n].setVersionType(string2);
            pvDisplayOptionArray[n].setAbstract(string3);
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 1, psXmlNodeArray[n].getAttribute("antiAlias"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 2, psXmlNodeArray[n].getAttribute("autoRotate"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 3, psXmlNodeArray[n].getAttribute("axes"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 4, psXmlNodeArray[n].getAttribute("axesLabel"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 7, psXmlNodeArray[n].getAttribute("border"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 9, psXmlNodeArray[n].getAttribute("cross"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 10, psXmlNodeArray[n].getAttribute("depthcue"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 11, psXmlNodeArray[n].getAttribute("drawing"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 12, psXmlNodeArray[n].getAttribute("edgeAura"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 14, psXmlNodeArray[n].getAttribute("frame"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 15, psXmlNodeArray[n].getAttribute("info"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 17, psXmlNodeArray[n].getAttribute("magnet"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 18, psXmlNodeArray[n].getAttribute("single"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 19, psXmlNodeArray[n].getAttribute("sorting"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 20, psXmlNodeArray[n].getAttribute("visible"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 21, psXmlNodeArray[n].getAttribute("xyGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 22, psXmlNodeArray[n].getAttribute("xzGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 23, psXmlNodeArray[n].getAttribute("yzGrid"));
            PsXmlNode psXmlNode6 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "title");
            if (psXmlNode6 != null) {
                pvDisplayOptionArray[n].setTitle(psXmlNode6.getContent());
            }
            if ((psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "cameras")) != null) {
                object4 = psXmlNode5.getAttribute("select");
                int n3 = 0;
                if (object4 != null) {
                    if (((String)object4).equals("perspective")) {
                        n3 = 0;
                    } else if (((String)object4).equals("orthoXY")) {
                        n3 = 1;
                    } else if (((String)object4).equals("orthoXZ")) {
                        n3 = 2;
                    } else if (((String)object4).equals("orthoYZ")) {
                        n3 = 3;
                    }
                }
                pvDisplayOptionArray[n].setCurrentCamera(n3);
                object3 = PsXmlSrc.getRsrcNodes(psXmlNode5, "camera");
                if (object3 != null) {
                    pvDisplayOptionArray[n].setNumCameras(((PsXmlNode[])object3).length);
                    n2 = 0;
                    while (n2 < ((PsXmlNode[])object3).length) {
                        String string4;
                        Object object5;
                        PsXmlNode psXmlNode7;
                        double d;
                        object2 = object3[n2].getAttribute("projection");
                        int n4 = 0;
                        if (object2 != null) {
                            if (((String)object2).equals("perspective")) {
                                n4 = 0;
                            } else if (((String)object2).equals("orthoXY")) {
                                n4 = 1;
                            } else if (((String)object2).equals("orthoXZ")) {
                                n4 = 2;
                            } else if (((String)object2).equals("orthoYZ")) {
                                n4 = 3;
                            }
                        }
                        pvDisplayOptionArray[n].setCameraProjection(n2, n4);
                        object = PsXmlLoader.parsePdVector((PsXmlNode)object3[n2], "position", stringArray);
                        if (object != null) {
                            pvDisplayOptionArray[n].setCameraPosition(n2, (PdVector)object);
                        }
                        if ((object = PsXmlLoader.parsePdVector((PsXmlNode)object3[n2], "interest", stringArray)) != null) {
                            pvDisplayOptionArray[n].setCameraInterest(n2, (PdVector)object);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object3[n2], "angle")) != 0.0) {
                            pvDisplayOptionArray[n].setCameraAngle(n2, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object3[n2], "roll")) != 0.0) {
                            pvDisplayOptionArray[n].setCameraRoll(n2, d);
                        }
                        if ((psXmlNode7 = PsXmlSrc.getRsrcNode((PsXmlNode)object3[n2], "transform")) != null) {
                            String string5;
                            object5 = psXmlNode7.getAttribute("enable");
                            if (object5 != null && ((String)object5).equals("true")) {
                                pvDisplayOptionArray[n].setEnabledCameraTransform(n2, true);
                            }
                            if ((string4 = psXmlNode7.getAttribute("ambient")) != null) {
                                if (string4.equals("R3Euclidean")) {
                                    pvDisplayOptionArray[n].setCameraAmbient(n2, 0);
                                } else if (string4.equals("R4Euclidean")) {
                                    pvDisplayOptionArray[n].setCameraAmbient(n2, 1);
                                } else if (string4.equals("S3Sphere")) {
                                    pvDisplayOptionArray[n].setCameraAmbient(n2, 2);
                                } else if (string4.equals("H3Hyperbolic")) {
                                    pvDisplayOptionArray[n].setCameraAmbient(n2, 3);
                                }
                            }
                            if ((string5 = psXmlNode7.getAttribute("perspective")) != null) {
                                if (string5.equals("parallel")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 0);
                                } else if (string5.equals("stereographic")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 1);
                                } else if (string5.equals("poincareBall")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 0);
                                } else if (string5.equals("kleinBall")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 1);
                                } else if (string5.equals("upperHalfspace")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 2);
                                }
                            }
                        }
                        if ((object5 = PsXmlSrc.getRsrcNode((PsXmlNode)object3[n2], "clipping")) != null) {
                            string4 = ((PsXmlNode)object5).getAttribute("enable");
                            if (string4 != null && string4.equals("true")) {
                                pvDisplayOptionArray[n].setEnabledCameraClip(n2, true);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object3[n2], "near")) != 0.0) {
                                pvDisplayOptionArray[n].setCameraNearClip(n2, d);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object3[n2], "far")) != 0.0) {
                                pvDisplayOptionArray[n].setCameraFarClip(n2, d);
                            }
                        }
                        ++n2;
                    }
                }
            } else {
                PsDebug.warning("missing element 'cameras'.");
            }
            if ((object4 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "lights")) != null) {
                PsXmlNode psXmlNode8 = PsXmlSrc.getRsrcNode((PsXmlNode)object4, "ambient");
                if (psXmlNode8 != null) {
                    pvDisplayOptionArray[n].setAmbientLight(PsXmlLoader.parseColorRGB(psXmlNode8, "color"));
                }
                if ((object3 = PsXmlSrc.getRsrcNodes((PsXmlNode)object4, "light")) != null) {
                    pvDisplayOptionArray[n].setNumLights(((PsXmlNode[])object3).length);
                    n2 = 0;
                    while (n2 < ((PsXmlNode[])object3).length) {
                        PdVector pdVector;
                        object2 = ((PsXmlNode)object3[n]).getAttribute("type");
                        if (object2 != null) {
                            if (((String)object2).equals("bulb")) {
                                pvDisplayOptionArray[n].setLightType(n2, 1);
                            } else if (((String)object2).equals("rgbCube")) {
                                pvDisplayOptionArray[n].setLightType(n2, 2);
                            } else if (((String)object2).equals("hue")) {
                                pvDisplayOptionArray[n].setLightType(n2, 3);
                            } else if (((String)object2).equals("spot")) {
                                pvDisplayOptionArray[n].setLightType(n2, 4);
                            } else if (((String)object2).equals("sun")) {
                                pvDisplayOptionArray[n].setLightType(n2, 5);
                            }
                        }
                        if ((pdVector = PsXmlLoader.parsePdVector((PsXmlNode)object3[n], "position", stringArray)) != null) {
                            pvDisplayOptionArray[n].setLightPosition(n2, pdVector);
                        }
                        if ((pdVector = PsXmlLoader.parsePdVector((PsXmlNode)object3[n], "interest", stringArray)) != null) {
                            pvDisplayOptionArray[n].setLightInterest(n2, pdVector);
                        }
                        if ((object = PsXmlLoader.parseColorRGB((PsXmlNode)object3[n], "color")) != null) {
                            pvDisplayOptionArray[n].setLightColor(n2, (Color)object);
                        }
                        ++n2;
                    }
                }
            } else {
                PsDebug.warning("missing element 'lights'.");
            }
            if ((psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "background")) != null) {
                object3 = PsXmlLoader.parseColorRGB(psXmlNode4, "color");
                if (object3 != null) {
                    pvDisplayOptionArray[n].setBackgroundColor((Color)object3);
                }
                if ((object2 = psXmlNode4.getAttribute("image")) != null && ((String)object2).equals("show")) {
                    pvDisplayOptionArray[n].setOption(5, true);
                } else {
                    pvDisplayOptionArray[n].setOption(5, false);
                }
                PsXmlNode psXmlNode9 = PsXmlSrc.getRsrcNode(psXmlNode4, "image");
                if (psXmlNode9 != null) {
                    PsXmlNode psXmlNode10;
                    object = psXmlNode9.getAttribute("repeat");
                    if (object != null) {
                        pvDisplayOptionArray[n].setBackgroundImageRepeat((String)object);
                    }
                    if ((psXmlNode10 = PsXmlSrc.getRsrcNode(psXmlNode9, "url")) != null) {
                        pvDisplayOptionArray[n].setBackgroundImage(psXmlNode10.getContent());
                    }
                }
            }
            if ((object3 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "foreground")) != null) {
                String string6;
                object2 = PsXmlLoader.parseColorRGB((PsXmlNode)object3, "color");
                if (object2 != null) {
                    pvDisplayOptionArray[n].setForegroundColor((Color)object2);
                }
                if ((string6 = ((PsXmlNode)object3).getAttribute("image")) != null && string6.equals("show")) {
                    pvDisplayOptionArray[n].setOption(13, true);
                } else {
                    pvDisplayOptionArray[n].setOption(13, false);
                }
                object = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "image");
                if (object != null) {
                    PsXmlNode psXmlNode11;
                    String string7 = ((PsXmlNode)object).getAttribute("repeat");
                    if (string7 != null) {
                        pvDisplayOptionArray[n].setForegroundImageRepeat(string7);
                    }
                    if ((psXmlNode11 = PsXmlSrc.getRsrcNode((PsXmlNode)object, "url")) != null) {
                        pvDisplayOptionArray[n].setForegroundImage(psXmlNode11.getContent());
                    }
                }
            }
            if ((object2 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "window")) != null) {
                PsXmlNode psXmlNode12 = PsXmlSrc.getRsrcNode((PsXmlNode)object2, "x");
                if (psXmlNode12 != null) {
                    int n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object2, "x");
                    int n6 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object2, "y");
                    pvDisplayOptionArray[n].setWindowPosition(n5, n6);
                }
                int n7 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object2, "width");
                int n8 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object2, "height");
                pvDisplayOptionArray[n].setWindowSize(n7, n8);
            }
            ++n;
        }
        return pvDisplayOptionArray;
    }

    public static PvDisplayOption[] read(String string) {
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to parse XML in file = " + string);
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = PvDisplayLoader.parseRsrcTree(psXmlSrc);
        if (pvDisplayOptionArray == null) {
            PsDebug.warning("failed to interpret content of JVD file = " + string);
            return null;
        }
        return pvDisplayOptionArray;
    }

    private static boolean hasAttribute(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    private static int parseVisibility(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    public static String write(PvDisplayOption[] pvDisplayOptionArray) {
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0) {
            PsDebug.warning("missing options.");
            return null;
        }
        PsXmlSrc psXmlSrc = PvDisplayLoader.fillRsrcTree(null, pvDisplayOptionArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlLoader.write(psXmlSrc);
    }

    protected static PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PvDisplayOption[] pvDisplayOptionArray) {
        PsXmlNode psXmlNode;
        PsXmlNode psXmlNode2;
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0 || pvDisplayOptionArray[0] == null) {
            return null;
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode2 = psXmlSrc.getRootNode()) == null) {
            psXmlNode2 = new PsXmlNode("jv-disp");
            psXmlSrc.setRootNode(psXmlNode2);
        }
        psXmlSrc.setDocName("jv-disp");
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[2];
        psXmlNodeArray[0] = psXmlNode2.addChild("meta");
        psXmlNodeArray[0].addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
        psXmlNodeArray[1] = psXmlNode2.addChild("meta");
        psXmlNodeArray[1].addAttribute("date", new Date().toString());
        if (pvDisplayOptionArray[0] != null) {
            psXmlNode = psXmlNode2.addChild("version", pvDisplayOptionArray[0].getVersion());
            psXmlNode.addAttribute("type", pvDisplayOptionArray[0].getVersionType());
            if (pvDisplayOptionArray[0].getTitle() != null) {
                psXmlNode2.addChild("title", pvDisplayOptionArray[0].getTitle());
            }
            psXmlNode2.addChild("abstract", pvDisplayOptionArray[0].getAbstract());
        }
        psXmlNode = psXmlNode2.addChild("displays");
        if (pvDisplayOptionArray != null) {
            int n = 0;
            while (n < pvDisplayOptionArray.length) {
                Dimension dimension;
                PsXmlNode psXmlNode3;
                Object object;
                int n2;
                PsXmlNode psXmlNode4 = psXmlNode.addChild("display");
                if (pvDisplayOptionArray[n].getOption(1)) {
                    psXmlNode4.addAttribute("antialias", "show");
                } else {
                    psXmlNode4.addAttribute("antialias", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(2)) {
                    psXmlNode4.addAttribute("autorotate", "show");
                } else {
                    psXmlNode4.addAttribute("autorotate", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(3)) {
                    psXmlNode4.addAttribute("axes", "show");
                } else {
                    psXmlNode4.addAttribute("axes", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(4)) {
                    psXmlNode4.addAttribute("axesLabel", "show");
                } else {
                    psXmlNode4.addAttribute("axesLabel", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(7)) {
                    psXmlNode4.addAttribute("border", "show");
                } else {
                    psXmlNode4.addAttribute("border", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(9)) {
                    psXmlNode4.addAttribute("cross", "show");
                } else {
                    psXmlNode4.addAttribute("cross", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(10)) {
                    psXmlNode4.addAttribute("depthcue", "show");
                } else {
                    psXmlNode4.addAttribute("deptcue", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(11)) {
                    psXmlNode4.addAttribute("drawing", "show");
                } else {
                    psXmlNode4.addAttribute("drawing", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(12)) {
                    psXmlNode4.addAttribute("edgeAura", "show");
                } else {
                    psXmlNode4.addAttribute("edgeAura", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(14)) {
                    psXmlNode4.addAttribute("frame", "show");
                } else {
                    psXmlNode4.addAttribute("frame", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(14)) {
                    psXmlNode4.addAttribute("info", "show");
                } else {
                    psXmlNode4.addAttribute("info", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(14)) {
                    psXmlNode4.addAttribute("magnet", "show");
                } else {
                    psXmlNode4.addAttribute("magnet", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(14)) {
                    psXmlNode4.addAttribute("single", "show");
                } else {
                    psXmlNode4.addAttribute("single", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(19)) {
                    psXmlNode4.addAttribute("sorting", "show");
                } else {
                    psXmlNode4.addAttribute("sorting", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(14)) {
                    psXmlNode4.addAttribute("visible", "show");
                } else {
                    psXmlNode4.addAttribute("visible", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(21)) {
                    psXmlNode4.addAttribute("xyGrid", "show");
                } else {
                    psXmlNode4.addAttribute("xyGrid", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(22)) {
                    psXmlNode4.addAttribute("xzGrid", "show");
                } else {
                    psXmlNode4.addAttribute("xzGrid", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(23)) {
                    psXmlNode4.addAttribute("yzGrid", "show");
                } else {
                    psXmlNode4.addAttribute("yzGrid", "hide");
                }
                psXmlNode4.addChild("title", pvDisplayOptionArray[n].getTitle());
                PsXmlNode psXmlNode5 = psXmlNode4.addChild("cameras");
                psXmlNode5.addAttribute("select", "0");
                int n3 = pvDisplayOptionArray[n].getNumCameras();
                int n4 = 0;
                while (n4 < n3) {
                    PsXmlNode psXmlNode6 = psXmlNode5.addChild("camera");
                    n2 = pvDisplayOptionArray[n].getCameraProjection(n4);
                    switch (n2) {
                        case 0: {
                            psXmlNode6.addAttribute("projection", "perspective");
                            break;
                        }
                        case 1: {
                            psXmlNode6.addAttribute("projection", "orthoXY");
                            break;
                        }
                        case 2: {
                            psXmlNode6.addAttribute("projection", "orthoXZ");
                            break;
                        }
                        case 3: {
                            psXmlNode6.addAttribute("projection", "orthoYZ");
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown camera type = " + n2);
                        }
                    }
                    PsXmlLoader.addVector(psXmlNode6, "position", pvDisplayOptionArray[n].getCameraPosition(n4), true);
                    PsXmlLoader.addVector(psXmlNode6, "interest", pvDisplayOptionArray[n].getCameraInterest(n4), true);
                    psXmlNode6.addChild("angle", pvDisplayOptionArray[n].getCameraAngle(n4));
                    psXmlNode6.addChild("roll", pvDisplayOptionArray[n].getCameraRoll(n4));
                    object = psXmlNode6.addChild("transform");
                    if (pvDisplayOptionArray[n].isEnabledCameraTransform(n4)) {
                        ((PsXmlNode)object).addAttribute("enable", "show");
                    } else {
                        ((PsXmlNode)object).addAttribute("enable", "hide");
                    }
                    int n5 = pvDisplayOptionArray[n].getCameraAmbient(n4);
                    switch (n5) {
                        case 0: {
                            ((PsXmlNode)object).addAttribute("ambient", "R3Euclidean");
                        }
                        case 1: {
                            ((PsXmlNode)object).addAttribute("ambient", "R4Euclidean");
                        }
                        case 2: {
                            ((PsXmlNode)object).addAttribute("ambient", "S3Sphere");
                        }
                        case 3: {
                            ((PsXmlNode)object).addAttribute("ambient", "H3Hyperbolic");
                        }
                    }
                    PsDebug.warning("unknown ambient space type = " + n5);
                    int n6 = pvDisplayOptionArray[n].getCameraPerspective(n4);
                    switch (n6) {
                        case 0: {
                            ((PsXmlNode)object).addAttribute("perspective", "parallel");
                            break;
                        }
                        case 1: {
                            ((PsXmlNode)object).addAttribute("perspective", "stereographic");
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown perspective type = " + n6);
                        }
                    }
                    psXmlNode3 = psXmlNode6.addChild("clipping");
                    psXmlNode3.addChild("near", pvDisplayOptionArray[n].getCameraNearClip(n4));
                    psXmlNode3.addChild("far", pvDisplayOptionArray[n].getCameraFarClip(n4));
                    ++n4;
                }
                PsXmlNode psXmlNode7 = psXmlNode4.addChild("lights");
                PsXmlLoader.addColor(psXmlNode7, "ambient", pvDisplayOptionArray[n].getAmbientLight());
                int n7 = pvDisplayOptionArray[n].getNumLights();
                n2 = 0;
                while (n2 < n7) {
                    object = psXmlNode7.addChild("light");
                    int n8 = pvDisplayOptionArray[n].getLightType(n2);
                    switch (n8) {
                        case 1: {
                            ((PsXmlNode)object).addAttribute("type", "bulb");
                            break;
                        }
                        case 2: {
                            ((PsXmlNode)object).addAttribute("type", "rgbCube");
                            break;
                        }
                        case 3: {
                            ((PsXmlNode)object).addAttribute("type", "hue");
                            break;
                        }
                        case 4: {
                            ((PsXmlNode)object).addAttribute("type", "spot");
                            break;
                        }
                        case 5: {
                            ((PsXmlNode)object).addAttribute("type", "sun");
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown light type = " + n8);
                        }
                    }
                    PsXmlLoader.addVector((PsXmlNode)object, "position", pvDisplayOptionArray[n].getLightPosition(n2), true);
                    PsXmlLoader.addVector((PsXmlNode)object, "interest", pvDisplayOptionArray[n].getLightInterest(n2), true);
                    PsXmlLoader.addColor((PsXmlNode)object, "color", pvDisplayOptionArray[n].getLightColor(n2));
                    ++n2;
                }
                PsXmlNode psXmlNode8 = psXmlNode4.addChild("background");
                PsXmlLoader.addColor(psXmlNode8, "color", pvDisplayOptionArray[n].getBackgroundColor());
                object = pvDisplayOptionArray[n].getBackgroundImage();
                if (object != null) {
                    if (pvDisplayOptionArray[n].getOption(5)) {
                        psXmlNode8.addAttribute("image", "show");
                    }
                    PsXmlNode psXmlNode9 = psXmlNode8.addChild("image");
                    psXmlNode9.addAttribute("repeat", pvDisplayOptionArray[n].getBackgroundImageRepeat());
                    psXmlNode9.addChild("url", (String)object);
                }
                psXmlNode3 = psXmlNode4.addChild("foreground");
                PsXmlLoader.addColor(psXmlNode3, "color", pvDisplayOptionArray[n].getForegroundColor());
                object = pvDisplayOptionArray[n].getForegroundImage();
                if (object != null) {
                    if (pvDisplayOptionArray[n].getOption(13)) {
                        psXmlNode3.addAttribute("image", "show");
                    }
                    PsXmlNode psXmlNode10 = psXmlNode3.addChild("image");
                    psXmlNode10.addAttribute("repeat", pvDisplayOptionArray[n].getForegroundImageRepeat());
                    psXmlNode10.addChild("url", (String)object);
                }
                PsXmlNode psXmlNode11 = psXmlNode4.addChild("window");
                Point point = pvDisplayOptionArray[n].getWindowPosition();
                if (point != null) {
                    psXmlNode11.addChild("x", point.x);
                    psXmlNode11.addChild("y", point.y);
                }
                if ((dimension = pvDisplayOptionArray[n].getWindowSize()) != null) {
                    psXmlNode11.addChild("width", dimension.width);
                    psXmlNode11.addChild("height", dimension.height);
                }
                ++n;
            }
        }
        return psXmlSrc;
    }
}

