/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PvDisplayOption
extends P_Vector {
    public static final int SHOW_ANTIALIAS = 1;
    public static final int SHOW_AUTOROTATE = 2;
    public static final int SHOW_AXES = 3;
    public static final int SHOW_AXES_LABEL = 4;
    public static final int SHOW_BACKGROUND_IMAGE = 5;
    public static final int SHOW_BORDER = 7;
    public static final int SHOW_CROSS = 9;
    public static final int SHOW_DEPTHCUE = 10;
    public static final int SHOW_DRAWING = 11;
    public static final int SHOW_EDGE_AURA = 12;
    public static final int SHOW_FOREGROUND_IMAGE = 13;
    public static final int SHOW_FRAME = 14;
    public static final int SHOW_INFO = 15;
    public static final int SHOW_LIGHTING = 16;
    public static final int SHOW_MAGNET = 17;
    public static final int SHOW_SINGLE = 18;
    public static final int SHOW_SORTING = 19;
    public static final int SHOW_VISIBLE = 20;
    public static final int SHOW_XY_GRID = 21;
    public static final int SHOW_XZ_GRID = 22;
    public static final int SHOW_YZ_GRID = 23;
    public static final int LIGHT_BULB = 1;
    public static final int LIGHT_RGB_CUBE = 2;
    public static final int LIGHT_HUE = 3;
    public static final int LIGHT_SPOT = 4;
    public static final int LIGHT_SUN = 5;
    protected String m_version = "0.10";
    protected String m_versionType = "dump";
    protected String m_title;
    protected String m_abstract;
    protected int m_dim;
    protected PdVector m_boundingBoxRatios;
    protected String[] m_axesLabel;
    protected int m_numCameras;
    protected int m_currentCamera;
    protected int[] m_cameraProjection;
    protected PdVector[] m_cameraPosition;
    protected PdVector[] m_cameraInterest;
    protected double[] m_cameraRoll;
    protected double[] m_cameraAngle;
    protected boolean[] m_cameraEnableTransform;
    protected int[] m_cameraAmbient;
    protected int[] m_cameraPerspective;
    protected boolean[] m_cameraEnableClip;
    protected double[] m_cameraNearClip;
    protected double[] m_cameraFarClip;
    protected int m_numLights;
    protected Color m_ambientLight;
    protected int[] m_lightType;
    protected PdVector[] m_lightPosition;
    protected PdVector[] m_lightInterest;
    protected Color[] m_lightColor;
    protected Color m_backgroundColor;
    protected String m_backgroundImageRepeat;
    protected String m_backgroundImage;
    protected Color m_foregroundColor;
    protected String m_foregroundImageRepeat;
    protected String m_foregroundImage;
    protected Point m_windowPosition;
    protected Dimension m_windowSize;
    protected PdVector m_viewCenter;
    protected PiVector m_axesEdge;

    public void setCameraPerspective(int n, int n2) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraPerspective[n] = n2;
    }

    public double getCameraRoll(int n) {
        return this.m_cameraRoll[n];
    }

    public void setCameraRoll(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraRoll[n] = d;
    }

    public void setEnabledCameraTransform(int n, boolean bl) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraEnableTransform[n] = bl;
    }

    public String getBackgroundImage() {
        return this.m_backgroundImage;
    }

    public void setBackgroundImage(String string) {
        this.m_backgroundImage = string;
    }

    public boolean isEnabledCameraClip(int n) {
        return this.m_cameraEnableClip[n];
    }

    protected boolean getOption(int n) {
        return this.hasTag(n);
    }

    protected void setOption(int n, boolean bl) {
        if (bl) {
            this.setTag(n);
            return;
        }
        this.clearTag(n);
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public PiVector getAxesEdge() {
        return this.m_axesEdge;
    }

    public int getCameraAmbient(int n) {
        return this.m_cameraAmbient[n];
    }

    public void setCameraAmbient(int n, int n2) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraAmbient[n] = n2;
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColor = color;
    }

    public void setAxesEdge(PiVector piVector) {
        this.m_axesEdge = piVector;
    }

    public int getCurrentCamera() {
        return this.m_currentCamera;
    }

    public void setCurrentCamera(int n) {
        this.m_currentCamera = n;
    }

    public int getNumLights() {
        return this.m_numLights;
    }

    public void setNumLights(int n) {
        if (n < 0) {
            PsDebug.warning("number = " + n + " < 0");
            return;
        }
        if (n < this.m_numLights) {
            return;
        }
        this.m_numLights = n + 1;
        this.m_lightType = PuData.realloc(this.m_lightType, this.m_numLights);
        this.m_lightPosition = PdVector.realloc(this.m_lightPosition, this.m_numLights);
        this.m_lightInterest = PdVector.realloc(this.m_lightInterest, this.m_numLights);
        this.m_lightColor = PdColor.realloc(this.m_lightColor, this.m_numLights);
    }

    public boolean isEnabledCameraTransform(int n) {
        return this.m_cameraEnableTransform[n];
    }

    public double getCameraFarClip(int n) {
        return this.m_cameraFarClip[n];
    }

    public void setCameraFarClip(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraFarClip[n] = d;
    }

    public PdVector getCameraPosition(int n) {
        return this.m_cameraPosition[n];
    }

    public void setCameraPosition(int n, PdVector pdVector) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraPosition[n].copy(pdVector);
    }

    public Color getAmbientLight() {
        return this.m_ambientLight;
    }

    public void setAmbientLight(Color color) {
        this.m_ambientLight = color;
    }

    public PdVector getLightPosition(int n) {
        return this.m_lightPosition[n];
    }

    public void setLightPosition(int n, PdVector pdVector) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightPosition[n] = pdVector;
    }

    public void configure(PvDisplayIf pvDisplayIf) {
        pvDisplayIf.setPaintTag(64, this.getOption(1));
        pvDisplayIf.setEnabledAnimation(this.getOption(2));
        pvDisplayIf.showAxes(this.getOption(3));
        pvDisplayIf.showBackImage(this.getOption(5));
        if (this.getBackgroundImage() != null) {
            pvDisplayIf.setBackgroundImage(this.getBackgroundImage());
        }
        pvDisplayIf.setPaintTag(4, this.getOption(7));
        pvDisplayIf.setPaintTag(16, this.getOption(9));
        pvDisplayIf.showDepthcue(this.getOption(10));
        pvDisplayIf.setPaintTag(1, this.getOption(11));
        pvDisplayIf.showEdgeAura(this.getOption(12));
        pvDisplayIf.showFrame(this.getOption(14));
        pvDisplayIf.setPaintTag(256, this.getOption(15));
        pvDisplayIf.showMagnet(this.getOption(17));
        pvDisplayIf.setPaintTag(2048, this.getOption(18));
        pvDisplayIf.setEnabledPainters(this.getOption(19));
        pvDisplayIf.showGrid(this.getOption(21));
        int n = 0;
        while (n < this.m_numCameras) {
            pvDisplayIf.selectCamera(this.m_cameraProjection[n]);
            PvCameraIf pvCameraIf = pvDisplayIf.getCamera();
            pvCameraIf.setPosition(this.m_cameraPosition[n]);
            pvCameraIf.setInterest(this.m_cameraInterest[n]);
            pvCameraIf.setRoll(this.m_cameraRoll[n]);
            pvCameraIf.setScale(900.0 / this.m_cameraAngle[n]);
            ++n;
        }
    }

    public int getCameraProjection(int n) {
        return this.m_cameraProjection[n];
    }

    public void setCameraProjection(int n, int n2) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraProjection[n] = n2;
    }

    public String getAbstract() {
        return this.m_abstract;
    }

    public Point getWindowPosition() {
        return this.m_windowPosition;
    }

    public void setAbstract(String string) {
        this.m_abstract = string;
    }

    public void setWindowPosition(int n, int n2) {
        this.m_windowPosition = new Point(n, n2);
    }

    public Dimension getWindowSize() {
        return this.m_windowSize;
    }

    public void setWindowSize(int n, int n2) {
        this.m_windowSize = new Dimension(n, n2);
    }

    public String[] getAxesLabel() {
        return this.m_axesLabel;
    }

    public void setAxesLabel(String[] stringArray) {
        this.m_axesLabel = stringArray;
    }

    public void setOptions(PvDisplayIf pvDisplayIf) {
        this.setOption(1, pvDisplayIf.hasPaintTag(64));
        this.setOption(2, pvDisplayIf.isEnabledAnimation());
        this.setOption(3, pvDisplayIf.isShowingAxes());
        this.setOption(5, pvDisplayIf.isShowingBackImage());
        this.setOption(7, pvDisplayIf.hasPaintTag(4));
        this.setOption(9, pvDisplayIf.hasPaintTag(16));
        this.setOption(10, pvDisplayIf.isShowingDepthcue());
        this.setOption(11, pvDisplayIf.hasPaintTag(1));
        this.setOption(12, pvDisplayIf.isShowingEdgeAura());
        this.setOption(14, pvDisplayIf.isShowingFrame());
        this.setOption(15, pvDisplayIf.hasPaintTag(256));
        this.setOption(17, pvDisplayIf.isShowingMagnet());
        this.setOption(18, pvDisplayIf.hasPaintTag(2048));
        this.setOption(19, pvDisplayIf.isEnabledPainters());
        this.setOption(21, pvDisplayIf.isShowingGrid());
        this.setNumCameras(1);
        PvCameraIf pvCameraIf = pvDisplayIf.getCamera();
        int n = 0;
        this.setCameraPosition(n, pvCameraIf.getPosition());
        this.setCameraInterest(n, pvCameraIf.getInterest());
        this.setCameraRoll(n, pvCameraIf.getRoll());
        this.setCameraAngle(n, 10.0);
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public String getVersionType() {
        return this.m_versionType;
    }

    public void setVersionType(String string) {
        this.m_versionType = string;
    }

    public PdVector getCameraInterest(int n) {
        return this.m_cameraInterest[n];
    }

    public void setCameraInterest(int n, PdVector pdVector) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraInterest[n].copy(pdVector);
    }

    public void setEnabledCameraClip(int n, boolean bl) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraEnableClip[n] = bl;
    }

    public double getCameraNearClip(int n) {
        return this.m_cameraNearClip[n];
    }

    public void setCameraNearClip(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraNearClip[n] = d;
    }

    public int getLightType(int n) {
        return this.m_lightType[n];
    }

    public void setLightType(int n, int n2) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightType[n] = n2;
    }

    public PdVector getLightInterest(int n) {
        return this.m_lightInterest[n];
    }

    public void setLightInterest(int n, PdVector pdVector) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightInterest[n] = pdVector;
    }

    public String getForegroundImageRepeat() {
        return this.m_foregroundImageRepeat;
    }

    public void setForegroundImageRepeat(String string) {
        this.m_foregroundImageRepeat = string;
    }

    public String getForegroundImage() {
        return this.m_foregroundImage;
    }

    public void setForegroundImage(String string) {
        this.m_foregroundImage = string;
    }

    public int getNumCameras() {
        return this.m_numCameras;
    }

    public void setNumCameras(int n) {
        if (n < 0) {
            PsDebug.warning("num = " + n + " < 0");
            return;
        }
        if (n < this.m_numCameras) {
            return;
        }
        this.m_numCameras = n;
        this.m_cameraProjection = PuData.realloc(this.m_cameraProjection, this.m_numCameras);
        this.m_cameraPosition = PdVector.realloc(this.m_cameraPosition, this.m_numCameras, this.m_dim);
        this.m_cameraInterest = PdVector.realloc(this.m_cameraInterest, this.m_numCameras, this.m_dim);
        this.m_cameraAngle = PuData.realloc(this.m_cameraAngle, this.m_numCameras);
        this.m_cameraRoll = PuData.realloc(this.m_cameraRoll, this.m_numCameras);
        this.m_cameraEnableTransform = PuData.realloc(this.m_cameraEnableTransform, this.m_numCameras);
        this.m_cameraAmbient = PuData.realloc(this.m_cameraAmbient, this.m_numCameras);
        this.m_cameraPerspective = PuData.realloc(this.m_cameraPerspective, this.m_numCameras);
        this.m_cameraEnableClip = PuData.realloc(this.m_cameraEnableClip, this.m_numCameras);
        this.m_cameraNearClip = PuData.realloc(this.m_cameraNearClip, this.m_numCameras);
        this.m_cameraFarClip = PuData.realloc(this.m_cameraFarClip, this.m_numCameras);
    }

    public String getBackgroundImageRepeat() {
        return this.m_backgroundImageRepeat;
    }

    public void setBackgroundImageRepeat(String string) {
        this.m_backgroundImageRepeat = string;
    }

    public PvDisplayOption() {
        this.setOption(1, false);
        this.setOption(2, false);
        this.setOption(3, false);
        this.setOption(4, false);
        this.setOption(5, false);
        this.setOption(7, false);
        this.setOption(9, false);
        this.setOption(10, true);
        this.setOption(11, true);
        this.setOption(12, false);
        this.setOption(13, false);
        this.setOption(14, false);
        this.setOption(15, false);
        this.setOption(16, false);
        this.setOption(17, false);
        this.setOption(18, false);
        this.setOption(19, true);
        this.setOption(20, true);
        this.setOption(21, false);
        this.setOption(22, false);
        this.setOption(23, false);
        this.m_dim = 3;
        this.m_axesLabel = new String[]{"x", "y", "z"};
    }

    public Color getLightColor(int n) {
        return this.m_lightColor[n];
    }

    public void setLightColor(int n, Color color) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightColor[n] = color;
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.m_foregroundColor = color;
    }

    private boolean assureCameraIndex(int n) {
        if (n < 0) {
            PsDebug.warning("index = " + n + " < 0");
            return false;
        }
        if (n < this.m_numCameras) {
            return true;
        }
        this.setNumCameras(n + 1);
        return true;
    }

    private boolean assureLightIndex(int n) {
        if (n < 0) {
            PsDebug.warning("index = " + n + " < 0");
            return false;
        }
        if (n < this.m_numLights) {
            return true;
        }
        this.setNumLights(n + 1);
        return true;
    }

    public double getCameraAngle(int n) {
        return this.m_cameraAngle[n];
    }

    public void setCameraAngle(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraAngle[n] = d;
    }

    public PdVector getBoundingBoxRatios() {
        return this.m_boundingBoxRatios;
    }

    public void setBoundingBoxRatios(PdVector pdVector) {
        this.m_boundingBoxRatios = pdVector;
    }

    public int getCameraPerspective(int n) {
        return this.m_cameraPerspective[n];
    }
}

