/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public final class PuDouble
extends PsObject {
    protected int m_iValue;
    protected int m_numOfIncrements;
    protected static final int m_iLineIncr = 1;
    protected int m_iPageIncr;
    protected double m_shownAccuracy = 100000.0;
    private double m_defValue = 0.0;
    private double m_defMinimum = -10.0;
    private double m_defMaximum = 10.0;
    private double m_defLineIncr = 0.1;
    private double m_defPageIncr = 1.0;
    protected double m_value;
    protected double m_minimum;
    protected double m_maximum;
    protected double m_lineIncr;
    protected double m_pageIncr;
    protected boolean m_enabled = true;
    private boolean m_bPanelInitialized = false;

    public void setValue(double d) {
        PsPanel psPanel;
        if (d < this.m_minimum) {
            d = this.m_minimum;
        } else if (this.m_maximum < d) {
            d = this.m_maximum;
        }
        if (this.m_value == d) {
            return;
        }
        this.m_value = d;
        this.m_iValue = (int)((this.m_value - this.m_minimum) / this.m_lineIncr);
        if (this.hasInspector("Info") && ((psPanel = this.getInspector("Info")).isShowing() || !this.m_bPanelInitialized)) {
            this.m_bPanelInitialized = true;
            psPanel.update(this);
        }
    }

    public double getValue() {
        return this.m_value;
    }

    public double getMin() {
        return this.m_minimum;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public PuDouble(String string, PsUpdateIf psUpdateIf) {
        this.setTag(4);
        this.setTag(6);
        this.setParent(psUpdateIf);
        this.setName(string);
        this.init();
    }

    public void blend(double d, PuDouble puDouble, double d2, PuDouble puDouble2) {
        this.m_defValue = d * puDouble.m_defValue + d2 * puDouble2.m_defValue;
        this.m_defMinimum = d * puDouble.m_defMinimum + d2 * puDouble2.m_defMinimum;
        this.m_defMaximum = d * puDouble.m_defMaximum + d2 * puDouble2.m_defMaximum;
        this.m_defLineIncr = d * puDouble.m_defLineIncr + d2 * puDouble2.m_defLineIncr;
        this.m_defPageIncr = d * puDouble.m_defPageIncr + d2 * puDouble2.m_defPageIncr;
        this.m_value = d * puDouble.m_value + d2 * puDouble2.m_value;
        this.m_minimum = d * puDouble.m_minimum + d2 * puDouble2.m_minimum;
        this.m_maximum = d * puDouble.m_maximum + d2 * puDouble2.m_maximum;
        this.m_lineIncr = d * puDouble.m_lineIncr + d2 * puDouble2.m_lineIncr;
        this.m_pageIncr = d * puDouble.m_pageIncr + d2 * puDouble2.m_pageIncr;
    }

    public void setDefBounds(double d, double d2, double d3, double d4) {
        this.m_defMinimum = d;
        this.m_defMaximum = d2;
        this.m_defLineIncr = d3;
        this.m_defPageIncr = d4;
    }

    protected void setIntValue(int n) {
        this.m_value = this.m_minimum + (double)n * this.m_lineIncr;
        this.m_iValue = n;
    }

    public void setDefValue(double d) {
        this.m_defValue = d;
    }

    public boolean update(Object object) {
        if (object == this.m_infoPanel) {
            return super.update(null);
        }
        return super.update(object);
    }

    protected void setValueFromPanel(double d) {
        if (d < this.m_minimum) {
            this.m_value = this.m_minimum;
            this.m_iValue = 0;
            this.getInspector("Info").update(this);
            return;
        }
        if (this.m_maximum < d) {
            this.m_value = this.m_maximum;
            this.m_iValue = this.m_numOfIncrements;
            this.getInspector("Info").update(this);
            return;
        }
        this.m_value = d;
        this.m_iValue = (int)((this.m_value - this.m_minimum) / this.m_lineIncr);
    }

    public double getLineIncr() {
        return this.m_lineIncr;
    }

    public void copy(PuDouble puDouble) {
        super.copy(puDouble);
        this.m_iValue = puDouble.m_iValue;
        this.m_numOfIncrements = puDouble.m_numOfIncrements;
        this.m_iPageIncr = puDouble.m_iPageIncr;
        this.m_shownAccuracy = puDouble.m_shownAccuracy;
        this.m_defValue = puDouble.m_defValue;
        this.m_defMinimum = puDouble.m_defMinimum;
        this.m_defMaximum = puDouble.m_defMaximum;
        this.m_defLineIncr = puDouble.m_defLineIncr;
        this.m_defPageIncr = puDouble.m_defPageIncr;
        this.m_value = puDouble.m_value;
        this.m_minimum = puDouble.m_minimum;
        this.m_maximum = puDouble.m_maximum;
        this.m_lineIncr = puDouble.m_lineIncr;
        this.m_pageIncr = puDouble.m_pageIncr;
    }

    public double getMax() {
        return this.m_maximum;
    }

    public double getPageIncr() {
        return this.m_pageIncr;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        PsPanel psPanel;
        this.m_minimum = d;
        this.m_maximum = d2;
        this.m_lineIncr = d3;
        this.m_pageIncr = d4;
        this.m_numOfIncrements = (int)((this.m_maximum - this.m_minimum + d4) / this.m_lineIncr);
        this.m_iPageIncr = (int)(d4 / d3);
        this.setValue(this.m_value);
        if (this.hasInspector("Info") && (psPanel = this.getInspector("Info")).isShowing()) {
            psPanel.update(this);
        }
    }

    public void init() {
        super.init();
        this.m_shownAccuracy = 100000.0;
        this.setBounds(this.m_defMinimum, this.m_defMaximum, this.m_defLineIncr, this.m_defPageIncr);
        this.m_value = 0.0;
        this.m_iValue = (int)((this.m_value - this.m_minimum) / this.m_lineIncr);
        this.setValue(this.m_defValue);
        if (this.hasInspector("Info")) {
            this.getInspector("Info").update(this);
        }
    }

    public void setBounds(double d, double d2) {
        this.setBounds(d, d2, this.m_defLineIncr, this.m_defPageIncr);
    }

    public void setEnabled(boolean bl) {
        if (this.m_enabled == bl) {
            return;
        }
        this.m_enabled = bl;
        if (this.hasInspector("Info")) {
            this.getInspector("Info").setEnabled(bl);
        }
    }
}

