/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;

public final class PsConsole
extends PsDialog
implements Runnable,
ItemListener {
    protected static final String HEADER_TEXT = "*** " + PsConfig.getMessage("InfoOf") + " " + PsConfig.getProgram() + " *********\n" + "\tJavaView v" + PsConfig.getVersion() + " " + PsConfig.getMessage("by") + " " + PsConfig.getAuthors() + "\n" + "\t" + PsConfig.getMessage("TopicOfThisVersion") + " = " + PsConfig.getTopic() + "\n\n";
    protected Checkbox m_cNotify;
    protected Checkbox m_cWarning;
    protected Checkbox m_cError;
    protected TextArea m_textArea;
    protected Button m_bClear;
    private boolean bRunning;

    public void removeAll() {
        this.m_textArea.setText("");
    }

    protected void stop() {
        this.bRunning = false;
    }

    public TextArea getTextArea() {
        if (this.m_textArea == null) {
            this.m_textArea = new TextArea(HEADER_TEXT, 50, 80, 0);
            this.m_textArea.setFont(new Font("Courier", 0, 12));
            this.m_textArea.setEditable(false);
        }
        return this.m_textArea;
    }

    public PsConsole(Frame frame) {
        super(frame, "JavaView " + PsConfig.getMessage("Console"), false);
        this.init();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_cNotify) {
            PsDebug.setNotify(this.m_cNotify.getState());
            return;
        }
        if (object == this.m_cWarning) {
            PsDebug.setWarning(this.m_cWarning.getState());
            return;
        }
        if (object == this.m_cError) {
            PsDebug.setError(this.m_cError.getState());
        }
    }

    public boolean update() {
        this.m_cNotify.setState(PsDebug.isNotify());
        this.m_cWarning.setState(PsDebug.isWarning());
        this.m_cError.setState(PsDebug.isError());
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bClear) {
            this.m_textArea.setText(HEADER_TEXT);
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public void run() {
        this.bRunning = true;
        if (this.bRunning) {
            try {
                Thread.sleep(PsDebug.getFlushInterval());
            }
            catch (InterruptedException interruptedException) {}
            PsDebug.flushMessages();
            return;
        }
    }

    public void init() {
        super.init();
        this.setLayout(new BorderLayout(5, 5));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3));
        this.add("North", panel);
        this.m_cNotify = new Checkbox(PsConfig.getMessage("cNotify"));
        this.m_cNotify.addItemListener(this);
        this.m_cNotify.setState(PsDebug.isNotify());
        this.m_cNotify.setEnabled(false);
        panel.add(this.m_cNotify);
        this.m_cWarning = new Checkbox(PsConfig.getMessage("cWarning"));
        this.m_cWarning.addItemListener(this);
        this.m_cWarning.setState(PsDebug.isWarning());
        panel.add(this.m_cWarning);
        this.m_cError = new Checkbox(PsConfig.getMessage("cError"));
        this.m_cError.addItemListener(this);
        this.m_cError.setState(PsDebug.isError());
        panel.add(this.m_cError);
        this.m_textArea = this.getTextArea();
        this.add("Center", this.m_textArea);
        Panel panel2 = this.getBottomButtons(2);
        this.m_bClear = new Button(PsConfig.getMessage("bClear"));
        this.m_bClear.addActionListener(this);
        panel2.add(this.m_bClear);
        this.add("South", panel2);
        this.pack();
    }

    public void append(StringBuffer stringBuffer) {
        if (this.getTextArea() == null) {
            System.out.println("PdDebug.append(): missing text area, msg = " + stringBuffer.toString());
            return;
        }
        this.m_textArea.append(stringBuffer.toString());
    }
}

