/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.URL;
import java.util.Hashtable;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.rsrc.JarResources;

public class PsImage {
    protected transient Image m_image;
    protected URL m_imageUrl;
    protected String m_imageString;
    protected String m_alternateText;
    protected int m_width;
    protected int m_height;
    protected boolean m_explicitSize = false;
    protected int m_explicitWidth = 0;
    protected int m_explicitHeight = 0;
    protected MediaTracker m_tracker;
    protected Component m_parentComponent;
    protected static int m_lastTrackerID = 0;
    protected int m_currentTrackerID;
    protected boolean m_bDoneLoading = false;
    private static Hashtable m_hashImage;

    public PsImage(URL uRL) {
        this.m_imageUrl = uRL;
        this.m_imageString = uRL.toString();
        this.m_alternateText = this.m_imageUrl.getFile();
        this.m_image = PsImage.getImage(this.m_imageUrl);
        this.init();
    }

    public PsImage(String string) {
        this.m_imageString = string;
        this.m_alternateText = string;
        this.m_image = PsImage.getImage(string);
        this.init();
    }

    public PsImage(Image image, String string) {
        this.m_image = image;
        this.m_imageString = string;
        this.m_alternateText = string;
        this.init();
    }

    public boolean loadImage() {
        if (this.m_bDoneLoading) {
            return true;
        }
        try {
            this.m_tracker.waitForID(this.m_currentTrackerID);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            PsDebug.warning("Error loading image " + this.m_imageString + ": " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        if (this.m_tracker.isErrorID(this.m_currentTrackerID)) {
            PsDebug.warning("Error loading image " + this.m_imageString);
            return false;
        }
        this.m_bDoneLoading = true;
        this.m_width = this.m_image.getWidth(null);
        this.m_height = this.m_image.getHeight(null);
        return true;
    }

    public static boolean loadImage(Component component, Image image) {
        if (image == null) {
            PsDebug.warning("missing argument image.");
            return false;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        int n = 0;
        mediaTracker.addImage(image, n);
        try {
            mediaTracker.waitForID(n);
        }
        catch (Exception exception) {
            PsDebug.warning("error loading image " + image.toString() + ": " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        if (mediaTracker.isErrorID(n)) {
            new Throwable("Error loading image " + image.toString()).printStackTrace();
            return false;
        }
        return true;
    }

    public static int[] getPixels(Image image, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        if (image == null) {
            PsDebug.warning("missing image");
            return null;
        }
        if (nArray == null) {
            if (n3 > 0 && n4 > 0) {
                nArray = new int[n3 * n4];
            }
            if (nArray == null) {
                PsDebug.warning("missing image size to create missing pixels");
                return null;
            }
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, nArray, 0, n6);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            PsDebug.warning("could not grab pixels");
            return null;
        }
        return nArray;
    }

    public static int[] getPixels(Image image) {
        int[] nArray = null;
        if (image != null) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n != -1 && n2 != -1) {
                nArray = new int[n * n2];
                PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
                try {
                    pixelGrabber.grabPixels();
                }
                catch (Exception exception) {
                    System.err.println("Exception: " + exception);
                    PsDebug.warning("could not grab pixels");
                    return null;
                }
            }
        }
        return nArray;
    }

    public static PsImage getImageFromArchive(String string, String string2) {
        Image image = null;
        PsImage psImage = null;
        if (m_hashImage != null && (psImage = (PsImage)m_hashImage.get(string)) != null) {
            PsDebug.message("Image take from hashtable, image = " + string);
            return psImage;
        }
        PsDebug.message("Second attempt: reading Jar file directly");
        try {
            JarResources jarResources = PsConfig.isApplication() ? new JarResources(string2) : new JarResources(PsConfig.getCodeBase() + string2, false);
            if (jarResources == null) {
                PsDebug.warning("failed to create resource for jar archive = " + string2);
                return new PsImage(string);
            }
            byte[] byArray = jarResources.getResource(string);
            if (byArray == null) {
                PsDebug.warning("failed to create blob for image = " + string);
                return new PsImage(string);
            }
            image = Toolkit.getDefaultToolkit().createImage(byArray);
            psImage = new PsImage(image, "ColorPicker");
            if (!psImage.loadImage()) {
                PsDebug.warning("failed to load image = " + string);
                return null;
            }
        }
        catch (Exception exception) {
            PsDebug.warning("exception during loading of image = " + string);
            return null;
        }
        if (m_hashImage == null) {
            m_hashImage = new Hashtable();
        }
        m_hashImage.put(string, psImage);
        return psImage;
    }

    public int getHeight() {
        return this.m_height;
    }

    public Image getImage() {
        boolean bl;
        if (!this.m_bDoneLoading && !(bl = this.loadImage())) {
            PsDebug.warning("loading of image failed = " + this.m_imageString);
            return null;
        }
        return this.m_image;
    }

    public void setSize(int n, int n2) {
        this.m_explicitSize = true;
        this.getImage();
        double d = (0.5 + (double)this.m_width) / (double)this.m_height;
        this.m_explicitWidth = n;
        this.m_explicitHeight = n2;
        if (n < 0 && n2 > 0) {
            this.m_explicitWidth = (int)(d * (double)n2);
        } else if (n > 0 && n2 < 0) {
            this.m_explicitHeight = (int)((double)n / d);
        }
        this.m_image = this.m_image.getScaledInstance(this.m_explicitWidth, this.m_explicitWidth, 4);
    }

    public static Image getImage(String string) {
        Image image = !PsConfig.isApplication() ? PsConfig.getApplet().getImage(PsConfig.getApplet().getCodeBase(), string) : Toolkit.getDefaultToolkit().getImage(string);
        return image;
    }

    public static Image getImage(URL uRL) {
        Image image = !PsConfig.isApplication() ? PsConfig.getApplet().getImage(uRL) : Toolkit.getDefaultToolkit().getImage(uRL);
        return image;
    }

    public void init() {
        this.m_tracker = this.m_parentComponent != null ? new MediaTracker(this.m_parentComponent) : new MediaTracker(PsConfig.getFrame());
        this.m_currentTrackerID = m_lastTrackerID++;
        this.m_tracker.addImage(this.m_image, this.m_currentTrackerID);
    }

    public void setParentComponent(Component component) {
        this.m_parentComponent = component;
    }

    public int getWidth() {
        return this.m_width;
    }

    public static Image createImageFromPixels(Component component, int[] nArray, int n, int n2, int n3, int n4) {
        Image image = component.createImage(new MemoryImageSource(n, n2, nArray, n3, n4));
        if (PsImage.loadImage(component, image)) {
            return image;
        }
        return null;
    }
}

