/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;

public abstract class PsMethodMenu
extends Vector
implements ActionListener,
ItemListener {
    private PsObject m_object;
    protected String m_language = PsConfig.getLanguage();

    public Menu addMenu(String string) {
        if (string == null) {
            PsDebug.warning("missing argument label");
            return null;
        }
        Menu menu = this.getMenu(string);
        if (menu != null) {
            return menu;
        }
        menu = new Menu(string);
        menu.setFont(PsConfig.getFont(2));
        this.addElement(menu);
        return menu;
    }

    public boolean applyMethod(String string) {
        return false;
    }

    public MenuItem getMenuItem(String string, String string2) {
        if (string == null || string2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Menu menu = this.getMenu(string);
        if (menu == null) {
            return null;
        }
        int n = menu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menu.getItem(n2);
            if (string2.equals(menuItem.getLabel())) {
                return menuItem;
            }
            ++n2;
        }
        return null;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_object == null) {
            return;
        }
        String string = (String)itemEvent.getItem();
        this.applyMethod(string);
        this.m_object.update(this.m_object);
    }

    public boolean hasMenuItem(String string, String string2) {
        return this.getMenuItem(string, string2) != null;
    }

    public void removeMenuItem(String string, String string2) {
        if (string == null || string2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (!this.hasMenuItem(string, string2)) {
            return;
        }
        Menu menu = this.getMenu(string);
        MenuItem menuItem = this.getMenuItem(string, string2);
        menuItem.removeActionListener(this);
        menu.remove(menuItem);
    }

    public static int getIndexOfMethod(String[] stringArray, String string) {
        if (stringArray != null || stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_object == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        this.applyMethod(string);
        this.m_object.update(this.m_object);
    }

    public MenuItem addMenuItem(String string, String string2) {
        if (string == null || string2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        MenuItem menuItem = this.getMenuItem(string, string2);
        if (menuItem != null) {
            return menuItem;
        }
        Menu menu = this.getMenu(string);
        if (menu == null) {
            PsDebug.warning("missing menu = " + string);
            return null;
        }
        menuItem = new MenuItem(string2);
        menuItem.addActionListener(this);
        menuItem.setFont(PsConfig.getFont(2));
        menu.add(menuItem);
        return menuItem;
    }

    public CheckboxMenuItem addMenuItem(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(string, string2);
        if (checkboxMenuItem != null) {
            checkboxMenuItem.setState(bl);
            return checkboxMenuItem;
        }
        Menu menu = this.getMenu(string);
        if (menu == null) {
            PsDebug.warning("missing menu = " + string);
            return null;
        }
        checkboxMenuItem = new CheckboxMenuItem(string2, bl);
        checkboxMenuItem.addItemListener(this);
        checkboxMenuItem.setFont(PsConfig.getFont(2));
        menu.add(checkboxMenuItem);
        return checkboxMenuItem;
    }

    public Menu getMenu(String string) {
        if (string == null) {
            PsDebug.warning("missing argument label");
            return null;
        }
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Menu menu = (Menu)this.elementAt(n2);
            if (string.equals(menu.getLabel())) {
                return menu;
            }
            ++n2;
        }
        return null;
    }

    public void init(PsObject psObject) {
        this.m_object = psObject;
    }

    public Object clone() {
        PsMethodMenu psMethodMenu = (PsMethodMenu)super.clone();
        if (psMethodMenu == null) {
            return null;
        }
        psMethodMenu.m_object = null;
        psMethodMenu.removeAllElements();
        return psMethodMenu;
    }

    public boolean hasMenu(String string) {
        return this.getMenu(string) != null;
    }

    public void removeMenu(String string) {
        if (string == null) {
            PsDebug.warning("missing argument label");
            return;
        }
        Menu menu = this.getMenu(string);
        this.removeElement(menu);
    }
}

