/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Color;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvGeometryIf;
import jv.rsrc.PsAuthorInfo;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PgJvxSrc
extends PgGeometry {
    protected String m_version = "0.10";
    protected String m_versionType = "dump";
    protected String m_title;
    protected PsAuthorInfo m_author;
    protected String m_abstract;
    protected String m_detail;
    protected String[] m_keyword;
    protected String m_primary;
    protected String m_secondary;
    protected String m_software;
    protected int m_geomType;
    protected boolean m_bDefaultLabelEnabled;
    protected boolean m_bShowIndices;
    protected boolean m_bShowVertexLabels;
    protected boolean m_bShowPolygonLabels;
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowElementLabels;
    protected boolean m_bShowOutline;
    protected boolean m_bShowBackface;
    protected int m_numVertices;
    protected int m_maxNumVertices;
    protected PdVector[] m_vertex;
    protected String[][] m_vertexFunction;
    protected Color[] m_vertexColor;
    protected PdVector[] m_vertexNormal;
    protected boolean m_bShowVertices;
    protected boolean m_bShowTaggedVertices;
    protected boolean m_bShowVertexNormals;
    protected boolean m_bShowVertexNormalArrow;
    protected boolean m_bShowVertexColors;
    protected double m_globalVertexSize;
    protected Color m_globalVertexColor;
    protected Color m_globalVertexTagColor;
    protected double m_globalVertexNormalLength;
    protected double m_globalVertexNormalSize;
    protected Color m_globalVertexNormalColor;
    protected int m_numVectorFields;
    private int[] m_dimOfVectors;
    protected PdVector[][] m_vector;
    protected Color[][] m_vectorColor;
    protected String[] m_vectorName;
    protected boolean[] m_bShowVectorField;
    protected boolean[] m_bShowVectorArrow;
    protected boolean[] m_vectorIsElementBased;
    protected double[] m_globalVectorLength;
    protected double[] m_globalVectorSize;
    protected Color[] m_globalVectorColor;
    protected int m_dimOfTextures;
    protected boolean m_bShowVertexTexture;
    protected boolean m_bShowElementTexture;
    protected String m_textureImage;
    protected PdVector[] m_vertexTexture;
    protected int m_numPolygons;
    protected int m_maxNumPolygons;
    protected int m_dimOfPolygons;
    protected PiVector[] m_polygon;
    protected Color[] m_polygonColor;
    protected PdVector[] m_polygonNormal;
    protected boolean m_bShowPolygons;
    protected boolean m_bShowTaggedPolygons;
    protected boolean m_bShowPolygonNormals;
    protected boolean m_bShowPolygonNormalArrow;
    protected boolean m_bShowPolygonColors;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected Color m_globalPolygonColor;
    protected Color m_globalPolygonTagColor;
    protected double m_globalPolygonSize;
    protected double m_globalPolygonNormalLength;
    protected double m_globalPolygonNormalSize;
    protected Color m_globalPolygonNormalColor;
    protected int m_numEdges;
    protected PiVector[] m_edge;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected boolean m_bShowEdgeColors;
    protected Color[] m_edgeColor;
    protected Color m_globalEdgeColor;
    protected Color m_globalEdgeTagColor;
    protected double m_globalEdgeSize;
    protected boolean m_bShowBoundaries;
    protected boolean m_bShowTaggedBoundaries;
    protected Color m_globalBndColor;
    protected Color m_globalBndTagColor;
    protected double m_globalBndSize;
    protected int m_dimOfElements;
    protected int m_maxDimOfElements = 300;
    protected int m_numElements;
    protected int m_maxNumElements;
    protected PiVector[] m_element;
    protected Color[] m_elementColor;
    protected PdVector[] m_elementNormal;
    protected PdVector[][] m_elementTexture;
    protected boolean m_bShowElements;
    protected boolean m_bShowTaggedElements;
    protected boolean m_bShowElementNormals;
    protected boolean m_bShowElementNormalArrow;
    protected boolean m_bShowElementColors;
    protected Color m_globalElementColor;
    protected Color m_globalElementTagColor;
    protected Color m_globalElementBackColor;
    protected boolean m_bShowElementBackColor;
    protected double m_globalElementNormalLength;
    protected double m_globalElementNormalSize;
    protected Color m_globalElementNormalColor;
    protected PiVector[] m_neighbour;

    public String getTextureImage() {
        return this.m_textureImage;
    }

    public void setTextureImage(String string) {
        this.m_textureImage = string;
    }

    public PdVector[] getPolygonNormals() {
        return this.m_polygonNormal;
    }

    public void assurePolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_numPolygons) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, this.m_numPolygons, this.m_dim);
        }
    }

    public void setPolygonNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_polygonNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of normal array");
            return;
        }
        this.assurePolygonNormals();
        PdVector.copy(this.m_polygonNormal, 0, pdVectorArray, 0, this.m_numPolygons);
    }

    public boolean isShowingPolygonNormals() {
        return this.m_bShowPolygonNormals;
    }

    public void showPolygonNormals(boolean bl) {
        this.m_bShowPolygonNormals = bl;
    }

    public boolean makeElementNormals() {
        if (this.m_numElements < 1) {
            return false;
        }
        if (this.m_dim == 1 || this.m_dim == 2) {
            PsDebug.warning("normals not computed since vertex dimension = " + this.m_dim);
            return false;
        }
        this.assureElementNormals();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector.setConstant(this.m_elementNormal, 0.0);
        int n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_element[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                PdVector pdVector4 = this.m_vertex[this.m_element[n].m_data[n3]];
                PdVector pdVector5 = this.m_vertex[this.m_element[n].m_data[(n3 + 1) % n2]];
                PdVector pdVector6 = this.m_vertex[this.m_element[n].m_data[(n3 + 2) % n2]];
                pdVector.sub(pdVector4, pdVector5);
                pdVector2.sub(pdVector6, pdVector5);
                pdVector3.cross(pdVector2, pdVector);
                if (pdVector3.normalize()) {
                    this.m_elementNormal[n].add(pdVector3);
                }
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_numElements) {
            this.m_elementNormal[n].normalize();
            ++n;
        }
        return true;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public void setPolygonColorList(int n, Color[] colorArray) {
        if (colorArray == null || colorArray.length == 0) {
            this.m_polygonColor = null;
            return;
        }
        this.assurePolygonColors();
        PdColor.copy(this.m_polygonColor, 0, colorArray, 0, n);
    }

    public PiVector getEdge(int n) {
        if (n < 0 || n >= this.m_numEdges) {
            return null;
        }
        return this.m_edge[n];
    }

    public boolean setEdge(int n, PiVector piVector) {
        if (n < 0 || piVector == null) {
            PsDebug.error("index out of range, corrupt argument", this);
            return false;
        }
        if (n >= this.m_numEdges) {
            PsDebug.warning("index=" + n + " > " + this.m_numEdges + "=m_numEdges, bad programming style", this);
            this.setNumEdges(n + 1, -1);
        }
        this.m_edge[n].copy(piVector);
        return true;
    }

    public Color getGlobalVectorColor(int n) {
        return this.m_globalVectorColor[n];
    }

    public boolean setGlobalVectorColor(int n, Color color) {
        this.m_globalVectorColor[n] = color;
        return true;
    }

    public Color getGlobalBndTagColor() {
        return this.m_globalBndTagColor;
    }

    public void setGlobalBndTagColor(Color color) {
        this.m_globalBndTagColor = color;
    }

    public boolean isShowingElementBackColor() {
        return this.m_bShowElementBackColor;
    }

    public void showElementBackColor(boolean bl) {
        this.m_bShowElementBackColor = bl;
    }

    public int addVertex(PdVector pdVector) {
        this.setVertex(this.m_numVertices, pdVector);
        return this.m_numVertices - 1;
    }

    public boolean isShowingPolygonNormalArrow() {
        return this.m_bShowPolygonNormalArrow;
    }

    public void showPolygonNormalArrow(boolean bl) {
        this.m_bShowPolygonNormalArrow = bl;
    }

    public Object clone() {
        PgJvxSrc pgJvxSrc = (PgJvxSrc)super.clone();
        if (pgJvxSrc == null) {
            return null;
        }
        if (this.m_author != null) {
            pgJvxSrc.m_author = (PsAuthorInfo)this.m_author.clone();
        }
        if (this.m_keyword != null) {
            pgJvxSrc.m_keyword = (String[])this.m_keyword.clone();
        }
        if (this.m_vertex != null) {
            pgJvxSrc.m_vertex = (PdVector[])P_Vector.clone(this.m_vertex);
        }
        if (this.m_vertexColor != null) {
            pgJvxSrc.m_vertexColor = (Color[])this.m_vertexColor.clone();
        }
        if (this.m_vertexFunction != null) {
            pgJvxSrc.m_vertexFunction = PuString.clone(this.m_vertexFunction);
        }
        if (this.m_vertexNormal != null) {
            pgJvxSrc.m_vertexNormal = (PdVector[])P_Vector.clone(this.m_vertexNormal);
        }
        if (this.m_vertexTexture != null) {
            pgJvxSrc.m_vertexTexture = (PdVector[])P_Vector.clone(this.m_vertexTexture);
        }
        if (this.m_polygon != null) {
            pgJvxSrc.m_polygon = (PiVector[])P_Vector.clone(this.m_polygon);
        }
        if (this.m_polygonColor != null) {
            pgJvxSrc.m_polygonColor = (Color[])this.m_polygonColor.clone();
        }
        if (this.m_polygonNormal != null) {
            pgJvxSrc.m_polygonNormal = (PdVector[])P_Vector.clone(this.m_polygonNormal);
        }
        if (this.m_element != null) {
            pgJvxSrc.m_element = (PiVector[])P_Vector.clone(this.m_element);
        }
        if (this.m_elementColor != null) {
            pgJvxSrc.m_elementColor = (Color[])this.m_elementColor.clone();
        }
        if (this.m_elementNormal != null) {
            pgJvxSrc.m_elementNormal = (PdVector[])P_Vector.clone(this.m_elementNormal);
        }
        if (this.m_elementTexture != null) {
            pgJvxSrc.m_elementTexture = (PdVector[][])P_Vector.clone(this.m_elementTexture);
        }
        if (this.m_neighbour != null) {
            pgJvxSrc.m_neighbour = (PiVector[])P_Vector.clone(this.m_neighbour);
        }
        if (this.m_edge != null) {
            pgJvxSrc.m_edge = (PiVector[])P_Vector.clone(this.m_edge);
        }
        if (this.m_edgeColor != null) {
            pgJvxSrc.m_edgeColor = (Color[])this.m_edgeColor.clone();
        }
        return pgJvxSrc;
    }

    public int getNumVertices() {
        return this.m_numVertices;
    }

    public int getNumEdges() {
        return this.m_numEdges;
    }

    public void setNumVertices(int n) {
        if (n > this.m_maxNumVertices) {
            this.setMaxNumVertices(n);
        }
        this.m_numVertices = n;
    }

    public void setNumEdges(int n, int n2) {
        if (this.m_numEdges == n) {
            return;
        }
        this.m_edge = n2 > -1 ? PiVector.realloc(this.m_edge, n, n2) : PiVector.realloc(this.m_edge, n);
        if (this.m_edgeColor != null) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, n);
        }
        this.m_numEdges = n;
    }

    public boolean isShowingBackface() {
        return this.m_bShowBackface;
    }

    public void showBackface(boolean bl) {
        this.m_bShowBackface = bl;
        if (!this.m_bShowBackface && this.m_elementNormal == null) {
            this.makeElementNormals();
        }
    }

    public void setDefaultLabelEnabled(boolean bl) {
        this.m_bDefaultLabelEnabled = bl;
    }

    public String getDetail() {
        return this.m_detail;
    }

    public void setDetail(String string) {
        this.m_detail = string;
    }

    public String getPrimary() {
        return this.m_primary;
    }

    public void setPrimary(String string) {
        this.m_primary = string;
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl) {
        int n;
        PdVector[] pdVectorArray;
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgJvxSrc pgJvxSrc = (PgJvxSrc)super.reflect(pdMatrix, bl);
        PdVector[] pdVectorArray2 = this.getVertices();
        PdVector[] pdVectorArray3 = pgJvxSrc.getVertices();
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            pdVectorArray3[n2].leftMultAffin(pdMatrix, pdVectorArray2[n2], true);
            ++n2;
        }
        if (this.m_vertexNormal != null) {
            PdVector[] pdVectorArray4 = this.getVertexNormals();
            pdVectorArray = pgJvxSrc.getVertexNormals();
            n = 0;
            while (n < this.m_numVertices) {
                pdVectorArray[n].leftMultAffin(pdMatrix, pdVectorArray4[n], false);
                if (!bl) {
                    pdVectorArray[n].multScalar(-1.0);
                }
                pdVectorArray[n].normalize();
                ++n;
            }
        }
        if (!bl) {
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            int n3 = 0;
            while (n3 < this.m_numElements) {
                piVectorArray[n3].invert();
                ++n3;
            }
        }
        if (this.m_elementNormal != null) {
            PdVector[] pdVectorArray5 = this.getElementNormals();
            pdVectorArray = pgJvxSrc.getElementNormals();
            n = 0;
            while (n < this.m_numElements) {
                pdVectorArray[n].leftMultAffin(pdMatrix, pdVectorArray5[n], false);
                if (!bl) {
                    pdVectorArray[n].multScalar(-1.0);
                }
                pdVectorArray[n].normalize();
                ++n;
            }
        }
        return pgJvxSrc;
    }

    public int addEdge(PiVector piVector) {
        this.setEdge(this.m_numEdges, piVector);
        return this.m_numEdges - 1;
    }

    public Color[] getVertexColors() {
        return this.m_vertexColor;
    }

    public void init() {
        super.init();
    }

    public int getDimOfVectors(int n) {
        return this.m_dimOfVectors[n];
    }

    public PdVector[] getVectors(int n) {
        return this.m_vector[n];
    }

    public Color[] getVectorFieldColors(int n) {
        return this.m_vectorColor[n];
    }

    public Color[] getEdgeColors() {
        return this.m_edgeColor;
    }

    public Color[] getElementColors() {
        return this.m_elementColor;
    }

    public void assureVertexColors() {
        if (this.m_vertexColor == null || this.m_vertexColor.length != this.m_numVertices) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, this.m_numVertices);
        }
    }

    public void assureEdgeColors() {
        if (this.m_edgeColor == null || this.m_edgeColor.length != this.m_numEdges) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, this.m_numEdges);
        }
    }

    public void assureElementColors() {
        if (this.m_elementColor == null || this.m_elementColor.length != this.m_maxNumElements) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, this.m_maxNumElements);
        }
    }

    public void setVertexColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_vertexColor = null;
            return;
        }
        if (colorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexColors();
        PdColor.copy(this.m_vertexColor, 0, colorArray, 0, this.m_numVertices);
    }

    public void setVectors(int n, PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || this.m_vector == null || this.m_vector[n] == null || pdVectorArray.length < this.m_vector[n].length) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        PdVector.copy(this.m_vector[n], 0, pdVectorArray, 0, this.m_vector[n].length);
    }

    public String getAbstract() {
        return this.m_abstract;
    }

    public void setAbstract(String string) {
        this.m_abstract = string;
    }

    public void setEdgeColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_edgeColor = null;
            return;
        }
        if (colorArray.length < this.m_numEdges) {
            PsDebug.warning("void length of color array");
            return;
        }
        this.assureEdgeColors();
        PdColor.copy(this.m_edgeColor, 0, colorArray, 0, this.m_numEdges);
    }

    public void setElementColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_elementColor = null;
            return;
        }
        if (colorArray.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        this.assureElementColors();
        PdColor.copy(this.m_elementColor, 0, colorArray, 0, this.m_numElements);
    }

    public boolean isShowingVertexColors() {
        return this.m_bShowVertexColors;
    }

    public double getGlobalVectorSize(int n) {
        return this.m_globalVectorSize[n];
    }

    public boolean setGlobalVectorSize(int n, double d) {
        this.m_globalVectorSize[n] = d;
        return true;
    }

    public void showVertexColors(boolean bl) {
        this.m_bShowVertexColors = bl;
    }

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public void showPolygonStartArrow(boolean bl) {
        this.m_bShowPolygonStartArrow = bl;
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
    }

    public boolean isShowingElementColors() {
        return this.m_bShowElementColors;
    }

    public boolean isShowingVertexTexture() {
        return this.m_bShowVertexTexture;
    }

    public boolean isShowingElementTexture() {
        return this.m_bShowElementTexture;
    }

    public void showElementColors(boolean bl) {
        this.m_bShowElementColors = bl;
    }

    public void showVertexTexture(boolean bl) {
        this.m_bShowVertexTexture = bl;
    }

    public void showElementTexture(boolean bl) {
        this.m_bShowElementTexture = bl;
    }

    public int getNumPolygons() {
        return this.m_numPolygons;
    }

    public void setNumPolygons(int n) {
        if (n > this.m_maxNumPolygons) {
            this.setMaxNumPolygons(n);
        }
        this.m_numPolygons = n;
    }

    public boolean isDefaultLabelEnabled() {
        return this.m_bDefaultLabelEnabled;
    }

    public double getGlobalVertexNormalLength() {
        return this.m_globalVertexNormalLength;
    }

    public void setGlobalVertexNormalLength(double d) {
        this.m_globalVertexNormalLength = d;
    }

    public double getGlobalElementNormalLength() {
        return this.m_globalElementNormalLength;
    }

    public void setGlobalElementNormalLength(double d) {
        this.m_globalElementNormalLength = d;
    }

    public String getVectorFieldName(int n) {
        return this.m_vectorName[n];
    }

    public void setVectorFieldName(int n, String string) {
        this.m_vectorName[n] = string;
    }

    public PsAuthorInfo getAuthors() {
        return this.m_author;
    }

    public void setAuthors(PsAuthorInfo psAuthorInfo) {
        this.m_author = psAuthorInfo;
    }

    public PdVector[] getVertexNormals() {
        return this.m_vertexNormal;
    }

    public PdVector[] getElementNormals() {
        return this.m_elementNormal;
    }

    public void assureVertexNormals() {
        if (this.m_vertexNormal == null || this.m_vertexNormal.length != this.m_numVertices) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, this.m_numVertices, this.m_dim);
        }
    }

    public void assureElementNormals() {
        if (this.m_elementNormal == null || this.m_elementNormal.length != this.m_maxNumElements) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, this.m_maxNumElements, this.m_dim);
        }
    }

    public void setVertexNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_vertexNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexNormals();
        PdVector.copy(this.m_vertexNormal, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public void setElementNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_elementNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of normal array");
            return;
        }
        this.assureElementNormals();
        PdVector.copy(this.m_elementNormal, 0, pdVectorArray, 0, this.m_numElements);
    }

    public boolean isShowingVertexNormals() {
        return this.m_bShowVertexNormals;
    }

    public void showVertexNormals(boolean bl) {
        this.m_bShowVertexNormals = bl;
    }

    public boolean isShowingElementNormals() {
        return this.m_bShowElementNormals;
    }

    public void showElementNormals(boolean bl) {
        this.m_bShowElementNormals = bl;
    }

    public PgJvxSrc() {
        this(3);
    }

    public PgJvxSrc(int n) {
        super(n);
        this.setDimOfSimplex(1);
        this.m_dim = n;
        this.m_geomType = -1;
        this.m_bShowVertices = false;
        this.m_bShowTaggedVertices = true;
        this.m_bShowVertexNormals = false;
        this.m_bShowVertexNormalArrow = false;
        this.m_bShowVertexColors = false;
        this.m_bDefaultLabelEnabled = false;
        this.m_bShowIndices = false;
        this.m_bShowVertexLabels = false;
        this.m_bShowPolygonLabels = false;
        this.m_bShowEdgeLabels = false;
        this.m_bShowElementLabels = false;
        this.m_bShowPolygons = false;
        this.m_bShowTaggedPolygons = true;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_bShowPolygonNormals = false;
        this.m_bShowPolygonNormalArrow = false;
        this.m_bShowPolygonColors = false;
        this.m_bShowElements = true;
        this.m_bShowTaggedElements = true;
        this.m_bShowBackface = true;
        this.m_bShowElementNormals = false;
        this.m_bShowElementNormalArrow = false;
        this.m_bShowElementColors = false;
        this.m_bShowElementBackColor = false;
        this.m_bShowOutline = false;
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = true;
        this.m_bShowEdgeColors = false;
        this.m_bShowBoundaries = false;
        this.m_bShowTaggedBoundaries = true;
        this.m_bShowVertexTexture = false;
        this.m_bShowElementTexture = false;
        this.m_globalVertexSize = 2.0;
        this.m_globalVertexColor = Color.red;
        this.m_globalVertexTagColor = Color.magenta;
        this.m_globalVertexNormalSize = 1.0;
        this.m_globalVertexNormalLength = 0.5;
        this.m_globalVertexNormalColor = Color.yellow;
        this.m_numVectorFields = 0;
        this.m_vector = null;
        this.m_bShowVectorField = null;
        this.m_bShowVectorArrow = null;
        this.m_globalVectorColor = null;
        this.m_globalVectorLength = null;
        this.m_globalVectorSize = null;
        this.m_dimOfTextures = 2;
        this.m_globalPolygonColor = Color.black;
        this.m_globalPolygonTagColor = Color.red;
        this.m_globalPolygonSize = 1.0;
        this.m_globalPolygonNormalLength = 1.0;
        this.m_globalPolygonNormalSize = 1.0;
        this.m_globalPolygonNormalColor = Color.yellow;
        this.m_globalElementColor = new Color(100, 230, 255);
        this.m_globalElementBackColor = new Color(100, 230, 255);
        this.m_globalElementTagColor = Color.magenta;
        this.m_globalElementNormalSize = 1.0;
        this.m_globalElementNormalLength = 0.5;
        this.m_globalElementNormalColor = Color.yellow;
        this.m_globalEdgeColor = Color.black;
        this.m_globalEdgeTagColor = Color.red;
        this.m_globalEdgeSize = 1.0;
        this.m_globalBndColor = Color.blue;
        this.m_globalBndTagColor = Color.magenta;
        this.m_globalBndSize = 3.0;
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(85, this.m_bDefaultLabelEnabled);
        pvGeometryIf.setState(80, this.isShowingIndices());
        pvGeometryIf.setState(81, this.isShowingVertexLabels());
        pvGeometryIf.setState(83, this.isShowingEdgeLabels());
        pvGeometryIf.setState(82, this.isShowingPolygonLabels());
        pvGeometryIf.setState(84, this.isShowingElementLabels());
        pvGeometryIf.setState(50, this.m_bShowVertices);
        pvGeometryIf.setState(51, this.m_bShowTaggedVertices);
        pvGeometryIf.setGlobalVertexSize((int)this.m_globalVertexSize);
        pvGeometryIf.setGlobalVertexColor(this.m_globalVertexColor);
        pvGeometryIf.setGlobalVertexTagColor(this.m_globalVertexTagColor);
        pvGeometryIf.setNumVertices(this.m_numVertices);
        pvGeometryIf.setVertices(this.m_vertex);
        pvGeometryIf.setVertexColors(this.m_vertexColor);
        pvGeometryIf.setVertexNormals(this.m_vertexNormal);
        pvGeometryIf.setGlobalVertexNormalSize(this.m_globalVertexNormalSize);
        pvGeometryIf.setGlobalVertexNormalLength(this.m_globalVertexNormalLength);
        pvGeometryIf.setGlobalVertexNormalColor(this.m_globalVertexNormalColor);
        pvGeometryIf.setState(90, this.m_bShowVertexColors && this.m_vertexColor != null);
        pvGeometryIf.setState(60, this.m_bShowVertexNormals);
        pvGeometryIf.setState(61, this.m_bShowVertexNormalArrow);
        pvGeometryIf.setVertexTextures(this.m_vertexTexture);
        pvGeometryIf.setState(71, this.m_vertexTexture != null && this.m_bShowVertexTexture);
        if (this.m_numVectorFields > 0) {
            pvGeometryIf.setState(91, false);
            int n = 0;
            while (n < this.m_numVectorFields) {
                pvGeometryIf.setVectorList(n, this.m_vector[n]);
                if (this.m_vectorIsElementBased[n]) {
                    pvGeometryIf.setElementBased(n, true);
                } else {
                    pvGeometryIf.setElementBased(n, false);
                }
                pvGeometryIf.setGlobalVectorColor(n, this.m_globalVectorColor[n]);
                pvGeometryIf.setGlobalVectorLength(n, this.m_globalVectorLength[n]);
                pvGeometryIf.setGlobalVectorSize(n, this.m_globalVectorSize[n]);
                pvGeometryIf.setState(66, this.m_bShowVectorField[n]);
                pvGeometryIf.setState(67, this.m_bShowVectorArrow[n]);
                ++n;
            }
        } else {
            pvGeometryIf.setVectorField(null);
        }
        pvGeometryIf.setState(54, this.m_bShowPolygons);
        pvGeometryIf.setState(55, this.m_bShowTaggedPolygons);
        pvGeometryIf.setGlobalPolygonSize(this.m_globalPolygonSize);
        pvGeometryIf.setGlobalPolygonColor(this.m_globalPolygonColor);
        pvGeometryIf.setNumPolygons(this.m_numPolygons);
        pvGeometryIf.setPolygons(this.m_polygon);
        pvGeometryIf.setPolygonColors(this.m_polygonColor);
        pvGeometryIf.setPolygonNormals(this.m_polygonNormal);
        pvGeometryIf.setGlobalPolygonNormalSize(this.m_globalPolygonNormalSize);
        pvGeometryIf.setGlobalPolygonNormalLength(this.m_globalPolygonNormalLength);
        pvGeometryIf.setGlobalPolygonNormalColor(this.m_globalPolygonNormalColor);
        pvGeometryIf.setState(88, this.m_bShowPolygonStartArrow);
        pvGeometryIf.setState(89, this.m_bShowPolygonEndArrow);
        pvGeometryIf.setState(92, this.m_bShowPolygonColors && this.m_polygonColor != null);
        pvGeometryIf.setState(64, this.m_bShowPolygonNormals);
        pvGeometryIf.setState(65, this.m_bShowPolygonNormalArrow);
        pvGeometryIf.setState(52, this.m_bShowEdges);
        pvGeometryIf.setState(53, this.m_bShowTaggedEdges);
        pvGeometryIf.setState(87, this.m_bShowOutline);
        pvGeometryIf.setState(93, this.m_bShowEdgeColors);
        pvGeometryIf.setGlobalEdgeSize(this.m_globalEdgeSize);
        pvGeometryIf.setGlobalEdgeColor(this.m_globalEdgeColor);
        pvGeometryIf.setState(58, this.m_bShowBoundaries);
        pvGeometryIf.setState(59, this.m_bShowTaggedBoundaries);
        pvGeometryIf.setState(56, this.m_bShowElements);
        pvGeometryIf.setState(57, true);
        pvGeometryIf.setState(68, this.m_bShowBackface);
        pvGeometryIf.setNumElements(this.m_numElements);
        pvGeometryIf.setElements(this.m_element);
        pvGeometryIf.setNeighbours(this.m_neighbour);
        pvGeometryIf.setState(94, this.m_bShowElementColors && this.m_elementColor != null);
        pvGeometryIf.setState(99, this.m_bShowElementBackColor);
        pvGeometryIf.setElementColors(this.m_elementColor);
        pvGeometryIf.setState(62, this.m_bShowElementNormals);
        pvGeometryIf.setState(63, this.m_bShowElementNormalArrow);
        pvGeometryIf.setElementNormals(this.m_elementNormal);
        pvGeometryIf.setGlobalElementNormalSize(this.m_globalElementNormalSize);
        pvGeometryIf.setGlobalElementNormalLength(this.m_globalElementNormalLength);
        pvGeometryIf.setGlobalElementNormalColor(this.m_globalElementNormalColor);
        pvGeometryIf.setState(72, this.m_elementTexture != null && this.m_bShowElementTexture);
        pvGeometryIf.setElementTextures(this.m_elementTexture);
        pvGeometryIf.setGlobalElementColor(this.m_globalElementColor);
        pvGeometryIf.setGlobalElementBackColor(this.m_globalElementBackColor);
        pvGeometryIf.setGlobalElementTagColor(this.m_globalElementTagColor);
    }

    public PdVector getVertex(int n) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_vertex[n];
    }

    public boolean setVertex(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        this.m_vertex[n].copy(pdVector);
        return true;
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalPolygonTagColor;
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalPolygonTagColor = color;
    }

    public Color getGlobalBndColor() {
        return this.m_globalBndColor;
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor = color;
    }

    public boolean isShowingVertexNormalArrow() {
        return this.m_bShowVertexNormalArrow;
    }

    public String[] getKeywords() {
        return this.m_keyword;
    }

    public void setKeywords(String[] stringArray) {
        this.m_keyword = stringArray;
    }

    public void showVertexNormalArrow(boolean bl) {
        this.m_bShowVertexNormalArrow = bl;
    }

    public boolean isShowingElementNormalArrow() {
        return this.m_bShowElementNormalArrow;
    }

    public void showElementNormalArrow(boolean bl) {
        this.m_bShowElementNormalArrow = bl;
    }

    public String[][] getVertexFunctions() {
        return this.m_vertexFunction;
    }

    public void setVertexFunctions(String[][] stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        int n = stringArray[0].length;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            int n3 = stringArray[n2].length;
            this.m_vertex[n2].setSize(n3);
            if (n != -1 && n3 != n) {
                n = -1;
            }
            ++n2;
        }
        this.m_dim = n;
        this.m_vertexFunction = stringArray;
    }

    public boolean isShowingIndices() {
        return this.m_bShowIndices;
    }

    public void showIndices(boolean bl) {
        this.m_bShowIndices = bl;
    }

    public PgJvxSrc getJvx() {
        return this;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        this.copy(pgJvxSrc);
    }

    public int getNumElements() {
        return this.m_numElements;
    }

    public void setNumElements(int n) {
        if (n > this.m_maxNumElements) {
            this.setMaxNumElements(n);
        }
        this.m_numElements = n;
    }

    public int addPolygon(PiVector piVector) {
        this.setPolygon(this.m_numPolygons, piVector);
        return this.m_numPolygons - 1;
    }

    public boolean isShowingOutline() {
        return this.m_bShowOutline;
    }

    public void showOutline(boolean bl) {
        this.m_bShowOutline = bl;
    }

    public int addElement(PiVector piVector) {
        this.setNumElements(this.m_numElements + 1);
        this.setElement(this.m_numElements - 1, piVector);
        return this.m_numElements - 1;
    }

    public void setNumVectors(int n, int n2, int n3) {
        this.m_dimOfVectors[n] = n3;
        this.m_vector[n] = PdVector.realloc(this.m_vector[n], n2, n3);
    }

    public void assureVectorColors(int n) {
        if (this.m_vectorColor[n] == null || this.m_vectorColor[n].length != this.m_vector[n].length) {
            this.m_vectorColor[n] = PdColor.realloc(this.m_vectorColor[n], this.m_vector[n].length);
        }
    }

    public void setVectorColors(int n, Color[] colorArray) {
        if (colorArray == null || colorArray.length == 0 || this.m_vector == null || this.m_vector[n] == null || colorArray.length < this.m_vector[n].length) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVectorColors(n);
        PdColor.copy(this.m_vectorColor[n], 0, colorArray, 0, this.m_vector[n].length);
    }

    public boolean isShowingVertexLabels() {
        return this.m_bShowVertexLabels;
    }

    public Color getGlobalVertexColor() {
        return this.m_globalVertexColor;
    }

    public Color getGlobalVertexNormalColor() {
        return this.m_globalVertexNormalColor;
    }

    public void setGlobalVertexColor(Color color) {
        this.m_globalVertexColor = color;
    }

    public void setGlobalVertexNormalColor(Color color) {
        this.m_globalVertexNormalColor = color;
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor;
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor = color;
    }

    public Color getGlobalElementColor() {
        return this.m_globalElementColor;
    }

    public PdVector[] getVertexTextures() {
        return this.m_vertexTexture;
    }

    public PdVector[][] getElementTextures() {
        return this.m_elementTexture;
    }

    public void assureVertexTextures() {
        if (this.m_vertexTexture == null || this.m_vertexTexture.length != this.m_numVertices) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_numVertices, this.m_dimOfTextures);
        }
    }

    public void assureElementTextures() {
        if (this.m_elementTexture == null || this.m_elementTexture.length != this.m_maxNumElements) {
            this.m_elementTexture = new PdVector[this.m_maxNumElements][];
        }
        int n = 0;
        while (n < this.m_numElements) {
            this.m_elementTexture[n] = PdVector.realloc(this.m_elementTexture[n], this.m_element[n].getSize(), this.m_dimOfTextures);
            ++n;
        }
    }

    public Color getGlobalElementNormalColor() {
        return this.m_globalElementNormalColor;
    }

    public void setGlobalElementColor(Color color) {
        this.m_globalElementColor = color;
    }

    public int getNumVectorFields() {
        return this.m_numVectorFields;
    }

    public void setNumVectorFields(int n) {
        PdVector[][] pdVectorArrayArray = new PdVector[n][];
        int n2 = 0;
        while (n2 < Math.min(n, this.m_numVectorFields)) {
            pdVectorArrayArray[n2] = this.m_vector[n2];
            ++n2;
        }
        this.m_vector = pdVectorArrayArray;
        Color[][] colorArrayArray = new Color[n][];
        int n3 = 0;
        while (n3 < Math.min(n, this.m_numVectorFields)) {
            colorArrayArray[n3] = this.m_vectorColor[n3];
            ++n3;
        }
        this.m_vectorColor = colorArrayArray;
        this.m_numVectorFields = n;
        this.m_dimOfVectors = PuData.realloc(this.m_dimOfVectors, n);
        this.m_vectorName = PuData.realloc(this.m_vectorName, n);
        this.m_bShowVectorField = PuData.realloc(this.m_bShowVectorField, n);
        this.m_bShowVectorArrow = PuData.realloc(this.m_bShowVectorArrow, n);
        if (n > this.m_numVectorFields) {
            n3 = this.m_numVectorFields;
            while (n3 < n) {
                this.m_bShowVectorField[n3] = false;
                this.m_bShowVectorArrow[n3] = false;
                ++n3;
            }
        }
        this.m_vectorIsElementBased = PuData.realloc(this.m_vectorIsElementBased, n);
        this.m_globalVectorLength = PuData.realloc(this.m_globalVectorLength, n);
        this.m_globalVectorSize = PuData.realloc(this.m_globalVectorSize, n);
        this.m_globalVectorColor = PdColor.realloc(this.m_globalVectorColor, n);
        n3 = 0;
        while (n3 < this.m_numVectorFields) {
            this.m_globalVectorSize[n3] = 1.0;
            this.m_globalVectorLength[n3] = 1.0;
            this.m_globalVectorColor[n3] = Color.yellow;
            ++n3;
        }
    }

    public void setGlobalElementNormalColor(Color color) {
        this.m_globalElementNormalColor = color;
    }

    public double getGlobalBndSize() {
        return this.m_globalBndSize;
    }

    public void setGlobalBndSize(double d) {
        this.m_globalBndSize = d;
    }

    public void setVertexTextures(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_vertexTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexTextures();
        PdVector.copy(this.m_vertexTexture, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public void setElementTextures(PdVector[][] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_elementTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of tex array");
            return;
        }
        int n = 0;
        while (n < this.m_numElements) {
            if (pdVectorArray[n] == null || pdVectorArray[n].length != this.m_element[n].getSize()) {
                PsDebug.warning("void length of texCoords[" + n + "]");
                return;
            }
            ++n;
        }
        this.assureElementTextures();
        this.m_elementTexture = pdVectorArray;
        n = 0;
        while (n < this.m_numElements) {
            PdVector.copy(this.m_elementTexture[n], 0, pdVectorArray[n], 0, this.m_element[n].getSize());
            ++n;
        }
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public boolean isShowingElementLabels() {
        return this.m_bShowElementLabels;
    }

    public void showVertexLabels(boolean bl) {
        this.m_bShowVertexLabels = bl;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public void showElementLabels(boolean bl) {
        this.m_bShowElementLabels = bl;
    }

    public PiVector[] getElements() {
        return this.m_element;
    }

    public void setDimOfElements(int n) {
        if (n == this.m_dimOfElements) {
            return;
        }
        if (n != -1 && n < 3) {
            PsDebug.warning("argument aSize=" + n + " out of range.");
            return;
        }
        this.m_dimOfElements = n;
        if (n == -1) {
            int n2 = this.m_numElements;
            while (n2 < this.m_maxNumElements) {
                this.m_element[n2].setSize(0);
                this.m_neighbour[n2].setSize(0);
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < this.m_maxNumElements) {
            this.m_element[n3].setSize(n);
            this.m_neighbour[n3].setSize(n);
            this.m_neighbour[n3].setConstant(-1);
            ++n3;
        }
    }

    protected void setMaxNumElements(int n) {
        if (this.m_maxNumElements == n) {
            return;
        }
        this.m_maxNumElements = n;
        if (this.m_dimOfElements > -1) {
            this.m_element = PiVector.realloc(this.m_element, n, this.m_dimOfElements);
            this.m_neighbour = PiVector.realloc(this.m_neighbour, n, this.m_dimOfElements);
        } else {
            this.m_element = PiVector.realloc(this.m_element, n);
            this.m_neighbour = PiVector.realloc(this.m_neighbour, n);
            this.assureNeighbours();
        }
        if (this.m_elementNormal != null) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, n, this.m_dim);
        }
        if (this.m_elementColor != null) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, n);
        }
        if (this.m_maxNumElements < this.m_numElements) {
            this.m_numElements = this.m_maxNumElements;
        }
        if (this.m_elementTexture != null) {
            this.assureElementTextures();
        }
    }

    public void setElements(PiVector[] piVectorArray) {
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numElements == 0) {
            return;
        }
        if (piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of element array");
            return;
        }
        int n = 0;
        int n2 = piVectorArray[0].getSize();
        int n3 = 0;
        while (n3 < this.m_numElements) {
            int n4 = piVectorArray[n3].getSize();
            if (n4 > this.m_maxDimOfElements) {
                n = n4;
                n4 = this.m_maxDimOfElements;
            }
            this.m_element[n3].setSize(n4);
            if (n2 != -1 && n4 != n2) {
                n2 = -1;
            }
            ++n3;
        }
        if (this.m_dimOfElements != n2) {
            this.setDimOfElements(n2);
        }
        PiVector.copy(this.m_element, 0, piVectorArray, 0, this.m_numElements);
        this.assureNeighbours();
        if (n > 0) {
            PsDebug.error("maximal dimension of an element = " + n + " truncated to size = " + this.m_maxDimOfElements);
        }
    }

    public boolean isShowingElements() {
        return this.m_bShowElements;
    }

    public void showElements(boolean bl) {
        this.m_bShowElements = bl;
    }

    public void setPolygonNormalList(int n, PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length == 0) {
            return;
        }
        this.assurePolygonNormals();
        PdVector.copy(this.m_polygonNormal, 0, pdVectorArray, 0, n);
    }

    public void setVectorElementBased(int n, boolean bl) {
        this.m_vectorIsElementBased[n] = bl;
    }

    public boolean isShowingPolygonLabels() {
        return this.m_bShowPolygonLabels;
    }

    public void showPolygonLabels(boolean bl) {
        this.m_bShowPolygonLabels = bl;
    }

    public boolean isShowingBoundaries() {
        return this.m_bShowBoundaries;
    }

    public void showBoundaries(boolean bl) {
        this.m_bShowBoundaries = bl;
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public void showPolygonEndArrow(boolean bl) {
        this.m_bShowPolygonEndArrow = bl;
    }

    public Color getGlobalVertexTagColor() {
        return this.m_globalVertexTagColor;
    }

    public void setGlobalVertexTagColor(Color color) {
        this.m_globalVertexTagColor = color;
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalPolygonColor;
    }

    public void setVectorArrowVisible(int n, boolean bl) {
        this.m_bShowVectorArrow[n] = bl;
    }

    public Color getGlobalPolygonNormalColor() {
        return this.m_globalPolygonNormalColor;
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalPolygonColor = color;
    }

    public void setGlobalPolygonNormalColor(Color color) {
        this.m_globalPolygonNormalColor = color;
    }

    public Color getGlobalEdgeTagColor() {
        return this.m_globalEdgeTagColor;
    }

    public void setGlobalEdgeTagColor(Color color) {
        this.m_globalEdgeTagColor = color;
    }

    public Color getGlobalElementBackColor() {
        return this.m_globalElementBackColor;
    }

    public Color getGlobalElementTagColor() {
        return this.m_globalElementTagColor;
    }

    public void setGlobalElementBackColor(Color color) {
        this.m_globalElementBackColor = color;
    }

    public void setGlobalElementTagColor(Color color) {
        this.m_globalElementTagColor = color;
    }

    protected void setDimOfElement(int n, int n2) {
        if (this.m_dimOfElements == n2) {
            return;
        }
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return;
        }
        if (n2 < 3) {
            PsDebug.warning("argument aSize=" + n2 + " out of range.");
            return;
        }
        if (this.m_numElements == 1) {
            this.setDimOfElements(n2);
        } else if (this.m_dimOfElements != -1) {
            this.setDimOfElements(-1);
        }
        this.m_element[n].setSize(n2);
        this.m_neighbour[n].setSize(n2);
        this.m_neighbour[n].setConstant(-1);
    }

    public PiVector getElement(int n) {
        if (n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_element[n];
    }

    public boolean setElement(int n, PiVector piVector) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (piVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        int n2 = piVector.getSize();
        if (n2 > this.m_maxDimOfElements) {
            n2 = this.m_maxDimOfElements;
            PsDebug.error("maximal dimension of element = " + n2 + " truncated to size = " + this.m_maxDimOfElements);
        }
        this.setDimOfElement(n, n2);
        this.m_element[n].copy(piVector);
        return true;
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    public void assureNeighbours() {
        int n;
        boolean bl = false;
        if (this.m_neighbour == null || this.m_neighbour.length != this.m_maxNumElements) {
            bl = true;
        } else {
            n = 0;
            while (n < this.m_maxNumElements) {
                if (this.m_neighbour[n].getSize() != this.m_element[n].getSize()) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (this.m_dimOfElements != -1) {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements, this.m_dimOfElements);
        } else {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements);
            n = 0;
            while (n < this.m_maxNumElements) {
                this.m_neighbour[n].setSize(this.m_element[n].getSize());
                ++n;
            }
        }
        if (bl) {
            n = 0;
            while (n < this.m_maxNumElements) {
                this.m_neighbour[n].setConstant(-1);
                ++n;
            }
        }
    }

    public double getGlobalVectorLength(int n) {
        return this.m_globalVectorLength[n];
    }

    public boolean setGlobalVectorLength(int n, double d) {
        this.m_globalVectorLength[n] = d;
        return true;
    }

    public void setNeighbours(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_neighbour = null;
            return;
        }
        if (piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of neighbour array");
            return;
        }
        this.assureNeighbours();
        int n = 0;
        while (n < this.m_numElements) {
            this.m_neighbour[n].setSize(piVectorArray[n].getSize());
            ++n;
        }
        PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numElements);
    }

    public void setDimOfVertices(int n) {
        this.m_dim = n;
    }

    public PdVector[] getVertices() {
        return this.m_vertex;
    }

    public PiVector[] getEdges() {
        return this.m_edge;
    }

    protected void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        this.m_vertex = PdVector.realloc(this.m_vertex, n, this.m_dim);
        this.m_maxNumVertices = n;
        if (this.m_numVertices > this.m_maxNumVertices) {
            this.m_numVertices = this.m_maxNumVertices;
        }
        if (this.m_vertexColor != null) {
            this.assureVertexColors();
        }
        if (this.m_vertexNormal != null) {
            this.assureVertexNormals();
        }
        if (this.m_vertexTexture != null) {
            this.assureVertexTextures();
        }
    }

    public void setVertices(PdVector[] pdVectorArray) {
        if ((pdVectorArray == null || pdVectorArray.length == 0) && this.m_numVertices == 0) {
            return;
        }
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        int n = pdVectorArray[0].getSize();
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            int n3 = pdVectorArray[n2].getSize();
            this.m_vertex[n2].setSize(n3);
            if (n != -1 && n3 != n) {
                n = -1;
            }
            ++n2;
        }
        this.m_dim = n;
        PdVector.copy(this.m_vertex, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public void setEdges(PiVector[] piVectorArray) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < this.m_numEdges) {
            PsDebug.warning("void length of edge array");
            return;
        }
        PiVector.copy(this.m_edge, 0, piVectorArray, 0, this.m_numEdges);
    }

    public boolean isShowingVertices() {
        return this.m_bShowVertices;
    }

    public void showVertices(boolean bl) {
        this.m_bShowVertices = bl;
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean bl) {
        this.m_bShowEdges = bl;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public boolean makeElementColorsFromXYZ() {
        if (this.m_numElements == 0) {
            return true;
        }
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector[] pdVectorArray = this.getBounds();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numElements) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[n].m_data), pdVectorArray[0]);
            if (this.m_dim == 1) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), 0.0f, 0.0f);
            } else if (this.m_dim == 2) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), 0.0f);
            } else if (this.m_dim >= 3) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), (float)(pdVector.m_data[2] / dArray[2]));
            }
            ++n;
        }
        return true;
    }

    public int getType() {
        return this.m_geomType;
    }

    public void setType(int n) {
        this.m_geomType = n;
    }

    public String getVersionType() {
        return this.m_versionType;
    }

    public void setVersionType(String string) {
        this.m_versionType = string;
    }

    public PiVector getPolygon(int n) {
        if (n < 0 || n >= this.m_numPolygons) {
            return null;
        }
        return this.m_polygon[n];
    }

    public PdVector[] getBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] pdVectorArray = super.getBounds();
        PdVector.min(pdVectorArray[0], this.m_vertex, this.m_numVertices);
        PdVector.max(pdVectorArray[1], this.m_vertex, this.m_numVertices);
        return pdVectorArray;
    }

    public boolean setPolygon(int n, PiVector piVector) {
        if (n < 0) {
            PsDebug.error("index out of range, corrupt argument", this);
            return false;
        }
        if (piVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " >= " + this.m_numPolygons + "=m_numPolygons, bad programming style", this);
            this.setNumPolygons(n + 1);
        }
        int n2 = piVector.getSize();
        this.m_polygon[n].setSize(n2);
        this.m_polygon[n].copy(piVector);
        if (this.m_dimOfPolygons != n2) {
            this.m_dimOfPolygons = -1;
        }
        return true;
    }

    public boolean isVectorElementBased(int n) {
        return this.m_vectorIsElementBased[n];
    }

    public Color[] getPolygonColors() {
        return this.m_polygonColor;
    }

    public void assurePolygonColors() {
        if (this.m_polygonColor == null || this.m_polygonColor.length != this.m_numPolygons) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, this.m_numPolygons);
        }
    }

    public String getSecondary() {
        return this.m_secondary;
    }

    public void setSecondary(String string) {
        this.m_secondary = string;
    }

    public void setPolygonColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_polygonColor = null;
            return;
        }
        if (colorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of color array");
            return;
        }
        this.assurePolygonColors();
        PdColor.copy(this.m_polygonColor, 0, colorArray, 0, this.m_numPolygons);
    }

    public boolean isShowingPolygonColors() {
        return this.m_bShowPolygonColors;
    }

    public void showPolygonColors(boolean bl) {
        this.m_bShowPolygonColors = bl;
    }

    public boolean isVectorArrowVisible(int n) {
        return this.m_bShowVectorArrow[n];
    }

    public String getSoftware() {
        return this.m_software;
    }

    public void setSoftware(String string) {
        this.m_software = string;
    }

    public double getGlobalVertexSize() {
        return this.m_globalVertexSize;
    }

    public double getGlobalVertexNormalSize() {
        return this.m_globalVertexNormalSize;
    }

    public void setGlobalVertexSize(double d) {
        this.m_globalVertexSize = d;
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalVertexNormalSize = d;
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize;
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize = d;
    }

    public double getGlobalElementNormalSize() {
        return this.m_globalElementNormalSize;
    }

    public void setGlobalElementNormalSize(double d) {
        this.m_globalElementNormalSize = d;
    }

    public double getGlobalPolygonNormalLength() {
        return this.m_globalPolygonNormalLength;
    }

    public void setGlobalPolygonNormalLength(double d) {
        this.m_globalPolygonNormalLength = d;
    }

    public String getKeyword(int n) {
        return this.m_keyword[n];
    }

    public void setKeyword(int n, String string) {
        this.m_keyword[n] = string;
    }

    public PiVector[] getPolygons() {
        return this.m_polygon;
    }

    public void setDimOfPolygons(int n) {
        if (n > -1) {
            int n2 = 0;
            while (n2 < this.m_maxNumPolygons) {
                this.m_polygon[n2].setSize(n);
                ++n2;
            }
        }
        this.m_dimOfPolygons = n;
    }

    protected void setMaxNumPolygons(int n) {
        if (this.m_maxNumPolygons == n) {
            return;
        }
        this.m_polygon = this.m_dimOfPolygons > -1 ? PiVector.realloc(this.m_polygon, n, this.m_dimOfPolygons) : PiVector.realloc(this.m_polygon, n);
        if (this.m_polygonColor != null) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, n);
        }
        if (this.m_polygonNormal != null) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, n, this.m_dim);
        }
        this.m_maxNumPolygons = n;
        if (this.m_numPolygons > this.m_maxNumPolygons) {
            this.m_numPolygons = this.m_maxNumPolygons;
        }
    }

    public double getGlobalPolygonSize() {
        return this.m_globalPolygonSize;
    }

    public double getGlobalPolygonNormalSize() {
        return this.m_globalPolygonNormalSize;
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize = d;
    }

    public void setGlobalPolygonNormalSize(double d) {
        this.m_globalPolygonNormalSize = d;
    }

    public void setPolygons(PiVector[] piVectorArray) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < this.m_numPolygons) {
            this.setMaxNumPolygons(0);
            return;
        }
        int n = 0;
        while (n < this.m_numPolygons) {
            this.m_polygon[n].setSize(piVectorArray[n].getSize());
            ++n;
        }
        PiVector.copy(this.m_polygon, 0, piVectorArray, 0, this.m_numPolygons);
    }

    public boolean isShowingPolygons() {
        return this.m_bShowPolygons;
    }

    public void showPolygons(boolean bl) {
        this.m_bShowPolygons = bl;
    }
}

