/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import jv.loader.PsXmlNode;
import jv.loader.PsXmlSrc;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PuData;

public final class PsAuthorInfo
extends PsObject {
    public static final int FIRST_NAME = 0;
    public static final int LAST_NAME = 1;
    public static final int ORGANIZATION = 2;
    public static final int ADDRESS = 3;
    public static final int EMAIL = 4;
    public static final int URL = 5;
    private static final int m_numCodes = 6;
    protected int m_numAuthors;
    protected int m_currAuthor;
    protected String[][] m_info = new String[6][];

    protected static int getNumCodes() {
        return 6;
    }

    public PsAuthorInfo() {
        this.init();
    }

    public PsXmlNode getXmlNode(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            psXmlNode = new PsXmlNode("authors");
        } else {
            psXmlNode.removeChildren();
        }
        int n = 0;
        while (n < this.m_numAuthors) {
            String[] stringArray;
            PsXmlNode psXmlNode2 = psXmlNode.addChild("author");
            psXmlNode2.addChild("firstname", this.m_info[0][n]);
            psXmlNode2.addChild("lastname", this.m_info[1][n]);
            PsXmlNode psXmlNode3 = psXmlNode2.addChild("affiliation");
            psXmlNode3.addChild("organization", this.m_info[2][n]);
            PsXmlNode psXmlNode4 = psXmlNode3.addChild("address");
            if (this.m_info[3][n] != null && !this.m_info[3][n].equals("") && (stringArray = PuString.splitString(this.m_info[3][n], '\n')) != null && stringArray.length > 0) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    psXmlNode4.addChild("line", stringArray[n2]);
                    ++n2;
                }
            }
            psXmlNode2.addChild("email", this.m_info[4][n]);
            psXmlNode2.addChild("url", this.m_info[5][n]);
            ++n;
        }
        return psXmlNode;
    }

    public PsXmlNode getXmlNode() {
        PsXmlNode psXmlNode = this.getXmlNode(null);
        return psXmlNode;
    }

    public int getSelectedAuthor() {
        return this.m_currAuthor;
    }

    public void setSelectedAuthor(int n) {
        this.m_currAuthor = n;
    }

    public String getInfo(int n, int n2) {
        if (n < 0 || this.m_numAuthors <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return null;
        }
        if (n2 < 0 || 6 <= n2) {
            PsDebug.warning("index out of range, code = " + n2);
            return null;
        }
        return this.m_info[n2][n];
    }

    public void setInfo(int n, int n2, String string) {
        if (n < 0 || this.m_numAuthors <= n) {
            PsDebug.warning("index out of range][ind = " + n);
            return;
        }
        this.m_info[n2][n] = string;
    }

    public void setXmlNode(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            PsDebug.warning("missing resource.");
            return;
        }
        String string = psXmlNode.getType();
        if (string == null || !string.equals("authors")) {
            PsDebug.error("node has wrong type = " + string);
            return;
        }
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, "author");
        if (psXmlNodeArray != null) {
            this.setNumAuthors(psXmlNodeArray.length);
            int n = 0;
            while (n < this.m_numAuthors) {
                this.m_info[0][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "firstname");
                this.m_info[1][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "lastname");
                this.m_info[2][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "organization");
                PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "address");
                PsXmlNode[] psXmlNodeArray2 = PsXmlSrc.getRsrcNodes(psXmlNode2, "line");
                if (psXmlNodeArray2 == null) {
                    psXmlNodeArray2 = PsXmlSrc.getRsrcNodes(psXmlNode2, "l");
                    PsDebug.error("usage of old address <l> element tag found.\n\tPlease, replace all occurances of <l> with with new tag <line>.");
                }
                if (psXmlNodeArray2 == null || psXmlNodeArray2.length == 0) {
                    this.m_info[3][n] = null;
                } else {
                    this.m_info[3][n] = psXmlNodeArray2[0].getContent();
                    int n2 = 1;
                    while (n2 < psXmlNodeArray2.length) {
                        this.m_info[3][n] = this.m_info[3][n] + "\n" + psXmlNodeArray2[n2].getContent();
                        ++n2;
                    }
                }
                this.m_info[4][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "email");
                this.m_info[5][n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "url");
                ++n;
            }
            return;
        }
        this.setNumAuthors(0);
        PsDebug.warning("missing authors.");
    }

    public int getNumAuthors() {
        return this.m_numAuthors;
    }

    public void init() {
        super.init();
        this.m_numAuthors = 0;
        this.m_currAuthor = 0;
        int n = 0;
        do {
            this.m_info[n] = null;
        } while (++n < 6);
    }

    public Object clone() {
        PsAuthorInfo psAuthorInfo = (PsAuthorInfo)super.clone();
        if (psAuthorInfo == null) {
            return null;
        }
        if (this.m_info != null) {
            psAuthorInfo.m_info = PuString.clone(this.m_info);
        }
        return psAuthorInfo;
    }

    public void setNumAuthors(int n) {
        this.m_numAuthors = n;
        int n2 = 0;
        do {
            this.m_info[n2] = PuData.realloc(this.m_info[n2], n);
        } while (++n2 < 6);
    }
}

