/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PjProject;
import jv.project.PvCameraEvent;
import jv.project.PvCameraListenerIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.vecmath.PdVector;
import jv.viewer.PvScene;

public class PjAxes
extends PjProject
implements PvCameraListenerIf {
    protected int m_dim;
    protected PdVector m_viewVect;
    protected PgAxes m_axes;
    protected PgGeometry m_geom;
    protected PvScene m_scene;
    private static /* synthetic */ Class class$jv$thirdParty$ruler$PjAxes;

    public PjAxes(int n) {
        super("Demo of Variable Axes");
        this.m_dim = n;
        this.m_axes = new PgAxes();
        this.m_viewVect = new PdVector(0.0, 0.0, -1.0);
        if (this.getClass() == (class$jv$thirdParty$ruler$PjAxes != null ? class$jv$thirdParty$ruler$PjAxes : (class$jv$thirdParty$ruler$PjAxes = PjAxes.class$("jv.thirdParty.ruler.PjAxes")))) {
            this.init();
        }
    }

    public void dragCamera(PvCameraEvent pvCameraEvent) {
        this.pickCamera(pvCameraEvent);
    }

    public boolean update(Object object) {
        if (object == null) {
            return true;
        }
        if (object == this.m_geom) {
            this.m_axes.configure(this.m_geom.getBounds(), this.m_viewVect);
            return this.m_axes.update(this.m_axes);
        }
        if (object == this.m_scene) {
            this.m_axes.configure(this.m_scene.getBounds(), this.m_viewVect);
            return this.m_axes.update(this.m_axes);
        }
        if (object == this.m_axes) {
            return super.update(null);
        }
        return super.update(object);
    }

    public void setScene(PvScene pvScene) {
        this.m_scene = pvScene;
        this.m_scene.addUpdateListener(this);
    }

    public void pickCamera(PvCameraEvent pvCameraEvent) {
        this.m_viewVect.copy(pvCameraEvent.getViewDir());
        if (this.m_geom != null) {
            this.m_axes.configure(this.m_geom.getBounds(), this.m_viewVect);
        } else if (this.m_scene != null) {
            this.m_axes.configure(this.m_scene.getBounds(), this.m_viewVect);
        } else {
            return;
        }
        this.m_axes.update(this.m_axes);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        this.m_geom = pgGeometry;
        this.m_geom.addUpdateListener(this);
    }

    public void start() {
        PgGeometry[] pgGeometryArray = this.m_axes.getAxes();
        int n = 0;
        while (n < pgGeometryArray.length) {
            this.addGeometry(pgGeometryArray[n]);
            ++n;
        }
        this.addGeometry(this.m_axes);
        PvViewerIf pvViewerIf = this.getViewer();
        PvDisplayIf pvDisplayIf = pvViewerIf.getDisplay();
        pvDisplayIf.addCameraListener(this);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PgAxes getAxes() {
        return this.m_axes;
    }

    public void init() {
        super.init();
        this.m_axes.init();
        this.m_axes.showAxesTitles(true, true, true);
        this.m_axes.setMode(2);
        PdVector[] pdVectorArray = new PdVector[]{new PdVector(-10.0, -10.0, -10.0), new PdVector(10.0, 10.0, 10.0)};
    }

    public void removeScene(PvScene pvScene) {
        if (this.m_scene != pvScene) {
            PsDebug.warning("PjAxes.removeScene(): scene was not registered.");
            return;
        }
        pvScene.removeUpdateListener(this);
        this.m_scene = null;
    }

    public void removeGeometry(PgGeometry pgGeometry) {
        if (this.m_geom != pgGeometry) {
            PsDebug.warning("PjAxes.removeGeometry(): geometry was not registered.");
            return;
        }
        pgGeometry.removeUpdateListener(this);
        this.m_geom = null;
    }
}

