/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay;

public class PvCamera_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PvCamera m_camera;
    protected PvDisplay m_disp;
    protected CheckboxGroup m_gProjection;
    protected Checkbox m_rPerspective;
    protected Checkbox m_rTop;
    protected Checkbox m_rFront;
    protected Checkbox m_rRight;
    protected Panel m_pAmbient;
    protected Checkbox m_rModel;
    protected Choice m_cAmbient;
    protected Choice m_cProj;
    protected PdVector m_viewDir;
    protected PdVector_IP m_pViewDir;
    protected PdVector m_interest;
    protected PdVector_IP m_pInterest;
    protected PuDouble m_dist;
    protected PuDouble m_roll;
    protected Panel m_pClip;
    protected Checkbox m_cClip;
    protected Button m_bCenter;
    protected Button m_bFit;
    protected Button m_bReset;
    private static /* synthetic */ Class class$jv$viewer$PvCamera_IP;

    public PvCamera_IP() {
        if (this.getClass() == (class$jv$viewer$PvCamera_IP != null ? class$jv$viewer$PvCamera_IP : (class$jv$viewer$PvCamera_IP = PvCamera_IP.class$("jv.viewer.PvCamera_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_camera == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_rPerspective) {
            this.m_disp.selectCamera(0);
            this.m_camera.update(null);
            return;
        }
        if (object == this.m_rTop) {
            this.m_disp.selectCamera(1);
            this.m_camera.update(null);
            return;
        }
        if (object == this.m_rFront) {
            this.m_disp.selectCamera(2);
            this.m_camera.update(null);
            return;
        }
        if (object == this.m_rRight) {
            this.m_disp.selectCamera(3);
            this.m_camera.update(null);
            return;
        }
        if (object == this.m_rModel) {
            this.m_disp.enableTransformModel(this.m_rModel.getState());
            this.m_pAmbient.setEnabled(this.m_disp.isTransformModel());
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_cAmbient) {
            this.m_disp.setAmbientSpace(this.m_cAmbient.getSelectedIndex());
            int n = this.m_disp.getAmbientSpace();
            this.m_cProj.removeAll();
            int n2 = 0;
            while (n2 < PgGeometryIf.AMBIENT_PROJECTIONS[n].length) {
                this.m_cProj.add(PgGeometryIf.AMBIENT_PROJECTIONS[n][n2]);
                ++n2;
            }
            this.m_cProj.select(0);
            this.m_disp.update(this.m_disp);
            return;
        }
        if (object == this.m_cProj) {
            this.m_disp.setAmbientProjection(this.m_cProj.getSelectedIndex());
            this.m_disp.update(this.m_disp);
            return;
        }
        if (object == this.m_cClip) {
            this.m_disp.enableClip(this.m_cClip.getState());
            this.m_camera.m_nearClip.setEnabled(this.m_camera.m_bEnableClip);
            this.m_camera.m_farClip.setEnabled(this.m_camera.m_bEnableClip);
            PdVector[] pdVectorArray = this.m_camera.getBounds();
            if (this.m_cClip.getState() && pdVectorArray != null) {
                double d;
                double d2;
                if (pdVectorArray[1].m_data[2] < pdVectorArray[0].m_data[2]) {
                    d2 = pdVectorArray[1].m_data[2];
                    d = pdVectorArray[0].m_data[2];
                } else {
                    d2 = pdVectorArray[0].m_data[2];
                    d = pdVectorArray[1].m_data[2];
                }
                this.m_camera.m_nearClip.setBounds(d2 - (-d2 + d) / 2.0, d + (-d2 + d) / 2.0, 0.02, 1.0);
                this.m_camera.m_farClip.setBounds(d2 - (-d2 + d) / 2.0, d + (-d2 + d) / 2.0, 0.02, 1.0);
                this.m_camera.m_nearClip.setValue(d);
                this.m_camera.m_farClip.setValue(d2);
            }
            this.m_camera.update(null);
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        if (psUpdateIf == null) {
            PsDebug.warning("missing camera");
            return;
        }
        super.setParent(psUpdateIf);
        this.m_camera = (PvCamera)psUpdateIf;
        this.m_disp = this.m_camera.m_display;
        this.m_pClip.removeAll();
        this.m_pClip.add(this.m_camera.m_nearClip.getInfoPanel());
        this.m_pClip.add(this.m_camera.m_farClip.getInfoPanel());
        this.m_pClip.validate();
        this.m_cClip.setState(this.m_camera.m_bEnableClip);
        this.m_camera.m_nearClip.setEnabled(this.m_camera.m_bEnableClip);
        this.m_camera.m_farClip.setEnabled(this.m_camera.m_bEnableClip);
        this.m_rModel.setState(this.m_disp.isTransformModel());
        this.m_pAmbient.setEnabled(this.m_disp.isTransformModel());
        switch (this.m_camera.getProjectionMode()) {
            case 0: {
                this.m_gProjection.setSelectedCheckbox(this.m_rPerspective);
                break;
            }
            case 1: {
                this.m_gProjection.setSelectedCheckbox(this.m_rTop);
                break;
            }
            case 2: {
                this.m_gProjection.setSelectedCheckbox(this.m_rFront);
                break;
            }
            case 3: {
                this.m_gProjection.setSelectedCheckbox(this.m_rRight);
                break;
            }
            default: {
                PsDebug.warning("unknown projection mode = " + this.m_camera.getProjectionMode());
            }
        }
        this.setTitle(PsConfig.getMessage("cameraTitle") + " " + this.m_disp.getName() + ": " + this.m_gProjection.getSelectedCheckbox().getLabel());
    }

    public boolean update(Object object) {
        if (this.m_camera == null) {
            PsDebug.warning("missing camera");
            return false;
        }
        if (object == this.m_camera) {
            this.m_disp = this.m_camera.m_display;
            this.m_viewDir.copy(this.m_camera.getViewDir());
            this.m_pViewDir.update(this.m_viewDir);
            this.m_interest.copy(this.m_camera.getInterest());
            this.m_pInterest.update(this.m_interest);
            this.m_dist.setValue(this.m_camera.getDist());
            this.m_roll.setValue(this.m_camera.getRoll());
            if (this.m_cClip.getState() != this.m_camera.m_bEnableClip) {
                this.m_cClip.setState(this.m_camera.m_bEnableClip);
                this.m_camera.m_nearClip.setEnabled(this.m_camera.m_bEnableClip);
                this.m_camera.m_farClip.setEnabled(this.m_camera.m_bEnableClip);
            }
            if (this.m_pAmbient.isEnabled()) {
                int n;
                int n2;
                this.m_rModel.setState(this.m_disp.isTransformModel());
                this.m_pAmbient.setEnabled(this.m_disp.isTransformModel());
                if (this.m_cAmbient.getItemCount() == 0) {
                    n2 = 0;
                    while (n2 < PgGeometryIf.AMBIENT_SPACES.length) {
                        this.m_cAmbient.add(PgGeometryIf.AMBIENT_SPACES[n2]);
                        ++n2;
                    }
                }
                if (this.m_cAmbient.getSelectedIndex() != this.m_disp.getAmbientSpace()) {
                    this.m_cAmbient.select(this.m_disp.getAmbientSpace());
                    this.m_cProj.removeAll();
                }
                n2 = this.m_disp.getAmbientSpace();
                if (this.m_cProj.getItemCount() == 0) {
                    n = 0;
                    while (n < PgGeometryIf.AMBIENT_PROJECTIONS[n2].length) {
                        this.m_cProj.add(PgGeometryIf.AMBIENT_PROJECTIONS[n2][n]);
                        ++n;
                    }
                }
                n = this.m_disp.getAmbientProjection();
                if (this.m_cProj.getSelectedIndex() != n) {
                    this.m_cProj.select(n);
                }
            }
            return true;
        }
        if (object == this) {
            this.m_camera.setViewDir(this.m_pViewDir.getVector());
            this.m_camera.setInterest(this.m_pInterest.getVector());
            this.m_camera.setDist(this.m_dist.getValue());
            this.m_camera.setRoll(this.m_roll.getValue());
            return this.m_camera.update(null);
        }
        if (object == this.m_pViewDir) {
            this.m_camera.setViewDir(this.m_pViewDir.getVector());
            return this.m_camera.update(null);
        }
        if (object == this.m_pInterest) {
            this.m_camera.setInterest(this.m_pInterest.getVector());
            return this.m_camera.update(null);
        }
        if (object == this.m_dist) {
            this.m_camera.setDist(this.m_dist.getValue());
            return this.m_camera.update(null);
        }
        if (object == this.m_roll) {
            this.m_camera.setRoll(this.m_roll.getValue());
            return this.m_camera.update(null);
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_camera == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bCenter) {
            this.m_disp.center();
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_bFit) {
            this.m_disp.fit();
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_bReset) {
            this.m_disp.resetTransformModel();
            this.m_camera.init();
            this.m_disp.fit();
            this.m_camera.update(this.m_camera);
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setBorderType(3);
        this.addTitle("");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 2));
        this.add(panel);
        this.m_gProjection = new CheckboxGroup();
        this.m_rPerspective = new Checkbox(PsConfig.getMessage("rPerspective"), this.m_gProjection, true);
        this.m_rPerspective.addItemListener(this);
        panel.add(this.m_rPerspective);
        this.m_rTop = new Checkbox(PsConfig.getMessage("rTop"), this.m_gProjection, false);
        this.m_rTop.addItemListener(this);
        panel.add(this.m_rTop);
        this.m_rFront = new Checkbox(PsConfig.getMessage("rFront"), this.m_gProjection, false);
        this.m_rFront.addItemListener(this);
        panel.add(this.m_rFront);
        this.m_rRight = new Checkbox(PsConfig.getMessage("rRight"), this.m_gProjection, false);
        this.m_rRight.addItemListener(this);
        panel.add(this.m_rRight);
        this.addLine(1);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(4, 1));
        this.add(panel2);
        this.m_pViewDir = new PdVector_IP();
        this.m_pViewDir.setTitle(PsConfig.getMessage("pViewDir"));
        this.m_pViewDir.setParent(this);
        this.m_viewDir = new PdVector(3);
        this.m_pViewDir.setVector(this.m_viewDir);
        panel2.add(this.m_pViewDir);
        this.m_pInterest = new PdVector_IP();
        this.m_pInterest.setTitle(PsConfig.getMessage("pInterest"));
        this.m_pInterest.setParent(this);
        this.m_interest = new PdVector(3);
        this.m_pInterest.setVector(this.m_interest);
        panel2.add(this.m_pInterest);
        this.m_dist = new PuDouble(PsConfig.getMessage("dist"), this);
        this.m_dist.setBounds(0.001, 100.0, 1.0, 10.0);
        this.m_dist.setValue(10.0);
        panel2.add(this.m_dist.getInfoPanel());
        this.m_roll = new PuDouble(PsConfig.getMessage("roll"), this);
        this.m_roll.setBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_roll.setValue(0.0);
        panel2.add(this.m_roll.getInfoPanel());
        this.addLine(1);
        this.m_rModel = new Checkbox(PsConfig.getMessage("rModel"), false);
        this.m_rModel.addItemListener(this);
        this.m_rModel.setFont(PsConfig.getFont(3));
        this.add(this.m_rModel);
        this.m_pAmbient = new Panel();
        this.m_pAmbient.setLayout(new GridLayout(2, 2));
        this.add(this.m_pAmbient);
        this.m_pAmbient.add(new Label(PsConfig.getMessage("pAmbient")));
        this.m_cAmbient = new Choice();
        this.m_cAmbient.addItemListener(this);
        this.m_pAmbient.add(this.m_cAmbient);
        this.m_pAmbient.add(new Label(PsConfig.getMessage("cProj")));
        this.m_cProj = new Choice();
        this.m_cProj.addItemListener(this);
        this.m_pAmbient.add(this.m_cProj);
        this.addLine(1);
        this.m_cClip = new Checkbox(PsConfig.getMessage("cClip"));
        this.m_cClip.addItemListener(this);
        this.m_cClip.setFont(PsConfig.getFont(3));
        this.m_cClip.setState(false);
        this.add(this.m_cClip);
        this.m_pClip = new PsPanel();
        this.m_pClip.setLayout(new GridLayout(2, 1));
        this.add(this.m_pClip);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        this.add(panel3);
        this.m_bCenter = new Button(PsConfig.getMessage("bCenter"));
        this.m_bCenter.addActionListener(this);
        panel3.add(this.m_bCenter);
        this.m_bFit = new Button(PsConfig.getMessage("bFit"));
        this.m_bFit.addActionListener(this);
        panel3.add(this.m_bFit);
        this.m_bReset = new Button(PsConfig.getMessage("bReset"));
        this.m_bReset.addActionListener(this);
        panel3.add(this.m_bReset);
    }
}

