/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuProj;
import jv.viewer.PvScene;
import jv.viewer.PvThickGraphics;

final class PvGeometry
extends PgJvxSrc
implements PvGeometryIf {
    protected PvDisplayIf m_display;
    protected PgGeometryIf m_geometry;
    protected static int PS_ZOOM = 1;
    protected Color m_backColor;
    protected boolean m_bShowEdgeAura;
    protected int m_drawingOrder = 0;
    protected PdVector[] m_bndBox;
    protected PiVector[] m_bndBoxTrans;
    protected Color m_globalBndboxColor;
    private int m_dimTrans;
    protected int m_dimOfColors;
    protected int m_pickedVertex;
    protected int[] m_texturePix;
    protected int m_textureWidth;
    protected int m_textureHeight;
    protected PdVector[] m_faceTextureBnd;
    protected PiVector[] m_faceDestBnd;
    private int prevElemHeight;
    private int prevElemWidth;
    private transient Image m_destImage;
    private int imgHeight;
    private int imgWidth;
    private transient MemoryImageSource mis;
    protected int m_alpha;
    protected boolean m_bShowTransparency;
    protected Vector m_vectorfield;
    protected int m_currentVectorField;
    protected boolean m_bShowGlobalVectorArrow;
    protected boolean m_bShowVectors;
    protected boolean m_bShowVectorColors = false;
    private boolean m_bHasTaggedVertices;
    protected int m_numPolygonEdges;
    protected boolean m_bHasTaggedPolygons;
    protected boolean m_bHasTaggedEdges;
    protected boolean m_bHasTaggedBoundaries;
    protected boolean m_bHasTaggedElements;
    private boolean m_bHasNeighbours;
    private PdVector m_vt;
    protected PiVector[] m_vertexTrans;
    protected PiVector[] m_vertexNormalTrans;
    protected PiVector[] m_elementNormalTrans;
    protected PiVector[][] m_vectorTrans;
    protected boolean m_useVertices;
    protected boolean m_useElements;
    protected boolean m_usePolygons;
    private int[] xv = new int[this.m_maxDimOfElements];
    private int[] yv = new int[this.m_maxDimOfElements];
    private double grey = 200.0;
    private double greyElem = 30.0;
    private boolean m_elemIsClipped;
    private int[] m_origInd = new int[this.m_maxDimOfElements];
    private PiVector m_pix = new PiVector();
    private PiVector m_pixZero = new PiVector();
    protected boolean m_bShowDepthcue;
    protected boolean m_bShowEdgeOnce;
    protected boolean m_bEnableClip;
    protected double m_clipFar;
    protected double m_clipNear;
    protected PvScene m_scene;
    protected Dimension m_dispSize;
    private double m_heightFac;
    private double m_itemHeight;
    PdMatrix m_projMat;
    PdMatrix m_viewMat;
    int[] m_position = null;

    private void drawVector_(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.drawVector_(graphics, n, n2, n3, n4, n5, true, bl);
    }

    private void drawVector_(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        this.drawLine(graphics, n, n2, n3, n4, n5);
        if (bl2) {
            this.drawVectorTip(graphics, n, n2, n3, n4, n5, bl);
        }
    }

    public boolean setVectorList(int n, PdVector[] pdVectorArray) {
        if (pdVectorArray == null || n != this.m_currentVectorField) {
            PsDebug.warning("missing vectorfield or invalid index");
            return false;
        }
        this.m_vector[this.m_currentVectorField] = PdVector.realloc(this.m_vector[this.m_currentVectorField], pdVectorArray.length, this.m_dim);
        PdVector.copy(this.m_vector[this.m_currentVectorField], 0, pdVectorArray, 0, pdVectorArray.length);
        this.m_vectorTrans[this.m_currentVectorField] = PiVector.realloc(this.m_vectorTrans[this.m_currentVectorField], pdVectorArray.length, this.m_dimTrans);
        return true;
    }

    public boolean hasTagPolygon(int n, int n2) {
        return this.m_polygon[n].hasTag(n2);
    }

    public int addPolygon(PiVector piVector) {
        this.setNumPolygons(this.m_numPolygons + 1);
        this.m_polygon[this.m_numPolygons - 1].setSize(piVector.getSize());
        this.m_polygon[this.m_numPolygons - 1].copy(piVector);
        this.computeNumPolygonEdges();
        return this.m_numPolygons - 1;
    }

    public void setState(int n, boolean bl) {
        switch (n) {
            case 85: {
                this.m_bDefaultLabelEnabled = bl;
                return;
            }
            case 86: {
                this.m_bShowTitle = bl;
                return;
            }
            case 80: {
                this.m_bShowIndices = bl;
                return;
            }
            case 81: {
                this.m_bShowVertexLabels = bl;
                return;
            }
            case 82: {
                this.m_bShowPolygonLabels = bl;
                return;
            }
            case 83: {
                this.m_bShowEdgeLabels = bl;
                return;
            }
            case 84: {
                this.m_bShowElementLabels = bl;
                return;
            }
            case 50: {
                this.m_bShowVertices = bl;
                return;
            }
            case 51: {
                this.m_bShowTaggedVertices = bl;
                return;
            }
            case 52: {
                this.m_bShowEdges = bl;
                return;
            }
            case 53: {
                this.m_bShowTaggedEdges = bl;
                return;
            }
            case 87: {
                this.m_bShowOutline = bl;
                return;
            }
            case 54: {
                this.m_bShowPolygons = bl;
                return;
            }
            case 55: {
                this.m_bShowTaggedPolygons = bl;
                return;
            }
            case 56: {
                this.m_bShowElements = bl;
                return;
            }
            case 57: {
                this.m_bShowTaggedElements = bl;
                return;
            }
            case 68: {
                this.m_bShowBackface = bl;
                return;
            }
            case 58: {
                this.m_bShowBoundaries = bl;
                return;
            }
            case 59: {
                this.m_bShowTaggedBoundaries = bl;
                return;
            }
            case 60: {
                this.m_bShowVertexNormals = bl;
                return;
            }
            case 62: {
                this.m_bShowElementNormals = bl;
                return;
            }
            case 64: {
                this.m_bShowPolygonNormals = bl;
                return;
            }
            case 61: {
                this.m_bShowVertexNormalArrow = bl;
                return;
            }
            case 63: {
                this.m_bShowElementNormalArrow = bl;
                return;
            }
            case 65: {
                this.m_bShowPolygonNormalArrow = bl;
                return;
            }
            case 88: {
                this.m_bShowPolygonStartArrow = bl;
                return;
            }
            case 89: {
                this.m_bShowPolygonEndArrow = bl;
                return;
            }
            case 66: {
                this.m_bShowVectors = bl;
                return;
            }
            case 67: {
                this.m_bShowGlobalVectorArrow = bl;
                return;
            }
            case 69: {
                this.m_bShowBndBox = bl;
                return;
            }
            case 70: {
                this.m_bShowCenter = bl;
                return;
            }
            case 71: {
                this.m_bShowVertexTexture = bl;
                return;
            }
            case 72: {
                this.m_bShowElementTexture = bl;
                return;
            }
            case 73: {
                this.m_bShowTransparency = bl;
                return;
            }
            case 90: {
                this.m_bShowVertexColors = bl;
                return;
            }
            case 92: {
                this.m_bShowPolygonColors = bl;
                return;
            }
            case 93: {
                this.m_bShowEdgeColors = bl;
                return;
            }
            case 94: {
                this.m_bShowElementColors = bl;
                return;
            }
            case 99: {
                this.m_bShowElementBackColor = bl;
                return;
            }
            case 91: {
                this.m_bShowVectorColors = bl;
                return;
            }
        }
        PsDebug.warning("invalid key = " + n);
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n < 3) {
            graphics.drawLine(n2, n3, n4, n5);
            return;
        }
        PvThickGraphics.drawLine(graphics, n, n2, n3, n4, n5);
    }

    private boolean getElementBndBox(int[] nArray, int[] nArray2, int n) {
        int n2 = this.m_element[n].m_data.length;
        int n3 = 0;
        do {
            nArray[n3] = Integer.MAX_VALUE;
            nArray2[n3] = Integer.MIN_VALUE;
        } while (++n3 < 2);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.m_element[n].m_data[n4];
            n3 = 0;
            do {
                if (this.m_vertexTrans[n5].m_data[n3] < nArray[n3]) {
                    nArray[n3] = this.m_vertexTrans[n5].m_data[n3];
                }
                if (this.m_vertexTrans[n5].m_data[n3] <= nArray2[n3]) continue;
                nArray2[n3] = this.m_vertexTrans[n5].m_data[n3];
            } while (++n3 < 2);
            ++n4;
        }
        return nArray[0] < this.m_dispSize.width && nArray2[0] >= 0 && nArray[1] < this.m_dispSize.height && nArray2[1] >= 0;
    }

    private void drawElementBnd(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2) {
        if (!(!this.m_bHasNeighbours || this.m_neighbour[n].m_data.length < n2 || this.m_bEnableClip && this.m_elemIsClipped)) {
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_neighbour[n].m_data[n3] == -1) {
                    graphics.setColor(this.m_globalBndColor);
                    int n4 = (n3 + 1) % n2;
                    int n5 = (n3 + 2) % n2;
                    this.drawLine(graphics, (int)this.m_globalBndSize, nArray[n4], nArray2[n4], nArray[n5], nArray2[n5]);
                }
                ++n3;
            }
        }
    }

    protected int getNumItems() {
        this.m_useElements = false;
        this.m_usePolygons = false;
        this.m_useVertices = false;
        if (this.m_numElements == 0 && this.m_numPolygonEdges == 0 && (this.m_bShowVertices || this.m_bShowTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors) || !this.m_bShowElements && !this.m_bShowEdges && !this.m_bShowBoundaries && !this.m_bShowElementNormals && !this.m_bShowVectors && !this.m_bShowPolygons) {
            this.m_useVertices = true;
        }
        if (this.m_numPolygonEdges > 0 && (this.m_bShowPolygons || this.m_bShowTaggedPolygons || this.m_bShowPolygonNormals)) {
            this.m_usePolygons = true;
        }
        this.m_bHasNeighbours = false;
        if (this.m_numElements > 0 && (this.m_bShowElements || this.m_bShowEdges || this.m_bShowOutline || this.m_bShowBoundaries || this.m_bShowElementNormals || this.m_bShowVectors || this.m_bShowTaggedElements && this.m_bHasTaggedElements || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges)) {
            this.m_useElements = true;
            if (this.m_neighbour != null && this.m_neighbour.length >= this.m_numElements && this.m_neighbour[0] != null && this.m_neighbour[0].getSize() == this.m_element[0].getSize()) {
                this.m_bHasNeighbours = true;
            }
        }
        int n = 0;
        if (this.m_useVertices) {
            n += this.m_numVertices;
        }
        if (this.m_useElements) {
            n += this.m_numElements;
        }
        if (this.m_usePolygons) {
            n += this.m_numPolygonEdges;
        }
        return n;
    }

    private void project(PiVector piVector, PdVector pdVector, PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        int n;
        if (pdMatrix2 != null) {
            if (this.m_dim < 4) {
                pdVector.m_data[3] = 1.0;
            }
            pdVector.leftMultMatrix(pdMatrix2);
        }
        switch (this.m_ambientSpace) {
            case 2: {
                if (this.m_ambientProj == 1) {
                    PuProj.stereoS3_to_R3(pdVector, pdVector);
                    break;
                }
                if (this.m_ambientProj != 0) break;
                break;
            }
            case 3: {
                if (this.m_ambientProj == 1) {
                    PuProj.lorentz2Klein(pdVector, pdVector);
                    break;
                }
                if (this.m_ambientProj == 0) {
                    PuProj.lorentz2Poincare(pdVector, pdVector);
                    break;
                }
                if (this.m_ambientProj != 2) break;
                PuProj.lorentz2Uhm(pdVector, pdVector);
            }
        }
        double d = 1.0;
        if (this.m_position != null) {
            PdVector pdVector2 = new PdVector(this.m_viewMat.m_data[2][0], this.m_viewMat.m_data[2][1], this.m_viewMat.m_data[2][2]);
            d = pdVector2.length();
        }
        int n2 = 0;
        do {
            double d2 = pdMatrix.m_data[n2][3] + 0.5;
            n = 0;
            do {
                d2 += pdMatrix.m_data[n2][n] * pdVector.m_data[n] / d;
            } while (++n < 3);
            piVector.m_data[n2] = (int)d2;
        } while (++n2 < 3);
        if (this.m_position != null) {
            n2 = PS_ZOOM * this.m_dispSize.width / 10;
            n = PS_ZOOM * this.m_dispSize.height - n2;
            int n3 = (int)(pdMatrix.m_data[0][3] + 0.5);
            int n4 = (int)(pdMatrix.m_data[1][3] + 0.5);
            piVector.m_data[0] = piVector.m_data[0] + (n2 - n3);
            piVector.m_data[1] = piVector.m_data[1] + (n - n4);
        }
    }

    private static int discretizeBndEdge(PiVector piVector, PiVector piVector2, PdVector pdVector, PdVector pdVector2, PiVector[] piVectorArray, PdVector[] pdVectorArray, int n) {
        pdVectorArray[n].set(pdVector.m_data[0], pdVector.m_data[1]);
        piVectorArray[n].set(piVector.m_data[0], piVector.m_data[1]);
        ++n;
        int n2 = Math.abs(piVector2.m_data[1] - piVector.m_data[1]);
        if (n2 == 0) {
            return n;
        }
        int n3 = piVector2.m_data[1] > piVector.m_data[1] ? 1 : -1;
        double d = (double)(piVector2.m_data[0] - piVector.m_data[0]) / (double)n2;
        double d2 = (pdVector2.m_data[0] - pdVector.m_data[0]) / (double)n2;
        double d3 = (pdVector2.m_data[1] - pdVector.m_data[1]) / (double)n2;
        double d4 = pdVector.m_data[0];
        double d5 = pdVector.m_data[1];
        double d6 = piVector.m_data[0];
        int n4 = piVector.m_data[1];
        do {
            pdVectorArray[n].set(d4 += d2, d5 += d3);
            piVectorArray[n].set((int)((d6 += d) + 0.5), n4 += n3);
            ++n;
        } while (--n2 > 0);
        return n;
    }

    public boolean hasTagElement(int n, int n2) {
        return this.m_element[n].hasTag(n2);
    }

    public boolean setGlobalVectorColor(int n, Color color) {
        if (color == null || n != this.m_currentVectorField) {
            PsDebug.warning("missing color or invalid index");
            return false;
        }
        this.m_globalVectorColor[this.m_currentVectorField] = color;
        return true;
    }

    public boolean setPolygonColor(int n, Color color) {
        if (n < 0) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (n >= this.m_numPolygons) {
            this.setNumPolygons(n + 1);
        }
        this.assurePolygonColors();
        this.m_polygonColor[n] = color;
        return true;
    }

    public boolean setPolygonTag(int n, int n2) {
        if (n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (n2 < 0 || n2 >= 32) {
            PsDebug.warning("tag=" + n2 + " out of range", this);
            return false;
        }
        this.m_polygon[n].setTag(n2);
        return true;
    }

    public boolean hasTagVertex(int n, int n2) {
        return this.m_vertex[n].hasTag(n2);
    }

    public int addVertex(PdVector pdVector) {
        this.setNumVertices(this.m_numVertices + 1);
        this.m_vertex[this.m_numVertices - 1].copy(pdVector);
        return this.m_numVertices - 1;
    }

    public void setGlobalBndSize(double d) {
        this.m_globalBndSize = d;
        if (this.m_globalBndSize > 1.0) {
            this.m_globalBndSize = 2.0 * d - 1.0;
        }
    }

    protected boolean untagAllVertices() {
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].clearTag(1);
            this.m_geometry.clearTagVertex(n, 1);
            ++n;
        }
        return true;
    }

    public boolean setPolygonNormal(int n, PdVector pdVector) {
        if (n < 0) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (n >= this.m_numPolygons) {
            this.setNumPolygons(n + 1);
        }
        this.assurePolygonNormals();
        this.m_polygonNormal[n].copy(pdVector);
        return true;
    }

    protected Vector getTaggedVertices() {
        Vector<PdVector> vector = new Vector<PdVector>();
        int n = 0;
        while (n < this.m_numVertices) {
            if (this.m_vertex[n].hasTag(1)) {
                vector.addElement(this.m_vertex[n]);
            }
            ++n;
        }
        return vector;
    }

    protected boolean untagVertices(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        int n5 = 0;
        while (n5 < this.m_numVertices) {
            if (this.m_vertex[n5].hasTag(1) && rectangle.contains(this.m_vertexTrans[n5].m_data[0], this.m_vertexTrans[n5].m_data[1])) {
                this.m_vertex[n5].clearTag(1);
                this.m_geometry.clearTagVertex(n5, 1);
            }
            ++n5;
        }
        return true;
    }

    protected void setDisplay(PvDisplayIf pvDisplayIf) {
        this.m_display = pvDisplayIf;
    }

    protected int computeNumPolygonEdges() {
        this.m_numPolygonEdges = 0;
        int n = 0;
        while (n < this.m_numPolygons) {
            if (this.m_polygon[n] != null) {
                this.m_numPolygonEdges += Math.max(this.m_polygon[n].getSize() - 1, 0);
            }
            ++n;
        }
        return this.m_numPolygonEdges;
    }

    protected void drawItem(Graphics graphics, int n, double d, double d2) {
        String string;
        this.m_heightFac = d;
        this.m_itemHeight = d2;
        if (!(this.m_bShowBackface || this.m_elementNormal != null && this.m_elementNormal.length == this.m_numElements)) {
            this.m_bShowBackface = true;
            PsDebug.warning("missing normals, backelement culling switched off");
        }
        if (this.m_bShowTitle && (string = this.m_geometry.getName()) != null) {
            graphics.setColor(Color.black);
            int[] nArray = this.m_labelAttribute[5].m_data;
            if (graphics.getFont() != PsConfig.getFont(nArray[3])) {
                graphics.setFont(PsConfig.getFont(nArray[3]));
            }
            int n2 = 0;
            if (nArray[2] == 1) {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                n2 = fontMetrics.stringWidth(string);
            }
            graphics.drawString(string, this.m_bndBoxTrans[1].m_data[0] + (nArray[0] - n2) * PS_ZOOM, this.m_bndBoxTrans[1].m_data[1]);
        }
        int n3 = 0;
        if (this.m_useVertices) {
            if (n < this.m_numVertices) {
                this.drawVertex(graphics, n);
                return;
            }
            n3 = this.m_numVertices;
        }
        if (this.m_useElements) {
            if (n - n3 < this.m_numElements) {
                this.drawElement(graphics, n - n3);
                return;
            }
            n3 = this.m_numElements;
        }
        if (this.m_usePolygons) {
            if (n - n3 < this.m_numPolygonEdges) {
                this.drawPolygon(graphics, n - n3);
                int n4 = 0;
                do {
                    if (this.m_origInd[n4] == -1) continue;
                    this.drawVertex(graphics, this.m_origInd[n4]);
                } while (++n4 < 2);
                return;
            }
            PsDebug.error("itemInd out of range, index = " + n, this);
        }
    }

    private boolean isBackelementCulled(int n, int n2) {
        return !(this.m_elementNormal != null && this.m_elementNormal.length == this.m_numElements ? (double)this.m_elementNormalTrans[n].m_data[2] > 0.0 : this.m_vertexNormal != null && this.m_vertexNormal.length == this.m_numVertices && this.m_element[n].m_data.length > 0 && (double)this.m_vertexNormalTrans[this.m_element[n].m_data[0]].m_data[2] > 0.0);
    }

    protected boolean setGeometryPolygon(int n, PiVector piVector) {
        this.setPolygon(n, piVector);
        return this.m_geometry.setPolygon(n, piVector);
    }

    protected void projectItems(Graphics graphics, PdMatrix pdMatrix, PdMatrix pdMatrix2, PdMatrix pdMatrix3, PdMatrix pdMatrix4) {
        this.m_projMat = pdMatrix2;
        this.m_viewMat = pdMatrix3;
        this.projectVertices(graphics, pdMatrix, pdMatrix4);
        int n = 0;
        do {
            this.m_vt.copy(this.m_bndBox[n]);
            this.project(this.m_bndBoxTrans[n], this.m_vt, pdMatrix, pdMatrix4);
        } while (++n < 2);
        if (this.m_bShowVertexNormals || this.m_bShowEdgeAura || this.m_bShowOutline || !this.m_bShowBackface || this.m_bShowElementBackColor) {
            this.projectVertexNormals(graphics, pdMatrix, pdMatrix4);
        }
        if (this.m_bShowElementNormals || this.m_bShowEdgeAura || this.m_bShowOutline || !this.m_bShowBackface || this.m_bShowElementBackColor) {
            this.projectElementNormals(graphics, pdMatrix, pdMatrix4);
        }
        if (this.m_bShowVectors) {
            this.projectVectors(graphics, pdMatrix, pdMatrix4);
        }
        if (this.m_bShowTaggedVertices) {
            this.m_bHasTaggedVertices = false;
            n = 0;
            while (n < this.m_numVertices) {
                if (this.m_vertex[n].hasTag(1)) {
                    this.m_bHasTaggedVertices = true;
                    break;
                }
                ++n;
            }
        }
        if (this.m_bShowTaggedPolygons) {
            this.m_bHasTaggedPolygons = false;
            n = 0;
            while (n < this.m_numPolygons) {
                if (this.m_polygon[n].hasTag(1)) {
                    this.m_bHasTaggedPolygons = true;
                    break;
                }
                ++n;
            }
        }
        if (this.m_bShowTaggedElements) {
            this.m_bHasTaggedElements = false;
            n = 0;
            while (n < this.m_numElements) {
                if (this.m_element[n].hasTag(1)) {
                    this.m_bHasTaggedElements = true;
                    return;
                }
                ++n;
            }
        }
    }

    public PgGeometryIf getGeometry() {
        return this.m_geometry;
    }

    public void setGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing geometry");
            return;
        }
        this.m_geometry = pgGeometryIf;
        this.setName(pgGeometryIf.getName() + "_Container");
        this.update(this.m_geometry);
    }

    protected void setPosition(int n, int n2) {
        this.m_position = new int[]{n, n2};
    }

    public int getDrawingOrder() {
        return this.m_drawingOrder;
    }

    public void setDrawingOrder(int n) {
        this.m_drawingOrder = n;
    }

    private void drawElementVectors(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n3 = 0;
        while (n3 < this.m_numVectorFields) {
            if (this.m_vectorIsElementBased[n3]) {
                if (!this.m_bShowVectorColors) {
                    graphics.setColor(this.m_globalVectorColor[n3]);
                }
                double[] dArray = new double[3];
                int n4 = 0;
                do {
                    dArray[n4] = 0.0;
                    int n5 = 0;
                    while (n5 < this.m_element[n].m_data.length) {
                        int n6 = n4;
                        dArray[n6] = dArray[n6] + (double)this.m_vertexTrans[this.m_element[n].m_data[n5]].m_data[n4];
                        ++n5;
                    }
                    int n7 = n4++;
                    dArray[n7] = dArray[n7] / (double)this.m_element[n].m_data.length;
                } while (n4 < 2);
                this.drawVector_(graphics, (int)this.m_globalVectorSize[0], (int)dArray[0], (int)dArray[1], this.m_vectorTrans[n3][n].m_data[0], this.m_vectorTrans[n3][n].m_data[1], this.m_bShowGlobalVectorArrow);
            }
            ++n3;
        }
    }

    public void init() {
        super.init();
        this.m_useVertices = true;
        this.m_useElements = true;
        this.m_bHasNeighbours = false;
        this.m_bShowTransparency = true;
        this.m_alpha = 255;
        this.m_bShowGlobalVectorArrow = false;
        this.m_bShowVectorColors = false;
        this.m_bHasTaggedVertices = false;
        this.m_bHasTaggedPolygons = false;
        this.m_bHasTaggedEdges = false;
        this.m_bHasTaggedBoundaries = false;
        this.m_bHasTaggedElements = false;
        this.m_vertexTrans = null;
        this.m_vertexNormalTrans = null;
        this.m_elementNormalTrans = null;
        this.m_vectorTrans = null;
        this.m_globalBndboxColor = Color.magenta;
        this.m_bndBox = PdVector.realloc(this.m_bndBox, 2, this.m_dimTrans);
        this.m_bndBox[0].setConstant(-1.0);
        this.m_bndBox[1].setConstant(1.0);
        this.m_bndBoxTrans = PiVector.realloc(this.m_bndBoxTrans, 2, this.m_dimTrans);
        this.m_center = new PdVector(this.m_dim);
        this.m_center.setConstant(0.0);
    }

    protected void projectVectors(Graphics graphics, PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0 || this.m_numVectorFields == 0) {
            this.m_bShowVectors = false;
            return;
        }
        int n = 0;
        while (n < this.m_numVectorFields) {
            int n2;
            if (!this.m_vectorIsElementBased[n]) {
                int n3 = 0;
                while (n3 < this.m_numVertices) {
                    n2 = 0;
                    while (n2 < this.m_dim) {
                        this.m_vt.m_data[n2] = this.m_vertex[n3].m_data[n2] + this.m_globalVectorLength[n] * this.m_vector[n][n3].m_data[n2];
                        ++n2;
                    }
                    this.project(this.m_vectorTrans[n][n3], this.m_vt, pdMatrix, pdMatrix2);
                    ++n3;
                }
            } else {
                PdVector pdVector = new PdVector(this.m_dim);
                n2 = 0;
                while (n2 < this.m_numElements) {
                    int n4;
                    int[] nArray = this.m_element[n2].m_data;
                    if (nArray.length >= 2) {
                        pdVector.add(this.m_vertex[nArray[0]], this.m_vertex[nArray[1]]);
                        n4 = 2;
                        while (n4 < nArray.length) {
                            pdVector.add(this.m_vertex[nArray[n4]]);
                            ++n4;
                        }
                        pdVector.multScalar(1.0 / (double)nArray.length);
                    } else {
                        pdVector = this.m_vertex[nArray[0]];
                    }
                    n4 = 0;
                    while (n4 < this.m_dim) {
                        this.m_vt.m_data[n4] = pdVector.m_data[n4] + this.m_globalVectorLength[n] * this.m_vector[n][n2].m_data[n4];
                        ++n4;
                    }
                    this.project(this.m_vectorTrans[n][n2], this.m_vt, pdMatrix, pdMatrix2);
                    ++n2;
                }
            }
            ++n;
        }
    }

    protected boolean setGeometryElement(int n, PiVector piVector) {
        this.setElement(n, piVector);
        return this.m_geometry.setElement(n, piVector);
    }

    protected int pickVertex(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        int n3 = 0;
        while (n3 < this.m_numVertices) {
            rectangle.setBounds(this.m_vertexTrans[n3].m_data[0] - 3, this.m_vertexTrans[n3].m_data[1] - 3, 7, 7);
            if (rectangle.contains(n, n2)) {
                this.m_vertex[n3].setTag(1);
                this.m_geometry.setTagVertex(n3, 1);
                this.m_pickedVertex = n3;
                return this.m_pickedVertex;
            }
            ++n3;
        }
        return -1;
    }

    protected int releaseVertex(int n) {
        if (n >= 0 && n < this.m_numVertices) {
            this.m_vertex[n].clearTag(1);
            this.m_geometry.clearTagVertex(n, 1);
        }
        this.m_pickedVertex = -1;
        return -1;
    }

    public void setTexture(int[] nArray, int n, int n2) {
        this.m_texturePix = nArray;
        this.m_textureWidth = n;
        this.m_textureHeight = n2;
        if (nArray == null) {
            this.setState(71, false);
            this.setState(72, false);
        }
    }

    public boolean setElementTexture(int n, PdVector[] pdVectorArray) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureElementTextures();
        this.m_elementTexture[n] = PdVector.copyNew(pdVectorArray, pdVectorArray.length);
        return true;
    }

    public boolean setVertexTexture(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureVertexTextures();
        this.m_vertexTexture[n].copy(pdVector);
        return true;
    }

    private void drawElementTexture(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, PdVector[] pdVectorArray) {
        int[] nArray3 = new int[2];
        int[] nArray4 = new int[2];
        boolean bl = this.getElementBndBox(nArray3, nArray4, n);
        if (!bl) {
            return;
        }
        int n3 = nArray4[0] - nArray3[0] + 1;
        int n4 = nArray4[1] - nArray3[1] + 1;
        if (n4 >= this.m_dispSize.height || n3 >= this.m_dispSize.width) {
            return;
        }
        if (this.mis == null || this.imgHeight < n4 || this.imgWidth < n3) {
            this.imgHeight = Math.max(n4, this.imgHeight);
            this.imgWidth = Math.max(n3, this.imgWidth);
            this.m_pix.setSize(this.imgWidth * this.imgHeight);
            this.m_pixZero.setSize(this.imgWidth * this.imgHeight);
            this.mis = new MemoryImageSource(this.imgWidth, this.imgHeight, this.m_pix.m_data, 0, this.imgWidth);
            this.mis.setAnimated(true);
            this.drawElementTexture_(graphics, n, n2, nArray, nArray2, nArray3[0], nArray3[1], this.m_pix.m_data, this.imgWidth, n4, pdVectorArray);
            this.m_destImage = ((Component)((Object)this.m_display)).createImage(this.mis);
        } else {
            this.drawElementTexture_(graphics, n, n2, nArray, nArray2, nArray3[0], nArray3[1], this.m_pix.m_data, this.imgWidth, n4, pdVectorArray);
            this.mis.newPixels(0, 0, Math.max(n3, this.prevElemWidth), Math.max(n4, this.prevElemHeight));
        }
        if (this.m_destImage != null) {
            graphics.drawImage(this.m_destImage, nArray3[0], nArray3[1], null);
        }
        System.arraycopy(this.m_pixZero.m_data, 0, this.m_pix.m_data, 0, this.imgWidth * n4);
        this.prevElemWidth = n3;
        this.prevElemHeight = n4;
    }

    protected boolean setGeometryVertex(int n, PdVector pdVector) {
        this.setVertex(n, pdVector);
        return this.m_geometry.setVertex(n, pdVector);
    }

    public boolean setGlobalVectorSize(int n, double d) {
        if (n != this.m_currentVectorField) {
            PsDebug.warning("invalid index of vectorfield");
            return false;
        }
        this.m_globalVectorSize[this.m_currentVectorField] = d;
        if (this.m_globalVectorSize[this.m_currentVectorField] > 1.0) {
            this.m_globalVectorSize[this.m_currentVectorField] = 2.0 * d - 1.0;
        }
        return true;
    }

    public void clearTagElement(int n, int n2) {
        this.m_element[n].clearTag(n2);
        this.m_geometry.clearTagElement(n, n2);
    }

    private void drawElement(Graphics graphics, int n) {
        int n2;
        int n3 = this.m_element[n].m_data.length;
        if (!this.m_bShowBackface && this.isBackelementCulled(n, n3)) {
            return;
        }
        if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
            if (this.m_bShowVertexTexture && this.m_vertexTexture == null) {
                this.m_bShowVertexTexture = false;
            }
            if (this.m_bShowElementTexture && this.m_elementTexture == null) {
                this.m_bShowElementTexture = false;
            }
        }
        PdVector[] pdVectorArray = null;
        if (this.m_bEnableClip) {
            this.m_elemIsClipped = false;
            if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
                pdVectorArray = PdVector.realloc(pdVectorArray, this.m_maxDimOfElements, 2);
            }
            if (this.m_bShowVertexTexture) {
                PdVector[] pdVectorArray2 = new PdVector[n3];
                n2 = 0;
                while (n2 < n3) {
                    pdVectorArray2[n2] = this.m_vertexTexture[this.m_element[n].m_data[n2]];
                    ++n2;
                }
                n3 = this.clipElement(n, n3, this.xv, this.yv, this.m_origInd, pdVectorArray, pdVectorArray2);
            } else {
                n3 = this.m_bShowElementTexture ? this.clipElement(n, n3, this.xv, this.yv, this.m_origInd, pdVectorArray, this.m_elementTexture[n]) : this.clipElement(n, n3, this.xv, this.yv, this.m_origInd, null, null);
            }
            if (n3 == 0) {
                return;
            }
        } else {
            int n4 = n3 - 1;
            while (n4 >= 0) {
                n2 = this.m_element[n].m_data[n4];
                this.xv[n4] = this.m_vertexTrans[n2].m_data[0];
                this.yv[n4] = this.m_vertexTrans[n2].m_data[1];
                this.m_origInd[n4] = n2;
                --n4;
            }
            if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
                pdVectorArray = new PdVector[n3];
                n4 = n3 - 1;
                while (n4 >= 0) {
                    if (this.m_bShowVertexTexture) {
                        pdVectorArray[n4] = this.m_vertexTexture[this.m_element[n].m_data[n4]];
                    } else if (this.m_bShowElementTexture) {
                        pdVectorArray[n4] = this.m_elementTexture[n][n4];
                    }
                    --n4;
                }
            }
        }
        if (this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements) {
            if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
                this.drawElementTexture(graphics, n, n3, this.xv, this.yv, pdVectorArray);
            } else {
                this.drawElement(graphics, n, n3, this.xv, this.yv);
            }
        }
        if (this.m_bShowEdges || this.m_bShowOutline || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges) {
            this.drawElementEdges(graphics, n, n3, this.xv, this.yv);
        }
        if (!(!this.m_bShowBoundaries || this.m_bEnableClip && this.m_elemIsClipped)) {
            this.drawElementBnd(graphics, n, n3, this.xv, this.yv);
        }
        if (!this.m_useVertices && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors)) {
            this.drawElementVertices(graphics, n, n3, this.m_origInd);
        }
        if ((this.m_bShowIndices || this.m_bShowElementLabels) && (this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements)) {
            int n5 = 0;
            n2 = 0;
            int n6 = n3 - 1;
            while (n6 >= 0) {
                n5 += this.xv[n6];
                n2 += this.yv[n6];
                --n6;
            }
            graphics.setColor(Color.orange);
            String string = this.m_element[n].getName();
            if (string == null && this.m_bDefaultLabelEnabled) {
                string = String.valueOf(n);
            }
            if (string != null && n3 > 0) {
                int[] nArray = this.m_labelAttribute[3].m_data;
                if (graphics.getFont() != PsConfig.getFont(nArray[3])) {
                    graphics.setFont(PsConfig.getFont(nArray[3]));
                }
                int n7 = 0;
                if (nArray[2] == 1) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    n7 = fontMetrics.stringWidth(string);
                }
                graphics.drawString(string, n5 / n3 + (nArray[0] - n7) * PS_ZOOM, n2 / n3 + nArray[1] * PS_ZOOM);
            }
        }
        if (this.m_bShowElementNormals) {
            this.drawElementNormal(graphics, n, n3, this.xv, this.yv);
        }
        if (this.m_bShowVectors) {
            this.drawElementVectors(graphics, n, n3, this.xv, this.yv, this.m_origInd);
        }
    }

    private void drawElement(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2) {
        if (this.m_bShowTaggedElements && this.m_bHasTaggedElements && (this.m_element[n].hasTag(1) || this.m_element[n].hasTag(1))) {
            graphics.setColor(this.m_globalElementTagColor);
        } else if (this.m_bShowElements) {
            if (this.m_bShowDepthcue) {
                if (this.m_bShowElementBackColor && this.isBackelementCulled(n, n2)) {
                    graphics.setColor(PdColor.getDimmedColor(this.m_globalElementBackColor, this.m_heightFac));
                } else if (this.m_bShowElementColors) {
                    graphics.setColor(PdColor.getDimmedColor(this.m_elementColor[n], this.m_heightFac));
                } else {
                    graphics.setColor(PdColor.getDimmedColor(this.m_globalElementColor, this.m_heightFac));
                }
            } else if (this.m_bShowElementBackColor && this.isBackelementCulled(n, n2)) {
                graphics.setColor(this.m_globalElementBackColor);
            } else if (this.m_bShowElementColors) {
                graphics.setColor(this.m_elementColor[n]);
            } else {
                graphics.setColor(this.m_globalElementColor);
            }
        } else {
            return;
        }
        graphics.fillPolygon(nArray, nArray2, n2);
    }

    protected boolean removeGeometryElement(int n) {
        this.removeElement(n);
        this.m_geometry.removeElement(n);
        return true;
    }

    public boolean setGlobalVectorLength(int n, double d) {
        if (n != this.m_currentVectorField) {
            PsDebug.warning("invalid index of vectorfield");
            return false;
        }
        this.m_globalVectorLength[this.m_currentVectorField] = d;
        return true;
    }

    protected boolean tagVertices(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        int n5 = 0;
        while (n5 < this.m_numVertices) {
            if (rectangle.contains(this.m_vertexTrans[n5].m_data[0], this.m_vertexTrans[n5].m_data[1])) {
                this.m_vertex[n5].setTag(1);
                this.m_geometry.setTagVertex(n5, 1);
            }
            ++n5;
        }
        return true;
    }

    private void drawElementEdges(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2) {
        block14: {
            if (this.m_bShowEdgeAura && !this.m_bShowElements) {
                graphics.setColor(this.m_backColor);
                PvThickGraphics.drawPolygon(graphics, Math.max(6, (int)(2.0 * this.m_globalEdgeSize)), nArray, nArray2, n2, !this.isBackelementCulled(n, n2));
            }
            if (this.m_bShowTaggedEdges && this.m_bHasTaggedEdges && (this.m_element[n].hasTag(1) || this.m_element[n].hasTag(1))) {
                graphics.setColor(this.m_globalEdgeTagColor);
            } else if (this.m_bShowDepthcue && !this.m_bShowElements) {
                if (this.m_bShowEdgeColors) {
                    graphics.setColor(PdColor.getDimmedColor(this.m_edgeColor[n], this.m_heightFac));
                } else {
                    double d = this.grey * (1.0 - this.m_heightFac);
                    graphics.setColor(new Color((int)(d + this.m_heightFac * (double)this.m_globalEdgeColor.getRed()), (int)(d + this.m_heightFac * (double)this.m_globalEdgeColor.getGreen()), (int)(d + this.m_heightFac * (double)this.m_globalEdgeColor.getBlue())));
                }
            } else if (this.m_bShowEdgeColors) {
                graphics.setColor(this.m_edgeColor[n]);
            } else {
                graphics.setColor(this.m_globalEdgeColor);
            }
            if (!this.m_bShowOutline || !this.m_bHasNeighbours || this.m_elementNormal == null || this.m_bEnableClip && this.m_elemIsClipped) break block14;
            int n3 = 0;
            while (n3 < n2) {
                block15: {
                    int n4;
                    int n5;
                    int n6;
                    block17: {
                        block16: {
                            int n7 = this.m_neighbour[n].m_data[n3];
                            if (n7 >= this.m_numElements) break block15;
                            n6 = (n3 + 1) % n2;
                            n5 = (n3 + 2) % n2;
                            n4 = (int)this.m_globalEdgeSize;
                            if (n7 == -1 || (this.m_elementNormalTrans[n].m_data[2] > 0 || this.m_elementNormalTrans[n7].m_data[2] <= 0) && (this.m_elementNormalTrans[n].m_data[2] < 0 || this.m_elementNormalTrans[n7].m_data[2] >= 0)) break block16;
                            n4 = (int)(2.0 * this.m_globalBndSize + 1.0);
                            break block17;
                        }
                        if (!this.m_bShowEdges) break block15;
                    }
                    this.drawLine(graphics, n4, nArray[n6], nArray2[n6], nArray[n5], nArray2[n5]);
                }
                ++n3;
            }
            return;
        }
        if ((int)this.m_globalEdgeSize == 1) {
            graphics.drawPolygon(nArray, nArray2, n2);
            return;
        }
        PvThickGraphics.drawPolygon(graphics, (int)this.m_globalEdgeSize, nArray, nArray2, n2);
    }

    private void drawElementVertices(Graphics graphics, int n, int n2, int[] nArray) {
        int n3 = 0;
        while (n3 < n2) {
            block3: {
                block4: {
                    if (nArray[n3] == -1) break block3;
                    if (!this.m_bShowBackface || !this.m_bShowEdgeOnce || !this.m_bHasNeighbours || this.m_bEnableClip && this.m_elemIsClipped) break block4;
                    int n4 = this.m_neighbour[n].m_data[(n3 - 2 + n2) % n2];
                    int n5 = this.m_neighbour[n].m_data[(n3 - 1 + n2) % n2];
                    if (n4 != -1 && this.m_itemHeight < this.m_scene.getHeightOfItemInCurrentGeometry(n4) || n5 != -1 && this.m_itemHeight < this.m_scene.getHeightOfItemInCurrentGeometry(n5)) break block3;
                }
                this.drawVertex(graphics, nArray[n3]);
            }
            ++n3;
        }
    }

    protected void projectVertices(Graphics graphics, PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0) {
            return;
        }
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vt.copy(this.m_vertex[n]);
            this.project(this.m_vertexTrans[n], this.m_vt, pdMatrix, pdMatrix2);
            ++n;
        }
    }

    private void drawVectorTip(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        double d = n4 - n2;
        double d2 = n5 - n3;
        double d3 = d * d + d2 * d2;
        double d4 = (double)PS_ZOOM * ((double)n + 4.0);
        if (d3 < 1.0) {
            return;
        }
        double d5 = bl ? 2.0 * d4 / Math.PI / Math.sqrt(d3) * Math.atan(d3 / 50.0 / (double)PS_ZOOM / (double)PS_ZOOM) : 2.0 * d4 / Math.PI / Math.sqrt(d3) * Math.atan(8.0 / (double)PS_ZOOM / (double)PS_ZOOM);
        d = (int)(d * d5);
        d2 = (int)(d2 * d5);
        int n6 = n4 + (int)(-d + d2);
        int n7 = n5 + (int)(-d - d2);
        this.drawLine(graphics, n, n4, n5, n6, n7);
        n6 = n4 + (int)(-d - d2);
        n7 = n5 + (int)(d - d2);
        this.drawLine(graphics, n, n4, n5, n6, n7);
    }

    protected void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexTrans = PiVector.realloc(this.m_vertexTrans, n, this.m_dimTrans);
        if (this.m_vertexNormal != null) {
            this.m_vertexNormalTrans = PiVector.realloc(this.m_vertexNormalTrans, n, this.m_dimTrans);
        }
    }

    public boolean update(Object object) {
        if (object == this.m_geometry) {
            if (this.m_geometry == null) {
                PsDebug.warning("missing associated geometry");
                return false;
            }
            this.m_geometry.paint(this);
            if (!this.getName().startsWith(this.m_geometry.getName())) {
                this.setName(this.m_geometry.getName() + "_Container");
            }
            this.getBounds();
            return true;
        }
        return false;
    }

    public boolean setPolygon(int n, PiVector piVector) {
        if (!super.setPolygon(n, piVector)) {
            return false;
        }
        this.computeNumPolygonEdges();
        return true;
    }

    public void clearTagPolygon(int n, int n2) {
        this.m_polygon[n].clearTag(n2);
        this.m_geometry.clearTagPolygon(n, n2);
    }

    private void drawPolygon(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4 = 0;
        while (n4 < this.m_numPolygons) {
            n3 = this.m_polygon[n4].getSize() - 1;
            if (n < n3) break;
            n -= n3;
            ++n4;
        }
        if (n4 == this.m_numPolygons) {
            PsDebug.warning("edgeInd = " + n + " out of bounds.");
            return;
        }
        n3 = n != 0 ? 0 : 1;
        boolean bl = n == this.m_polygon[n4].getSize() - 2;
        int n5 = 2;
        if (this.m_bEnableClip) {
            this.m_elemIsClipped = false;
            n5 = this.clipPolygon(n4, n, this.xv, this.yv, this.m_origInd);
            if (n5 == 0) {
                return;
            }
        } else {
            n2 = 0;
            while (n2 < n5) {
                int n6 = this.m_polygon[n4].m_data[n + n2];
                this.xv[n2] = this.m_vertexTrans[n6].m_data[0];
                this.yv[n2] = this.m_vertexTrans[n6].m_data[1];
                this.m_origInd[n2] = n6;
                ++n2;
            }
        }
        n2 = (int)this.m_globalPolygonSize;
        if (this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons && (this.m_polygon[n4].hasTag(1) || this.m_polygon[n4].hasTag(1))) {
            n2 = (int)(2.0 * this.m_globalPolygonSize);
            graphics.setColor(this.m_globalPolygonTagColor);
        } else if (this.m_bShowPolygons) {
            if (this.m_bShowEdgeAura) {
                graphics.setColor(this.m_backColor);
                this.drawLine(graphics, Math.max(6, 2 * (int)this.m_globalPolygonSize), this.xv[0], this.yv[0], this.xv[1], this.yv[1]);
            }
            Color color = this.m_bShowPolygonColors ? this.m_polygonColor[n4] : this.m_globalPolygonColor;
            if (this.m_bShowDepthcue) {
                graphics.setColor(new Color((int)(this.grey * (1.0 - this.m_heightFac) + this.m_heightFac * (double)color.getRed()), (int)(this.grey * (1.0 - this.m_heightFac) + this.m_heightFac * (double)color.getGreen()), (int)(this.grey * (1.0 - this.m_heightFac) + this.m_heightFac * (double)color.getBlue())));
            } else {
                graphics.setColor(color);
            }
        } else {
            return;
        }
        this.drawLine(graphics, n2, this.xv[0], this.yv[0], this.xv[1], this.yv[1]);
        if (this.m_bShowPolygonEndArrow && bl) {
            this.drawVectorTip(graphics, n2, this.xv[0], this.yv[0], this.xv[1], this.yv[1], false);
        }
        if (this.m_bShowPolygonStartArrow && n3 != 0) {
            this.drawVectorTip(graphics, n2, this.xv[1], this.yv[1], this.xv[0], this.yv[0], false);
        }
        if ((this.m_bShowIndices || this.m_bShowPolygonLabels) && (this.m_bShowPolygons || this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons)) {
            String string = this.m_polygon[n4].getName();
            if (string == null && this.m_bDefaultLabelEnabled) {
                string = String.valueOf(n4) + "," + String.valueOf(n);
            }
            if (string != null) {
                int[] nArray = this.m_labelAttribute[2].m_data;
                if (graphics.getFont() != PsConfig.getFont(nArray[3])) {
                    graphics.setFont(PsConfig.getFont(nArray[3]));
                }
                int n7 = 0;
                if (nArray[2] == 1) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    n7 = fontMetrics.stringWidth(string);
                }
                graphics.drawString(string, (this.xv[0] + this.xv[1]) / 2 + (nArray[0] - n7) * PS_ZOOM, (this.yv[0] + this.yv[1]) / 2 + nArray[1] * PS_ZOOM);
            }
        }
    }

    protected boolean removeGeometryPolygon(int n) {
        this.removePolygon(n);
        this.m_geometry.removePolygon(n);
        return true;
    }

    public boolean setLabelAttributes(PiVector[] piVectorArray) {
        PiVector.copy(this.m_labelAttribute, 0, piVectorArray, 0, piVectorArray.length);
        return true;
    }

    public PdVector[] getBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector.min(this.m_bndBox[0], this.m_vertex, this.m_numVertices);
        PdVector.max(this.m_bndBox[1], this.m_vertex, this.m_numVertices);
        int n = this.m_dimTrans - 1;
        while (n >= this.m_dim) {
            this.m_bndBox[0].setEntry(n, 0.0);
            this.m_bndBox[1].setEntry(n, 0.0);
            --n;
        }
        return this.m_bndBox;
    }

    public void setElementBased(int n, boolean bl) {
        this.m_vectorIsElementBased[n] = bl;
    }

    protected void projectVertexNormals(Graphics graphics, PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0 || this.m_vertexNormal == null || this.m_vertexNormal.length < this.m_numVertices) {
            this.m_bShowVertexNormals = false;
            return;
        }
        int n = 0;
        while (n < this.m_numVertices) {
            int n2 = 0;
            while (n2 < this.m_dim) {
                this.m_vt.m_data[n2] = this.m_vertex[n].m_data[n2] + this.m_globalVertexNormalLength * this.m_vertexNormal[n].m_data[n2];
                ++n2;
            }
            this.project(this.m_vertexNormalTrans[n], this.m_vt, pdMatrix, pdMatrix2);
            ++n;
        }
    }

    protected void projectElementNormals(Graphics graphics, PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numElements == 0 || this.m_elementNormal == null || this.m_elementNormal.length < this.m_numElements) {
            this.m_bShowElementNormals = false;
            return;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numElements) {
            int n2;
            int[] nArray = this.m_element[n].m_data;
            if (nArray.length >= 2) {
                pdVector.add(this.m_vertex[nArray[0]], this.m_vertex[nArray[1]]);
                n2 = 2;
                while (n2 < nArray.length) {
                    pdVector.add(this.m_vertex[nArray[n2]]);
                    ++n2;
                }
                pdVector.multScalar(1.0 / (double)nArray.length);
            } else {
                pdVector = this.m_vertex[nArray[0]];
            }
            n2 = 0;
            while (n2 < this.m_dim) {
                this.m_vt.m_data[n2] = pdVector.m_data[n2] + this.m_globalElementNormalLength * this.m_elementNormal[n].m_data[n2];
                ++n2;
            }
            this.project(this.m_elementNormalTrans[n], this.m_vt, pdMatrix, pdMatrix2);
            if (this.m_dim >= 3) {
                double d = 0.0;
                int n3 = 0;
                while (n3 < nArray.length) {
                    d += (double)this.m_vertexTrans[nArray[n3]].m_data[2];
                    ++n3;
                }
                this.m_elementNormalTrans[n].m_data[2] = (int)((double)this.m_elementNormalTrans[n].m_data[2] - d / (double)nArray.length);
            }
            ++n;
        }
    }

    private void drawElementTexture_(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int n3, int n4, int[] nArray3, int n5, int n6, PdVector[] pdVectorArray) {
        int n7 = 0;
        int n8 = nArray2[0];
        int n9 = 1;
        while (n9 < n2) {
            if (nArray2[n9] < n8) {
                n8 = nArray2[n9];
                n7 = n9;
            }
            ++n9;
        }
        int n10 = 0;
        int n11 = 0;
        while (n11 < n2) {
            n9 = (n7 + n11) % n2;
            n10 = PvGeometry.discretizeBndEdge(new PiVector(nArray[n9], nArray2[n9]), new PiVector(nArray[(n9 + 1) % n2], nArray2[(n9 + 1) % n2]), pdVectorArray[n9], pdVectorArray[(n9 + 1) % n2], this.m_faceDestBnd, this.m_faceTextureBnd, n10);
            ++n11;
        }
        int n12 = (int)((double)(n10 + 1) / 2.0);
        n9 = 0;
        while (n9 < n12) {
            int n13 = this.m_faceDestBnd[n9].m_data[0] - n3;
            int n14 = this.m_faceDestBnd[n9].m_data[1] - n4;
            double d = this.m_faceTextureBnd[n9].m_data[0] * ((double)this.m_textureWidth - 1.0);
            double d2 = this.m_faceTextureBnd[n9].m_data[1] * ((double)this.m_textureHeight - 1.0);
            n11 = n10 - 1 - n9;
            int n15 = this.m_faceDestBnd[n11].m_data[0] - n3;
            double d3 = this.m_faceTextureBnd[n11].m_data[0] * ((double)this.m_textureWidth - 1.0);
            double d4 = this.m_faceTextureBnd[n11].m_data[1] * ((double)this.m_textureHeight - 1.0);
            if (n13 >= 0 && n13 <= n5 && n14 >= 0 && n14 <= n6 && n15 >= 0 && n15 <= n5) {
                this.drawScanLine(this.m_texturePix, this.m_textureWidth, this.m_textureHeight, nArray3, n5, n13, n15, n14, d, d2, d3, d4);
            }
            ++n9;
        }
    }

    public void assureVertexNormals() {
        super.assureVertexNormals();
        if (this.m_vertexNormalTrans == null || this.m_vertexNormalTrans.length != this.m_numVertices) {
            this.m_vertexNormalTrans = PiVector.realloc(this.m_vertexNormalTrans, this.m_numVertices, this.m_dimTrans);
        }
    }

    public void assureElementNormals() {
        super.assureElementNormals();
        if (this.m_elementNormalTrans == null || this.m_elementNormalTrans.length != this.m_numElements) {
            this.m_elementNormalTrans = PiVector.realloc(this.m_elementNormalTrans, this.m_numElements, this.m_dimTrans);
        }
    }

    public int[] removePolygon(int n) {
        if (n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return null;
        }
        this.m_polygon[n].setTag(2);
        return null;
    }

    public void setTagPolygon(int n, int n2) {
        this.m_polygon[n].setTag(n2);
        this.m_geometry.setTagPolygon(n, n2);
    }

    private int clipPolygon(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = 0;
        int n4 = 0;
        double d7 = 0.0;
        int n5 = 0;
        do {
            double d8;
            int n6 = this.m_polygon[n].m_data[n2 + n5];
            if ((double)this.m_vertexTrans[n6].m_data[2] < this.m_clipFar || (double)this.m_vertexTrans[n6].m_data[2] > this.m_clipNear) {
                this.m_elemIsClipped = true;
                d4 = this.m_vertexTrans[n6].m_data[0];
                d5 = this.m_vertexTrans[n6].m_data[1];
                d6 = this.m_vertexTrans[n6].m_data[2];
                if (n4 == 1) {
                    d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                    d8 = (1.0 - d7) * d3 + d7 * d6;
                    nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                    nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                    nArray3[n3] = -1;
                    ++n3;
                }
                n4 = -1;
                continue;
            }
            d = this.m_vertexTrans[n6].m_data[0];
            d2 = this.m_vertexTrans[n6].m_data[1];
            d3 = this.m_vertexTrans[n6].m_data[2];
            if (n4 == -1) {
                d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                d8 = (1.0 - d7) * d3 + d7 * d6;
                nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                nArray3[n3] = -1;
                ++n3;
            }
            nArray[n3] = this.m_vertexTrans[n6].m_data[0];
            nArray2[n3] = this.m_vertexTrans[n6].m_data[1];
            nArray3[n3] = n6;
            ++n3;
            n4 = 1;
        } while (++n5 < 2);
        return n3;
    }

    protected int addGeometryPolygon(PiVector piVector) {
        this.addPolygon(piVector);
        return this.m_geometry.addPolygon(piVector);
    }

    public PvGeometry(int n) {
        super(n);
        this.m_dim = n < 3 ? 3 : n;
        this.m_dimTrans = 3;
        this.m_dimOfColors = 3;
        this.m_bShowBackface = true;
        this.m_bShowDepthcue = true;
        this.m_bShowEdgeOnce = true;
        this.m_clipFar = Double.NEGATIVE_INFINITY;
        this.m_clipNear = Double.POSITIVE_INFINITY;
        this.m_vt = new PdVector(4);
        this.init();
    }

    public int[] removeElement(int n) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return null;
        }
        this.m_element[n].setTag(2);
        return null;
    }

    public boolean setVertexColor(int n, Color color) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureVertexColors();
        this.m_vertexColor[n] = color;
        return true;
    }

    public boolean setElementColor(int n, Color color) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureElementColors();
        this.m_elementColor[n] = color;
        return true;
    }

    public boolean setVertexTag(int n, int n2) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (n2 < 0 || n2 >= 32) {
            PsDebug.warning("tag=" + n2 + " out of range", this);
            return false;
        }
        this.m_vertex[n].setTag(n2);
        return true;
    }

    public boolean setElementTag(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (n2 < 0 || n2 >= 32) {
            PsDebug.warning("tag=" + n2 + " out of range", this);
            return false;
        }
        this.m_element[n].setTag(n2);
        return true;
    }

    public void setTransparency(double d) {
        if (Math.abs(1.0 - d) < 0.02) {
            this.m_alpha = 0;
            return;
        }
        if (Math.abs(d) < 0.02) {
            this.m_alpha = -16777216;
            return;
        }
        this.m_alpha = (255 - (int)(255.0 * d) & 0xFF) << 24;
    }

    public int setVectorField(Object object) {
        if (object == null) {
            this.m_vectorfield = null;
            this.m_vector = null;
            this.m_vectorIsElementBased = null;
            this.m_vectorTrans = null;
            this.m_currentVectorField = -1;
            this.m_numVectorFields = 0;
            return -1;
        }
        if (this.m_vectorfield == null) {
            this.m_vectorfield = new Vector();
            this.m_vector = new PdVector[1][];
            this.m_vectorIsElementBased = new boolean[1];
            this.m_vectorIsElementBased[0] = false;
            this.m_vectorTrans = new PiVector[1][];
        }
        this.m_currentVectorField = this.m_vectorfield.indexOf(object);
        if (this.m_currentVectorField == -1) {
            ++this.m_numVectorFields;
            this.m_vectorfield.addElement(object);
            this.m_currentVectorField = this.m_vectorfield.indexOf(object);
            int n = this.m_vector.length;
            int n2 = n + 1;
            PdVector[][] pdVectorArrayArray = new PdVector[n2][];
            int n3 = 0;
            while (n3 < n) {
                pdVectorArrayArray[n3] = this.m_vector[n3];
                ++n3;
            }
            pdVectorArrayArray[n] = null;
            this.m_vector = pdVectorArrayArray;
            this.m_vectorIsElementBased = PuData.realloc(this.m_vectorIsElementBased, n2);
            this.m_vectorIsElementBased[n] = false;
            PiVector[][] piVectorArrayArray = new PiVector[n2][];
            int n4 = 0;
            while (n4 < n) {
                piVectorArrayArray[n4] = this.m_vectorTrans[n4];
                ++n4;
            }
            piVectorArrayArray[n] = null;
            this.m_vectorTrans = piVectorArrayArray;
            this.m_globalVectorColor = PdColor.realloc(this.m_globalVectorColor, this.m_vectorfield.size());
            this.m_globalVectorLength = PuData.realloc(this.m_globalVectorLength, this.m_vectorfield.size());
            this.m_globalVectorSize = PuData.realloc(this.m_globalVectorSize, this.m_vectorfield.size());
        }
        return this.m_currentVectorField;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.m_geometry != null && this.m_geometry.isVisible() != bl) {
            this.m_geometry.setVisible(bl);
        }
    }

    public void clearTagVertex(int n, int n2) {
        this.m_vertex[n].clearTag(n2);
        this.m_geometry.clearTagVertex(n, n2);
    }

    public void setTagElement(int n, int n2) {
        this.m_element[n].setTag(n2);
        this.m_geometry.setTagElement(n, n2);
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalVertexNormalSize = d;
        if (this.m_globalVertexNormalSize > 1.0) {
            this.m_globalVertexNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize = d;
        if (this.m_globalEdgeSize > 1.0) {
            this.m_globalEdgeSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalElementNormalSize(double d) {
        this.m_globalElementNormalSize = d;
        if (this.m_globalElementNormalSize > 1.0) {
            this.m_globalElementNormalSize = 2.0 * d - 1.0;
        }
    }

    private void drawVertex(Graphics graphics, int n) {
        int n2;
        if (this.m_vertex[n].hasTag(2)) {
            return;
        }
        if (this.m_bEnableClip && ((double)this.m_vertexTrans[n].m_data[2] < this.m_clipFar || (double)this.m_vertexTrans[n].m_data[2] > this.m_clipNear)) {
            return;
        }
        if (this.m_bShowVertexNormals) {
            if (this.m_bShowDepthcue) {
                graphics.setColor(PdColor.getDimmedColor(this.m_globalVertexNormalColor, this.m_heightFac));
            } else {
                graphics.setColor(this.m_globalVertexNormalColor);
            }
            this.drawVector_(graphics, (int)this.m_globalVertexNormalSize, this.m_vertexTrans[n].m_data[0], this.m_vertexTrans[n].m_data[1], this.m_vertexNormalTrans[n].m_data[0], this.m_vertexNormalTrans[n].m_data[1], this.m_bShowVertexNormalArrow);
        }
        if (this.m_bShowVectors) {
            n2 = 0;
            while (n2 < this.m_numVectorFields) {
                if (!this.m_vectorIsElementBased[n2]) {
                    if (!this.m_bShowVectorColors) {
                        graphics.setColor(this.m_globalVectorColor[n2]);
                    }
                    this.drawVector_(graphics, (int)this.m_globalVectorSize[n2], this.m_vertexTrans[n].m_data[0], this.m_vertexTrans[n].m_data[1], this.m_vectorTrans[n2][n].m_data[0], this.m_vectorTrans[n2][n].m_data[1], this.m_bShowGlobalVectorArrow);
                }
                ++n2;
            }
        }
        n2 = (int)this.m_globalVertexSize;
        if (this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && (this.m_vertex[n].hasTag(1) || this.m_vertex[n].hasTag(1))) {
            n2 = (int)(2.0 * this.m_globalVertexSize);
            graphics.setColor(this.m_globalVertexTagColor);
        } else if (this.m_bShowVertices) {
            if (this.m_bShowDepthcue) {
                if (this.m_bShowVertexColors && this.m_vertexColor != null) {
                    graphics.setColor(PdColor.getDimmedColor(this.m_vertexColor[n], this.m_heightFac));
                } else {
                    graphics.setColor(PdColor.getDimmedColor(this.m_globalVertexColor, this.m_heightFac));
                }
            } else if (this.m_bShowVertexColors && this.m_vertexColor != null) {
                graphics.setColor(this.m_vertexColor[n]);
            } else {
                graphics.setColor(this.m_globalVertexColor);
            }
        } else {
            return;
        }
        int n3 = n2 * PS_ZOOM;
        graphics.fillOval(this.m_vertexTrans[n].m_data[0] - n3, this.m_vertexTrans[n].m_data[1] - n3, 2 * n3, 2 * n3);
        graphics.setColor(Color.black);
        graphics.drawOval(this.m_vertexTrans[n].m_data[0] - n3, this.m_vertexTrans[n].m_data[1] - n3, 2 * n3, 2 * n3);
        if (this.m_bShowIndices || this.m_bShowVertexLabels) {
            String string = this.m_vertex[n].getName();
            if (string == null && this.m_bDefaultLabelEnabled) {
                string = String.valueOf(n);
            }
            if (string != null) {
                int n4;
                int[] nArray = this.m_labelAttribute[0].m_data;
                if (graphics.getFont() != PsConfig.getFont(nArray[3])) {
                    graphics.setFont(PsConfig.getFont(nArray[3]));
                }
                if (nArray[2] == 1) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    n4 = fontMetrics.stringWidth(string) + n2;
                } else {
                    n4 = -n2;
                }
                graphics.drawString(string, this.m_vertexTrans[n].m_data[0] + (nArray[0] - n4) * PS_ZOOM, this.m_vertexTrans[n].m_data[1] + nArray[1] * PS_ZOOM);
            }
        }
    }

    private int clipElement(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, PdVector[] pdVectorArray, PdVector[] pdVectorArray2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        PdVector pdVector = null;
        PdVector pdVector2 = null;
        int n3 = 0;
        int n4 = 0;
        double d7 = 0.0;
        int n5 = 0;
        while (n5 <= n2) {
            double d8;
            int n6 = this.m_element[n].m_data[n5 % n2];
            if ((double)this.m_vertexTrans[n6].m_data[2] < this.m_clipFar || (double)this.m_vertexTrans[n6].m_data[2] > this.m_clipNear) {
                this.m_elemIsClipped = true;
                d4 = this.m_vertexTrans[n6].m_data[0];
                d5 = this.m_vertexTrans[n6].m_data[1];
                d6 = this.m_vertexTrans[n6].m_data[2];
                if (pdVectorArray2 != null) {
                    pdVector2 = pdVectorArray2[n5 % n2];
                }
                if (n4 == 1) {
                    d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                    d8 = (1.0 - d7) * d3 + d7 * d6;
                    nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                    nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                    if (pdVectorArray2 != null) {
                        pdVectorArray[n3].m_data[0] = (1.0 - d7) * pdVector.m_data[0] + d7 * pdVector2.m_data[0];
                        pdVectorArray[n3].m_data[1] = (1.0 - d7) * pdVector.m_data[1] + d7 * pdVector2.m_data[1];
                    }
                    nArray3[n3] = -1;
                    ++n3;
                }
                n4 = -1;
            } else if (n5 != n2 || n4 != 1) {
                d = this.m_vertexTrans[n6].m_data[0];
                d2 = this.m_vertexTrans[n6].m_data[1];
                d3 = this.m_vertexTrans[n6].m_data[2];
                if (pdVectorArray2 != null) {
                    pdVector = pdVectorArray2[n5 % n2];
                }
                if (n4 == -1) {
                    d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                    d8 = (1.0 - d7) * d3 + d7 * d6;
                    nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                    nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                    if (pdVectorArray2 != null) {
                        pdVectorArray[n3].m_data[0] = (1.0 - d7) * pdVector.m_data[0] + d7 * pdVector2.m_data[0];
                        pdVectorArray[n3].m_data[1] = (1.0 - d7) * pdVector.m_data[1] + d7 * pdVector2.m_data[1];
                    }
                    nArray3[n3] = -1;
                    ++n3;
                }
                if (n5 < n2) {
                    nArray[n3] = this.m_vertexTrans[n6].m_data[0];
                    nArray2[n3] = this.m_vertexTrans[n6].m_data[1];
                    if (pdVectorArray2 != null) {
                        pdVectorArray[n3] = pdVectorArray2[n5];
                    }
                    nArray3[n3] = n6;
                    ++n3;
                    n4 = 1;
                }
            }
            ++n5;
        }
        n2 = n3;
        return n2;
    }

    protected boolean removeGeometryVertex(int n) {
        this.removeVertex(n);
        this.m_geometry.removeVertex(n);
        return true;
    }

    protected int addGeometryElement(PiVector piVector) {
        this.addElement(piVector);
        return this.m_geometry.addElement(piVector);
    }

    public boolean setVertexNormal(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureVertexNormals();
        this.m_vertexNormal[n].copy(pdVector);
        return true;
    }

    public boolean setElementNormal(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureElementNormals();
        this.m_elementNormal[n].copy(pdVector);
        return true;
    }

    private void drawElementNormal(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2) {
        double[] dArray = new double[3];
        int n3 = 0;
        do {
            dArray[n3] = 0.0;
            int n4 = 0;
            while (n4 < this.m_element[n].m_data.length) {
                int n5 = n3;
                dArray[n5] = dArray[n5] + (double)this.m_vertexTrans[this.m_element[n].m_data[n4]].m_data[n3];
                ++n4;
            }
            int n6 = n3++;
            dArray[n6] = dArray[n6] / (double)this.m_element[n].m_data.length;
        } while (n3 < 3);
        if (this.m_bShowDepthcue) {
            graphics.setColor(PdColor.getDimmedColor(this.m_globalElementNormalColor, this.m_heightFac));
        } else {
            graphics.setColor(this.m_globalElementNormalColor);
        }
        this.drawVector_(graphics, (int)this.m_globalElementNormalSize, (int)dArray[0], (int)dArray[1], this.m_elementNormalTrans[n].m_data[0], this.m_elementNormalTrans[n].m_data[1], this.m_bShowElementNormalArrow);
    }

    public int[] removeVertex(int n) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return null;
        }
        this.m_vertex[n].setTag(2);
        return null;
    }

    public void setTagVertex(int n, int n2) {
        this.m_vertex[n].setTag(n2);
        this.m_geometry.setTagVertex(n, n2);
    }

    protected int addGeometryVertex(PdVector pdVector) {
        this.addVertex(pdVector);
        return this.m_geometry.addVertex(pdVector);
    }

    public void setPolygons(PiVector[] piVectorArray) {
        super.setPolygons(piVectorArray);
        this.computeNumPolygonEdges();
    }

    public void setGlobalPolygonNormalSize(double d) {
        this.m_globalPolygonNormalSize = d;
        if (this.m_globalPolygonNormalSize > 1.0) {
            this.m_globalPolygonNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize = (int)d;
        if (this.m_globalPolygonSize > 1.0) {
            this.m_globalPolygonSize = 2.0 * d - 1.0;
        }
    }

    private void drawScanLine(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5, int n6, double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        int n7;
        double d7 = 0.0;
        double d8 = 0.0;
        int n8 = n5 - n4;
        if (n8 >= 0) {
            n7 = n6 * n3 + n4;
            d6 = d;
            d5 = d2;
        } else {
            n7 = n6 * n3 + n5;
            d6 = d3;
            d5 = d4;
        }
        if (n8 != 0) {
            d7 = (d3 - d) / (double)n8;
            d8 = (d4 - d2) / (double)n8;
            n8 = Math.abs(n8);
        }
        while (n8 >= 0) {
            int n9 = nArray[(n2 - (int)d5 - 1) * n + (int)d6];
            if (this.m_bShowDepthcue && this.m_bShowTransparency) {
                n9 = this.m_alpha | (int)((double)((n9 & 0xFF0000) >> 16) * this.m_heightFac) << 16 | (int)((double)((n9 & 0xFF00) >> 8) * this.m_heightFac) << 8 | (int)((double)(n9 & 0xFF) * this.m_heightFac);
            } else if (this.m_bShowDepthcue && !this.m_bShowTransparency) {
                n9 = (int)((double)((n9 & 0xFF0000) >> 16) * this.m_heightFac) << 16 | (int)((double)((n9 & 0xFF00) >> 8) * this.m_heightFac) << 8 | (int)((double)(n9 & 0xFF) * this.m_heightFac);
            } else if (!this.m_bShowDepthcue && this.m_bShowTransparency) {
                n9 = this.m_alpha | n9 & 0xFFFFFF;
            }
            nArray2[n7++] = n9;
            d6 += d7;
            d5 += d8;
            --n8;
        }
    }
}

