/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuMath;
import jv.viewer.PvGeometry;

public final class PvScene
extends PsObject {
    protected int m_maxNumGeometries = 20;
    protected int m_numGeometries = 0;
    protected PvGeometry[] m_geometry;
    protected Vector m_special;
    protected PvGeometry m_currentGeom;
    protected int m_numItems;
    protected int[][] m_itemInd;
    protected double[] m_itemHeight;
    protected int[] m_itemSort;
    protected int m_dim;
    protected PdVector[] m_bndBox;
    protected PdVector m_center;
    protected int m_pickedVertex;
    protected int m_pickedGeometry;
    private int m_geomInd;
    private PiVector[] m_faceDestBnd;
    private PdMatrix transMatrix = new PdMatrix(4);
    private static /* synthetic */ Class class$jv$viewer$PvGeometry;

    public void setState(int n, boolean bl) {
        switch (n) {
            default: {
                PsDebug.warning("invalid key = " + n);
            }
            case 69: 
            case 70: 
        }
    }

    private int getGeometryIndOfItem(int n) {
        int n2 = 0;
        while (n2 < this.m_numGeometries) {
            if (this.m_itemInd[n2][0] <= n && n <= this.m_itemInd[n2][1]) {
                return n2;
            }
            ++n2;
        }
        PsDebug.warning("missing geometry of item = " + n);
        return -1;
    }

    public PvScene() {
        this.m_geometry = new PvGeometry[this.m_maxNumGeometries];
        this.m_itemInd = new int[this.m_maxNumGeometries][3];
        this.m_bndBox = new PdVector[2];
        this.m_special = new Vector();
        this.init();
    }

    public boolean containsGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return false;
        }
        return this.getGeometry(pgGeometryIf) != null;
    }

    public void paint(Graphics graphics, PvDisplayIf pvDisplayIf) {
        int n;
        int n2;
        Serializable serializable;
        int n3 = this.getNumAllGeometries();
        if (n3 == 0 || n3 == this.m_numGeometries && this.m_numItems == 0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = pvDisplayIf.isShowingDepthcue();
        PdMatrix pdMatrix = pvDisplayIf.getTransMatrix(4);
        PdMatrix pdMatrix2 = pvDisplayIf.getTransMatrix(2);
        PdMatrix pdMatrix3 = pvDisplayIf.getTransMatrix(1);
        PvGeometry[] pvGeometryArray = this.getGeometries();
        Dimension dimension = pvDisplayIf.getSize();
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < n3) {
            pvGeometryArray[n4].m_backColor = pvDisplayIf.getBackgroundColor();
            pvGeometryArray[n4].m_bShowEdgeAura = pvDisplayIf.isShowingEdgeAura();
            pvGeometryArray[n4].showBndBox(pvDisplayIf.isShowingBndBox());
            pvGeometryArray[n4].m_bShowEdgeOnce = pvDisplayIf.isShowingEdgesOnce();
            pvGeometryArray[n4].m_bShowDepthcue = pvDisplayIf.isShowingDepthcue();
            pvGeometryArray[n4].m_bEnableClip = pvDisplayIf.isClip();
            pvGeometryArray[n4].m_clipFar = 1000.0 * pvDisplayIf.getFarClip();
            pvGeometryArray[n4].m_clipNear = 1000.0 * pvDisplayIf.getNearClip();
            pvGeometryArray[n4].m_scene = this;
            pvGeometryArray[n4].m_dispSize = dimension;
            if (pvGeometryArray[n4].isShowingVertexTexture() || pvGeometryArray[n4].isShowingElementTexture()) {
                bl2 = true;
            }
            if (pvGeometryArray[n4].hasModelMatrix()) {
                serializable = pvGeometryArray[n4].getModelMatrix();
                pvGeometryArray[n4].projectItems(graphics, pdMatrix3, pdMatrix2, pdMatrix, (PdMatrix)serializable);
            } else {
                pvGeometryArray[n4].projectItems(graphics, pdMatrix3, pdMatrix2, pdMatrix, null);
            }
            ++n4;
        }
        if (bl2) {
            this.m_faceDestBnd = PiVector.realloc(this.m_faceDestBnd, (dimension.height + dimension.width) * 2, 2);
            n4 = 0;
            while (n4 < n3) {
                pvGeometryArray[n4].m_dispSize = dimension;
                if (pvGeometryArray[n4].isShowingVertexTexture() || pvGeometryArray[n4].isShowingElementTexture()) {
                    pvGeometryArray[n4].m_faceDestBnd = this.m_faceDestBnd;
                    pvGeometryArray[n4].m_faceTextureBnd = PdVector.realloc(pvGeometryArray[n4].m_faceTextureBnd, (dimension.height + dimension.width) * 2, 2);
                }
                ++n4;
            }
        } else {
            this.m_faceDestBnd = null;
        }
        this.copyItemHeight();
        if (pvDisplayIf.isEnabledPainters() && this.m_numItems > 0) {
            PuMath.heapsort(this.m_numItems, this.m_itemHeight, this.m_itemSort);
            d = this.m_itemHeight[this.m_itemSort[0]];
            d2 = this.m_itemHeight[this.m_itemSort[this.m_numItems - 1]];
        } else {
            d2 = -1.7976931348623157E308;
            d = Double.MAX_VALUE;
            n4 = 0;
            while (n4 < this.m_numItems) {
                if (this.m_itemHeight[n4] > d2) {
                    d2 = this.m_itemHeight[n4];
                } else if (this.m_itemHeight[n4] < d) {
                    d = this.m_itemHeight[n4];
                }
                this.m_itemSort[n4] = n4;
                ++n4;
            }
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (PvGeometry)enumeration.nextElement();
            if (serializable.getDrawingOrder() != -1 || !serializable.isVisible()) continue;
            serializable.m_bShowEdgeOnce = false;
            serializable.m_bShowDepthcue = false;
            n2 = serializable.getNumItems();
            n = 0;
            while (n < n2) {
                serializable.drawItem(graphics, n, d3, 0.0);
                ++n;
            }
        }
        int n5 = 0;
        while (n5 < this.m_numItems) {
            int n6 = this.m_itemSort[n5];
            this.m_geomInd = this.getGeometryIndOfItem(n6);
            if (this.m_geometry[this.m_geomInd].isVisible()) {
                if (bl) {
                    d3 = d2 - d < 1.0E-10 ? 1.0 : (this.m_itemHeight[n6] - d) / (d2 - d);
                }
                this.m_geometry[this.m_geomInd].drawItem(graphics, n6 - this.m_itemInd[this.m_geomInd][0], d3, this.m_itemHeight[n6]);
            }
            ++n5;
        }
        Enumeration enumeration2 = this.m_special.elements();
        while (enumeration2.hasMoreElements()) {
            serializable = (PvGeometry)enumeration2.nextElement();
            if (serializable.getDrawingOrder() != 1 || !serializable.isVisible()) continue;
            serializable.m_bShowEdgeOnce = false;
            serializable.m_bShowDepthcue = false;
            n2 = serializable.getNumItems();
            n = 0;
            while (n < n2) {
                serializable.drawItem(graphics, n, d3, 0.0);
                ++n;
            }
        }
    }

    protected PvGeometry[] getGeometries() {
        int n = this.getNumAllGeometries();
        PvGeometry[] pvGeometryArray = new PvGeometry[n];
        if (n == 0) {
            return pvGeometryArray;
        }
        int n2 = 0;
        while (n2 < this.m_numGeometries) {
            pvGeometryArray[n2] = this.m_geometry[n2];
            ++n2;
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            pvGeometryArray[n2++] = (PvGeometry)enumeration.nextElement();
        }
        return pvGeometryArray;
    }

    private void assureIndexList() {
        if (this.m_numGeometries == 0) {
            return;
        }
        this.m_itemInd[0][0] = 0;
        int n = 0;
        while (n < this.m_numGeometries) {
            this.m_itemInd[n][1] = this.m_itemInd[n][0] + this.m_itemInd[n][2] - 1;
            if (n + 1 < this.m_numGeometries) {
                this.m_itemInd[n + 1][0] = this.m_itemInd[n][1] + 1;
            }
            ++n;
        }
        this.m_numItems = this.m_itemInd[this.m_numGeometries - 1][1] + 1;
        if (this.m_itemHeight == null || this.m_itemHeight.length != this.m_numItems) {
            this.m_itemHeight = new double[this.m_numItems];
            this.m_itemSort = new int[this.m_numItems];
        }
    }

    public boolean update(Object object) {
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            if (object != enumeration.nextElement()) continue;
            return true;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n] == object) {
                this.m_itemInd[n][2] = this.m_geometry[n].getNumItems();
                this.assureIndexList();
                return super.update(null);
            }
            ++n;
        }
        PsDebug.warning("missing geometry");
        return super.update(object);
    }

    public void selectGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return;
        }
        if (this.m_special.contains(pvGeometry)) {
            this.m_currentGeom = pvGeometry;
            return;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n] == pvGeometry) {
                this.m_currentGeom = this.m_geometry[n];
                return;
            }
            ++n;
        }
        PsDebug.warning("geometry not found, name = " + pvGeometry.getGeometry().getName());
    }

    protected PvGeometry getGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return null;
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            PvGeometry pvGeometry = (PvGeometry)enumeration.nextElement();
            if (pvGeometry.getGeometry() != pgGeometryIf) continue;
            return pvGeometry;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n].getGeometry() == pgGeometryIf) {
                return this.m_geometry[n];
            }
            ++n;
        }
        return null;
    }

    public double getDiameter() {
        if (this.m_numItems == 0) {
            return 0.0;
        }
        PdVector[] pdVectorArray = this.getBounds();
        double d = PdVector.dist(pdVectorArray[0], pdVectorArray[1]);
        return d;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void copyItemHeight() {
        int n = 0;
        while (n < this.m_numGeometries) {
            int n2;
            double d;
            int[] nArray;
            PiVector[] piVectorArray;
            int n3;
            int n4;
            int n5 = 0;
            if (this.m_geometry[n].m_useVertices) {
                n4 = this.m_geometry[n].getNumVertices();
                n3 = 0;
                while (n3 < n4) {
                    this.m_itemHeight[this.m_itemInd[n][0] + n3] = this.m_geometry[n].m_vertexTrans[n3].m_data[2];
                    ++n3;
                }
                n5 = n4;
            }
            if (this.m_geometry[n].m_useElements) {
                n4 = this.m_geometry[n].getNumElements();
                piVectorArray = this.m_geometry[n].getElements();
                n3 = 0;
                while (n3 < n4) {
                    nArray = piVectorArray[n3].m_data;
                    d = 0.0;
                    n2 = 0;
                    while (n2 < nArray.length) {
                        d += (double)this.m_geometry[n].m_vertexTrans[nArray[n2]].m_data[2];
                        ++n2;
                    }
                    this.m_itemHeight[this.m_itemInd[n][0] + n5 + n3] = d /= (double)nArray.length;
                    ++n3;
                }
                n5 += n4;
            }
            if (this.m_geometry[n].m_usePolygons) {
                n4 = this.m_geometry[n].getNumPolygons();
                piVectorArray = this.m_geometry[n].getPolygons();
                n3 = 0;
                while (n3 < n4) {
                    nArray = piVectorArray[n3].m_data;
                    if (nArray != null) {
                        n2 = 0;
                        while (n2 < nArray.length - 1) {
                            d = (double)(this.m_geometry[n].m_vertexTrans[nArray[n2]].m_data[2] + this.m_geometry[n].m_vertexTrans[nArray[n2 + 1]].m_data[2]) / 2.0;
                            this.m_itemHeight[this.m_itemInd[n][0] + n5++] = d;
                            ++n2;
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    private int getNumAllGeometries() {
        return this.m_numGeometries + this.m_special.size();
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = new PdVector[this.m_maxNumGeometries];
        PdVector[] pdVectorArray2 = new PdVector[this.m_maxNumGeometries];
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numGeometries) {
            PdVector[] pdVectorArray3;
            if (this.m_geometry[n2].isVisible() && (pdVectorArray3 = this.m_geometry[n2].getBounds()) != null) {
                pdVectorArray[n] = pdVectorArray3[0];
                pdVectorArray2[n] = pdVectorArray3[1];
                ++n;
            }
            ++n2;
        }
        if (n != 0) {
            PdVector.min(this.m_bndBox[0], pdVectorArray, n);
            PdVector.max(this.m_bndBox[1], pdVectorArray2, n);
        }
        if (n == 0 || PdVector.dist(this.m_bndBox[0], this.m_bndBox[1]) < 1.0E-10) {
            this.m_bndBox[0].setConstant(-10.0);
            this.m_bndBox[1].setConstant(10.0);
        }
        return this.m_bndBox;
    }

    public void init() {
        super.init();
        this.m_dim = 3;
        this.m_numItems = 0;
        this.m_itemHeight = null;
        this.m_itemSort = null;
        this.m_bndBox[0] = new PdVector(this.m_dim);
        this.m_bndBox[1] = new PdVector(this.m_dim);
        this.m_center = new PdVector(this.m_dim);
        this.m_bndBox[0].setConstant(-10.0);
        this.m_bndBox[1].setConstant(10.0);
        this.m_center.setConstant(0.0);
    }

    public PvGeometry removeGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return null;
        }
        if (this.m_special.contains(pvGeometry)) {
            this.m_special.removeElement(pvGeometry);
            if (pvGeometry == this.m_currentGeom) {
                if (this.m_numGeometries > 0) {
                    this.selectGeometry(this.m_geometry[0]);
                } else {
                    this.m_numItems = 0;
                    this.m_currentGeom = null;
                }
            }
            return this.m_currentGeom;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n] == pvGeometry) {
                this.m_numGeometries += -1;
                if (n < this.m_numGeometries) {
                    this.m_geometry[n] = this.m_geometry[this.m_numGeometries];
                    this.m_itemInd[n][2] = this.m_itemInd[this.m_numGeometries][2];
                    if (this.m_geometry[this.m_numGeometries] == this.m_currentGeom) {
                        this.selectGeometry(this.m_geometry[n]);
                    }
                }
                this.m_geometry[this.m_numGeometries] = null;
                if (this.m_numGeometries > 0) {
                    this.assureIndexList();
                    if (pvGeometry == this.m_currentGeom) {
                        this.selectGeometry(this.m_geometry[0]);
                    }
                } else {
                    this.m_numItems = 0;
                    this.m_currentGeom = null;
                }
                return this.m_currentGeom;
            }
            ++n;
        }
        return this.m_currentGeom;
    }

    protected double getHeightOfItemInCurrentGeometry(int n) {
        if (n > this.m_itemInd[this.m_geomInd][2]) {
            return Double.NEGATIVE_INFINITY;
        }
        int n2 = n + this.m_itemInd[this.m_geomInd][0];
        return this.m_itemHeight[n2];
    }

    public void addGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return;
        }
        if (pvGeometry.getDrawingOrder() == -1 || pvGeometry.getDrawingOrder() == 1) {
            this.m_special.addElement(pvGeometry);
        } else {
            int n = 0;
            while (n < this.m_numGeometries) {
                if (this.m_geometry[n] == pvGeometry) {
                    this.update(pvGeometry);
                    return;
                }
                ++n;
            }
            if (this.m_numGeometries == this.m_maxNumGeometries) {
                int[][] nArray = this.m_itemInd;
                this.m_geometry = (PvGeometry[])PuData.realloc(class$jv$viewer$PvGeometry != null ? class$jv$viewer$PvGeometry : (class$jv$viewer$PvGeometry = PvScene.class$("jv.viewer.PvGeometry")), this.m_geometry, 2 * this.m_maxNumGeometries);
                this.m_itemInd = new int[2 * this.m_maxNumGeometries][3];
                int n2 = 0;
                while (n2 < this.m_maxNumGeometries) {
                    int n3 = 0;
                    do {
                        this.m_itemInd[n2][n3] = nArray[n2][n3];
                    } while (++n3 < 3);
                    ++n2;
                }
                this.m_maxNumGeometries = 2 * this.m_maxNumGeometries;
            }
            this.m_geometry[this.m_numGeometries++] = pvGeometry;
            if (this.m_numGeometries == 1) {
                this.selectGeometry(pvGeometry);
            }
        }
        this.update(pvGeometry);
    }
}

