/*
 * Decompiled with CFR 0.152.
 */
package third.bee;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.loader.PgExport_Dialog;
import jv.number.PdVector_IP;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import third.bee.PgBeeLoader;

public class PjBee
extends PjProject
implements ActionListener {
    protected String DEFAULT_DATAFILE = PsConfig.getCodeBase() + "third/bee/beedata.bee";
    protected String m_filename;
    protected PgElementSet m_geom = new PgElementSet(3);
    protected PgPointSet m_positions;
    protected PgPolygon m_straightest;
    protected PgPolygonSet m_coords;
    protected PgPolygonOnElementSet m_poly;
    protected PdVector m_queen;
    protected PdVector m_otherbee;
    protected PdVector_IP m_pQueen;
    protected PdVector_IP m_pOtherbee;
    protected double[] MAX;
    protected PdVector m_dir;
    protected double m_dist;
    protected int m_numData = 0;
    protected PdVector[] m_queendata;
    protected PdVector[] m_beedata;
    protected PiVector m_iddata;
    protected char[] m_colordata;
    protected PuInteger m_actData;
    private static /* synthetic */ Class class$third$bee$PjBee;

    public void updatePositions() {
        this.m_positions.setVertex(0, this.m_queen);
        this.m_positions.setVertex(1, this.m_otherbee);
        this.m_positions.update(null);
    }

    public void showDistance() {
        this.m_dist = this.calculateDistance(this.m_queen, this.m_otherbee, this.m_dir);
    }

    public PjBee() {
        super("PjBee");
        this.m_geom.setName("Honeycomb");
        this.m_geom.setGlobalEdgeColor(new Color(180, 115, 0));
        this.m_poly = new PgPolygonOnElementSet(this.m_geom);
        this.m_straightest = new PgPolygon(3);
        this.m_straightest.setName("Shortest Path");
        this.m_coords = new PgPolygonSet(3);
        this.m_coords.setName("Coordinate Frame");
        this.m_positions = new PgPointSet(3);
        this.m_positions.setName("Positions of Bees");
        this.MAX = new double[3];
        this.MAX[0] = 50.0;
        this.MAX[1] = 80.0;
        this.MAX[2] = 5.0;
        this.m_queen = new PdVector(3);
        this.m_otherbee = new PdVector(3);
        this.m_pQueen = new PdVector_IP();
        this.m_pQueen.setTitle("Queen (red)");
        this.m_pQueen.setParent((PsUpdateIf)this);
        this.m_pQueen.setVector(this.m_queen);
        this.m_pOtherbee = new PdVector_IP();
        this.m_pOtherbee.setTitle("Other Bee (blue)");
        this.m_pOtherbee.setParent((PsUpdateIf)this);
        this.m_pOtherbee.setVector(this.m_otherbee);
        this.m_actData = new PuInteger("Data Pair Num.", (PsUpdateIf)this);
        this.m_dir = new PdVector(3);
        if (this.getClass() == (class$third$bee$PjBee != null ? class$third$bee$PjBee : (class$third$bee$PjBee = PjBee.class$("third.bee.PjBee")))) {
            this.init();
        }
    }

    public void selectActData() {
        int n = this.m_actData.getValue();
        this.m_queen.copy(this.m_queendata[n - 1]);
        this.m_otherbee.copy(this.m_beedata[n - 1]);
        this.projectPosition(this.m_otherbee);
        this.projectPosition(this.m_queen);
        this.m_pOtherbee.update((Object)this.m_otherbee);
        this.m_pQueen.update((Object)this.m_queen);
        this.updatePositions();
        this.showDistance();
        this.showStraightest();
    }

    public double calculateDistance(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d = 1.0E-10;
        int n = 0;
        do {
            if (!(Math.abs(pdVector.getEntry(n)) < d && Math.abs(pdVector2.getEntry(n)) < d) && (!(Math.abs(this.MAX[n] - pdVector.getEntry(n)) < d) || !(Math.abs(this.MAX[n] - pdVector2.getEntry(n)) < d))) continue;
            double d2 = PdVector.dist((PdVector)pdVector, (PdVector)pdVector2);
            if (pdVector3 != null) {
                pdVector3.copy(pdVector2);
                pdVector3.sub(pdVector);
            }
            return d2;
        } while (++n < 3);
        n = 0;
        int n2 = 1;
        int n3 = 2;
        double d3 = pdVector.getEntry(n);
        double d4 = pdVector2.getEntry(n);
        double d5 = pdVector.getEntry(n2);
        double d6 = pdVector2.getEntry(n2);
        PdVector[] pdVectorArray = new PdVector[]{new PdVector(d4 - d3, -(d5 + this.MAX[n3] + d6)), new PdVector(2.0 * this.MAX[n] - d3 - d4 + this.MAX[n3], d6 - d5), new PdVector(d4 - d3, 2.0 * this.MAX[n2] - d5 - d6 + this.MAX[n3]), new PdVector(-(d3 + d4 + this.MAX[n3]), d6 - d5)};
        double d7 = 0.0;
        int n4 = -1;
        int n5 = 0;
        do {
            double d8 = pdVectorArray[n5].length();
            if (n4 != -1 && !(d7 > d8)) continue;
            n4 = n5;
            d7 = d8;
        } while (++n5 < 4);
        double d9 = d7;
        if (pdVector3 != null) {
            pdVector3.setEntry(n, pdVectorArray[n4].getEntry(0));
            pdVector3.setEntry(n2, pdVectorArray[n4].getEntry(1));
            pdVector3.setEntry(n3, 0.0);
        }
        return d9;
    }

    public void showStraightest() {
        PvPickEvent pvPickEvent = this.m_geom.intersectionWithLine(this.m_queen, new PdVector(0.0, 0.0, 1.0));
        PdBary pdBary = pvPickEvent.getBary();
        int n = pvPickEvent.getElementInd();
        pvPickEvent = this.m_geom.intersectionWithLine(this.m_queen, new PdVector(0.0, 0.0, -1.0));
        PdBary pdBary2 = pvPickEvent.getBary();
        int n2 = pvPickEvent.getElementInd();
        PiVector piVector = this.m_geom.getElement(n);
        PdVector pdVector = new PdVector(3);
        PdBary.getVertex((PdVector)pdVector, (PdBary)pdBary, (PdVector)this.m_geom.getVertex(piVector.getEntry(0)), (PdVector)this.m_geom.getVertex(piVector.getEntry(1)), (PdVector)this.m_geom.getVertex(piVector.getEntry(2)));
        pdVector.sub(this.m_queen);
        double d = pdVector.length();
        piVector = this.m_geom.getElement(n2);
        PdBary.getVertex((PdVector)pdVector, (PdBary)pdBary2, (PdVector)this.m_geom.getVertex(piVector.getEntry(0)), (PdVector)this.m_geom.getVertex(piVector.getEntry(1)), (PdVector)this.m_geom.getVertex(piVector.getEntry(2)));
        pdVector.sub(this.m_queen);
        double d2 = pdVector.length();
        if (d2 < d) {
            n = n2;
            pdBary.copy(pdBary2);
        }
        PdBaryDir pdBaryDir = new PdBaryDir();
        PwBary.projectOntoElement((PgElementSet)this.m_geom, (int)n, (PdVector)this.m_dir, (PdBaryDir)pdBaryDir);
        double d3 = PwBary.norm((PgElementSet)this.m_geom, (int)n, (PdBaryDir)pdBaryDir, (boolean)false);
        if (d3 < 1.0E-10) {
            return;
        }
        pdBaryDir.multScalar(1.0 / d3);
        this.m_poly.exp(n, pdBary, pdBaryDir, this.m_dist);
        this.m_poly.getPolygon(this.m_straightest);
        this.m_straightest.update(null);
    }

    public boolean update(Object object) {
        if (object == ((PsObject)this).m_infoPanel) {
            return true;
        }
        if (object == this.m_pQueen) {
            if (this.projectPosition(this.m_queen)) {
                this.m_pQueen.update((Object)this.m_queen);
            }
            this.updatePositions();
            this.showDistance();
            this.showStraightest();
            return super.update((Object)this);
        }
        if (object == this.m_pOtherbee) {
            if (this.projectPosition(this.m_otherbee)) {
                this.m_pOtherbee.update((Object)this.m_otherbee);
            }
            this.updatePositions();
            this.showDistance();
            this.showStraightest();
            return super.update((Object)this);
        }
        if (object == this.m_actData) {
            this.selectActData();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        if (actionEvent.getSource() == null) {
            return;
        }
        PgExport_Dialog pgExport_Dialog = new PgExport_Dialog(PsConfig.getFrame(), "Save data ...", true);
        StringBuffer stringBuffer = new StringBuffer();
        PdVector pdVector = new PdVector(3);
        int n = 0;
        while (n < this.m_numData) {
            stringBuffer.append(this.m_colordata[n]);
            stringBuffer.append("\t");
            stringBuffer.append(this.m_iddata.getEntry(n));
            stringBuffer.append("\t");
            stringBuffer.append(this.calculateDistance(this.m_queendata[n], this.m_beedata[n], pdVector));
            stringBuffer.append("\n");
            ++n;
        }
        pgExport_Dialog.setText(stringBuffer.toString().trim());
        String string = new String("beedata");
        pgExport_Dialog.setFilename(string);
        pgExport_Dialog.setSize(400, 500);
        pgExport_Dialog.setFilenameExtension("dist");
        pgExport_Dialog.setVisible(true);
    }

    public void load(String string) {
        PgBeeLoader pgBeeLoader = new PgBeeLoader();
        PgPointSet pgPointSet = new PgPointSet(3);
        if ((pgPointSet = pgBeeLoader.read(pgPointSet, string)) == null) {
            PsDebug.warning((String)("PjBee.load(): failed to read bee data from file = " + string));
            return;
        }
        this.m_numData = pgPointSet.getNumVertices() / 3;
        this.m_queendata = new PdVector[this.m_numData];
        this.m_beedata = new PdVector[this.m_numData];
        this.m_iddata = new PiVector(this.m_numData);
        this.m_colordata = new char[this.m_numData];
        int n = 0;
        while (n < this.m_numData) {
            this.m_colordata[n] = (char)pgPointSet.getVertex(3 * n).getEntry(0);
            this.m_iddata.setEntry(n, (int)pgPointSet.getVertex(3 * n).getEntry(1));
            this.m_queendata[n] = pgPointSet.getVertex(3 * n + 1);
            this.m_beedata[n] = pgPointSet.getVertex(3 * n + 2);
            ++n;
        }
        this.m_actData.setDefBounds(1, this.m_numData, 1, 5);
        this.m_actData.setDefValue(1);
        this.m_actData.init();
        this.selectActData();
        this.m_filename = new String(string);
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_positions);
        this.addGeometry((PgGeometryIf)this.m_coords);
        this.addGeometry((PgGeometryIf)this.m_straightest);
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean projectPosition(PdVector pdVector) {
        boolean bl = false;
        int n = 0;
        do {
            if (pdVector.getEntry(n) > this.MAX[n]) {
                pdVector.setEntry(n, this.MAX[n]);
                bl = true;
                continue;
            }
            if (!(pdVector.getEntry(n) < 0.0)) continue;
            pdVector.setEntry(n, 0.0);
            bl = true;
        } while (++n < 3);
        if (pdVector.getEntry(2) < this.MAX[2] / 2.0) {
            pdVector.setEntry(2, 0.0);
        } else {
            pdVector.setEntry(2, this.MAX[2]);
        }
        n = -1;
        double d = 0.0;
        int n2 = 0;
        do {
            if (n != -1 && !(d > Math.abs(pdVector.getEntry(n2)))) continue;
            n = n2;
            d = Math.abs(pdVector.getEntry(n2));
        } while (++n2 < 3);
        n2 = 3;
        do {
            if (n != -1 && !(d > Math.abs(this.MAX[n2 - 3] - pdVector.getEntry(n2 - 3)))) continue;
            n = n2;
            d = Math.abs(this.MAX[n2 - 3] - pdVector.getEntry(n2 - 3));
        } while (++n2 < 6);
        if (d > 0.0) {
            bl = true;
            if (n > 2) {
                pdVector.setEntry(n - 3, this.MAX[n - 3]);
            } else {
                pdVector.setEntry(n, 0);
            }
        }
        return bl;
    }

    public void init() {
        super.init();
        this.m_geom.setNumVertices(8);
        this.m_geom.setVertex(0, new PdVector(0.0, 0.0, 0.0));
        this.m_geom.setVertex(1, new PdVector(this.MAX[0], 0.0, 0.0));
        this.m_geom.setVertex(2, new PdVector(this.MAX[0], 0.0, this.MAX[2]));
        this.m_geom.setVertex(3, new PdVector(0.0, 0.0, this.MAX[2]));
        this.m_geom.setVertex(4, new PdVector(0.0, this.MAX[1], 0.0));
        this.m_geom.setVertex(5, new PdVector(this.MAX[0], this.MAX[1], 0.0));
        this.m_geom.setVertex(6, new PdVector(this.MAX[0], this.MAX[1], this.MAX[2]));
        this.m_geom.setVertex(7, new PdVector(0.0, this.MAX[1], this.MAX[2]));
        this.m_geom.setNumElements(12);
        this.m_geom.setElement(0, new PiVector(0, 1, 2));
        this.m_geom.setElement(1, new PiVector(0, 2, 3));
        this.m_geom.setElement(2, new PiVector(3, 2, 6));
        this.m_geom.setElement(3, new PiVector(3, 6, 7));
        this.m_geom.setElement(4, new PiVector(7, 6, 5));
        this.m_geom.setElement(5, new PiVector(7, 5, 4));
        this.m_geom.setElement(6, new PiVector(4, 5, 1));
        this.m_geom.setElement(7, new PiVector(4, 1, 0));
        this.m_geom.setElement(8, new PiVector(1, 5, 6));
        this.m_geom.setElement(9, new PiVector(1, 6, 2));
        this.m_geom.setElement(10, new PiVector(4, 0, 3));
        this.m_geom.setElement(11, new PiVector(4, 3, 7));
        this.m_geom.makeNeighbour();
        this.m_geom.makeElementNormals();
        this.m_geom.showElements(false);
        this.m_coords.setNumVertices(4);
        double d = (this.MAX[0] + this.MAX[1] + this.MAX[2]) / 6.0;
        this.m_coords.setVertex(0, new PdVector(0.0, 0.0, 0.0));
        this.m_coords.setVertex(1, new PdVector(d, 0.0, 0.0));
        this.m_coords.setVertex(2, new PdVector(0.0, d, 0.0));
        this.m_coords.setVertex(3, new PdVector(0.0, 0.0, d));
        this.m_coords.setNumPolygons(3);
        this.m_coords.setDimOfPolygons(2);
        this.m_coords.setPolygon(0, new PiVector(0, 1));
        this.m_coords.setPolygon(1, new PiVector(0, 2));
        this.m_coords.setPolygon(2, new PiVector(0, 3));
        this.m_coords.setGlobalPolygonSize(4.0);
        this.m_coords.showIndices(true);
        this.m_coords.showVectorArrow(true);
        this.m_straightest.showVertices(false);
        this.m_straightest.setGlobalPolygonColor(Color.red);
        this.m_straightest.setGlobalPolygonSize(2.0);
        this.m_positions.setNumVertices(2);
        this.m_positions.setGlobalVertexSize(5);
        Color[] colorArray = new Color[]{Color.red, Color.blue};
        this.m_positions.setVertexColors(colorArray);
        this.m_positions.showVertexColors(true);
        this.m_queen.set(this.MAX[0] / 2.0, this.MAX[1] / 2.0, this.MAX[2]);
        this.m_otherbee.set(this.MAX[0] / 2.0, this.MAX[1] / 2.0, 0.0);
        this.m_pQueen.update((Object)this.m_queen);
        this.m_pOtherbee.update((Object)this.m_otherbee);
        this.m_actData.setDefValue(0);
        this.m_actData.setDefBounds(0, 0, 0, 0);
        this.m_actData.init();
        this.updatePositions();
        this.showDistance();
        this.showStraightest();
        this.load(this.DEFAULT_DATAFILE);
    }
}

