/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Component;
import java.awt.Image;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.objectGui.PsImage;

public class PgTexture
extends PsObject {
    protected String m_imageName = null;
    protected Image m_image = null;
    protected PuInteger m_uMin = new PuInteger(PsConfig.getMessage("textureUMin"), this);
    protected PuInteger m_vMin = new PuInteger(PsConfig.getMessage("textureVMin"), this);
    protected PuInteger m_uMax = new PuInteger(PsConfig.getMessage("textureUMax"), this);
    protected PuInteger m_vMax = new PuInteger(PsConfig.getMessage("textureVMax"), this);
    private static /* synthetic */ Class class$jv$geom$PgTexture;

    public PgTexture() {
        if (this.getClass() == (class$jv$geom$PgTexture != null ? class$jv$geom$PgTexture : (class$jv$geom$PgTexture = PgTexture.class$("jv.geom.PgTexture")))) {
            this.init();
        }
    }

    public String getImageName() {
        return this.m_imageName;
    }

    public void setImageName(String string) {
        this.m_imageName = string;
    }

    protected Image loadImage(Component component) {
        Image image = PsImage.getImage(this.m_imageName);
        if (component == null) {
            component = PsConfig.getFrame();
        }
        if (!PsImage.loadImage(component, image)) {
            PsDebug.warning("failed loading image = " + this.m_imageName);
            return null;
        }
        this.setImage(image);
        return image;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(object);
        }
        if (object == this.m_uMin) {
            return super.update(this);
        }
        if (object == this.m_vMin) {
            return super.update(this);
        }
        if (object == this.m_uMax) {
            return super.update(this);
        }
        if (object == this.m_vMax) {
            return super.update(this);
        }
        return super.update(object);
    }

    public int getUMin() {
        return this.m_uMin.getValue();
    }

    public void setUMin(int n) {
        this.m_uMin.setValue(n);
    }

    public int getVMin() {
        return this.m_vMin.getValue();
    }

    public void setVMin(int n) {
        this.m_vMin.setValue(n);
    }

    public void copy(PgTexture pgTexture) {
        super.copy(pgTexture);
        this.m_imageName = pgTexture.m_imageName;
        this.m_image = pgTexture.m_image;
        this.m_uMin.copy(pgTexture.m_uMin);
        this.m_vMin.copy(pgTexture.m_vMin);
        this.m_uMax.copy(pgTexture.m_uMax);
        this.m_vMax.copy(pgTexture.m_vMax);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setImage(String string) {
        this.m_imageName = string;
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setImage(Image image) {
        this.m_image = image;
        this.init();
    }

    public int getHeight() {
        return this.m_vMax.getValue() - this.m_vMin.getValue();
    }

    public void init() {
        super.init();
        int n = 1280;
        int n2 = 1024;
        if (this.m_image != null) {
            n = this.m_image.getWidth(null);
            n2 = this.m_image.getHeight(null);
        }
        this.m_uMin.setDefBounds(0, n, 5, 10);
        this.m_uMin.setDefValue(0);
        this.m_uMin.init();
        this.m_vMin.setDefBounds(0, n2, 5, 10);
        this.m_vMin.setDefValue(0);
        this.m_vMin.init();
        this.m_uMax.setDefBounds(0, n, 5, 10);
        this.m_uMax.setDefValue(n);
        this.m_uMax.init();
        this.m_vMax.setDefBounds(0, n2, 5, 10);
        this.m_vMax.setDefValue(n2);
        this.m_vMax.init();
    }

    public Object clone() {
        PgTexture pgTexture = (PgTexture)super.clone();
        if (pgTexture == null) {
            return null;
        }
        pgTexture.m_uMin = (PuInteger)this.m_uMin.clone();
        pgTexture.m_vMin = (PuInteger)this.m_vMin.clone();
        pgTexture.m_uMax = (PuInteger)this.m_uMax.clone();
        pgTexture.m_vMax = (PuInteger)this.m_vMax.clone();
        return pgTexture;
    }

    public int getWidth() {
        return this.m_uMax.getValue() - this.m_uMin.getValue();
    }

    public int getUMax() {
        return this.m_uMax.getValue();
    }

    public void setUMax(int n) {
        this.m_uMax.setValue(n);
    }

    public int getVMax() {
        return this.m_vMax.getValue();
    }

    public void setVMax(int n) {
        this.m_vMax.setValue(n);
    }
}

