/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.number.PdColor;
import jv.number.PdColor_Dialog;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;

public class PdColor_IP
extends PsPanel
implements TextListener {
    protected PdColor m_color;
    protected int[] m_rgbOld = new int[3];
    protected int[] m_rgbNew = new int[3];
    protected int m_length = 3;
    protected int m_min = 0;
    protected int m_max = 255;
    protected PsPanel m_pColor;
    protected TextField[] m_text;
    private boolean m_bInteractive = true;

    public PdColor_IP() {
        this.setLayout(new GridLayout(1, 2));
        Panel panel = new Panel();
        panel.setLayout(new GuiStackLayout(0, 0));
        this.add(panel);
        this.m_lTitle = new Label();
        panel.add("WIDE*2", this.m_lTitle);
        this.m_pColor = new PsPanel();
        this.m_pColor.setInsetSize(1);
        this.m_pColor.setLayout(new BorderLayout());
        this.m_pColor.setBorderType(2);
        this.m_pColor.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PdColor_Dialog pdColor_Dialog = new PdColor_Dialog(PdColor_IP.this.m_color);
                pdColor_Dialog.setParent(PdColor_IP.this.m_color);
                ((Component)pdColor_Dialog).setVisible(true);
            }
            {
                PdColor_IP.this.getClass();
            }
        });
        this.m_pColor.setBackground(Color.red);
        panel.add("FILL*1", this.m_pColor);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, this.m_length));
        this.add(panel2);
        this.m_text = new TextField[this.m_length];
        int n = 0;
        while (n < this.m_length) {
            this.m_text[n] = new TextField("0");
            this.m_text[n].addTextListener(this);
            panel2.add(this.m_text[n]);
            ++n;
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_color = (PdColor)psUpdateIf;
        this.m_lTitle.setText(this.m_color.getName());
        int n = 0;
        while (n < this.m_length) {
            this.m_rgbOld[0] = this.m_color.getEntry(n);
            ++n;
        }
    }

    public Color getColor() {
        return new Color(this.m_rgbNew[0], this.m_rgbNew[1], this.m_rgbNew[2]);
    }

    public boolean update(Object object) {
        if (this.m_color == null) {
            PsDebug.warning("missing color");
            return true;
        }
        if (object == this.m_color) {
            this.setEnabled(this.m_color.isEnabled());
            this.m_bInteractive = false;
            int n = 0;
            while (n < this.m_length) {
                this.m_rgbNew[n] = this.m_color.getEntry(n);
                ((TextComponent)this.m_text[n]).setText(String.valueOf(this.m_rgbNew[n]));
                ++n;
            }
            this.m_bInteractive = true;
            this.m_pColor.setBackground(this.m_color.getColor());
            this.m_pColor.repaint();
            return true;
        }
        return false;
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.m_bInteractive) {
            return;
        }
        if (this.m_color == null) {
            PsDebug.warning("no color assigned, return");
            return;
        }
        Object object = textEvent.getSource();
        int n = 0;
        while (n < this.m_length) {
            if (object == this.m_text[n]) {
                String string = this.m_text[n].getText();
                if (string == null || string.equals("")) {
                    return;
                }
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 < this.m_min || this.m_max < n2) {
                        PsDebug.warning("wrong format");
                        ((TextComponent)this.m_text[n]).setText(String.valueOf(this.m_rgbNew[n]));
                        return;
                    }
                    this.m_rgbNew[n] = n2;
                    this.m_color.setEntry(n, this.m_rgbNew[n]);
                    this.m_pColor.setBackground(this.m_color.getColor());
                    this.m_pColor.repaint();
                    this.m_color.update(null);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("wrong format = " + string);
                    return;
                }
            }
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_lTitle.setEnabled(bl);
        this.m_pColor.setEnabled(bl);
        int n = 0;
        while (n < this.m_length) {
            this.m_text[n].setEnabled(bl);
            ++n;
        }
    }
}

