/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PvCameraIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuReflect;
import jv.viewer.PvDisplay;

public final class PvCamera
extends PsObject
implements PvCameraIf {
    private double Z_STRETCH = 1000.0;
    private double SIZE = 10.0;
    private PdVector m_interest = new PdVector(3);
    private PdVector m_position = new PdVector(3);
    private PdVector m_viewDir = new PdVector(3);
    private PdVector m_upVector = new PdVector(3);
    private PdVector m_defaultUpVector = new PdVector(3);
    protected double m_defRoll = 0.0;
    protected PuDouble m_roll;
    protected double m_defFieldOfView = 53.13;
    protected PuDouble m_fieldOfView;
    protected PuDouble m_nearClip;
    private double m_defNearClip = this.SIZE;
    protected PuDouble m_farClip;
    private double m_defFarClip = -this.SIZE;
    protected boolean m_bEnableClip;
    protected PdMatrix m_proj = new PdMatrix(4);
    protected PdMatrix m_projInv = new PdMatrix(4);
    public PdMatrix m_view = new PdMatrix(4);
    public PdMatrix m_viewInv = new PdMatrix(4);
    protected PdMatrix m_incrView = new PdMatrix(4);
    protected PdMatrix m_incrViewInv = new PdMatrix(4);
    public PdMatrix m_trans = new PdMatrix(4);
    public PdMatrix m_transInv = new PdMatrix(4);
    protected int m_mode;
    protected int m_projMode;
    protected double m_nHeight;
    protected double m_nWidth;
    protected double m_fit = -1.0;
    protected double m_scaleTotal = 1.0;
    protected double m_scaleValue;
    protected double m_xTransValue;
    protected double m_yTransValue;
    protected double m_zTransValue;
    protected PdVector m_vecAlt = new PdVector(3);
    protected PdVector m_vec = new PdVector(3);
    protected PdVector m_rotAxis = new PdVector(3);
    protected PdVector m_pick = new PdVector(4);
    protected PdVector m_worldPick = new PdVector(4);
    private double[] m_prevNormLoc = new double[2];
    private double[] m_currNormLoc = new double[2];
    protected PvDisplay m_display;

    public double getRoll() {
        PdVector pdVector = this.getViewDir();
        PdVector pdVector2 = this.m_defaultUpVector.orthogonalPart(null, pdVector);
        PdVector pdVector3 = this.getUpVector();
        this.m_roll.setValue(PdVector.angleWithOrientation(pdVector3, pdVector2, pdVector) * 180.0 / Math.PI);
        return this.m_roll.getValue();
    }

    public void setRoll(double d) {
        PdVector pdVector;
        PdVector pdVector2;
        PdVector pdVector3;
        if (this.m_roll.getValue() != d * Math.PI / 180.0) {
            this.m_roll.setValue(d);
        }
        if (!(pdVector3 = this.m_defaultUpVector.orthogonalPart(null, pdVector2 = this.getViewDir())).normalize()) {
            pdVector = PdVector.copyNew(this.m_defaultUpVector);
            double d2 = pdVector.getEntry(2);
            pdVector.setEntry(2, pdVector.getEntry(1));
            pdVector.setEntry(1, d2);
            pdVector3 = pdVector.orthogonalPart(null, pdVector2);
            if (!pdVector3.normalize()) {
                return;
            }
        }
        pdVector = PdVector.crossNew(pdVector3, pdVector2);
        this.m_upVector.blend(Math.cos(d *= Math.PI / 180), pdVector3, Math.sin(d), pdVector);
        this.computeView();
    }

    public boolean isEnabledClip() {
        return this.m_bEnableClip;
    }

    public void fit(double d) {
        this.setScale(1.1 * this.SIZE / d);
    }

    protected void mouseAnimate() {
        if (this.m_display.isEnabledLocalTransform()) {
            this.m_view.rightMult(this.m_incrView);
            this.m_viewInv.leftMult(this.m_incrViewInv);
        } else {
            this.m_view.leftMult(this.m_incrView);
            this.m_viewInv.rightMult(this.m_incrViewInv);
        }
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    private void computeView() {
        PdVector pdVector = this.getInterest();
        this.m_viewDir.normalize();
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = this.m_upVector.orthogonalPart(null, this.m_viewDir);
        if (!pdVector3.normalize()) {
            this.m_upVector.m_data[1] = this.m_upVector.m_data[1] + 1.0;
            pdVector3 = this.m_upVector.orthogonalPart(null, this.m_viewDir);
            if (!pdVector3.normalize()) {
                this.m_upVector.m_data[2] = this.m_upVector.m_data[2] + 1.0;
                pdVector3 = this.m_upVector.orthogonalPart(null, this.m_viewDir);
                if (!pdVector3.normalize()) {
                    this.m_upVector.m_data[2] = this.m_upVector.m_data[2] + 1.0;
                    pdVector3 = this.m_upVector.orthogonalPart(null, this.m_viewDir);
                }
            }
        }
        pdVector2.cross(this.m_viewDir, pdVector3);
        double d = this.getScale();
        int n = 0;
        do {
            this.m_view.m_data[0][n] = d * pdVector2.m_data[n];
            this.m_view.m_data[1][n] = d * pdVector3.m_data[n];
            this.m_view.m_data[2][n] = -d * this.m_viewDir.m_data[n];
            this.m_viewInv.m_data[n][0] = pdVector2.m_data[n] / d;
            this.m_viewInv.m_data[n][1] = pdVector3.m_data[n] / d;
            this.m_viewInv.m_data[n][2] = -this.m_viewDir.m_data[n] / d;
            this.m_viewInv.m_data[n][3] = -this.m_view.m_data[n][3];
        } while (++n < 3);
        this.setInterest(pdVector);
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    public boolean update(Object object) {
        if (object == this.m_fieldOfView) {
            this.setFieldOfView(this.m_fieldOfView.getValue());
            return super.update(null);
        }
        if (object == this.m_roll) {
            this.setRoll(this.m_roll.getValue());
            return super.update(null);
        }
        if (object == this.m_nearClip) {
            if (this.m_nearClip.getValue() < this.m_farClip.getValue()) {
                this.m_farClip.setValue(this.m_nearClip.getValue());
            }
            return super.update(null);
        }
        if (object == this.m_farClip) {
            if (this.m_farClip.getValue() > this.m_nearClip.getValue()) {
                this.m_nearClip.setValue(this.m_farClip.getValue());
            }
            return super.update(null);
        }
        return super.update(object);
    }

    public PdVector getInterest() {
        int n = 0;
        do {
            this.m_interest.m_data[n] = this.m_viewInv.m_data[n][3];
        } while (++n < 3);
        return this.m_interest;
    }

    public void setInterest(PdVector pdVector) {
        int n = pdVector.getSize();
        int n2 = 0;
        do {
            this.m_view.m_data[n2][3] = 0.0;
            int n3 = 0;
            while (n3 < n) {
                double[] dArray = this.m_view.m_data[n2];
                dArray[3] = dArray[3] - this.m_view.m_data[n2][n3] * pdVector.m_data[n3];
                ++n3;
            }
            this.m_viewInv.m_data[n2][3] = pdVector.m_data[n2];
        } while (++n2 < 3);
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    protected void resizeImage(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            if (this.m_nHeight > 0.0) {
                PsDebug.warning("window has dimensions=0");
            }
            return;
        }
        this.m_nWidth = d;
        this.m_nHeight = d2;
        this.computeProjection();
    }

    public void setEnabledClip(boolean bl) {
        this.m_bEnableClip = bl;
    }

    public double getNearClip() {
        return this.m_nearClip.getValue();
    }

    public void setNearClip(double d) {
        this.m_nearClip.setValue(d);
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = null;
        if (this.m_display != null && this.m_display.m_scene != null) {
            pdVectorArray = this.m_display.m_scene.getBounds();
        }
        if (pdVectorArray == null) {
            return null;
        }
        double[] dArray = new double[3];
        int n = 0;
        do {
            int n2 = 0;
            do {
                double d = 0.0;
                int n3 = 0;
                do {
                    d += this.m_trans.m_data[n2][n3] * pdVectorArray[n].m_data[n3];
                } while (++n3 < 3);
                dArray[n2] = (int)(d + 0.5 + this.m_trans.m_data[n2][3]);
            } while (++n2 < 3);
            n2 = 0;
            do {
                pdVectorArray[n].m_data[n2] = dArray[n2];
            } while (++n2 < 2);
            pdVectorArray[n].m_data[2] = dArray[2] / this.Z_STRETCH;
        } while (++n < 2);
        return pdVectorArray;
    }

    public int getProjectionMode() {
        return this.m_projMode;
    }

    public void setProjectionMode(int n) {
        this.m_projMode = n;
    }

    protected void mousePressed(int n, int n2) {
        PvDisplay.normalizedCoordsFromViewport(this.m_prevNormLoc, n, n2, (int)this.m_nWidth, (int)this.m_nHeight);
        this.m_scaleValue = Math.exp(this.m_prevNormLoc[0] + this.m_prevNormLoc[1]);
        this.m_xTransValue = this.m_prevNormLoc[0] * this.SIZE / 2.0;
        this.m_yTransValue = this.m_prevNormLoc[1] * this.SIZE / 2.0;
        this.m_zTransValue = this.m_xTransValue + this.m_yTransValue;
        this.m_vecAlt.invStereoProj(this.m_prevNormLoc[0], this.m_prevNormLoc[1]);
    }

    protected void mouseDragged(int n, int n2, boolean bl) {
        PvDisplay.normalizedCoordsFromViewport(this.m_currNormLoc, n, n2, (int)this.m_nWidth, (int)this.m_nHeight);
        this.m_incrView.setIdentity();
        this.m_incrViewInv.setIdentity();
        if (this.m_mode == 1) {
            double d;
            double d2 = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
            this.m_incrView.m_data[0][0] = d = d2 / this.m_scaleValue;
            this.m_incrView.m_data[1][1] = d;
            this.m_incrView.m_data[2][2] = d;
            this.m_incrViewInv.m_data[0][0] = 1.0 / d;
            this.m_incrViewInv.m_data[1][1] = 1.0 / d;
            this.m_incrViewInv.m_data[2][2] = 1.0 / d;
            this.m_scaleTotal *= d;
            this.m_scaleValue = d2;
        } else if (this.m_mode == 3 || this.m_projMode != 0) {
            double d = this.m_currNormLoc[0] * this.SIZE / 2.0;
            double d3 = this.m_currNormLoc[1] * this.SIZE / 2.0;
            double d4 = d - this.m_xTransValue;
            double d5 = d3 - this.m_yTransValue;
            this.m_incrView.m_data[0][3] = d4;
            this.m_incrView.m_data[1][3] = d5;
            this.m_incrViewInv.m_data[0][3] = -d4;
            this.m_incrViewInv.m_data[1][3] = -d5;
            this.m_xTransValue = d;
            this.m_yTransValue = d3;
        } else if (this.m_mode == 0 && this.m_projMode == 0) {
            double d;
            this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
            if (bl) {
                int n3 = 0;
                if (this.m_currNormLoc[1] == this.m_prevNormLoc[1]) {
                    n3 = 1;
                }
                if (this.m_vecAlt.getEntry(n3) != 0.0) {
                    this.m_vecAlt.setEntry(n3, 0.0);
                    this.m_vecAlt.normalize();
                }
                this.m_vec.setEntry(n3, 0.0);
                this.m_vec.normalize();
            }
            if ((d = Math.acos(PdVector.dot(this.m_vec, this.m_vecAlt))) < 1.0E-10) {
                return;
            }
            this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
            this.m_vecAlt.copy(this.m_vec);
            if (this.m_rotAxis.length() < 1.0E-10) {
                return;
            }
            if (!PuReflect.makeRotation(this.m_incrView, this.m_rotAxis, d)) {
                return;
            }
            this.m_incrViewInv.transpose(this.m_incrView);
        } else if (this.m_mode == 4) {
            double d;
            double d6 = this.m_currNormLoc[0] * this.SIZE / 2.0;
            double d7 = this.m_currNormLoc[1] * this.SIZE / 2.0;
            double d8 = d6 + d7;
            this.m_incrView.m_data[2][3] = d = d8 - this.m_zTransValue;
            this.m_incrViewInv.m_data[2][3] = -d;
            this.m_xTransValue = d6;
            this.m_yTransValue = d7;
            this.m_zTransValue = d8;
        } else {
            return;
        }
        if (this.m_display.isEnabledLocalTransform()) {
            this.m_view.rightMult(this.m_incrView);
            this.m_viewInv.leftMult(this.m_incrViewInv);
        } else {
            this.m_view.leftMult(this.m_incrView);
            this.m_viewInv.rightMult(this.m_incrViewInv);
        }
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
        if (this.m_mode != 1 && this.m_mode != 3 && this.m_projMode == 0 && this.m_mode == 0 && this.m_projMode == 0) {
            this.getRoll();
        }
    }

    public PvCamera(PvDisplay pvDisplay, int n) {
        this.m_display = pvDisplay;
        this.m_projMode = n;
        this.m_fieldOfView = new PuDouble(PsConfig.getMessage("fieldOfView"), this);
        this.m_roll = new PuDouble(PsConfig.getMessage("roll"), this);
        this.m_nearClip = new PuDouble(PsConfig.getMessage("nearClip"), this);
        this.m_farClip = new PuDouble(PsConfig.getMessage("farClip"), this);
        this.init();
    }

    protected int getMode() {
        return this.m_mode;
    }

    public PdVector getUpVector() {
        double d = this.getScale();
        int n = 0;
        do {
            this.m_upVector.m_data[n] = this.m_view.m_data[1][n] / d;
        } while (++n < 3);
        return this.m_upVector;
    }

    public void setUpVector(PdVector pdVector) {
        this.m_upVector.copy(pdVector);
        this.computeView();
    }

    protected void setMode(int n) {
        this.m_mode = n;
    }

    public double getScale() {
        return Math.sqrt(this.m_view.m_data[2][0] * this.m_view.m_data[2][0] + this.m_view.m_data[2][1] * this.m_view.m_data[2][1] + this.m_view.m_data[2][2] * this.m_view.m_data[2][2]);
    }

    public void setScale(double d) {
        double d2 = this.getScale();
        double d3 = d / d2;
        int n = 0;
        do {
            int n2 = 0;
            do {
                double[] dArray = this.m_view.m_data[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] * d3;
                double[] dArray2 = this.m_viewInv.m_data[n];
                int n4 = n2++;
                dArray2[n4] = dArray2[n4] / d3;
            } while (n2 < 3);
            double[] dArray = this.m_view.m_data[n];
            dArray[3] = dArray[3] * d3;
        } while (++n < 3);
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    public PdVector getViewDir() {
        double d = this.getScale();
        int n = 0;
        do {
            this.m_viewDir.m_data[n] = -this.m_view.m_data[2][n] / d;
        } while (++n < 3);
        return this.m_viewDir;
    }

    public void setViewDir(PdVector pdVector) {
        double d = this.getRoll();
        this.m_viewDir.copy(pdVector);
        this.computeView();
        this.setRoll(d);
    }

    public double getDist() {
        double d = this.SIZE / this.getScale();
        return d;
    }

    public void setDist(double d) {
        this.setScale(this.SIZE / d);
    }

    public double getFarClip() {
        return this.m_farClip.getValue();
    }

    public double getFieldOfView() {
        return this.m_fieldOfView.getValue();
    }

    public void setFieldOfView(double d) {
    }

    public void setFarClip(double d) {
        this.m_farClip.setValue(d);
    }

    protected void mouseAnimateGeometry() {
        PuReflect.makeRotation(this.m_incrView, new PdVector(0.0, 0.0, 1.0), 0.06283185307179587);
        this.m_incrViewInv.transpose(this.m_incrView);
        if (this.m_display.isEnabledLocalTransform()) {
            this.m_view.rightMult(this.m_incrView);
            this.m_viewInv.leftMult(this.m_incrViewInv);
        } else {
            this.m_view.leftMult(this.m_incrView);
            this.m_viewInv.rightMult(this.m_incrViewInv);
        }
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    public PdVector getPosition() {
        double d = this.getDist();
        PdVector pdVector = this.getInterest();
        PdVector pdVector2 = this.getViewDir();
        int n = 0;
        do {
            this.m_position.m_data[n] = pdVector.m_data[n] - d * pdVector2.m_data[n];
        } while (++n < 3);
        return this.m_position;
    }

    public void setPosition(PdVector pdVector) {
        double d = this.getRoll();
        this.m_viewDir.sub(this.getInterest(), pdVector);
        double d2 = this.m_viewDir.length();
        this.computeView();
        this.setDist(d2);
        this.setRoll(d);
    }

    private void computeProjection() {
        if (this.m_nWidth <= 0.0 && this.m_nHeight <= 0.0) {
            return;
        }
        this.m_proj.m_data[0][0] = Math.min(this.m_nWidth, this.m_nHeight) / this.SIZE;
        this.m_proj.m_data[1][1] = -Math.min(this.m_nWidth, this.m_nHeight) / this.SIZE;
        this.m_proj.m_data[0][3] = (this.m_nWidth - 1.0) / 2.0;
        this.m_proj.m_data[1][3] = (this.m_nHeight - 1.0) / 2.0;
        this.m_projInv.m_data[0][0] = 1.0 / this.m_proj.m_data[0][0];
        this.m_projInv.m_data[1][1] = 1.0 / this.m_proj.m_data[1][1];
        this.m_projInv.m_data[0][3] = -this.m_proj.m_data[0][3] / this.m_proj.m_data[0][0];
        this.m_projInv.m_data[1][3] = -this.m_proj.m_data[1][3] / this.m_proj.m_data[1][1];
        this.m_proj.m_data[2][2] = this.Z_STRETCH;
        this.m_projInv.m_data[2][2] = 1.0 / this.Z_STRETCH;
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    public void init() {
        super.init();
        this.m_fieldOfView.setDefBounds(5.0, 180.0, 1.0, 5.0);
        this.m_fieldOfView.setDefValue(this.m_defFieldOfView);
        this.m_fieldOfView.init();
        this.m_roll.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_roll.setDefValue(this.m_defRoll);
        this.m_roll.init();
        this.m_nearClip.setDefBounds(this.m_defNearClip - 2.0 * (this.m_defNearClip - this.m_defFarClip), this.m_defNearClip + 2.0 * (this.m_defNearClip - this.m_defFarClip), 0.1, 1.0);
        this.m_nearClip.setDefValue(this.m_defNearClip);
        this.m_nearClip.init();
        this.m_farClip.setDefBounds(this.m_defFarClip - 2.0 * (this.m_defNearClip - this.m_defFarClip), this.m_defNearClip + 2.0 * (this.m_defNearClip - this.m_defFarClip), 0.1, 1.0);
        this.m_farClip.setDefValue(this.m_defFarClip);
        this.m_farClip.init();
        this.m_bEnableClip = false;
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        this.m_pick.set(0.0, 0.0, 0.0, 1.0);
        this.m_proj.setIdentity();
        this.m_projInv.setIdentity();
        this.m_view.setIdentity();
        this.m_viewInv.setIdentity();
        this.m_incrView.setIdentity();
        this.m_incrViewInv.setIdentity();
        this.m_trans.setIdentity();
        this.m_transInv.setIdentity();
        this.computeProjection();
        switch (this.m_projMode) {
            case 0: {
                this.m_viewDir.set(0.1, 0.6, -0.4);
                this.m_defaultUpVector.set(0.0, 0.0, 1.0);
                break;
            }
            case 1: {
                this.m_viewDir.set(0.0, 0.0, -1.0);
                this.m_defaultUpVector.set(0.0, 1.0, 0.0);
                break;
            }
            case 2: {
                this.m_viewDir.set(0.0, 1.0, 0.0);
                this.m_defaultUpVector.set(0.0, 0.0, 1.0);
                break;
            }
            case 3: {
                this.m_viewDir.set(-1.0, 0.0, 0.0);
                this.m_defaultUpVector.set(0.0, 0.0, 1.0);
                break;
            }
            default: {
                PsDebug.error("unkown projection mode = " + this.m_projMode, this);
            }
        }
        this.m_upVector.copy(this.m_defaultUpVector);
        this.setInterest(new PdVector(0.0, 0.0, 0.0));
        this.computeView();
    }
}

