/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuMath;
import jv.viewer.PvDisplay;
import jv.viewer.PvGeometry;

public final class PvScene
extends PsObject {
    protected int m_maxNumGeometries = 20;
    protected int m_numGeometries = 0;
    protected PvGeometry[] m_geometry;
    protected Vector m_special;
    protected PvGeometry m_currentGeom;
    protected int m_numItems;
    protected int[][] m_itemInd;
    protected double[] m_itemHeight;
    protected int[] m_itemSort;
    protected int m_dim;
    protected PdVector[] m_bndBox;
    protected PdVector m_center;
    protected int m_pickedVertex;
    protected int m_pickedGeometry;
    private int m_geomInd;
    private PiVector[] m_faceDestBnd;
    private PdMatrix transMatrix = new PdMatrix(4);
    protected int m_dimWithZBuffer = 4;
    protected static int t_itemInd = 0;
    protected static int m_zMin;
    protected static int m_zMax;
    protected static PdVector m_lightDir;
    protected static PdVector m_lightDirTrans;
    protected boolean m_bUseTexture = false;
    private transient Image m_destImage;
    private int imgHeight;
    private int imgWidth;
    private transient MemoryImageSource mis;
    private PiVector m_pix = new PiVector();
    private PiVector m_pixZero = new PiVector();
    private static /* synthetic */ Class class$jv$viewer$PvGeometry;

    public void setState(int n, boolean bl) {
        switch (n) {
            default: {
                PsDebug.warning("invalid key = " + n);
            }
            case 69: 
            case 70: 
        }
    }

    private int getGeometryIndOfItem(int n) {
        int n2 = 0;
        while (n2 < this.m_numGeometries) {
            if (this.m_itemInd[n2][0] <= n && n <= this.m_itemInd[n2][1]) {
                return n2;
            }
            ++n2;
        }
        PsDebug.warning("missing geometry of item = " + n);
        return -1;
    }

    protected int assureMIS_new(int n, int n2) {
        if (this.mis == null || this.imgHeight != n2 || this.imgWidth != n) {
            this.imgWidth = n;
            this.imgHeight = n2;
            this.m_pix.setSize(this.imgWidth * this.imgHeight);
            this.m_pixZero.setSize(this.imgWidth * this.imgHeight);
            this.mis = new MemoryImageSource(this.imgWidth, this.imgHeight, this.m_pix.m_data, 0, this.imgWidth);
            this.mis.setAnimated(true);
            return PvGeometry.MIS_IMAGE_REQUIRED;
        }
        return PvGeometry.MIS_IMAGE_REDRAW;
    }

    public PvScene() {
        this.m_geometry = new PvGeometry[this.m_maxNumGeometries];
        this.m_itemInd = new int[this.m_maxNumGeometries][3];
        this.m_bndBox = new PdVector[2];
        this.m_special = new Vector();
        this.init();
    }

    public boolean containsGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return false;
        }
        return this.getGeometry(pgGeometryIf) != null;
    }

    public void paint(Graphics graphics, PvDisplayIf pvDisplayIf) {
        int n;
        int n2;
        int n3 = this.getNumAllGeometries();
        if (n3 == 0 || n3 == this.m_numGeometries && this.m_numItems == 0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = pvDisplayIf.isShowingDepthcue();
        PdMatrix pdMatrix = pvDisplayIf.getTransMatrix(4);
        PdMatrix pdMatrix2 = pvDisplayIf.getTransMatrix(2);
        PdMatrix pdMatrix3 = pvDisplayIf.getTransMatrix(1);
        PvGeometry[] pvGeometryArray = this.getGeometries();
        Dimension dimension = pvDisplayIf.getSize();
        this.m_bUseTexture = false;
        m_zMin = Integer.MAX_VALUE;
        m_zMax = Integer.MIN_VALUE;
        boolean bl2 = ((PvDisplay)pvDisplayIf).isEnabledZBuffer();
        boolean bl3 = ((PvDisplay)pvDisplayIf).m_bEnableNewZBuffer;
        m_lightDirTrans.leftMultMatrix(pdMatrix, m_lightDir);
        int n4 = 0;
        while (n4 < n3) {
            if (pvGeometryArray[n4].isVisible()) {
                pvGeometryArray[n4].m_lightDir.copyArray(m_lightDirTrans);
                pvGeometryArray[n4].m_lightDir.normalize();
                pvGeometryArray[n4].m_backColor = pvDisplayIf.getBackgroundColor();
                pvGeometryArray[n4].m_bShowEdgeAura = pvDisplayIf.isShowingEdgeAura();
                pvGeometryArray[n4].showBndBox(pvDisplayIf.isShowingBndBox());
                pvGeometryArray[n4].m_bShowEdgeOnce = pvDisplayIf.isShowingEdgesOnce();
                pvGeometryArray[n4].m_bShowDepthcue = pvDisplayIf.isShowingDepthcue();
                pvGeometryArray[n4].m_bEnableClip = pvDisplayIf.isEnabledClip();
                pvGeometryArray[n4].m_clipFar = 1000.0 * pvDisplayIf.getFarClip();
                pvGeometryArray[n4].m_clipNear = 1000.0 * pvDisplayIf.getNearClip();
                pvGeometryArray[n4].m_scene = this;
                pvGeometryArray[n4].m_dispSize = dimension;
                pvGeometryArray[n4].m_bEnableZBuffer = bl2;
                if (pvGeometryArray[n4].isShowingVertexTexture() || pvGeometryArray[n4].isShowingElementTexture()) {
                    this.m_bUseTexture = true;
                }
                PdMatrix pdMatrix4 = null;
                if (pvGeometryArray[n4].hasModelMatrix()) {
                    pdMatrix4 = pvGeometryArray[n4].getModelMatrix();
                }
                pvGeometryArray[n4].projectItems(pdMatrix3, pdMatrix2, pdMatrix, pdMatrix4);
                m_zMin = Math.min(m_zMin, pvGeometryArray[n4].getZMin());
                m_zMax = Math.max(m_zMax, pvGeometryArray[n4].getZMax());
            }
            ++n4;
        }
        n4 = PvGeometry.MIS_IMAGE_REDRAW;
        if (this.m_bUseTexture || bl2) {
            this.m_faceDestBnd = PiVector.realloc(this.m_faceDestBnd, (dimension.height + dimension.width) * 2, this.m_dimWithZBuffer);
            if (bl3) {
                n4 = this.assureMIS_new(dimension.width, dimension.height);
            }
            int n5 = 0;
            while (n5 < n3) {
                pvGeometryArray[n5].m_dispSize = dimension;
                if (pvGeometryArray[n5].m_bNewZBuffer != bl3 || bl3 && n4 == PvGeometry.MIS_IMAGE_REQUIRED) {
                    pvGeometryArray[n5].clearMIS();
                    if (bl3) {
                        pvGeometryArray[n5].setMIS(this.imgWidth, this.imgHeight, this.m_pix.m_data, this.m_pixZero.m_data);
                    }
                    pvGeometryArray[n5].m_bNewZBuffer = bl3;
                }
                if (pvGeometryArray[n5].isShowingVertexTexture() || pvGeometryArray[n5].isShowingElementTexture() || bl2) {
                    pvGeometryArray[n5].m_faceDestBnd = this.m_faceDestBnd;
                    pvGeometryArray[n5].m_faceTextureBnd = PdVector.realloc(pvGeometryArray[n5].m_faceTextureBnd, (dimension.height + dimension.width) * 2, 3);
                }
                ++n5;
            }
        } else {
            this.m_faceDestBnd = null;
        }
        this.copyItemHeight();
        if (pvDisplayIf.isEnabledPainters() && this.m_numItems > 0) {
            PuMath.heapsort(this.m_numItems, this.m_itemHeight, this.m_itemSort);
            d = this.m_itemHeight[this.m_itemSort[0]];
            d2 = this.m_itemHeight[this.m_itemSort[this.m_numItems - 1]];
        } else {
            d2 = -1.7976931348623157E308;
            d = Double.MAX_VALUE;
            int n6 = 0;
            while (n6 < this.m_numItems) {
                if (this.m_itemHeight[n6] > d2) {
                    d2 = this.m_itemHeight[n6];
                } else if (this.m_itemHeight[n6] < d) {
                    d = this.m_itemHeight[n6];
                }
                this.m_itemSort[n6] = n6;
                ++n6;
            }
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            PvGeometry pvGeometry = (PvGeometry)enumeration.nextElement();
            if (pvGeometry.getDrawingOrder() != -1 || !pvGeometry.isVisible()) continue;
            pvGeometry.m_bShowEdgeOnce = false;
            pvGeometry.m_bShowDepthcue = false;
            int n7 = pvGeometry.getNumItems();
            n2 = 0;
            while (n2 < n7) {
                pvGeometry.drawItem(graphics, n2, d3, 0.0);
                ++n2;
            }
        }
        boolean bl4 = false;
        double d4 = d2 - d;
        if (d4 < 1.0E-10) {
            bl4 = true;
            d3 = 1.0;
        }
        if (this.m_numGeometries == 1) {
            this.m_geomInd = 0;
            if (this.m_geometry[this.m_geomInd].isVisible()) {
                n2 = 0;
                while (n2 < this.m_numItems) {
                    n = bl2 && bl3 ? this.m_numItems - this.m_itemSort[n2] - 1 : this.m_itemSort[n2];
                    if (bl && !bl4) {
                        d3 = (this.m_itemHeight[n] - d) / d4;
                    }
                    t_itemInd = n2++;
                    this.m_geometry[this.m_geomInd].drawItem(graphics, n - this.m_itemInd[this.m_geomInd][0], d3, this.m_itemHeight[n]);
                }
            }
        } else {
            n2 = 0;
            while (n2 < this.m_numItems) {
                n = bl2 && bl3 ? this.m_numItems - this.m_itemSort[n2] - 1 : this.m_itemSort[n2];
                this.m_geomInd = this.getGeometryIndOfItem(n);
                if (this.m_geometry[this.m_geomInd].isVisible()) {
                    if (bl && !bl4) {
                        d3 = (this.m_itemHeight[n] - d) / d4;
                    }
                    t_itemInd = n2;
                    this.m_geometry[this.m_geomInd].drawItem(graphics, n - this.m_itemInd[this.m_geomInd][0], d3, this.m_itemHeight[n]);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n3) {
            if (pvGeometryArray[n2].isShowingTitle()) {
                pvGeometryArray[n2].drawTitle(graphics);
            }
            ++n2;
        }
        Enumeration enumeration2 = this.m_special.elements();
        while (enumeration2.hasMoreElements()) {
            PvGeometry pvGeometry = (PvGeometry)enumeration2.nextElement();
            if (pvGeometry.getDrawingOrder() != 1 || !pvGeometry.isVisible()) continue;
            pvGeometry.m_bShowEdgeOnce = false;
            pvGeometry.m_bShowDepthcue = false;
            int n8 = pvGeometry.getNumItems();
            int n9 = 0;
            while (n9 < n8) {
                pvGeometry.drawItem(graphics, n9, d3, 0.0);
                ++n9;
            }
        }
        if (bl3 && (this.m_bUseTexture || bl2)) {
            this.drawMIS_new(graphics, n4, pvDisplayIf);
        }
    }

    protected void drawMIS_new(Graphics graphics, int n, PvDisplayIf pvDisplayIf) {
        if (n == PvGeometry.MIS_IMAGE_REQUIRED) {
            this.m_destImage = ((Component)((Object)pvDisplayIf)).createImage(this.mis);
        } else {
            this.mis.newPixels(0, 0, this.imgWidth, this.imgHeight);
        }
        if (this.m_destImage != null) {
            graphics.drawImage(this.m_destImage, 0, 0, null);
        }
        System.arraycopy(this.m_pixZero.m_data, 0, this.m_pix.m_data, 0, this.imgWidth * this.imgHeight);
    }

    protected PvGeometry[] getGeometries() {
        int n = this.getNumAllGeometries();
        PvGeometry[] pvGeometryArray = new PvGeometry[n];
        if (n == 0) {
            return pvGeometryArray;
        }
        int n2 = 0;
        while (n2 < this.m_numGeometries) {
            pvGeometryArray[n2] = this.m_geometry[n2];
            ++n2;
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            pvGeometryArray[n2++] = (PvGeometry)enumeration.nextElement();
        }
        return pvGeometryArray;
    }

    private void assureIndexList() {
        if (this.m_numGeometries == 0) {
            return;
        }
        this.m_itemInd[0][0] = 0;
        int n = 0;
        while (n < this.m_numGeometries) {
            this.m_itemInd[n][1] = this.m_itemInd[n][0] + this.m_itemInd[n][2] - 1;
            if (n + 1 < this.m_numGeometries) {
                this.m_itemInd[n + 1][0] = this.m_itemInd[n][1] + 1;
            }
            ++n;
        }
        this.m_numItems = this.m_itemInd[this.m_numGeometries - 1][1] + 1;
        if (this.m_itemHeight == null || this.m_itemHeight.length != this.m_numItems) {
            this.m_itemHeight = new double[this.m_numItems];
            this.m_itemSort = new int[this.m_numItems];
        }
    }

    public boolean update(Object object) {
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            if (object != enumeration.nextElement()) continue;
            return true;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n] == object) {
                this.m_itemInd[n][2] = this.m_geometry[n].getNumItems();
                this.assureIndexList();
                return super.update(null);
            }
            ++n;
        }
        PsDebug.warning("missing geometry");
        return super.update(object);
    }

    static {
        m_lightDir = new PdVector(0.0, 0.7071, 0.7071, 0.0);
        m_lightDirTrans = new PdVector(0.0, 0.7071, 0.7071, 0.0);
    }

    public void selectGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return;
        }
        if (this.m_special.contains(pvGeometry)) {
            this.m_currentGeom = pvGeometry;
            return;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n] == pvGeometry) {
                this.m_currentGeom = this.m_geometry[n];
                return;
            }
            ++n;
        }
        PsDebug.warning("geometry not found, name = " + pvGeometry.getGeometry().getName());
    }

    protected PvGeometry getGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return null;
        }
        Enumeration enumeration = this.m_special.elements();
        while (enumeration.hasMoreElements()) {
            PvGeometry pvGeometry = (PvGeometry)enumeration.nextElement();
            if (pvGeometry.getGeometry() != pgGeometryIf) continue;
            return pvGeometry;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n].getGeometry() == pgGeometryIf) {
                return this.m_geometry[n];
            }
            ++n;
        }
        return null;
    }

    public double getDiameter() {
        if (this.m_numItems == 0) {
            return 0.0;
        }
        PdVector[] pdVectorArray = this.getBounds();
        double d = PdVector.dist(pdVectorArray[0], pdVectorArray[1]);
        return d;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void copyItemHeight() {
        int n = 0;
        while (n < this.m_numGeometries) {
            int n2;
            double d;
            int[] nArray;
            int[] nArray2;
            int n3;
            int n4;
            int n5 = 0;
            PvGeometry pvGeometry = this.m_geometry[n];
            if (pvGeometry.m_useVertices) {
                n4 = pvGeometry.getNumVertices();
                n3 = 0;
                while (n3 < n4) {
                    this.m_itemHeight[this.m_itemInd[n][0] + n3] = pvGeometry.m_vertexTrans[n3].m_data[2];
                    ++n3;
                }
                n5 = n4;
            } else if (pvGeometry.m_useUnusedVertices && (nArray2 = pvGeometry.getUnusedVertices()) != null) {
                int n6 = pvGeometry.getNumUnusedVertices();
                n3 = 0;
                while (n3 < n6) {
                    this.m_itemHeight[this.m_itemInd[n][0] + n3] = pvGeometry.m_vertexTrans[nArray2[n3]].m_data[2];
                    ++n3;
                }
                n5 = n6;
            }
            if (pvGeometry.m_useElements) {
                n4 = pvGeometry.getNumElements();
                PiVector[] piVectorArray = pvGeometry.getElements();
                n3 = 0;
                while (n3 < n4) {
                    nArray = piVectorArray[n3].m_data;
                    d = 0.0;
                    n2 = 0;
                    while (n2 < nArray.length) {
                        d += (double)pvGeometry.m_vertexTrans[nArray[n2]].m_data[2];
                        ++n2;
                    }
                    this.m_itemHeight[this.m_itemInd[n][0] + n5 + n3] = d /= (double)nArray.length;
                    ++n3;
                }
                n5 += n4;
            }
            if (pvGeometry.m_usePolygons) {
                n4 = pvGeometry.getNumPolygons();
                PiVector[] piVectorArray = pvGeometry.getPolygons();
                n3 = 0;
                while (n3 < n4) {
                    nArray = piVectorArray[n3].m_data;
                    if (nArray != null) {
                        n2 = 0;
                        while (n2 < nArray.length - 1) {
                            d = (double)(pvGeometry.m_vertexTrans[nArray[n2]].m_data[2] + pvGeometry.m_vertexTrans[nArray[n2 + 1]].m_data[2]) / 2.0;
                            this.m_itemHeight[this.m_itemInd[n][0] + n5++] = d;
                            ++n2;
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    private int getNumAllGeometries() {
        return this.m_numGeometries + this.m_special.size();
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = new PdVector[this.m_maxNumGeometries];
        PdVector[] pdVectorArray2 = new PdVector[this.m_maxNumGeometries];
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numGeometries) {
            PdVector[] pdVectorArray3;
            if (this.m_geometry[n2].isVisible() && (pdVectorArray3 = this.m_geometry[n2].getBounds()) != null) {
                pdVectorArray[n] = pdVectorArray3[0];
                pdVectorArray2[n] = pdVectorArray3[1];
                ++n;
            }
            ++n2;
        }
        if (n != 0) {
            PdVector.min(this.m_bndBox[0], pdVectorArray, n);
            PdVector.max(this.m_bndBox[1], pdVectorArray2, n);
        }
        if (n == 0 || PdVector.dist(this.m_bndBox[0], this.m_bndBox[1]) < 1.0E-10) {
            this.m_bndBox[0].setConstant(-10.0);
            this.m_bndBox[1].setConstant(10.0);
        }
        return this.m_bndBox;
    }

    public void init() {
        super.init();
        this.m_dim = 3;
        this.m_numItems = 0;
        this.m_itemHeight = null;
        this.m_itemSort = null;
        this.m_bndBox[0] = new PdVector(this.m_dim);
        this.m_bndBox[1] = new PdVector(this.m_dim);
        this.m_center = new PdVector(this.m_dim);
        this.m_bndBox[0].setConstant(-10.0);
        this.m_bndBox[1].setConstant(10.0);
        this.m_center.setConstant(0.0);
    }

    public PvGeometry removeGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return null;
        }
        if (this.m_special.contains(pvGeometry)) {
            this.m_special.removeElement(pvGeometry);
            if (pvGeometry == this.m_currentGeom) {
                if (this.m_numGeometries > 0) {
                    this.selectGeometry(this.m_geometry[0]);
                } else {
                    this.m_numItems = 0;
                    this.m_currentGeom = null;
                }
            }
            return this.m_currentGeom;
        }
        int n = 0;
        while (n < this.m_numGeometries) {
            if (this.m_geometry[n] == pvGeometry) {
                this.m_numGeometries += -1;
                if (n < this.m_numGeometries) {
                    this.m_geometry[n] = this.m_geometry[this.m_numGeometries];
                    this.m_itemInd[n][2] = this.m_itemInd[this.m_numGeometries][2];
                    if (this.m_geometry[this.m_numGeometries] == this.m_currentGeom) {
                        this.selectGeometry(this.m_geometry[n]);
                    }
                }
                this.m_geometry[this.m_numGeometries] = null;
                if (this.m_numGeometries > 0) {
                    this.assureIndexList();
                    if (pvGeometry == this.m_currentGeom) {
                        this.selectGeometry(this.m_geometry[0]);
                    }
                } else {
                    this.m_numItems = 0;
                    this.m_currentGeom = null;
                }
                return this.m_currentGeom;
            }
            ++n;
        }
        return this.m_currentGeom;
    }

    public void addGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            return;
        }
        if (pvGeometry.getDrawingOrder() == -1 || pvGeometry.getDrawingOrder() == 1) {
            this.m_special.addElement(pvGeometry);
        } else {
            int n = 0;
            while (n < this.m_numGeometries) {
                if (this.m_geometry[n] == pvGeometry) {
                    this.update(pvGeometry);
                    return;
                }
                ++n;
            }
            if (this.m_numGeometries == this.m_maxNumGeometries) {
                int[][] nArray = this.m_itemInd;
                this.m_geometry = (PvGeometry[])PuData.realloc(class$jv$viewer$PvGeometry != null ? class$jv$viewer$PvGeometry : (class$jv$viewer$PvGeometry = PvScene.class$("jv.viewer.PvGeometry")), this.m_geometry, 2 * this.m_maxNumGeometries);
                this.m_itemInd = new int[2 * this.m_maxNumGeometries][3];
                int n2 = 0;
                while (n2 < this.m_maxNumGeometries) {
                    int n3 = 0;
                    do {
                        this.m_itemInd[n2][n3] = nArray[n2][n3];
                    } while (++n3 < 3);
                    ++n2;
                }
                this.m_maxNumGeometries = 2 * this.m_maxNumGeometries;
            }
            this.m_geometry[this.m_numGeometries++] = pvGeometry;
            if (this.m_numGeometries == 1) {
                this.selectGeometry(pvGeometry);
            }
        }
        this.update(pvGeometry);
    }

    protected double getHeightOfElementInCurrentGeometry(int n) {
        if (n > this.m_itemInd[this.m_geomInd][2]) {
            return Double.NEGATIVE_INFINITY;
        }
        int n2 = n + this.m_itemInd[this.m_geomInd][0];
        return this.m_itemHeight[n2];
    }
}

