/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_Catenoid
extends PgWeierstrassDescr {
    protected PuInteger m_numULines = new PuInteger("Number of U-Lines", (PsUpdateIf)this);
    protected PuInteger m_numVLines = new PuInteger("Number of V-Lines", (PsUpdateIf)this);
    protected PuDouble m_phi = new PuDouble("V Max", (PsUpdateIf)this);
    protected PuDouble m_radius = new PuDouble("radius", (PsUpdateIf)this);
    private static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_Catenoid;

    public void getReflections() {
        this.reflectPart(1, 0, 3, 0);
    }

    public PgWeierstrass_Catenoid() {
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_Catenoid != null ? class$vgp$minimal$weier$PgWeierstrass_Catenoid : (class$vgp$minimal$weier$PgWeierstrass_Catenoid = PgWeierstrass_Catenoid.class$("vgp.minimal.weier.PgWeierstrass_Catenoid")))) {
            this.init();
        }
    }

    public PuComplex g(PiVector piVector, int n, PuComplex puComplex) {
        return PuComplex.inv((PuComplex)puComplex);
    }

    public int getDimOfElements() {
        return 4;
    }

    public boolean update(Object object) {
        if (object == this.m_numULines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_numVLines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_phi) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_radius) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public double getUMin(PiVector piVector, int n) {
        return 0.0;
    }

    public double getVMin(PiVector piVector, int n) {
        return 0.0;
    }

    public PuComplex f(PiVector piVector, int n, PuComplex puComplex) {
        return PuComplex.ONE;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        return PuComplex.polarToRect((double)Math.exp(puComplex.re), (double)puComplex.im);
    }

    public int getNumULines(PiVector piVector, int n) {
        return this.m_numULines.getValue();
    }

    public int getNumVLines(PiVector piVector, int n) {
        return this.m_numVLines.getValue();
    }

    public String getName() {
        return "Catenoid - Helicoid";
    }

    public int getNumParts() {
        return 2;
    }

    public void init() {
        this.m_numULines.setDefBounds(3, 65, 1, 10);
        this.m_numULines.setDefValue(11);
        this.m_numULines.init();
        this.addParameter((PsObject)this.m_numULines);
        this.m_numVLines.setDefBounds(7, 65, 1, 10);
        this.m_numVLines.setDefValue(33);
        this.m_numVLines.init();
        this.addParameter((PsObject)this.m_numVLines);
        this.m_phi.setDefBounds(0.0, Math.PI * 4, 0.19634954084936207, 1.5707963267948966);
        this.m_phi.setDefValue(Math.PI * 2);
        this.m_phi.init();
        this.addParameter((PsObject)this.m_phi);
        this.m_radius.setDefBounds(0.5, 5.0, 0.1, 1.0);
        this.m_radius.setDefValue(2.0);
        this.m_radius.init();
        this.addParameter((PsObject)this.m_radius);
        this.m_intDiscr.setDefBounds(1, 100, 1, 10);
        this.m_intDiscr.setDefValue(10);
        this.m_intDiscr.init();
        this.m_conjugation.setDefBounds(0.0, Math.PI * 2, 0.04908738521234052, 0.7853981633974483);
        this.m_conjugation.setDefValue(0.0);
        this.m_conjugation.init();
        this.addParameter((PsObject)this.m_conjugation);
        super.init();
    }

    public double getUMax(PiVector piVector, int n) {
        return this.m_radius.getValue();
    }

    public double getVMax(PiVector piVector, int n) {
        return this.m_phi.getValue();
    }

    public PuComplex[] getFStart(int n) {
        PuComplex[] puComplexArray = new PuComplex[this.m_vertDim];
        puComplexArray[0] = new PuComplex(2.0, 0.0);
        puComplexArray[1] = new PuComplex(0.0, 0.0);
        puComplexArray[2] = new PuComplex(0.0, Math.PI * -2);
        return puComplexArray;
    }
}

