/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.torusknot;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jvx.geom.PgTube;

public class PjTorusKnot
extends PjProject {
    protected boolean m_bShowTorus = true;
    protected boolean m_bShowTube = true;
    protected boolean m_bShowKnot = true;
    protected PgElementSet m_torus = new PgElementSet(3);
    protected PgTube m_tube;
    protected PgPolygon m_knot;
    protected double m_radius = 2.0;
    protected double m_thick = 1.0;
    protected int m_defPolygonDiscr = 120;
    protected int m_defNumUWindings = 5;
    protected int m_defNumZWindings = 4;
    protected PuInteger m_polygonDiscr;
    protected PuInteger m_numUWindings;
    protected PuInteger m_numZWindings;
    private static /* synthetic */ Class class$vgp$tutor$torusknot$PjTorusKnot;

    private void evalTorus(PdVector pdVector, double d, double d2) {
        if (pdVector == null || pdVector.getSize() < 3) {
            return;
        }
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double d5 = Math.sin(d2);
        double d6 = Math.cos(d2);
        pdVector.set(d4 * (this.m_thick * d6 + this.m_radius), d3 * (this.m_thick * d6 + this.m_radius), this.m_thick * d5);
    }

    public void setDefWindings(int n, int n2) {
        this.m_defNumUWindings = n;
        this.m_defNumZWindings = n2;
    }

    public PjTorusKnot() {
        super("TorusKnot");
        this.m_torus.setName("Torus");
        this.m_knot = new PgPolygon(3);
        this.m_knot.setName("TorusKnot");
        this.m_tube = new PgTube(3);
        this.m_tube.setName("Tube");
        this.m_tube.setPolygon(this.m_knot);
        this.m_tube.addUpdateListener((PsUpdateIf)this);
        this.m_polygonDiscr = new PuInteger("Knot Discr", (PsUpdateIf)this);
        this.m_numUWindings = new PuInteger("U-Windings", (PsUpdateIf)this);
        this.m_numZWindings = new PuInteger("Z-Windings", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$torusknot$PjTorusKnot != null ? class$vgp$tutor$torusknot$PjTorusKnot : (class$vgp$tutor$torusknot$PjTorusKnot = PjTorusKnot.class$("vgp.tutor.torusknot.PjTorusKnot")))) {
            this.init();
        }
    }

    private void computeKnot(int n, int n2, int n3) {
        if (n == 1) {
            return;
        }
        this.m_knot.setNumVertices(n);
        double d = Math.PI * 2 * (double)n2 / ((double)n - 1.0);
        double d2 = Math.PI * 2 * (double)n3 / ((double)n - 1.0);
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            this.evalTorus(this.m_knot.getVertex(n4), d3, d4);
            d3 += d;
            d4 += d2;
            int n5 = 255 * n4 / (n - 1);
            this.m_knot.setVertexColor(n4, PdColor.hsv2rgb((Color)new Color(n5, 255, 255)));
            ++n4;
        }
        this.m_knot.update((Object)this.m_knot);
        this.m_tube.update((Object)this.m_knot);
    }

    public boolean update(Object object) {
        if (object == this.m_numUWindings) {
            this.computeKnot(this.m_polygonDiscr.getValue(), this.m_numUWindings.getValue(), this.m_numZWindings.getValue());
            return true;
        }
        if (object == this.m_numZWindings) {
            this.computeKnot(this.m_polygonDiscr.getValue(), this.m_numUWindings.getValue(), this.m_numZWindings.getValue());
            return true;
        }
        if (object == this.m_polygonDiscr) {
            this.computeKnot(this.m_polygonDiscr.getValue(), this.m_numUWindings.getValue(), this.m_numZWindings.getValue());
            return true;
        }
        if (object == this.m_tube) {
            this.m_tube.assureElementColors();
            int n = this.m_knot.getNumVertices() - 1;
            int n2 = this.m_tube.getDiscr().getValue();
            if (n2 == 2) {
                n2 = 1;
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                int n5 = 255 * n4 / (n - 1);
                Color color = PdColor.hsv2rgb((Color)new Color(n5, 255, 255));
                int n6 = 0;
                while (n6 < n2) {
                    this.m_tube.setElementColor(n3++, color);
                    ++n6;
                }
                ++n4;
            }
            return true;
        }
        return super.update(object);
    }

    public void setWindings(int n, int n2) {
        this.m_numUWindings.setValue(n);
        this.m_numZWindings.setValue(n2);
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_torus);
        this.addGeometry((PgGeometryIf)this.m_knot);
        this.addGeometry((PgGeometryIf)this.m_tube);
        this.selectGeometry((PgGeometryIf)this.m_torus);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_bShowTorus = true;
        this.m_bShowTube = true;
        this.m_torus.computeTorus(21, 15, this.m_radius, this.m_thick);
        this.m_torus.showElements(false);
        this.m_polygonDiscr.setDefBounds(2, 300, 1, 5);
        this.m_polygonDiscr.setDefValue(this.m_defPolygonDiscr);
        this.m_polygonDiscr.init();
        this.m_numUWindings.setDefBounds(0, 20, 1, 2);
        this.m_numUWindings.setDefValue(this.m_defNumUWindings);
        this.m_numUWindings.init();
        this.m_numZWindings.setDefBounds(0, 20, 1, 2);
        this.m_numZWindings.setDefValue(this.m_defNumZWindings);
        this.m_numZWindings.init();
        this.setWindings(this.m_defNumUWindings, this.m_defNumZWindings);
        this.computeKnot(this.m_polygonDiscr.getValue(), this.m_numUWindings.getValue(), this.m_numZWindings.getValue());
        this.m_knot.assureVertexColors();
        this.m_knot.showVertexColors(true);
        this.m_knot.setGlobalVertexSize(4);
        this.m_knot.setGlobalPolygonSize(3.0);
        this.m_tube.setDefThickness(0.2);
        this.m_tube.init();
        this.m_tube.setPolygon(this.m_knot);
        this.m_tube.generateTube();
        this.m_tube.assureElementColors();
        this.m_tube.showElementColors(true);
    }
}

