/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.vectorField;

import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;

public class PjVectorField
extends PjProject {
    public static final int GRADIENT = 0;
    public static final int ROTATION = 1;
    protected PgDomain m_geom;
    protected PgVectorField m_vf = new PgVectorField(2);
    protected int m_fieldType;
    protected Vector m_center;
    protected PuDouble m_radius;
    protected double m_defRadius = 0.5;
    private static /* synthetic */ Class class$vgp$tutor$vectorField$PjVectorField;

    public void computeVectorfield() {
        int n = this.m_geom.getNumVertices();
        this.m_vf.setNumVectors(n);
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        PdVector[] pdVectorArray2 = this.m_vf.getVertices();
        int n2 = 0;
        while (n2 < n) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            Enumeration enumeration = this.m_center.elements();
            while (enumeration.hasMoreElements()) {
                PdVector pdVector = (PdVector)enumeration.nextElement();
                d = Math.exp(-2.0 * PdVector.dist((PdVector)pdVector, (PdVector)pdVectorArray2[n2]) * this.m_radius.getValue());
                d3 += -2.0 * (pdVectorArray2[n2].m_data[0] - pdVector.m_data[0]) * d;
                d2 += -2.0 * (pdVectorArray2[n2].m_data[1] - pdVector.m_data[1]) * d;
            }
            if (this.m_fieldType == 0) {
                pdVectorArray[n2].set(d3, d2);
            } else {
                pdVectorArray[n2].set(-d2, d3);
            }
            ++n2;
        }
        if (this.m_vf.hasInspector("Info") && this.m_vf.getInspector("Info").isShowing()) {
            this.m_vf.getInspector("Info").update((Object)this.m_vf);
        }
    }

    public void setFieldType(int n) {
        this.m_fieldType = n;
    }

    public PjVectorField() {
        super("Potential");
        this.m_vf.setName("Vector Field");
        this.m_fieldType = 1;
        this.m_geom = new PgDomain(2);
        this.m_geom.setName("Domain with Vectorfield");
        this.m_geom.setParent((PsUpdateIf)this);
        this.m_center = new Vector();
        this.m_radius = new PuDouble("Radius of Decay", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$vectorField$PjVectorField != null ? class$vgp$tutor$vectorField$PjVectorField : (class$vgp$tutor$vectorField$PjVectorField = PjVectorField.class$("vgp.tutor.vectorField.PjVectorField")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            super.update(null);
        } else {
            if (object == this.m_geom) {
                this.m_center.removeAllElements();
                int n = this.m_geom.getNumVertices();
                int n2 = 0;
                while (n2 < n) {
                    if (this.m_geom.hasTagVertex(n2, 1)) {
                        this.m_center.addElement(this.m_geom.getVertex(n2));
                    }
                    ++n2;
                }
                this.computeVectorfield();
                return true;
            }
            if (object == this.m_radius) {
                this.computeVectorfield();
                this.m_geom.update(null);
                return true;
            }
            if (object == ((PsObject)this).m_infoPanel) {
                this.computeVectorfield();
                this.m_geom.update(null);
                return true;
            }
        }
        return super.update(object);
    }

    public void start() {
        this.m_geom.addVectorField(this.m_vf);
        this.m_vf.setGeometry((PgPointSet)this.m_geom);
        this.m_geom.showEdges(false);
        this.m_geom.showElements(false);
        this.m_geom.update(null);
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.selectCamera(1);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_radius.setDefBounds(0.001, 5.0, 0.01, 0.1);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        PgDomainDescr pgDomainDescr = this.m_geom.getDescr();
        pgDomainDescr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        pgDomainDescr.setSize(-5.0, -5.0, 5.0, 5.0);
        pgDomainDescr.setDiscrBounds(2, 2, 50, 50);
        pgDomainDescr.setDiscr(20, 20);
        this.m_geom.computeSurface();
        this.m_geom.setTagVertex(0, 1);
        this.m_geom.setTagVertex(87, 1);
        this.m_geom.setTagVertex(305, 1);
        this.m_geom.setTagVertex(375, 1);
    }

    public int getFieldType() {
        return this.m_fieldType;
    }
}

